%pagesize 78,132

; Title		: WCLIB
; Function	: Assembler routines for WC.PAS
; Version	: 2.42
; Date		: Feb 21, 2000
; Author	: J.R. Ferguson
; Language	: Intel 8068/8088 assembler
; O.S.		: MS-DOS v3.2
; Assembler	: Turbo Assembler v3.2
; Remarks	: Turbo Pascal parameter passing conventions

		name	WCLIB
		.model	TPASCAL
		ideal
		%nomacs
		locals	@@

MAXSTR          =       255;

;----------------------------------------------------------------------
		dataseg
;----------------------------------------------------------------------

	extrn	SentSep		:byte:MAXSTR+1	;AnyStr
	extrn	WordSep		:byte:MAXSTR+1	;AnyStr
	extrn	SkipSep		:byte:MAXSTR+1	;AnyStr
	extrn	Hyphens		:byte:MAXSTR+1	;AnyStr
	extrn	CurLine		:byte:MAXSTR+1	;AnyStr
	extrn	CurChar		:byte		;char
        extrn   LineInd         :byte           ;Strind
        extrn   WordLen         :byte           ;StrInd
        extrn   Wcnt            :dword          ;Longint
        extrn   Scnt            :dword          ;Longint
        extrn   Lcnt            :dword          ;Longint
        extrn   Ccnt            :dword          ;Longint

%newpage
;----------------------------------------------------------------------
	codeseg
;----------------------------------------------------------------------

extrn	InpEof	:near	;function InpEof: boolean;
extrn   InpRead :near   ;procedure InpRead;


macro		IncLong offs
local l1
		inc	[word ptr offs]
		jnz	l1
		inc	[word ptr offs+2]
l1:
endm


macro		ChkSep	SepStr
		;;
		;;check if CurChar is found in SepStr
		;;
		;;out	cond Z	found
		;;
		mov	ax,ds
		mov	es,ax
		mov	di,offset SepStr
		sub	ch,ch
                mov     cl,[di]
		inc	di
		mov	al,[CurChar]
		cld
		repne	scasb
endm


macro		ChkWrd	SepStr
local l1
		;;
		;;Inword:= CurChar not in SepStr
		;;
		;;out	bl	Inword
		;;	cond Z	bl=0 (not InWord)
		;;
		ChkSep	SepStr
		mov	bl,1
		jne	l1
		sub	bl,bl
l1:		and	bl,bl
endm


%newpage
;
; procedure GetChar: boolean;
; Result (true/false) both in AL (1/0) and in z-flag (cond NZ/Z)
;
; Called from GetWord: preserve BP,SS,DS,BX
;
proc		GetChar near

		mov	al,[LineInd]		;if LineInd < Length(Curline)
		cmp	al,[CurLine]
		jnb	@@gc1    		;then begin
		inc	al			; Inc(LineInd);
		mov	[LineInd],al
		sub	ah,ah			; CurChar:= CurLine[LineInd];
                mov     si,ax
		mov	al,[CurLine+si]
		mov	[CurChar],al
                mov     al,1        		; GetChar:= true;
		jmp	short @@gc6		;end
@@gc1:		push	bx			;else begin
		call	InpEof			; if eof(Inp)
		and	al,al
		jz	@@gc2                   ; then begin
		mov	[CurChar],'.'		;  CurChar:= '.';
		sub	al,al			;  GetChar:= false;
		jmp	short @@gc5		; end
@@gc2:						; else begin
		call	InpRead			;  ReadLn(Inp,CurLine);
		IncLong	Lcnt			;  Inc(Lcnt);
		mov	al,[CurLine]		;  Inc(Ccnt,Length(CurLine));
		sub	ah,ah
		add	[word ptr Ccnt],ax
		jnc	@@gc3
		inc	[word ptr Ccnt+2]
@@gc3:		mov	[LineInd],0		;  LineInd:= 0;
		ChkSep	Hyphens			;  if CurChar not in Hyphens
		je	@@gc4
		mov	[CurChar],' '		;  then CurChar:= ' ';
@@gc4:		mov	al,1			;  GetChar:= true;
@@gc5:		pop     bx			; end;
@@gc6:	                			;end;
		and	al,al			;set Z-flag to reflect result
		ret

endp		GetChar

%newpage
;
; function GetWord: boolean;
;
; Called from Turbo Pascal: preserve SS,DS,BP
;
; Register usage : bl = InWord (boolean)
;
proc		GetWord near
public		GetWord

		;
		; skip to next word
		;
@@gwA:		ChkWrd	SkipSep			;while not (InWord:=
		jnz	@@gwB			; CurChar not in SkipSep)
		call	GetChar			;and GetChar
		jnz	@@gwA			;do {just skip};

		;
		; skip word, counting it's lenghth
		;
@@gwB:		and	bl,bl			;if InWord
		jz	@@gwC			;then begin
		IncLong	Wcnt			; Inc(Wcnt)
		mov	[WordLen],1		; WordLen:= 1;
@@gwB0:		and	bl,bl			; while InWord
		jz	@@gwB2
		call	GetChar			;   and GetChar
		jz	@@gwB2			; do begin
		ChkWrd	WordSep			;  if (InWrd:=
						;   CurChar not in WordSep)
		jz	@@gwB0	;@@gwB1		;  and
		ChkSep	Hyphens			;   CurChar not in Hyphens
		je	@@gwB0	;@@gwB1
		inc	[WordLen]		;  then Inc(WordLen);
@@gwB1:		jmp	short @@gwB0		; end {while InWord}

@@gwB2:		cmp	[CurChar],' '		; while CurChar=' '
		jne	@@gwB3
		call	GetChar			;   and GetChar
		jnz	@@gwB2			; do {nothing};

@@gwB3:		ChkSep	SentSep			; if CurChar in SentSep
		jne	@@gwB4
		IncLong	Scnt			; then Inc(Scnt);

@@gwB4:		jmp	short @@gwRet1		; GetWord:= true
						;end {if InWord}
@@gwC:						;else begin
		mov	[WordLen],0		;  WordLen:= 0;
		jmp	short @@gwRet0		;  GetWord:= false;
						;end;
@@gwRet0:	sub	al,al
		jmp	short @@gwRet
@@gwRet1:	mov	al,1
@@gwRet:	ret

endp		GetWord

		end
