/* A more sophisticated version of Unix "unexpand" command
 * =======================================================
 * Save some space by converting successive spaces to tabs.
 * Strings enclosed with single or double quotes preserved.
 * Trailing spaces/tabs at the end of line and empty lines
 * at the end of file discarded.
 *
 * Copyright (c) 1997 by Luchezar Iliev Georgiev, Bulgaria.
 *
 * Usage: unexpand < input_file > output_file
 */
#define TAB_STOPS   8
#include <stdio.h>

void main()
{
    int i, j, c, old, blanks = 0, empty_lines = 0, quote = 0;

    for (old = EOF, i = j = 0; (c = getchar()) != EOF; old = c) {
	switch (c) {
	    case '\n':
		i = j = blanks = quote = 0;
		if (old == '\n')
		    empty_lines++;
		else
		    putchar('\n');
		continue;
	    case '\t':
		if (quote)
		    for (putchar(' '), i++, j++; i % TAB_STOPS; i++, j++)
			putchar(' ');
		else {
		    i = (i + TAB_STOPS) / TAB_STOPS * TAB_STOPS;
		    blanks = !0;
		}
		continue;
	    case ' ':
		if (quote) {
		    putchar(' ');
		    j++;
		}
		blanks = !0;
		break;
	    case '\'':
	    case '\"':
		if (!quote)
		    quote = c;
		else if (quote == c)
		    quote = 0;
	    default:
		for (; empty_lines; empty_lines--)
		    putchar('\n');
		if (blanks) {
		    blanks = 0;
		    if (j + 1 == i) {
			putchar(' ');
			j++;
		    } else {
			for (; j < i / TAB_STOPS * TAB_STOPS;
			  j = (j + TAB_STOPS) / TAB_STOPS * TAB_STOPS)
			    putchar('\t');
			for (; j < i; j++)
			    putchar(' ');
		    }
		}
		putchar(c);
		j++;
	}
	i++;
    }
}
