	Name upper
	Title	Lowercase to Uppercase filter.
	page	,132
comment /

	This program is a filter that translates all lowercase
	characters to uppercase.  It will optionally accept a
	filename to read input from.  All output goes to the
	standard output device unless redirected.

	Examples:
		Upper abc.txt		read input from abc.txt,
				output goes to screen.
		Upper abc.txt >abcnew.txt
				read input from abc.txt,
				output goes to abcnew.txt.
		Upper <abc.txt >abcnew.txt
				same as previous example
		Upper abc.txt | find "ABC"
				translates abc.txt to uppercase
				and then searches the result
				for the string "ABC".
				Output goes to screen.
		find "abc" abc.txt | upper | sort
                          	Search abc.txt for all lines that
				contain "abc".  Translate all lines
				selected and sort them, sending output
				to the screen.
/
;===================================================================
code	segment	public
;===================================================================
;
;	command line is at 80h of psp - first byte is length
;
	org	80h
parmsize	db	?
parm		db	7fh dup (?)
;
; .com starts at 100h - but must jump around any data area
;
	org	100h			; com file starts here
	assume	cs:code,ds:code,es:code
upper:
	jmp	clear
;===================================================================
;
; data area for .com programs
;
handle	dw	0h			; assume standard input
bufsiz	equ	256
;
;===================================================================
clear:
;
; start of actual code is here (clear)
;
	mov	ah,30h		; get dos version
	int	21h
	cmp	al,2		; must be at least 2.0
	jb	oops
;
; release uneeded memory
;
	mov	bx,offset buffer[512]	; 256 byte buffer
	mov	sp,bx			; + 256 byte local stack
	mov	cx,4
	sar	bx,cl
	inc	bx		; paragraphs needed = end/16 + 1
	mov	ah,4ah		; SETBLOCK
	int	21h
;
; now figure out which file to read from - parm line or standard input
;
	cmp	parmsize,0h	; if zero, no parm
	jz	again		; assume standard input
;
; parm length is not zero - assume the parm is a file name.  If not
; found, quit.
;
	mov	al,parmsize	; get size of parm
	xor	ah,ah		; zero out top part of accum.
	mov	si,ax		; use length as a pointer into the dta
	mov	[si]+parm,0h	; to tack on a zero byte (asciiz).
;
; now try to open the file
;
	mov	dx,offset parm+1	; address of 'filename'
	mov	al,0h		; open for read only
	mov	ah,3dh		; dos open function
	int	21h		; invoke function
	jc	oops		; open error - quit
	mov	handle,ax	; save file handle
again:
	mov	bx,handle	; read from standard input or file
	mov	cx,bufsiz	; # of characters to read
	mov	dx,offset buffer
	mov	ah,3fh		; dos read function
	int	21h		; invoke function
	jc	oops		; error!
	cmp	ax,0h		; if zero, end of file
	jz	oops
;
	push	ax		; save copy of ax
	mov	cx,ax		; cx (and ax) contain # characters read
	mov	si,offset buffer
	mov	di,si		; di gets it too
loop1:
	lodsb			; get a character from buffer
	cmp	al,'a'		; if not between 'a' and 'z', skip
	jl	ok
	cmp	al,'z'
	jg	ok
	sub	al,20h		; else switch to uppercase
ok:
	stosb			; put back into buffer
	loop	loop1		; and repeat for entire buffer
;
	pop	cx		; restore character count
	mov	bx,1h		; standard output device
	mov	ah,40h		; dos write function
	int	21h		; invoke dos function

	jmp	again		; repeat until end of file or error
oops:
	int	20h		; return to dos

buffer	label	byte

code	ends
	end	upper
