	Name Snglspc
	Title	Convert doublespace to singlespace (remove blank lines.)
	page	,132
comment /

	This program is a filter that deletes blank lines from a file.

	Examples:
		Snglspc abc.txt		read input from abc.txt,
		Snglspc abc.txt >abcnew.txt
		Snglspc <abc.txt >abcnew.txt
		Snglspc abc.txt | find "ABC"
		find "abc" abc.txt | Snglspc | sort
/
;===================================================================
code	segment	public
;===================================================================
;
;	command line is at 80h of psp - first byte is length
;
	org	80h
parmsize	db	?
parm		db	7fh dup (?)
;
; .com starts at 100h - but must jump around any data area
;
	org	100h			; com file starts here
	assume	cs:code,ds:code,es:code
snglspc:
	jmp	clear
;===================================================================
;
; data area for .com programs
;
cr	equ	0dh
lf	equ	0ah
eof	equ	1ah
;
handle	dw	0h			; assume standard input
bufsiz	equ	256
flag		db	0h
outcount	dw	0h		; output char count
;
;===================================================================
clear:
;
; start of actual code is here (clear)
;
	mov	ah,30h		; get dos version
	int	21h
	cmp	al,2		; must be at least 2.0
	jae	xxxx
	jmp	oops
;
; release uneeded memory
;
xxxx:
	mov	bx,offset bufferout[512]	; 256 byte buffer
	mov	sp,bx			; + 256 byte local stack
	mov	cx,4
	sar	bx,cl
	inc	bx		; paragraphs needed = end/16 + 1
	mov	ah,4ah		; SETBLOCK
	int	21h
;
; now figure out which file to read from - parm line or standard input
;
	cmp	parmsize,0h	; if zero, no parm
	jz	again		; assume standard input
;
; parm length is not zero - assume the parm is a file name.  If not
; found, quit.
;
	mov	al,parmsize	; get size of parm
	xor	ah,ah		; zero out top part of accum.
	mov	si,ax		; use length as a pointer into the dta
	mov	[si]+parm,0h	; to tack on a zero byte (asciiz).
;
; now try to open the file
;
	mov	dx,offset parm+1	; address of 'filename'
	mov	al,0h		; open for read only
	mov	ah,3dh		; dos open function
	int	21h		; invoke function
	jc	oops		; open error - quit
	mov	handle,ax	; save file handle
again:
	mov	bx,handle	; read from standard input or file
	mov	cx,bufsiz	; # of characters to read
	mov	dx,offset bufferin
	mov	ah,3fh		; dos read function
	int	21h		; invoke function
;
	jc	oops		; error!
	cmp	ax,0h		; if zero, end of file
	jz	oops
;
	mov	cx,ax		; cx (and ax) contain # characters read
	mov	outcount,0h	; init output character counter
	mov	si,offset bufferin
	mov	di,offset bufferout
loop1:
	lodsb           	; get a character.  If cr or lf,
	cmp	al,cr		; increment flag.
	jne	next
	add	flag,1h
	jmp	next3
next:
	cmp	al,lf
	jne	next2
	add	flag,1h
	jmp	next3
next2:
	mov	flag,0h		; not cr/lf, reset flag
next3:
	cmp	flag,02h	; if flag is greater than 2, skip
	jg	skip		; the characters.
	inc	outcount	; increment count of characters output
	stosb
skip:
	loop	loop1		; and repeat for entire buffer
;
	mov	cx,outcount	; restore character count
	mov	bx,1h		; standard output device
	mov	dx,offset bufferout	; output buffer
	mov	ah,40h		; dos write function
	int	21h		; invoke dos function

	jmp	again		; repeat until end of file or error
oops:
	int	20h		; return to dos

bufferin	label	near
bufferout	equ	bufferin+256

code	ends
	end	snglspc
