	Name forclean
	Title
	page	,132
comment /

	This program is a filter that reads a fortran file and
	removes comment lines and numeric labels from the code.
	Used with trunc and find, this can help list all subroutines
 used by a program.

	==>	FIND "CALL" FORTRAN.FOR|FORCLEAN|TRUNC (|SORT|UNIQUE
					--------
/
;===================================================================
code	segment	public
;===================================================================
;
;	command line is at 80h of psp - first byte is length
;
	org	80h
parmsize	db	?
parm		db	7fh dup (?)
;
; .com starts at 100h - but must jump around any data area
;
	org	100h			; com file starts here
	assume	cs:code,ds:code,es:code
forclean:
	jmp	clear
;===================================================================
;
; data area for .com programs
;
inchar  	db	?
count		dw	?
;
;===================================================================
clear:
;
; start of actual code is here (clear)
;
	mov	ah,30h		; get dos version
	int	21h
	cmp	al,2		; must be at least 2.0
	jae	xxxx
	jmp	oops
;
; release uneeded memory
;
xxxx:
	mov	bx,offset bos[256]	; 256 byte local stack
	mov	sp,bx
	mov	cx,4
	sar	bx,cl
	inc	bx		; paragraphs needed = end/16 + 1
	mov	ah,4ah		; SETBLOCK
	int	21h
;
; Read a character.  If it is 'C' skip the line.  If numeric, convert
; to space.
;
; These two i/o parameters are constants.
;
parmok:
	mov	dx,offset inchar
	mov	cx,1h		; get 1 character
	mov	count,0h 	; position of character in line
again:
;
; read a character
;
	xor	bx,bx		; zero is handle of standard input
	mov	ah,3fh		; read a file/device function
	int	21h		; invoke the function
;
; if carry set of ax=0 exit
;
	jc	oops		; i/o error
	and	ax,ax		; set flags
	jz	oops		; eof
;
	inc	count		; character position in line
;
; compare character against parmline.
;
	cmp	count,1h	; if 1, test for '$' and 'C'
	jne	notfirst
;
; if C or $ skip the whole line. (It's a comment or metacommand.)
;
; If TAB, add 7 to count.
;
	cmp	inchar,09h	; tab character?
	jne	testc
	add	count,07h	; adjust for tab
	jmp	notfirst
testc:
	cmp	inchar,'C'
	je	skip
	cmp	inchar,'$'
	je	skip
;
; If character is '0'-'9' and count <6 convert to space.
;
notfirst:
	cmp	count,6h	; test for position
	jge	output		; don't test at all if count >=6.
	cmp	inchar,'0'	; if '0' >= inchar >= '9' convert it.
	jl	output
	cmp	inchar,'9'
	jg	output
	mov	inchar,' '	; convert to space
	jmp	output		; output the character
;
; First character was C or $ - skip the rest of the line.
;
skip:
	xor	bx,bx		; zero is handle of standard input
	mov	cx,1h		; get 1 character
	mov	ah,3fh		; read a file/device function
	int	21h		; invoke the function
;
; if carry set of ax=0 exit
;
	jc	oops		; i/o error
	and	ax,ax		; set flags
	jz	oops		; eof
;
; look for <lf>
;
	cmp	inchar,0Ah	; if inchar is <LF>, start i/o again.
	jne	skip		; otherwise skip it.
	mov	count,0h
	jmp	again
output:
	mov	bx,1h		; standard output handle
	mov	ah,40h		; dx still points at inchar
	int	21h		; call dos output function
;
; if character just output was a <lf>, re-init the position counter
;
	cmp	inchar,0Ah
	jne	again
	mov	count,0h
	jmp	again		; repeat cycle
oops:
	int	20h		; return to dos

bos	label	near		; bottom of stack

code	ends
	end	forclean
