	Name feed
	Title	feed
	page	,132
comment /

	This program is a filter that reads the parameter line
	for a file spec.  If it finds one it opens all matching
	files and sends them to standard output.  This is good
	for processing more than one file, find, translat, etc.
/
;===================================================================
code	segment	public
;===================================================================
;
;	command line is at 80h of psp - first byte is length
;
	org	80h
dta	db	21 dup (?)
attrib	db	?
ftime	dw	?
fdate	dw	?
fsize	dd	?
fname	db	13 dup (?) 	; dta asciiz filename from dos.
;
; .com starts at 100h - but must jump around any data area
;
	org	100h			; com file starts here
	assume	cs:code,ds:code,es:code
feed:
	jmp	short clear
;===================================================================
;
; data area for .com programs
;
handle	dw	0h			; assume standard input
bufsiz	equ	256
;
;===================================================================
clear:
;
; start of actual code is here (clear)
;
	mov	ah,30h		; get dos version
	int	21h
	cmp	al,2		; must be at least 2.0
	jb	nomore
;
; release uneeded memory
;
	lea	bx,buffer[512]	; 256 byte buffer + 256 byte stack
	mov	sp,bx
	mov	cx,4
	sar	bx,cl
	inc	bx		; paragraphs needed = end/16 + 1
	mov	ah,4ah		; SETBLOCK
	int	21h
;
; now figure out which file to read from - parm line or standard input
;
	cmp	dta,0h		; if zero, no parm
	jz	nomore		; must have parm to read
;
; parm length is not zero - assume the parm is a file name.  If not
; found, quit.
;
	mov	al,dta		; get size of parm
	xor	ah,ah		; zero out top part of accum.
	mov	si,ax		; use length as a pointer into the dta
	mov	[si]+dta+1,0h	; to tack on a zero byte (asciiz).
;
; Use the default dta at 80h.  Find first matching filename.
;
	mov	dx,offset dta+2	; address of 'filename'
	xor	cx,cx		; attributes of file - (normal)
	mov	ah,4Eh		; dos
	int	21h		; invoke function
	jc	nomore		; error or no match - quit
;
; fname should now contain the first byte of an asciiz filename that
; matches the filespec from the parmline. open the file and send it
; to standard output.
;
again:
;
; open the file
;
	mov	dx,offset fname	; point at asciiz filename
	mov	al,0h		; open for reading
	mov	ah,3dh		; read function call
	int	21h		; invoke dos
	jc	oops
	mov	handle,ax	; save file handle.
;
; now use the handle to read the file.  AX will contain the # of
; characters returned from the file after the read.
; if ax=0 eof.
;
readloop:
	mov	bx,handle	; read from standard input or file
	mov	cx,bufsiz	; # of characters to read
	mov	dx,offset buffer	; seg:off address of buffer area
	mov	ah,3fh		; dos read function
	int	21h		; invoke function
	jc	oops		; error!
	cmp	ax,0h		; if zero, end of file
	jz	oops
;
	mov	cx,ax		; cx (and ax) contain # characters read
	mov	si,offset buffer	; offset of buffer
;
	mov	bx,1h		; standard output device
	mov	ah,40h		; dos write function
	int	21h		; invoke dos function

	jmp	readloop	; repeat until end of file or error
oops:
;
; end of file or access error
; jump to next filename
;
	mov	ah,4fh		; this call takes no input.
	int	21h		; if carry set, no more files.
	jnc	again   	; if no carry, go transfer this one
nomore:
	int	20h		; return to dos

buffer	label	byte

code	ends
	end	feed
