	Name fecho
	Title
	page	,132
comment /

	This program is a filter that reads from standard input and
	echoes both to standard out and standard error output.  This
	is useful when debugging filter sequences because it allows
	you to view the intermediate data as the commands are executed.

/
;===================================================================
code	segment	public
;===================================================================
;
;	command line is at 80h of psp - first byte is length
;
	org	80h
parmsize	db	?
parm		db	7fh dup (?)
;
; .com starts at 100h - but must jump around any data area
;
	org	100h			; com file starts here
	assume	cs:code,ds:code,es:code
fecho:
	jmp	clear
;===================================================================
;
; data area for .com programs
;
inchar  	db	?
;
;===================================================================
clear:
;
; start of actual code is here (clear)
;
	mov	ah,30h		; get dos version
	int	21h
	cmp	al,2		; must be at least 2.0
	jb	oops
;
; release uneeded memory
;
	mov	bx,offset bos[256]	; 256 byte local stack
	mov	sp,bx
	mov	cx,4
	sar	bx,cl
	inc	bx		; paragraphs needed = end/16 + 1
	mov	ah,4ah		; SETBLOCK
	int	21h
;
; These two i/o parameters are constants.
;
	mov	dx,offset inchar
	mov	cx,1h		; get 1 character
again:
;
; read a character
;
	xor	bx,bx		; zero is handle of standard input
	mov	ah,3fh		; read a file/device function
	int	21h		; invoke the function
;
; if carry set of ax=0 exit
;
	jc	oops		; i/o error
	or	ax,ax		; set flags
	jz	oops		; eof
;
; now output to standard output
;
output:
	mov	bx,1h		; standard output handle
	mov	ah,40h		; dx still points at inchar
	int	21h		; call dos output function
;
; now output to error output as an echo
;
	mov	bx,2h		; standard output handle
	mov	ah,40h		; dx still points at inchar
	int	21h		; call dos output function
	jmp	again		; repeat cycle
oops:
	int	20h		; return to dos

bos	label	near		; bottom of stack

code	ends
	end	fecho
