        PAGE    60,132
NAME    ToFixed.Asm -> toFixed.EXE
        TITLE   ToFixed Version 1.5
        .model tiny
        .386            ; only works on a 386 or SX
                        ; must use MASM 6.0.  OPTASM won't work.

COMMENT 

ToFixed.COM Copyright Roedy Green Canadian Mind Products (1991)

May be freely distributed for non-military use only.

USE:

ToFixed  MyFile.Txt  70

Converts an ASCII text file into a fixed length format with all records
the same length.  Pads short records with spaces, and chops long records.
Input and Output records are delimited by CrLf.  There is no ^Z terminator
on the input or output file.  The record length specified does
not include the CrLf.

We use two 63K buffers, stored out past the stack.  Warning: needs 131K

The output overwrites the input file.


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.5 1998 November 8
- embed Barker address

Version 1.4 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.3
- new address and phone

Version 1.1
- added saftety checks for disk space and RAM
- now deletes temp file if aborts part way through

Version 1.0
- used to convert list of bartenders to fixed length format.



How It Works
------------

We read scanning for CrLf in the buffer.  We copy the record and
chop/pad as necessary to the output buffer.

If we are getting dangerously near the end of the buffer, we
read in a new buffer full.  The new buffer full will usually
partially overlap what we read previously.  The buffer will
start with the first unprocessed record.  This simplifies
processing.  We never have to process a record that spans
buffers.

By dangerously near the end, I mean within 255 bytes + CrLf of
the end of the buffer.  When we read the new buffer, we end up
reading in part of the tail end of the old buffer full.  We
re-read it so we can process it without worrying about it not
fitting inside the buffer.

Before we copy a record to the output buffer, we ensure it is
not dangerously full.  If it is, we write it out.  The next
output buffer then starts with the record we are about to write.

All subroutine calls are presumed to trash all registers.

       ; end of comment


CR      MACRO   ; Carriage return line feed
        DB 0dh,0ah
        ENDM

EOS     MACRO   ; marks end of display string
        DB 0dh,0ah,'$'
        ENDM
;======
CSEG    segment
        assume CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG
                                        ; Since this is a .COM program
        org 100h                        ; Likewise
;======================================
;       E Q U A T E S
;======================================

InBuffMax       equ     60*1024         ; amount to read at a time
OutBuffMax      equ     63*1024         ; amount to write at a time


;======================================
;   M A I N L I N E   R O U T I N E
;======================================
start:
        Call    CalcSeg                 ; calculate segment for Output buffer
        Call    ParseInFileName         ; pick first parm off commandline
        Call    ParseRecLen             ; pick second parm off commandline

        Call    OpenInFile              ; open the file for read
        Call    OpenOutfile             ; open temporary output file
        Call    CalcOutBuffDanger       ; how close to end can we get
                                        ; to end of output buffer?
NextBlock:
                                        ; loop, processing chunks of
                                        ; one input buffer full.
        Call    ReadInBuff              ; read first buffer full
        test    InBufflen,-1            ; if read nothing, we are done.
        jz      Done
        Call    ProcessBuff             ; process input buffer till dangerously
                                        ; near the end
        Call    CalcNextInLseek         ; calc position of next read
        jmp     NextBlock
Done:
        Call    WriteOutBuff            ; write out last buffer full
        Call    CloseInFile             ; close files
        Call    CloseOutFile
        Call    DelInFile               ; delete input file
        Call    RenOutfile              ; rename output file to input

        mov     ax, 4c00h               ; quit with errorlevel=0
        int     21h                     ; normal bye

Trouble:
        lea     dx,parsefailmsg         ; something went wrong
        Call    Say
        mov     ax, 4c01h               ; quit with errorlevel=1
        int     21h                     ; bye

;============================================

Say     Proc

;       on entry DX points to a string to display
        mov     ah,9
        int     21h
        ret
Say     EndP

;==============================================================

CalcSeg Proc    Near

;       Calculate segments where will put two buffers
;       put out beyond end of program


;       ensure have 128K RAM
;       See Ray Duncan's Advanced MS DOS page 440.

        mov     ah,04Ah                 ; resize RAM
        mov     bx,0ffffh               ; ask for all the ram
                                        ; We have everything already
        int     21h
                                        ; Will always fail, so carry is ok.
                                        ; no need to give back.
                                        ; bx = paras allocated
        cmp     bx,2*4096               ; 2 64K segments
        jb      RamFail

        mov     ax,ds
        add     ax,64*64                ; put 64K higher out past stack
        mov     OutSeg,ax
        ret

RAMFail:
        lea     dx,RAMFailMsg
        call    Say
        mov     ax,4c01h                ; quit with errorlevel=1
        int     21h                     ; fail

CalcSeg EndP

;==============================================================

ParseInFileName PROC

; PARSE FILENAME on commandline

                                ; counted string at HEX 80
                                ; contains command line.
                                ; It has no trailing null.
                                ; Name of file we want is
                                ; preceded and followed by
                                ; unwanted spaces.
        xor     ch,ch
        mov     cl,DS:80h       ; CX contains length of command
        mov     bx,cx
        mov     al,20h
        mov     [bx+81h],al     ; store trailing blank on command
        inc     cx              ; and increase string length.
                                ; to simplify parsing
        mov     di,81h
        jcxz    Trouble
        repe    scasb           ; scan for start file name
                                ; DI points one past it.
        mov     dx,di           ; DS:DX point to file
        dec     dx
        mov     InFilenameptr,dx; Save pointer for future ref.
        jcxz    Trouble
        repne   scasb           ; scan to end of file name
                                ; DI points one past trail blank
        mov     byte ptr [di-1],0
                                ; patch in trail null after filename
        ret

ParseInFileName ENDP

;==============================================================

ParseRecLen     PROC
;       get record length for output.

                                ; DS:SI points to blanks before
                                ; left over from parsing InFileName
                                ; number.  CX is command len.
        JCXZ    Trouble
        repe    scasb           ; scan for first digit of number
        mov     dx,di           ; point to number start
        dec     dx
        mov     NumberAd,dx     ; Save location start number for
                                ; future ref.
        jcxz    Trouble
        repne   scasb           ; scan for blank at end of number
        sub     di,dx           ; calculate length of number string
        dec     di
        jle     Trouble         ; had better be positive
        mov     NumberLen,di    ; save length for future ref.
        mov     cx,Numberlen
        mov     si,NumberAd
        call    ASCIItoBin      ; desired size = DX:AX
        mov     RecLen,ax
        ret

ParseRecLen     EndP

;============================================

ASCIIToBin      PROC

;       on entry DS:SI points to start of decimal ASCII string of digits.
;       String should contain only the decimal digits 0..9.
;       CX contains length of string > 0
;       On exit DX:AX contains binary equivalent of string.
        push    bx              ; save regs we will trash
        push    cx
        push    si
        push    di
        xor     ax,ax
        mov     dx,ax           ; accumulate in DX:AX

OneDigitLoop:

; multiply accumulated number by 10
                                ; Works because 10*X = 2*X + 8*X
                                ; use DI:BX as working register
        shl     ax,1
        rcl     dx,1            ; DX:AX = x*2
        mov     bx,ax
        mov     di,dx
        shl     bx,1
        rcl     di,1
        shl     bx,1
        rcl     di,1            ; DI:BX = x*8
        add     bx,ax
        adc     di,dx           ; DI:BX = x*2 + x*8

; add on the next digit
        xor     dx,dx
        mov     ah,dh
        lodsb                   ; get next digit in AL
        sub     al,"0"          ; convert 1 digit ASCII to bin
        JL      NumTrouble      ; ensure 0..9
        cmp     al,9
        JG      NumTrouble
        add     ax,bx           ; add it onto accumulated product
        adc     dx,di

        loop    OneDigitLoop    ; loop once for each digit

                                ; restore regs
        pop     di
        pop     si
        pop     cx
        pop     bx              ; save regs we will trash

        ret

NumTrouble:
;       Some problem, give standard Error message.
        jmp     Trouble

NumberAd        DW      0       ; address of number string
NumberLen       DW      0       ; length of number string

ASCIIToBin      ENDP

;============================================

OpenInFile      Proc    Near

;  OPEN THE FILE
        mov     dx,InFileNamePtr        ; DS:DX point to file
        mov     ax,03D02H               ; DOS open file, read/write
        int     21h
        jc      InFilefail
        mov     InHandle,ax     ; save handle
        ret

InFileFail:
        lea     dx,InFileFailMsg
        call    Say
        mov     ax,4c01h                ; quit with errorlevel=1
        int     21h                     ; fail

OpenInFile      EndP

;============================================

OpenOutfile     Proc    Near

;       Create temporary output file on SAME DRIVE as the input.
;       If inputfilename begins C:xxx then we use C:\ as our
;       starting point.  If there is no colon, then we use plain \.
;       This way we can later rename the file to the input.

        mov     si,InfileNamePtr
        cmp     byte ptr[si+1],":"
        jne     NoDriveSpecified
        lea     di,OutFileName
        movsw                           ; copy drive and colon
        mov     ax,005ch
        stosw                           ; store trailing \0

NoDriveSpecified:                       ; no drive specified, leave as \0

        mov     ah,5Ah                  ; create unique file
        mov     cx,0                    ; nothing special attribute
        lea     dx,OutFileName
                                        ; DS:dx points to filename
        int     21h
        jc      OutFileFail
        mov     OutHandle,ax
        ret

OutFileFail:
        lea     dx,OutFileFailMsg
        call    Say
        Call    DelOutFile
        mov     ax,4c01h                ; quit with errorlevel=1
        int     21h                     ; fail

OpenOutFile     EndP

;============================================

CloseInFile     Proc    Near

;       Close the input file

        mov     ah,3Eh          ; DOS close file
        mov     bx,InHandle
        int     21h
                                ; don't bother to check if it worked.
        ret

CloseInFile     EndP

;============================================

CloseOutFile    Proc    Near

;       Close the output file

        mov     ah,3Eh          ; DOS close file
        mov     bx,OutHandle
        int     21h
                                ; don't bother to check if it worked.
        ret

CloseOutFile    EndP

;============================================

DelInFile       Proc

;       Delete the input file, preparatory to renaming output to it.

        mov     ah,41h                  ; delete
        mov     dx,InfileNamePtr        ; Pointer to filespec (ASCIIZ string)
        int     21h
        ret

DelInFile       EndP

;============================================

DelOutFile      Proc

;       Delete the temporary output file in case we had to abort

        test    OutHandle,-1            ; No need to do anything unless
                                        ; file is open
        jz      OutFileGone
        Call    CloseOutFile
        mov     ah,41h                  ; delete
        lea     dx,OutfileName          ; Pointer to filespec (ASCIIZ string)
        int     21h
OutFileGone:
        ret

DelOutFile      EndP

;============================================


RenOutFile      Proc

;       Rename the output file to the input file

        mov     ah,56h
        lea     dx,OutFilename          ; DS:DX Pointer to an ASCIIZ string containing
                                        ; original path and filename
        mov     di,InFileNamePtr        ; ES:DI Pointer to an ASCIIZ string containing
                                        ; new path and filename
        int     21h
        ret

RenOutFile      EndP


;============================================


ReadInBuff      Proc    Near


;       Reads the next buffer full of info starting at LSEEK

        mov     ax,4200h                ; function to seek relative to start of file
        mov     bx,InHandle
        mov     dx,word Ptr InLseek     ; cx:dx pointer to where in file
        mov     cx,word Ptr InLseek+2
        int     21h

        mov     ah,3fh                  ; read function
        mov     bx,InHandle
        mov     cx,InBuffMax            ; bytes to read
        lea     dx,InBuffer             ; DS:DX is buffer
        int     21h                     ; Read buffer full
        mov     InBuffLen,ax            ; ax has bytes actually read.
                                        ; this is how we handle partial last buffer.
        ret

ReadInBuff              Endp


;============================================

ProcessBuff     Proc    Near

        Call    CalcInBuffDanger        ; calculate how close to the end we dare get
        lea     di,InBuffer             ; start at beginning of buffer

NextRec:
                                        ; loop for each record
        Call    EnsureOutRoom           ; make sure is room in output buffer for
                                        ; at least one more record
        cmp     di,InBuffDanger
        jae     BuffDone
                                ; we can process this record safely without
                                ; running off the end of the record.

        mov     si,di           ; save pointer to start of string
        mov     cx,256          ; longest possible line 255+Cr (+Lf)
        mov     al,13
        repne   scasb           ; scan till hit Cr
                                ; di is pointing at Lf
        inc     di              ; make di point at the next record
        sub     cx,255          ; length does not count CrLf
        neg     cx              ; si points to string, cx is its length
                                ; excluding the CrLf
        push    di
        Call    CopyToOut       ; copy string to output buffer, and append CrLf
        pop     di
        jmp     NextRec

BuffDone:
        mov     Unprocessed,di  ; first byte not processed
        ret

ProcessBuff     EndP


;============================================

CopyToOut       Proc    Near

;       Copies string pointed at by si,cx in input buffer to output buffer
;       chops/pads as needed.  cx excludes CrLf
;       copies 32 bits at a time

        push    ES
        push    cx
        mov     dx,Reclen
        cmp     cx,dx
        jl      Pad
        mov     cx,dx                   ; must chop or just fits
Pad:
        mov     di,OutFree              ; pointer to next free slot in output buffer
        push    cx
        shr     cx,2                    ; work by dwords, copying
        mov     bx,OutSeg
        mov     ES,bx
        assume  ES:OutBufSeg
        rep     movsd
        pop     cx                      ; handle the possible last odd last bytes
        and     cx,3
        rep     movsb
                                        ; calculate bytes of space padding
                                        ; needed.
        pop     cx                      ; original length
        sub     cx,dx
        neg     cx                      ; bytes of padding needed
        jle     NoPadding               ; no padding needed
        push    cx
        shr     cx,2
        mov     eax,020202020h          ; a quartet of spaces
        rep     stosd                   ; work by dwords, padding with spaces
        pop     cx
        and     cx,3
        rep     stosb                   ; handle possible last odd spaces
NoPadding:
        mov     ax,0a0dh                ; CrLf
        stosw                           ; di points to next free slot
        pop     ES
        assume  ES:CSEG
        mov     OutFree,di
        ret

CopyToOut       EndP

;============================================


CalcInBuffDanger        Proc    Near

;       calculate how close to the end of input buffer we dare process.

        lea     ax,inbuffer     ; presuming buffer is full
        add     ax,InBuffMax
        sub     ax,255+2
        lea     bx,Inbuffer     ; presuming buffer is partly full
        add     bx,InBuffLen
        cmp     ax,bx
        jb      fullcase
        mov     ax,bx           ; buffer only party full
fullcase:
        mov     InBuffDanger,ax
        ret

CalcInBuffDanger        EndP

;============================================

CalcOutBuffDanger       Proc    Near

;       calculate how close to the end of output buffer we dare process.

        lea     ax,outbuffer            ; presuming buffer is full
        add     ax,OutBuffMax
        sub     ax,RecLen
        dec     ax                      ; account for CrLf
        mov     OutBuffDanger,ax        ; first char unsafe
        ret

CalcOutBuffDanger       EndP

;============================================

EnsureOutRoom   Proc    Near

;       Ensure there is enough room left in the output buffer
;       for at least one more record

        mov     ax,OutFree              ; get next free slot
        cmp     ax,OutBuffDanger        ; length of a standard record
        jb      IsRoom
        Call    WriteOutBuff            ; write out current buffer
IsRoom:
        ret

EnsureOutRoom   EndP

;============================================

WriteOutBuff    Proc    Near

;       Write out the entire output buffer
;       No need to Lseek, as we write purely sequentially

        mov     ah,40h          ; write function
        mov     bx,OutHandle
        mov     cx,OutFree
        sub     cx,offset OutBuffer
                                ; cx = bytes to write
        jcxz    NoWrite         ; no need to write if no bytes.
        lea     dx,OutBuffer    ; DS:DX address of buffer
        push    DS
        mov     si,OutSeg
        mov     DS,si
        int     21h
        pop     DS
        jc      OutFileFail
        cmp     ax,cx           ; ensure all bytes were written
        jne     OutFileFail
NoWrite:
        mov     OutFree,Offset OutBuffer
                                ; set up for next buffer full
        ret

WriteOutBuff    EndP

;============================================

CalcNextInLSeek Proc    Near

;       Calculate offset of the next bufferload we will process
        mov     bx,unprocessed          ; byte past last record processed
        sub     bx,offset InBuffer      ; bx = length of processed buffer
        add     word ptr Inlseek,bx     ; seek bx bytes further along the file
        adc     word ptr Inlseek+2,0
        ret

CalcNextInLSeek EndP

;============================================

;======================
;  I N P U T   F I L E   V A R I A B L E S
;======================

InSeg                   dw      0
                        ; segment for InBuffer


InFileNamePtr   dw      0
                        ; pointer to filename in command line

InLSeek         DD      0
                        ; offset in current file where buffer fits in.

InBuffLen       DW      0
                        ; number of useful bytes in the current buffer.
                        ; c.f. InBuffMax -- size of buffer

InBuffDanger    DW      0
                        ; pointer to first byte near end of buffer considered
                        ; dangerously close to the end.

Unprocessed     DW      0
                        ; pointer to first byte not processed in buffer.
                        ; If entire buffer processed, points one past the end.

InHandle                DW      0
                        ; handle for reading the file.

;======================
;  O U T P U T  F I L E   V A R I A B L E S
;======================

OutSeg                  dw      0
                        ; segment for OutBuffer

OutFileName             db      "\",0,16 dup (0)
                        ; name of temporary output file

OutFree                 dw      offset OutBuffer
                        ; pointer to next free byte in the output buffer

OutHandle               dw      0
                        ; handle for writing the file.

OutBuffDanger           dw      0
                        ; pointer to first byte near end of buffer considered
                        ; dangerously close to the end.

RecLen                  dw      70
                        ; record length of fixed length output records
                        ; not counting the CrLf


;================================================
;   D I S P L A Y   S T R I N G S
;================================================

RAMFailMsg      db      07,"Not enough RAM.  ToFixed needs 128K",13,10,"$"

ParseFailMsg    db      07,"Problems with command line",13,10
                db      "Try:",13,10
                db      "ToFixed.Com Myfile.Txt 70",13,10,"$"

InFileFailMsg   db      07,"Could not open file",13,10
                db      "Try:",13,10
                db      "ToFixed.Com Myfile.Txt 70",13,10,"$"

OutFileFailMsg  db      07,"Could not write file; probably out of disk space.",13,10,"$"



;               Not displayed, but embedded

BannerMsg       label   byte
        DB      ' ToFixed 1.5 ',13d,10d
        DB      13d,10d
        DB      'Copyright (c) 1991,1998 Roedy Green Canadian Mind Products',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.',13,10,'$'

InBuffer        label byte
;                       really InBuffMax dup (?) but then stupid MASM
;                       generates 60K of zeroes!

;================================================
; S E G M E N T
;================================================


OutBufSeg       Segment AT 0h   ; will really be up past stack
OutBuffer       DB      OutBuffMax dup (?)
OutBufSeg       Ends


CSEG ends
end     Start
