/* PROGRAM TABOUT  converts tabs to spaces

usage : TABOUT.exe Myfile.TXT
        - expands tabs to spaces
        - trims off ^z Eof char
        - ensures each line ends in CrLf
        - trims trailing spaces of each line.

*/

/*
Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com
*/

/*
compiled under TINY model for DOS under Borland C++ 5.01,
no floating point needed.
Generates mysterious error message about strupr having no prototype. Why?

Version  2.4 1998 November 8
- embed Barker address

Version 2.3 1997 March 6
- add *.SQL, *.HTM, *.INI, *.DLL file types

Version 2.2 1996 October 25
- embed Quathiaski address.
- simplify code to create temporary workfile.
- simplify code to check extensions.
- new algorithm that does not have a maximum line length

Version 2.1 1993 June 8
- embed new address and phone

Version 2.0 1990/04/29 (c) Roedy Green in Microsoft C 5.1

The program will expand tabs from files with the following extensions:
        .ASM .PAS .BAT .CTL .CMD .LST .MAC .TXT .USE .KEY .ANS .C .H
The program will refuse to expand tabs from files with the following
extensions:
    bad =.EXE .COM .OBJ
For all other extensions the program will prompt with a warning
message ask and for confirmation before continuing.  *.DOC are
often MS-Word files - which must be left alone.


Source and excutables may be freely used for any purpose except military.

Possible future extensions:
There is a C library function to expand wildcards. All that
would be needed is loop in main to handle the multiple filenames.

*/

/* ==================================== */

#define Esc '\x1B'
#define TabSpacing 8

#include <stdlib.h>  /* exit, putenv, _splitpath */
#include <stdio.h>   /* fclose, fgetc, printf, remove, rename, setvbuf */
#include <string.h>  /* strcat, strcmp, strupr */
#include <conio.h>   /* getch */
#include <ctype.h>   /* toupper */

/* ==================================== */

/* use all global variables and no parameter passing for simplicity. */

FILE *Before;
/* input file containing no ^Z chars, except possibly at the end */

FILE *After;
/* output file with tabs expanded to tabs */

char * BFilename;
/* name of file we will convert */

char * AFilename;
/* name of the temporary output file */

/* ==================================== */

/* function prototypes, lowest level first */

void Honk (void);
void Die (void);
void OpenAFile (void);
void OpenBFile (void);
void SafeFilename (void);
void Banner (void);
int  main (int argc,  char *argv[]);

/* ==================================== */

int main( int argc,  char *argv[] )
/* main TABOUT */
{
  int c; /* process char by char */

  int col = 0; /* 1-based column we have written */
  /* 0 = no non-blank chars on line yet */

  int pendingSpaces = 0;  /* spaces we may later drop or emit */

  int i; /* local loop counter */

  if ( _osmajor < 3 )
    {
    Banner();
    printf("Oops!  DOS 3.0 or later needed\n");
    Die();
    }
  if ( argc != 2 /*  0=TabOut.Exe 1=MyFile.Txt  */ )
    {
    Banner();
    printf("Oops!  usage:  TABOUT  Myfile.TXT\n");
    Die();
    }
  BFilename = *++argv; /*  want first arg, not progname  */
  OpenBFile();    /* Open input "before" file. */
  /* Make sure file exists before */
  /* song and dance about extension. */
  SafeFilename(); /* make sure filename has sane extension */
  OpenAFile();    /* open output "after" file */
  printf("Converting tabs to spaces in %s ...\n",BFilename);

  while ( (c=fgetc(Before)) != EOF )
    {
    switch ( c )
      {
      case ' ':
        /* save up spaces, so trailing spaces can be dropped. */
        ++pendingSpaces;
        break;
      case '\t':
        /* effectively expand tab to 1 to 8 spaces */
        pendingSpaces += (TabSpacing - ((col+pendingSpaces) % TabSpacing));
        break;
      case '\n':
        /* ignore pending/trailing spaces */
        fputc('\n',After);
        /* runtime library expands to CrLf */
        col = 0;
        pendingSpaces = 0;
        break;
      default:
        /* ordinary non-blank char */
        /* squirt out any pent up spaces */
        for ( i=0; i<pendingSpaces; i++ )
          {
          fputc(' ',After);
          }
        col += pendingSpaces;
        pendingSpaces = 0;
        /* put out the char itself */
        fputc(c,After);
        col++;
        break;
      } /* end switch */
    } /* end while */
  /* Rename output to input */
  fclose (Before); fclose (After);
  remove (BFilename);
  rename (AFilename, BFilename);
  return (0);
} /* main TABOUT */

/* ==================================== */
void Banner(void)
{
  /* display copyright banner.  Usually not displayed, just embedded. */

  printf("\n Tabout 2.4 ۲\n"
         "\nFreeware to convert tabs to spaces."
         "\nCopyright (c) 1990,1998 Canadian Mind Products"
         "\n" "#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9"
         "\n" "tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com"
         "\n" "May be used freely for non-military use only"
         "\n\n");

} /* Banner */
/* ==================================== */

void SafeFilename(void)
{
  /* Ensure appropriate file name extensions.
     good =.ASM .PAS .etc - done without prompt
      bad =.EXE .COM .OBJ - abort
  warning =.DOC & others
  */
  static const char  * GoodExtensions  [] =
  { ".C", ".CPP",  ".H", ".HPP", ".RH", ".IH", ".TXT",
    ".ASM",".PAS",".BAT",".CTL",".CMD",
    ".LST",".MAC",".TXT",".ANS",
    ".USE",".KEY", ".HTM", ".SQL",".INI",0};
  /* 0 is just end marker */

  static const char * BadExtensions [] =
  { ".EXE",".COM",".OBJ",".DLL",0};

  int Response; /* Y or N, yes Virginia, int, C is weird */

  char Extension[_MAX_EXT];

  int i; /* local loop counter */

  _splitpath(BFilename,
             NULL /* drive */, NULL /* dir */, NULL /* name */, Extension);

  strupr(Extension); /* convert to upper case for compare */

  for ( i=0 ; GoodExtensions[i]; i++ )
    {
    if ( strcmp(Extension,GoodExtensions[i])==0 )
      { /* match, it is Good */
      return;
      }
    }
  for ( i=0 ; BadExtensions[i] ; i++ )
    {
    if ( strcmp(Extension,BadExtensions[i])==0 )
      { /* match, it is bad */
      Banner();
      printf("Oops!  Tabout cannot be used on EXE COM or OBJ files "
             "such as %s\n",
             BFilename);
      Die();
      }
    }
  /* just give a warning */
  printf("Warning!\n"     /* new line to give room for long filename */
         "Tabout is not usually used on %s files such as %s\n",
         Extension,BFilename);
  printf("Do you want to continue and expand the tabs anyway?"
         "  (Y)es (N)o  ");
  while ( 1 ) /* loop forever till user enters Y or N */
    {
    Honk();
    Response = getch();
    /* not echoed because user might hit tab or Enter */
    /* and mess up the screen */
    Response = toupper(Response);
    /* toupper is a macro, so needs simple argument */
    switch ( Response )
      {
      case 'Y':
        printf("Yes\n");
        return;
      case 'N':
        printf("No\n");
        /* fallthru */
      case Esc :
        printf("\nTabout aborted\n");
        Die();
        /* others, keep looping */
      }
    }
}  /* SafeFileName */

/* ==================================== */

void OpenBFile(void)
{ /* open input Before file */
  if ( ( Before = fopen( BFilename, "rt" ) ) == NULL )
    {
    Banner();
    printf("Oops!  Cannot find file %s\n",BFilename);
    Die();
    }
  setvbuf(Before,NULL,_IOFBF,40*512);
} /* OpenBFile */

/* ==================================== */

void OpenAFile(void)
{
  /* create a uniquely named temporary file to hold converted text */
  /* It must be in the same directory as the BFilename since we will */
  /* rename it later. */

  char drive[_MAX_DRIVE]; /* with colon */
  char dir[_MAX_DIR];     /* with lead/trail \ */
  char name[_MAX_FNAME];
  char ext[_MAX_EXT];     /* with lead . */
  char filepath[_MAX_DRIVE + _MAX_DIR];

  _splitpath(BFilename, drive, dir, name, ext);

  strcpy(filepath, drive);
  strcat(filepath, dir);

  /* Force to current directory if empty */
  if ( strcmp(filepath, "") == 0 )
    strcpy(filepath, ".");
  else
    filepath[strlen(filepath) - 1] = 0;  /* chop trail \ */

  /* stop tempnam from using SET TMP directory instead of filepath */
  /* Sets TMP just for this and any "children" */
  /* processes -- doesn't change parent's TMP */
  putenv("TMP=");

  if ( (AFilename = tempnam(filepath, "TMP")) == NULL )
    {
    printf("Oops!  Cannot create the temporary work file\n\a");
    exit(1);
    }
  if ( (After = fopen(AFilename, "wt")) == NULL )
    {
    printf("Oops! Cannot open work file %s\n\a", AFilename);
    exit(1);
    }

  setvbuf(After,NULL,_IOFBF,40*512);
} /* end OpenAFile */

/* ==================================== */

void Honk (void)
{
  /* make a noise */
  printf("\a");
}

/* =================================== */
void Die (void)
{
  Honk();
  fclose (Before);
  fclose (After);
  exit(1);   /* exit with errorlevel = 1 */
} /* Die */

/* ==================================== */

/* -30- */
