        PAGE    60,132
NAME    Quebec
        TITLE   Quebec.com version 1.5 1998 November 8

COMMENT 


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com

Version History
***************

Version 1.5 1998 November 8
- embed Barker address

Version 1.4 1996 October 25
- embed POB 707 Quathiaski Cove address

Quebec 1.3
- displays our new phone number and address

Quebec 1.2
- released to beta test 1991 Nov 23

Quebec 1.1
- lc and uc translate table now restored after patching.
- now hide Alt-Gr by turning into a release instead
  of consuming it.
- also hide stuttering Alt-Gr presses.

Quebec 1.0 was released to BIX beta test on 1991 Nov 21
- based on ESPAN.

Precis
******

QUEBEC French Canadian keyboard driver and generic toolkit.  The
particular keyboard supported IS NOT Microsoft's French Canadian
layout which uses a non standard code page.  This keyboard is
closer to the standard English keyboard using theAmerican
standard 437 codepage.  It has seven unusual keys:

~ ~     { ?     } ]     " ^     < '     < .     ? c,
` "     [ /     ] [     ' `     , ,     . .     / e'

To get the left-hand legends, you hit Alt-Gr (Right alt).  To
get accented keys, hit the accent key, then a letter.  To get a
plain accent, hit an accent key twice.

By modifying QUEBEC's tables you can handle other keyboard
layouts with keys of 1 to 4 legends each, and up to five
different dead-key accents.  MASM/OPTASM source included.  Takes
1424 bytes; by contrast KEYB CF is 6208.  Does not work with XTs
or Compaq.  Does not work under WINDOWS.  Shareware with a $20
registration fee.  Non-military use only.


Purpose
*******

If your keyboard looks like this, then QUEBEC will let you use
it under MS DOS.

 Esc     F1  F2  F3  F4  F5  F6  F7  F8  F9  F10  F11  F12


~~   !   @   #   $   %   ^   @   *   (   )  ---  +    Bsp
`"   1   2   3   4   5   6   7   8   9   0   -   =

  Tab  Q   W   E   R   T   Y   U   I   O   P    {?   }]
       q   w   e   r   t   y   u   i   o   p    [/   ][

CapsLock A   S   D   F   G   H   J   K   L   :   "^  Ent
         a   s   d   f   g   h   j   k   l   ;   '`

      Shf  Z   X   C   V   B   N   M   <'   >.   ?   Shf  |
           z   x   c   v   b   n   m   ,,   ..   /        \

Ctrl  Alt                  Space                    Alt-Gr   Ctrl


The particular keyboard supported IS NOT Microsoft's French
Canadian layout which uses a non standard 863 code page (with
complete upper case accented letters).  This keyboard is closer
to the standard English keyboard using the American standard 437
codepage (with few uppercase accented letters).  It has seven
unusual keys:

~ ~     { ?     } ]     " ^     < '     < .     ? c,
` "     [ /     ] [     ' `     , ,     . .     / e'


If your keyboard is different, you can still use QUEBEC, but you
will have to touch type, since the legends on your keys will not
match.  You can use the QUEBEC source code to create variants
for different keyboards.  If doing that is beyond your current
level of skill, we at Canadian Mind Products will do it for you
for a $250 fee.

Usage
*****

Insert this command near the end of your autoexec.bat file:

Quebec.Com

It will translate your keyboard to French Canadian layout.

NOTE: There is no way to get rid of Quebec except by rebooting.
However, if you load it in a DESQview window, you can get rid of
it my closing the window.  There is no hot key to enable or
disable it.

To get the left-hand legends, you hit Alt-Gr (Right alt).  To
get accented keys, hit the accent key, then a letter.  To get a
plain accent, hit an accent key twice.  Accent keys include:
' acute (aigu), ` grave, ^ hat (circonflexe),  " diaeresis
(trema), ~ tilde.

Accentable letters are a c e i n o u y < > -- upper or lower case
                           n     
                       A   I N O U Y  

The right hand legends are French, the left English.  The
English legends are never considered as dead-key accents, only
as punctuation.

Limitations
***********

QUEBEC does NOT work under WINDOWS, since Windows bypasses BIOS
to use the keyboard.

NOTE: There is no way to get rid of Quebec except by rebooting.
However, if you load it in a DESQview window, you can get rid of
it my closing the window.  There is no hot key to enable or
disable it.

Note it only works on AT computers.  XT computers require you to
load KEYB first.  Only use it ONCE!

There is no hot key Ctrl-Alt-F2 Ctrl-Alt-F1 enable/disable.

Rolling Your Own
****************

If you wish to modify this program, probably you can get the
effect you want just by changing the KEY table definitions
marked like this: <><><><><><><><><><><><><><><><><>

If you are using non-USA code pages, you might also need to
change the tables labelled: Unaccented, Tilde, Aigu, Grave,
Trema and Circ.  You could add others, such as Ring.

The code is well commented and serves as a teaching example on
keyboard TSRs.  Limitations: AT only, no XT, unless you use KEYB
in addition.  Requires AT-style INT 15 multiplex BIOS interrupt
support.  No hot key Ctrl-Alt-F2 enable/disable.  No safety code
to prevent loading twice.  This version uses the standard
English 437 code page.  It thus does not support the French
Canadian code page with the upper case =E^ etc.  This driver
never needs to translate scan code (rearrange keys), so that
feature has been stripped out to keep its size down.


Why Quebec?
***********

You might ask, why QUEBEC.COM?  Why not just use Microsoft's
KEYB.COM.

Quebec lets you use the a popular French Canadian keyboard
layout not supported by DOS's KEYB.  The foreign language
support routines that come with DOS take up too much RAM.  There
is no support for the this French Canadian layout.

The interrupt latency of DOS's KEYB is awful.

What Quebec Has to Do
*********************

Quebec must handle the following problem:

1.  Some keys have 4 legends.  If you hit the character, you get
    the lower right legend.  If you hit SHIFT+char, you get the upper
    right legend.  If you hit Alt-Gr+char you get the lower left
    legend.  If you hit Alt-Gr+char you get the lower left char.
    If you hit Alt-Gr+Shift+Char you get the upper left char.
    This convention is the reverse to of the common one where
    Alt+Gr gets you the RIGHT legends.  I did this because in
    this keyboard layout, the right legends are more frequently
    used.  If you want to use the opposite convention, just change
    the Configuration equate to enable AltGrRight.  Then reassemble.

2.  The accent keys are dead keys.
    If you hit ` for example, the next vowel gets an accent applied.
    e.g. ` + e =>     ' + e =>     " + o =>     ^ + e => 
         ~ + n => 
    Any accent key also works on C to give C cedille.
    Any accent key also works on < and > to give  .
    If you hit it twice you get the accent plain, e.g. `

3.  The "English" left accent keys are not dead.  The right "French"
    ones are.  English accent keys just type as punctuation.

4.  If Alt or Ctrl is pressed, we may just want BIOS to do the
    processing.

5.  If the keyboard buffer is full, it must make a short, shrill beep.

6.  Since we use the right Alt key (Alt-Gr = Alternate graphics)
    to invoke special interpretations of the legends, we must HIDE
    the use of that key from BIOS and maintain our own private
    Alt-Gr state.  Otherwise, a character we generate would look
    like ALT+char to BIOS.

BIOS Tools Quebec Can Use
*************************

For the AT we leave a small TSR resident that intercepts the INT
15 4F keyboard remap interrupt that gets triggered by hardware
every time there is a keystroke event (down or up).

The scan code appears in AL and we can change it if we want.  If
we "consume" the scan code, and with BIOS to do no further
processing on it, we can clear the carry flag, otherwise we
leave it set.

In the XT this extended INT 16 feature may or may not be
present.  If not you must load KEYB US first to provide the
extended INT 16 features.

We get both key-press and key-release scan codes.  We can ignore
key-releases.

Int 16 function 05 PUSH CHARACTER AND SCAN CODE allows us to
push a scan code / character pair into the keystroke buffer.
This is our method of generating characters for which there is
no corresponding scan code. In theory this function is supposed
to set the carry bit, and set AL=01 if the function fails.
However some BIOSes fail to set carry.

We sometimes need to know the state of CAPSLOCK or the Shift key
in order to decide whether to generate an upper or lower case
character.  We can find this out using INT 16H function 02, GET
KEYBOARD FLAGS.  Note this function does not let us discriminate
left from right ALT key.

                     Shift Status (AL)

8 4 2 1 8 4 2 1
1 . . . . . . .      Insert locked
. 1 . . . . . .      Caps Lock locked
. . 1 . . . . .      Num Lock locked
. . . 1 . . . .      Scroll Lock locked
. . . . 1 . . .      Alt key is pressed
. . . . . 1 . .      Ctrl key is pressed
. . . . . . 1 .      Left Shift key is pressed
. . . . . . . 1      Right Shift key is pressed


To determine the shift state of both the left and right Alt key
(the right one is called ALT-Gr) we use INT 16h, function 12h
Get Extended Shift Status.  We can be assured the Alt-Gr key and
extended support exists or a French Canadian keyboard has no
hope of working.  On exit: AL has the AL Shift status and AH the
Extended shift status.

                      Extended Shift Status (AH)

8 4 2 1 8 4 2 1
1 . . . . . . .      Sys Req key is pressed
. 1 . . . . . .      Caps Lock key is pressed
. . 1 . . . . .      Num Lock key is pressed
. . . 1 . . . .      Scroll Lock key is pressed
. . . . 1 . . .      Right Alt key is pressed
. . . . . 1 . .      Right Ctrl key is pressed
. . . . . . 1 .      Left Alt key is pressed
. . . . . . . 1      Left Ctrl key is pressed

Keyboard intercept fine points
******************************

Consider int 15H function 4Fh keyboard intercept.

Int 15 used for many things.  If you want to intercept
characters, you must enchain yourself to the old vector value,
so at the very least you can let the old vector handle non-4F
functions.

However, what if you DO process a character?  You are supposed
to Clear carry to indicate consumption and set carry to indicate
BIOS should handle the scan code.  Let us say we process a char.
Should we or should we not AFTERWARD, jump to the old vector?

If we have CONSUMED the character, we should NOT jump, we should
return immediately to avoid confusing downstream filters.  They
are expecting carry set.  They would not how to handle a
consumed character.

If we have NOT consumed the char, we should jump to the old
vector to let other filters have a bash at it.

Since the keyboard handler invokes INT 15H 4F with an INT, on
the stack will be the pushed the flags, then CS: then IP.  You
are supposed to clear carry to indicate you have consumed a
character.  Just doing a CLC will not suffice, since the IRET
will just restore the original flags buried on the stack.  You
have to clear carry, then do a RETF 2, to get rid of the buried
flags.

The sequence E0 38 is what you will see when Alt-Gr is depressed
and E0 B8 when it is released.

Since both the E0 and 38 codes have other uses, we must maintain
a state machine to ensure they occur without intervening
characters.  For example a left arrow on the arrow pad gives E0
4B .. E0 CB.  We must not meddle with E0 in that context, or
with 38 in the context of a LEFT-alt key depression.



How Quebec Works
****************

The most important table is the classifier table that classifies
each incoming scan code.  We strip the high bit before using it,
so it needs to be only 128 characters long.

There are 16 classes of keypress scan code:

0 - ignore this key entirely (there are no such keys in this implementation).

1 - ordinary key that BIOS can handle, turns off accenting though.
    Never gets accented.

2 - ordinary key that BIOS can handle, but allows accent to stay on.
    Never gets accented. (e.g. Alt, Shift, Alt-Gr)

3 - Key like "8/*" where determination based on state of SHIFT key.
    Might participate in getting accented.

4 - Key like "A" where determination based on state of SHIFT/Capslock.
    Might participate in getting accented.

5 - the tilde dead key.   (There is no such single key on the
    keyboard, but internally we fake one.)  If there were a key that
    always had this effect and nothing else, it would get class code
    5.

6 - Aigu acute ' accent dead key.

7 - Grave ` accent dead key

8 - Trema " accent dead key

9 - Circonflexe ^ dead key

10 - Special key (~ ~)
                 (` ") with four legends, containing dead keys.

11 - Special key ({ ?)
                 ([ /)

12 - Special key (} ])
                 (] [)

13 - Special key (" ^)
                 (' `)

14 - Special key (< ')
                 (, ,)

15 - Special key (> .)
                 (. .)

16 - Special key (? )
                 (/ )

The class is then used to index one of sixteen routines to handle the code.

Class 1 - PLAIN control scan codes, leave alone.
-  this code could also be used to handle perfectly
   standard alphabetic keys that do not participate in
   special processing.
-  Pass the scan code through to BIOS for processing.
-  Turn off AccentPending.
-  Tell BIOS to continue processing the scan code.

Class 2 - as class 1 but has no effect on AccentPending.
 - e.g. shift is not supposed to turn of the pending accent.
 - Just pass scan code through to BIOS for processing.

Class 3 - SHIFT SENSITIVE, accentable
 - test state of Ctrl and LEFT Alt keys.
   If pressed treat like class 1.
 - test state of shift key
   If pressed use Upper case translate table to find corresponding
   character otherwise use the Lower case translate table.
   If AccentPending, apply the appropriate accent.
   Push the translated character, and scan code into the keystroke buffer.
   If the buffer is full, emit a short beep.
   Turn off AccentPending.
   Tell BIOS keystroke was consumed.

Class 4 - CAPSLOCK SENSITIVE, accentable
 - test state combined Capslock and shift keys
   Treat as per class 3.

Class 5-10 - Dead keys
     is THAT accent pending?
           if not on already, turn on Accent-Pending for THAT accent.
           a new accent effectively turns off any pending other accent.
           if already on push that accent into the keystroke buffer and
              turn off Accent-Pending.
    Tell BIOS keystroke was consumed.

Class 11-16 Special keys
 - test state of shift key, Alt and Alt-Gr keys
   decide which of lower left, upper left, lower right, upper right it is.
   (I call this the quadrant)
   Patch the classifier table LCTRT an UCTRT entries to the chars that
   are desired for that quadrant.
   Look up a class code to use for that quadrant with that scan code.
   Use it to fake a new keystroke.

We thus need only three translate tables -- 128 bytes long, indexed
by scan code with the high bit stripped.

Classifier      - class of treatment for the scan code
LCTRT           - ASCII char for each scan code in lower case
UCTRT           - ASCII char for each scan code in upper case

There are also some small tables 20 bytes long giving both the
lower and upper case forms of the characters that could
potentially have accents, and how they look after the various
accents are applied.


The original QWERTY Layout
**************************

 Esc     F1  F2  F3  F4  F5  F6  F7  F8  F9  F10  F11  F12


~   !   @   #   $   %   ^   @   *   (   )  ---  +   |  Bsp
`   1   2   3   4   5   6   7   8   9   0   -   =   \

  Tab  Q   W   E   R   T   Y   U   I   O   P   {   }
       q   w   e   r   t   y   u   i   o   p   [   ]

CapsLock A   S   D   F   G   H   J   K   L   :   "   Ent
         a   s   d   f   g   h   j   k   l   ;   '

      Shf  Z   X   C   V   B   N   M   <   >   ?  Shf
           z   x   c   v   b   n   m   ,   .   /

Ctrl  Alt                  Space                     Alt   Ctrl


Register conventions
********************

During the interrupt, be must be careful to put everything, even
the flags back the way they were.  The two exceptions are the
carry flag and AL -- containing the scan code.

At the beginning of interrupt processing we save BX and CX.  We
set up DS: and ES:.  These are restored on exit.  During processing we
may trash these registers and AH.  However we must be extremely
careful to restore any other register used such SI, DI and DX.

We must also be careful with CALLS since we must leave the stack at
the same depth when we finally jump to ConsumeStroke.

We keep the scan code in AL throughout the processing.

Subroutines preserve all registers


 ; end of comment

CODE    SEGMENT PARA

        ASSUME  CS:CODE,DS:CODE,ES:CODE
        ORG     100H

;==============================================================

; C O N F I G U R A T I O N   E Q U A T E S

;; ONE AND ONLY ONE OF THE TWO FOLLOWING LINES SHOULD BE ACTIVE.

AltGrLeft       equ     1       ; make AltGr give Left legends

;; AltGrRight   equ     1       ; make AltGr give Right legends

;; Debugging    equ     1       ; comment out this line when not
                                ; debugging

;==============================================================
;       M A C R O S
;==============================================================

SAY     MACRO   Msg
;;      display message on screen
        lea     dx,&Msg         ;; use LEA rather than
                                ;; MOV Offset for more generality
        mov     ah,09h          ;; some assemblers will optimise this.
        int     21h
        ENDM

;==============================================================

KEY     MACRO   scan,class,lc,uc
        ORG     CLASSIFIER+&Scan        ;; build 3 translate tables
        db      &Class*2                ;; class 0 .. 16
                                        ;; mult by 2 to index by words

        ORG     LCTRT+&Scan
        db      &lc                     ;; lower case

        ORG     UCTRT+&Scan
        db      &uc                     ;; upper case


        ENDM
;==============================================================

KEY4    MACRO   CLplc,CLpuc,CLalc,CLauc,CHplc,CHpuc,CHalc,CHauc

;;              2 pairs of class codes and two pairs of chars
;;              mult class codes by 2 so they can index words.

        DB      &CLplc*2,&CLpuc*2,&CLalc*2,&CLauc*2
        DB      &CHplc,&CHpuc,&CHalc,&CHauc

        ENDM

;==============================================================

; MAINLINE PROGRAM

Quebec   PROC    FAR
START:
        JMP     Init
                                ; Mainline disposable Init routine
                                ; uses TRAP to set up vectors to
                                ; FIELD which later
                                ; does the real work.

;==============================================================

;       E Q U A T E S   F O R   S C A N   C O D E S   B Y   N A M E
;
;       We use SYSTEM scan codes, not keyboard scan codes.
;       INT 15 will see codes after the keyboard controller has
;       translated them.
;       Upper and lower case A use the same scan code as do 1 and ! for example.
;       When a key is duplicated on the numeric keypad and on the arrow
;       keypad, both use the same code, but the arrow keypad gets an E0 prefix.
;       The E0 characters themselves get passed through unmolested.
;       The press down codes shown have the high bit off.  The release
;       codes are the same with the high bit on.  We only process key
;       presses.  We don't even get this far for releases.

_ESC    EQU     01h     ; Esc
_1      EQU     02h     ; 1 !
_2      EQU     03h     ; 2 @
_3      EQU     04h     ; 3 #
_4      EQU     05h     ; 4 $
_5      EQU     06h     ; 5 %
_6      EQU     07h     ; 6 ^
_7      EQU     08h     ; 7 &
_8      EQU     09h     ; 8 *
_9      EQU     0Ah     ; 9 (
_0      EQU     0Bh     ; 0 )
_Minus  EQU     0Ch     ; - _
_Eq     EQU     0Dh     ; = +
_BS     EQU     0Eh     ; backspace <-
_Tab    EQU     0Fh     ; Tab ->
_Q      EQU     10h     ; Q
_W      EQU     11h     ; W
_E      EQU     12h     ; E
_R      EQU     13h     ; R
_T      EQU     14h     ; T
_Y      EQU     15h     ; Y
_U      EQU     16h     ; U
_I      EQU     17h     ; I
_O      EQU     18h     ; O
_P      EQU     19h     ; P
_LSq    EQU     1Ah     ; [ {
_RSq    EQU     1Bh     ; ] }
_Enter  EQU     1Ch     ; Enter
_Ctrl   EQU     1Dh     ; Ctrl (left or right)
_A      EQU     1Eh     ; A
_S      EQU     1Fh     ; S
_D      EQU     20h     ; D
_F      EQU     21h     ; F
_G      EQU     22h     ; G
_H      EQU     23h     ; H
_J      EQU     24h     ; J
_K      EQU     25h     ; K
_L      EQU     26h     ; L
_Semi   EQU     27h     ; ; :
_Quote  EQU     28h     ; ' "
_Grave  EQU     29h     ; ` ~
_LShift EQU     2Ah     ; Left Shift
_BSlash EQU     2Bh     ; \ |
_Z      EQU     2Ch     ; Z
_X      EQU     2Dh     ; X
_C      EQU     2Eh     ; C
_V      EQU     2Fh     ; V
_B      EQU     30h     ; B
_N      EQU     31h     ; N
_M      EQU     32h     ; M
_Comma  EQU     33h     ; , <
_Period EQU     34h     ; . >
_Slash  EQU     35h     ; / ?
_RShift EQU     36h     ; Right Shift
_PrtSc  EQU     37h     ; PrintScreen
_Alt    EQU     38h     ; left Alt, Right alt uses same code with E0 prefix
_Space  EQU     39h     ; Space
_CapsLk EQU     3Ah     ; CapsLock
_F1     EQU     3Bh     ; function key F1
_F2     EQU     3Ch     ; function key F2
_F3     EQU     3Dh     ; function key F3
_F4     EQU     3Eh     ; function key F4
_F5     EQU     3Fh     ; function key F5
_F6     EQU     40h     ; function key F6
_F7     EQU     41h     ; function key F7
_F8     EQU     42h     ; function key F8
_F9     EQU     43h     ; function key F9
_F10    EQU     44h     ; function key F10
_NumLk  EQU     45h     ; NumLock
_ScLk   EQU     46h     ; ScrollLock
_Home   EQU     47h     ; Home 7
_UP     EQU     48h     ; ^ arrow 8
_PgUp   EQU     49h     ; PgUp 9
_PadMin EQU     4Ah     ; Keypad minus
_Left   EQU     4Bh     ; <- 4
_Pad5   EQU     4Ch     ; 5 on keypad
_Right  EQU     4Dh     ; -> 6
_PadPls EQU     4Eh     ; Keypad plus
_End    EQU     4Fh     ; End 1
_Down   EQU     50h     ; v arrow 2
_PgDn   EQU     51h     ; PgDn 3
_Ins    EQU     52h     ; Ins 0
_Del    EQU     53h     ; Del .
_Sys    EQU     54h     ; SysRequest
_F11    EQU     57h     ; function key 11 (not always present)
_F12    EQU     58h     ; function key 12 (not always present)
; pause button simultates a Ctrl-Numlock.
;
; You can use the PC PowerTools utility, SCAN, to find out what codes your
; keyboard is generating.  To stop SCAN, hit the space bar.
; You may have to adjust the above table slightly.
;
;==============================================================

;       The four translate tables
CLASSIFIER      LABEL BYTE
        ;       class of each scan code
        db      128 dup (1*2)  ; by default all are class 1
                ; store as *2 so that can index word table of handlers
                ; 0 = ignore completely
                ; 1 = let BIOS handle, but clear Accent
                ; 2 = let BIOS handle, no effect on Accent state (e.g. Shift)
                ; 3 = SHIFT sensitive key. Might need accent
                ; 4 = CAPSLOCK sensitive key.  Might need accent
                ; 5 = dead key to invoke Tilde or other Spanish accents
                ; 6 = dead key to invoke Aigu acute accent on next key
                ; 7 = dead key to invoke Grave accent on next key
                ; 8 = dead key to invoke Trma  accent on next key
                ; 9 = dead key to invoke Circonflexe accent on next key
                ;10 = special 4-legend key      `   ~   "   ~
                ;11 = special 4-legend key      [   {   /   ?
                ;12 = special 4-legend key      ]   }   [   ]
                ;13 = special 4-legend key      '   "   `   ^
                ;14 = special 4-legend key      ,   <   ,   '
                ;15 = special 4-legend key      .   >   .   .
                ;16 = special 4-legend key      /   ?      

LCTRT   db      128 dup (0)
                ; character to translate scan into if in lower case

UCTRT   db      128 dup (0)
                ; character to translate scan into if in upper case


EndTrt  Label   Byte
;=================================================================
;  K E Y B O A R D   D E F I N I T I O N S
;=================================================================
;
;  The following keyboard definitions override the four previous
;  translate table defaults, thus they do not add to the size of
;  the program.
;
;  You may leave out any keys that will be treated as on a
;  standard USA keyboard.
;
;  If the character is potentially accentable, you must include
;  it here explicitly.
;
;  All the rest are presumed to be class 1
;
;  <><><><><><><><><><><><><><><><><><>
;                scan   class   lc  uc

        KEY     _Grave,  10,    "`","~"
        KEY     _LSq,    11,    "[","{"
        KEY     _RSq,    12,    "]","}"
        KEY     _Quote,  13,    "'",'"'
        KEY     _Comma,  14,    ",","<"
        KEY     _Period, 15,    ".",">"
        KEY     _Slash,  16,    "/","?"

        KEY     _A,      4,     "a","A"
        KEY     _C,      4,     "c","C"
        KEY     _E,      4,     "e","E"
        KEY     _I,      4,     "i","I"
        KEY     _N,      4,     "n","N"
        KEY     _O,      4,     "o","O"
        KEY     _U,      4,     "u","U"
        KEY     _Y,      4,     "y","Y"

        KEY     _LShift  2,     0,0
        KEY     _RShift  2,     0,0
        KEY     _Alt     2,     0,0             ; same code left/right

        ORG     EndTrt  ; get to the end

;       KEY4 Four-legend keys need more information for Alt-Gr
;                AGr plain  Alt-Gr  plain
;                l u l u    l   u   l   u       Alt-gr  Plain
;                class     char                 lc  uc  lc  uc
CL10    LABEL    BYTE
        KEY4     3,3,8,5,  "`","~",'"',"~" ;    `   ~   "   ~  _Grave
CL11    LABEL    BYTE
        KEY4     3,3,3,3,  "[","{","/","?" ;    [   {   /   ?  _LSq
CL12    LABEL    BYTE
        KEY4     3,3,3,3,  "]","}","[","]" ;    ]   }   [   ]  _RSq
CL13    LABEL    BYTE
        KEY4     3,3,7,9,  "'",'"',"`","^" ;    '   "   `   ^  _Quote
CL14    LABEL    BYTE
        KEY4     3,3,3,6,  ",","<",",","'" ;    ,   <   ,   '  _Comma
CL15    LABEL    BYTE
        KEY4     3,3,3,3,  ".",">",".","." ;    .   >   .   .  _Period
CL16    LABEL    BYTE
        KEY4     3,3,3,3,  "/","?","","" ;    /   ?        _Slash

;=================================================================

; A C C E N T   D E F I N I T I O N S

Unaccented      db      "aceinouy<>"    ; unaccented, template chars to help
                db      "ACEINOUY<>"    ; find matching accented chars

AccentCount     Equ     $-Unaccented    ; count chars that can be accented

Tilde           db      "y"    ; general Spanish accents
                db      "AIOUY"

Aigu            db      "y"    ; Aigu - acute accent
                db      "AIOUY"

Grave           db      "y"    ; grave accent
                db      "AEIOUY"

Trema           db      ""    ; diaeresis - Trma
                db      "EIY"

Circ            db      "y"    ; circonflexe
                db      "AEIOUY"

;; in some other keyboard, you may need these Ring characters
;;Ring          db      "eiouy"    ; ring, general Swedish accents
;;              db      "EIOUY"


;==============================================================

; V A R I A B L E S


RealInt15Off    DW      0       ; offset of original INT15 BIOS code
                                ; More likely will be pointer to
                                ; entry point of some other TSR
                                ; already hooked onto INT 15.
RealInt15Seg    DW      0       ; Seg of original INT15 BIOS code

AccentPending   DW      0       ; 0 if no Accent key just pressed.
                                ; address of table of appropriate accents
                                ; otherwise, eg. Tilde or Trema

AltGrState      DW      0       ; AltGr States
                                ; 0 = not depressed
                                ; 1 = not depressed but E0 seen,
                                ;     meaning it might be coming down.
                                ; 2 = is depressed
                                ; 3 = is depressed but E0 seen,
                                ;     meaning it might be going up.
                                ; mask with 2 to determine pressed state

UnpatchLC       DB      0       ; so can restore LCTRT after patching
                                ; old, standard table value

UnpatchUC       DB      0       ; so can restore UCTRT after patching
                                ; old, standard table value

Patched         DB      0       ; true if need to unpatch LCtrt and UCtrt
                                ; We have patched it in the process of
                                ; handling a 4-legend keycap

;==============================================================

FIELD   Proc    Far
;       Field (intercept and handle) INT 15 Interrupt
                                ; at this point on stack is
                                ; flags, CS: IP of code in INT 9 keystroke
                                ; Interrupts are off.  EOI not yet issued
                                ; Our caller will attend to it when we have done.
                                ; cld/std state unknown.
                                ; probably AH=4F, AL=scan, carry set.
                                ; interrupt handler than invoked us with INT 15
                                ; We use caller's SS:SP as a stack.
        pushf
        cmp     AH,04Fh         ; check if this is function 4F
        jne     NotStroke       ; 4F is the peek at keystroke interrupt

        push    bx              ; save a few registers
        push    cx              ; If it is a fancy one, we will later save more
        push    DS
        push    ES
        mov     bx,CS
        mov     DS,bx           ; set up DS: ES: to cover
        mov     ES,bx
        cld                     ; in interrupt, cannot count on CLD
        Call    TrackAltGr      ; internally track state of Alt-Gr key
                                ; we cannot let BIOS do this for us.
        test    al,80h
        jnz     LetBiosProcessStroke
                                ; we do no further processing
                                ; on release strokes
                                ; We let BIOS handle them.

IsStroke:
;   Is a downstroke.  Figure out what class.
        sub     ah,ah           ; clear high byte of scan code for easier
                                ; internal processing
        mov     bx,ax           ; classify the scan code
        mov     bl,classifier[bx]
                                ; classifier is premultiplied by 2
        ifdef   debugging
        cmp     bx,16*2
        ja      $               ; must never be above 32
        endif

        Jmp     word ptr HandleClass[BX]
                                ; jump to routine to process that class
                                ; of character.
                                ; will return to either
                                ; LetBiosProcessStroke or
                                ; ConsumeStroke
LetBiosProcessStroke:
        Call    Unpatch         ; Unpatch LCTrt and UCTrt if necessary
        pop     ES
        pop     DS
        pop     cx
        pop     bx              ; ask BIOS to continue processing this
                                ; scan code, following popf will restore
                                ; STC set by INT 9
        mov     ah,4Fh          ; restore ah

NotStroke:

;       Fall through to let other INT 15 AF handlers have a crack.
                                ; We simply want to jump to
                                ; the original INT 15,
        popf                    ; or give any other INT 15 AF handlers a bash
                                ; at the character as well.
                                ; will restore carry set.
        jmp     cs: dword ptr [RealInt15Off]

ConsumeStroke:
        Call    Unpatch         ; Unpatch LCTrt and UCTrt if necessary
        pop     ES
        pop     DS              ; tell BIOS we have handled the stroke and
        pop     cx              ; it need not process it further.
        pop     bx
        mov     ah,4Fh          ; restore ah
        popf                    ; restore flags
        clc                     ; tell BIOS stroke is consumed.
        retf    2               ; bypass restoring buried flags that would
                                ; occur if we used IRET
                                ; DON'T confuse downstream handlers
                                ; with the consumed keystroke;
                                ; we do not enchain to old vector.

FIELD   EndP

;==============================================================

TrackAltGr      Proc    Near

comment 

On entry AX=00xx where xx is the scan code with high byte stripped.
We internally track the state of the Alt-Gr key.
If there was an Alt-Gr depression we hide it from BIOS by making
it look like an Alt-Gr key release.

We want BIOS to think Alt-Gr is never pressed.  However, we
internally want to keep track of its current state.  Since the
Alt-Gr strokes are E0 38 ... E0 B8, we don't know if the E0
should be hidden or not till we see the 38.  E0 has other uses
e.g. a left arrow on the arrow pad gives E0 4B .. E0 CB.

So we DON'T hide (consume) the E0, and we later convert the 38
to a B8 to hide an Alt-Gr keypress.  We don't hide Alt-Gr
releases.  We cannot hide ALL 38's since 38 by itself is used for
LEFT alt depresses.

This dodge gives us the ability to always hide Alt-Gr from BIOS.
We could UNHIDE the Alt-Gr by allowing the 38 through
unmolested.  However, once we have done that, there is no way to
undo its effect by faking a release.  We cannot simply fake a
string of raw scan codes --- only strings of ASCII characters.
We have to monitor both keypresses and keyreleases in this
routine.  Most other routines only examine keypresses.

Think of this as a finite state automaton with four internal
states and four possible inputs and four possible states.

     UP  0 -- E0 --> 1  going down
         ^           |
         |           |
         B8          38  <- hide this transition from BIOS
         |           |
         |           V
going up 3 <-- E0 -- 2  DOWN

                                AltGrState
                                U  V  D  ^
                                0  1  2  3
        inputs                  ----------
    0   E0 - lead char        | 1  1  3  3
    1   38 - depress char     | 0  2* 2  2*    * <- special case
    2   B8 - release char     | 0  0  2  0          hide this transition
    3   xx - something else   | 0  0  2  2          use High Bit in table
                                                    to indicate this.
        AltGr States
        0 = not depressed (UP)
        1 = not depressed but E0 seen,
            meaning it might be going down.
        2 = is depressed (DOWN)
        3 = is depressed but E0 seen,
            meaning it might be going up.

end comment 

        push    bx
        push    cx
        push    di
                                        ; classify input
        lea     di,StateInputs          ; get list of scan codes relevant to
                                        ; Alt-Gr
        mov     cx,4                    ; There are 4 possible input match chars
                                        ; search for scan code in AL
        repne   scasb                   ; search for match
                                        ; treat match or not on 0 as "else"
                                        ; di points one past match
                                        ; by having a dummy we avoid a JNZ.
        sub     di,offset StateInputs+1 ; di = input 0 .. 3
        shl     di,1                    ; mult by 4 to get index to start of row
        shl     di,1                    ; in matrix
        add     di,AltGrState           ; get offset of elt in StateMatrix
        mov     bl,StateMatrix[di]      ; pick out new state from matrix

        ifdef   debugging
        cmp     bl,6
        ja      $                       ; must never be above 6
        endif

        mov     cx,bx                   ; Save high bit
        and     bx,03h                  ; mask high bit off, and high byte
        mov     AltGrState,bx           ; save new state

        test    cx,04h                  ; leave HIDE test in flags register
        jz      DontHide
        mov     al,0B8h                 ; hide by converting scan 38 to B8
                                        ; depress to release
DontHide:
        pop     di
        pop     cx
        pop     bx
        ret

StateInputs     db      0E0h,038h,0B8h,0
                                        ; scan codes relevant input to the
                                        ; finite state automaton for tracking Alt-Gr
                                        ; 0E->0 38->1 B8->2 others ->3
                                        ; use 0 as place marker for others.
StateMatrix     label   Byte

        db      1,   1, 3,   3          ; high bit means special case:
        db      0, 4+2, 2, 4+2          ; hide this scan code.
        db      0,   0, 2,   0          ; row = input E0 38 B8 else
        db      0,   0, 2,   2          ; col = state 0 1 2 3
                                        ;       0=up
                                        ;       1=going down
                                        ;       2=down
                                        ;       3=going up

TrackAltGr      EndP

;==============================================================

HandleClass     label word
        ; table of routines to handle each class of scan code
        dw offset       Class0          ; ignore
        dw offset       Class1          ; via BIOS
        dw offset       Class2          ; via BIOS, but no effect on accent
        dw offset       Class3          ; shift sensitive
        dw offset       Class4          ; capslock sensitive
        dw offset       Class5          ; Tilde dead key (Spanish)
        dw offset       Class6          ; Aigu dead key
        dw offset       Class7          ; Grave Tilde dead key
        dw offset       Class8          ; Trema dead key
        dw offset       Class9          ; Circonflexe dead key
        dw offset       Class10         ; Special 4-legend key
        dw offset       Class11         ; "
        dw offset       Class12         ; "
        dw offset       Class13         ; "
        dw offset       Class14         ; "
        dw offset       Class15         ; "
        dw offset       Class16         ; "
                                        ; Code should never index
                                        ; off past the end

;==============================================================

Class0  Proc    Near
;       ret handle a class 0 scan code -- ignore the stroke
        jmp     ConsumeStroke

Class0  EndP

;==============================================================

Class1  Proc    Near

;       ret handle a class 1 scan code -- let BIOS handle it
;       Turns off AccentPending though.
        mov     AccentPending,0
        jmp     LetBiosProcessStroke

Class1  EndP

;==============================================================

Class2  Proc    Near

;       ret handle a class 1 scan code -- let BIOS handle it
;       No effect on accentPending, e.g. Like Shift.
        jmp     LetBiosProcessStroke

Class2  EndP

;==============================================================

Class3  Proc    Near

;       ret handle a class 3 scan code, shift state sensitive
;       ax is scan code
        mov     bl,al           ; save copy of al
        mov     ah,02H          ; get keyboard flags
        int     16H
        xchg    al,bl
                                ; al=scan code bl=kbd flags
                                ; 8 4 2 1 8 4 2 1
                                ; 1 . . . . . . .      Insert locked
                                ; . 1 . . . . . .      Caps Lock locked
                                ; . . 1 . . . . .      Num Lock locked
                                ; . . . 1 . . . .      Scroll Lock locked
                                ; . . . . 1 . . .      Alt key is pressed
                                ; . . . . . 1 . .      Ctrl key is pressed
                                ; . . . . . . 1 .      Left Shift key is pressed
                                ; . . . . . . . 1      Right Shift key is pressed

        test    bl,0Ch          ; test if Ctrl or Alt pressed
        jnz     Class1          ; if yes, let BIOS handle it
                                ; but turn off AccentPending
        test    bl,3h           ; test if either shift key is down
                                ; nz means upper case, z mean lower case
                                ; LEAVE RESULT IN FLAGS REGISTER FOR BUILDCHAR
        jmp     BuildChar       ; never return

Class3  EndP

;==============================================================

AccentOn        Proc    Near

;       Turn on accents on next char.  This char ignored usually.
;       On entry BX points to table of accented letters

        cmp     bx,AccentPending
        je      Class3          ; if on already, treat like punctuation
                                ; instead of a dead char
        mov     AccentPending,bx
                                ; turn on AccentPending
        jmp     ConsumeStroke

AccentOn        EndP

;==============================================================

Class4  Proc    Near

;       ret handle a class 4 scan code, CapsLock Sensitive
;       ax is scan code
;       upper case is XOR of Shift and Capslock state.
;       i.e. if they differ, we are in upper case.

        mov     bl,al           ; save copy of al, the scan code
        mov     ah,02H          ; get keyboard flags
        int     16H
        xchg    al,bl           ; al=scan code bl=kbd flags
        test    bl,0Ch          ; test if Ctrl or Alt pressed
        jnz     Class1          ; if yes, let BIOS handle it
        test    bl,3h           ; test if either shift key is down
        lahf
        test    bl,40h          ; test if capslock is on
        mov     bl,ah
        lahf
        xor     bl,ah           ; test if shift key state diff capslock
        test    bl,40h          ; look at just the z flag
                                ; if nz means differ means upper case
                                ; LEAVE RESULT IN FLAGS REGISTER FOR BUILDCHAR
        jmp     BuildChar       ; never return

Class4  EndP

;==============================================================

Class5  Proc    Near

;       dead key that turns on Tilde  accent for next key
        lea     bx,Tilde        ; Tilde ~ Spanish dead key
        jmp     AccentOn

Class5  EndP

;==============================================================

Class6  Proc    Near

;       dead key that turns on Aigu accent for next key
        lea     bx,Aigu         ; acute ' dead key
        jmp     AccentOn

Class6  EndP

;==============================================================

Class7  Proc    Near

;       dead key that turns on Aigu accent for next key
        lea     bx,Grave        ; Grave ` dead key
        jmp     AccentOn

Class7  EndP

;==============================================================

Class8  Proc    Near

;       dead key that turns on Trma accent for next key
        lea     bx,Trema        ; Trema " dead key
        jmp     AccentOn

Class8  EndP

;==============================================================

Class9  Proc    Near

;       dead key that turns on Circonflexe accent for next key
        lea     bx,Circ         ; Circ ^ dead key
        jmp     AccentOn

Class9  EndP

;==============================================================

Class10 proc    Near
;       Handle special key
;       `   ~   "   ~
        lea     bx,CL10
        jmp     DoQuad

Class10 EndP

;==============================================================

Class11 proc    Near
;       Handle special key
;       [   {   /   ?
        lea     bx,CL11
        jmp     DoQuad

Class11 EndP

;==============================================================

Class12 proc    Near
;       Handle special key
;       ]   }   [   ]
        lea     bx,CL12
        jmp     DoQuad

Class12 EndP

;==============================================================

Class13 proc    Near
;       Handle special key
;       '   "   `   ^
        lea     bx,CL13
        jmp     DoQuad

Class13 EndP

;==============================================================

Class14 proc    Near
;       Handle special key
;       ,   <   ,   '
        lea     bx,CL14
        jmp     DoQuad

Class14 EndP

;==============================================================

Class15 proc    Near
;       Handle special key
;       .   >   .   .
        lea     bx,CL15
        jmp     DoQuad

Class15 EndP

;==============================================================

Class16 proc    Near
;       Handle special key
;       /   ?      
        lea     bx,CL16
        jmp     DoQuad

Class16 EndP

;==============================================================

DoQuad  Proc    Near

;       Special 4-legend Alt-Gr Sensitive Key
;       on entry BX points to a KEY4 table
;       ax is the scan code
;       Determine which quadrant to use, dynamically patch the
;       classifier table to the new lower/upper case, and
;       treat as a fresh char coming in, with a class equal to
;       that taken from the KEY4 table.
;       So far only DS BX and CX are saved.  We must restore anything
;       else we disturb, including AX=scan code.

        push    dx
        push    si
        push    di
        Call    Quadrant        ; dx is quadrant 0..3
        mov     si,dx           ; si=quadrant
        and     si,2            ; si=0 left   si=2 right
        add     si,4            ; bypass 4 classes at start of KEY4 table
        add     si,bx           ; si points to either left or right
                                ; lc/uc pair in KEY4 table
                                ;                   v
                                ; e.g. 3 3 8 5  ` ~ " ~
                                ;               ^
        mov     di,ax           ; scan code in di, high byte 0
        mov     cx,[si]         ; get the Lower case char from KEY4
                                ; into cl, and upper case into ch
                                ;                   v v
                                ; e.g. 3 3 8 5  ` ~ " ~
                                ;               ^ ^

        xchg    LCTRT[di],cl    ; patch LCTRT corresponding to this
                                ; scan code.
        xchg    UCTRT[di],ch    ; patch UCTRT corresponding to this
                                ; scan code
        mov     Patched,-1      ; Note we patched, to remind us to unpatch
        mov     UnpatchLC,cl    ; save so can be restored
        mov     UnpatchUC,ch

                                ; bx still points to start of KEY4 table
                                ; get the class corresponding to this
                                ; quadrant
        add     bx,dx           ; bx points to new class
                                ;        v
                                ; e.g. 3 3 8 5  ` ~ " ~
        mov     bl,[bx]         ; get the new class (premult by 2)
        sub     bh,bh           ; clear high byte
                                ; DO NOT PATCH the class
        pop     dx
        pop     di
        pop     si

        ifdef   debugging
        cmp     bx,16*2
        ja      $               ; must never be above 32
        endif

        Jmp     word ptr HandleClass[BX]
                                ; jump to routine to process that class
                                ; of character using fake Class and patched
                                ; LCTRT and UCTRT, but same scan code.
                                ; will return to either
                                ; LetBiosProcessStroke or
                                ; ConsumeStroke

DoQuad  EndP

;==============================================================

Unpatch         Proc    Near

;       Undo the patch to LCtrt and UCtrt if any

        test    Patched,-1
        jz      NoPatch
;                               ; was a patch, al contains scan code
                                ; with ah=0.  Put tables back the way
                                ; they were
        push    cx
        push    di
        mov     di,ax
        mov     cl,UnpatchLC
        mov     ch,UnPatchUC
        mov     LCTRT[di],cl
        mov     UCTRT[di],ch
        mov     Patched,0       ; note that tables are no longer patched
        pop     di
        pop     cx

NoPatch:
        ret

Unpatch         EndP

;==============================================================

Quadrant        Proc    Near

;       Decide which quadrant of the key legend applies
;       return result in dx.  Independent of keystroke scan code itself.
;       depends only on Left-Alt Right-Alt Left-Shift Right-Shift
;                                        A-Gr Alt-Gr
;       ?       nw ne   1 3   01 11      ul   ur
;       /       sw se   0 2   00 10      ll   lr
;       Preserves all registers
;       result is a number 0 1 2 or 3.

        push    ax
        push    bx
        mov     ah,12h
        int     16h             ; get extended shift status into AH
                                ;  8 4 2 1
                                ;  1 . . . Right Alt key is pressed
                                ;  . . 1 . Left Alt key is pressed
                                ; and keyboard flags into AL
                                ;  . . 1 .  Left Shift key is pressed
                                ;  . . . 1  Right Shift key is pressed
                                ; we ignore Right-Alt and use our own
                                ; reckoning -- AltGrState
        ifdef   debugging
        test    ah,8h
        jnz     $               ; BIOS should never see Alt-Gr depressed
        endif

;       get bits in this order: Right-alt Left-Alt Shift
;                                       2    1       0
        mov     bx,AltGrState   ; our Right-Alt depressed?

        ifdef   AltGrLeft
        not     bx              ; invert the sense
        endif

        ifdef   AltGrRight
                                ; leave the sense as is
        endif

        and     bx,02h          ; isolate it
        shl     bl,1            ; shift into position
        and     ah,02h          ; isolate Left alt
                                ; already in position
        or      bl,ah           ; develop conglomeration in bl
        mov     bh,al           ; get right shift
        and     bh,1            ; isolate it
        or      bl,bh           ; develop in bl
        shr     al,1            ; position left shift
        and     al,1            ; isolate it
        or      al,bl           ; leave result in al

        ifdef           debugging
        cmp     al,7
        ja      $               ; must never be above 7
        endif

        lea     bx,QuadTab
        xlat                    ; translate al = [bx+al] to get quadrant
        sub     ah,ah           ; clear high byte.
        mov     dx,ax
        pop     bx
        pop     ax
        ret

QuadTab Label   Byte            ; converts shift state to quadrant

                ; Right-Alt Left-Alt Shift
        DB  0   ;     0         0      0
        DB  1   ;     0         0      1
        DB  0   ;     0         1      0
        DB  3   ;     0         1      1
        DB  2   ;     1         0      0
        DB  3   ;     1         0      1
        DB  2   ;     1         1      0
        DB  3   ;     1         1      1

Quadrant        EndP

;==============================================================

BuildChar Proc  near

;       handle bulk of work for class 3 and class 4 scan codes
;       On entry flag reg says whether to use lc or uc table
;       nz = uc  z = lc
;       al is the scan code

        push    ax              ; save scan code
        lea     bx,LCTRT        ; presume will use lower case
        jz      StillLCTRT
        lea     bx,UCTRT        ; use UC Trt instead
StillLCTRT:
                                ; bx contains address of TRT for char
        mov     ch,al           ; CH = scan code
        xlat                    ; translate al = [bx+al] to get char
        call    ApplyAccent     ; possibly apply an accent
        mov     cl,al           ; CL = char
        mov     ah,05h          ; push char/scan to keystroke buffer
        int     16h             ; CH = scan code CL = char
                                ; either carry set or al=1 means trouble
                                ; WordPerfect Office ALWAYS sets carry
                                ; so we do not rely on this as a sign
                                ; of failure.
;;      jc      PushFail
        cmp     al,01
        jne     PushSuccessful
PushFail:
                                ; buffer overflow.  Emit a short beep
        call    Beep
PushSuccessful:
        mov     AccentPending,0 ; turn off AccentPending
        pop     ax              ; need to restore scan code so that
                                ; Unpatch will get the right place.
        jmp     ConsumeStroke   ; Tell BIOS not to bother with further
                                ; stroke processing.

BuildChar EndP

;==============================================================

ApplyAccent     Proc    Near

;       on entry al contains char poss needing an accent (poss lc or uc).
;       AccentPending points to table of accented chars for that accent,
;       e.g. Trema
;       On exit, al contains the accented char.
;       Works by scanning list of unaccented chars that could potentially
;       have accent the translates to corresponding char in accent table.

        test    AccentPending,-1
        jz      NoAccentNeeded

        push    bx
        push    cx
        push    di
        lea     di,Unaccented   ; get list of lc then uc chars
        mov     cx,AccentCount  ; count of chars in lc/uc list
        repne   scasb           ; search for match
        jne     NothingtoAccent ; usually will be no match
                                ; match di, is pointing one past
        sub     di,offset Unaccented+1
                                ; get offset relative to start of table
        mov     bx,AccentPending; start of table of corresp accented chars
        mov     al,[bx+di]      ; get corresp accented char
NothingToAccent:
        pop     di
        pop     cx
        pop     bx

NoAccentNeeded:
        ret

ApplyAccent     EndP

;==============================================================

Divisor equ     270             ; divisor for freq 4186 Hz, 3 octaves above mid C
Dur     equ     16666           ; mics duration (1/16 sec)

;==============================================================

BEEP    Proc    Near            ; emit one short beep
        sti                     ; turn ints back on, this will take a while
        push    ax
        Call    SoundOn
        push    ax              ; save old sound port value
        Call    Delay
        pop     ax
        Call    SoundOff
        pop     ax
        ret

BEEP    ENDP

;==============================================================

SoundOn Proc    Near
;       Turn on the speaker, hide old setting in AH
;       AH must remain undisturbed for soundoff.

        mov     al,0b6h
        out     043h,al         ; write timer mode register
        mov     ax,Divisor      ; freq divisor
                                ; two octaves above middle A.
        out     042h,al         ; write timer 2 cnt - lsb
        mov     al,ah
        out     042h,al         ; write timer 2 cnt - msb
        in      al,061h         ; get current port b setting
        mov     ah,al           ; save current setting
        or      al,003h         ; turn speaker on
        out     061h,al
        ret

SoundOn EndP

;==============================================================

Delay   Proc    Near

;       Delay   Dur microseconds
;       does not work on Compaq when called inside keyboard interrupt

        push    ax
        push    cx
        push    dx
        mov     cx,0            ; MSW
        mov     dx,Dur          ; LSW
        mov     ah,86h          ; delay CX:DX microseconds
        int     15h
        pop     dx
        pop     cx
        pop     ax
        ret

Delay   EndP

;==============================================================

SoundOff Proc   Near
;       Turn off the speaker
;       old port value in AH

        mov     al,ah           ; recover value of port
        out     061H,al
        ret

SoundOff EndP


;==============================================================
;==============================================================
;==============================================================
;==============================================================
; Everything below this line is disposable initialization code.
; It is thrown away and is not part of the resident code.
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================
DISPOSE:
;==============================================================
Init    Proc    Near
;       Initialize Quebec then Terminate and Stay Resident
        Say     CopyRightMsg    ; CopyRight banner
        call    Trap            ; redirect INT15 vector
        call    TSR             ; exit to DOS
Init    EndP

;==============================================================

TRAP    Proc    Near
;                               ; redirect the INT 15 to FIELD
;       Save real Int 15 vector
        mov     ax,3515h        ; get vector for multiplex int 15
        int     21h             ; vector in ES:BX
        mov     RealInt15Seg,ES ; save real vector
        mov     RealInt15Off,BX
;       Set up our Int 15 vector
                                ; DS:DX is vector.  DS ok already.
        mov     dx,Offset Field
        mov     ax,2515h        ; set vector for multiplex int 15
        int     21h             ; set vector from DS:DX
        ret
Trap    EndP

;==============================================================

TSR     Proc    Near
;       Terminate and Stay Resident

        mov     ES,DS:[2Ch]     ; pointer to environment
        mov     ah,49h          ; free ram allocated to the SET environment
        int     21h

        MOV     AH,3Eh          ; Close StdIn
        MOV     BX,0            ; Avoid holding onto a handle if
        INT     21H             ; foolish user typed Quebec <Myfile

        MOV     AH,3Eh          ; Close StdOut
        MOV     BX,1            ; Avoid holding onto a handle if
        INT     21H             ; user typed Quebec >NUL:

        MOV     AX,3100H        ; Terminate and Stay Resident function
                                ; Exit to DOS
        MOV     DX,((Dispose-Start)+100h+15d)/16d
        INT     21h             ; paragraphs to keep resident
                                ; 100h accounts for PSP.
                                ; 15d rounds up to next para.
                                ; We can throw away all
                                ; initialization code.
TSR     EndP

;==============================================================

;       Disposable Variables

;==============================================================

; Messages are all disposable, needed only during initialization.

CopyRightMsg    LABEL BYTE
        DB      ' Quebec 1.5 ۲',13,10
        DB      13,10
        DB      'Translate keyboard to French Canadian layout',13,10
        DB      13,10
        DB      'Copyright (c) 1991,1998 Roedy Green',13,10
        DB      'Canadian Mind Products',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      13,10
;                                                               spell out to avoid terminal $
        DB      'To continue legally using this Shareware program, you must send a twenty',13,10
        DB      'dollar registration fee in Canadian or US funds.  In return, we will send',13,10
        DB      'you the latest version of QUEBEC including MASM source.  Registration',13,10
        DB      'is the best way to protect yourself from viruses.  You must register first,',13,10
        DB      'if you want phone support.',13,10
        DB      13,10
        DB      'QUEBEC is for non-military use only.',13,10,'$'


;==============================================================

Quebec  ENDP
CODE    ENDS
        END     START
