kod segment
; ******************************************************
;       Program SDRUK wersja 1.01
;       drukujcy tekst w standardzie Mazovia
;       na drukarce zgodnej ze standardem EPSON FX.
;       Sawomir Stachniewicz, 1994
;
;       Ul. Przybyszewskiego 22
;       30-128 Krakw
;
;       e-mail: STACHNIEWICZ@VSB01.IFJ.EDU.PL
; ******************************************************
assume cs:kod, ds:kod
org 100h
start:
  cld
; zerowanie wskanika kierunku
  mov si, 80h
; do SI offset wiersza wejciowego (CS:80h)
  lodsb
; wczytanie dugoci wiersza do AL
  cbw
; zamiana bajtu (AL) na sowo (AX)
  mov cx, ax
  jcxz info1
; jeli wiersz by pusty
;
; dalej analiza parametrw
  call por
  jcxz info1
  dec si
  mov di, offset plikwe
  call nazwa
  jcxz info1
; nazwa pliku wejciowego do tablicy PLIKWE jako ASCIIz
  call por
  jcxz info1
  dec si
  inc cx
  mov di, offset plikwy
  call nazwa
; nazwa pliku wyjciowego do tablicy PLIKWY jako ASCIIz
  mov dx, offset plikwe
  mov ax, 3d00h
  int 21h
  jnc dalejxx
; prba otwarcia pliku wejciowego do odczytu
blad1:
  jmp blad
info1:
  mov si, offset napis
  call piszasc
  jmp koniec
dalejxx:
  mov uch1, ax
; numer identyfikacyjny do UCH1
  call binarne
  mov dx, offset plikwy
  mov ah, 5bh
  xor cx, cx
  int 21h
  jc blad1
; prba utworzenia pliku docelowego
  mov uch2, ax
; numer identyfikacyjny do UCH2
  call binarne
  mov dx, offset b
  mov cx, napis-b
  mov ah, 40h
  int 21h
; zapis sekwencji wejciowej (DOWNLOAD)
; w pliku docelowym
  jnc ustawiaj
  jmp zle2
ustawiaj:
  mov word ptr scrflg, 0
gpetla:
; gwna ptla programu
  mov ah, 3fh
  mov bx, uch1
  mov cx, 4096
  mov dx, offset bufor1
  int 21h
  jnc kontynuuj
  jmp zle1
kontynuuj:
; odczyt bloku 4 kB i umieszczenie w tablicy BUFOR1
  mov si, offset bufor1
  mov di, offset bufor2
  mov cx, ax
  push ax
mpetla:
  lodsb
  test al, 80h
; nie ma polskich liter dla znakw o kodach poniej 128
; czyli nie trzeba sprawdza wszystkich znakw
  jz niepol1
  push di
; zapamietaj biecy offset
  mov di, offset znaki
  push cx
  mov cx, 18
  repnz scasb
  jz dalej1
  pop cx
  jmp niepol
dalej1:
  mov al, 50
  sub al, cl
; podstawienie pod arbitralnie wybrany znak
; o kodzie od 33 do 50
  pop cx
  pop di
; biezacy offset
  push ax
; zapamietaj AX
  mov ax, 251bh
; Esc "%", pierwszy w zapisie bajt starszy (pniejszy)
  stosw
  pop ax
; pobierz poprzedni AX
  xchg ah, al
; zamien AH z AL
  mov al, 1
  stosw
; 1 znak
  mov ax, 251bh
  stosw
; Esc "%"
  xor ax, ax
  stosb
; 0
  loop mpetla
  jmp cd
niepol:
  pop di
niepol1:
  cmp byte ptr cmdflg, 0
  jz sprcmd
  call komendy
  loop mpetla
  jmp cd
sprcmd:
  cmp al, '\'
  jnz niecmd
  dec byte ptr cmdflg
  loop mpetla
  jmp cd
niecmd:
  cmp al, '^'
  jnz sprsub
  cmp byte ptr scrflg, 0
  jnz powrot
  inc byte ptr scrflg
  mov ax, 531bh
  stosw
  xor ax, ax
  stosb
  loop mpetla
  jmp cd
sprsub:
  cmp al, '_'
  jnz norm
  cmp byte ptr scrflg, 0
  jnz powrot
  inc byte ptr scrflg
  mov ax, 531bh
  stosw
  mov al, 1
  stosb
  loop mpetla
  jmp cd
powrot:
  mov ax, 541bh
  stosw
  dec byte ptr scrflg
  loop skok
  jmp cd
skok:
  jmp mpetla
norm:
  stosb
  loop skok
cd:
  pop si
; liczba odczyt. bajtw
  mov dx, offset bufor2
  sub di, dx
  mov cx, di
  mov ah, 40h
  mov bx, uch2
  int 21h
  jc zle2
; zapisanie na og ponad 4 kB danych z offsetu UCH2
; do pliku docelowego
  cmp ax, cx
  jb pelny
; czy wszystkie bajty sie zapisay ?
  cmp si, 4096
  jb zamknij
; jesli liczba odczyt. bajtw mniejsza od 4096,
; to ostatni blok
  jmp gpetla
zle1:
  mov si, offset odczyt
  jmp pisz
pelny:
  mov si, offset full
  jmp pisz
zle2:
  mov si, offset zapis
pisz:
  call piszasc
zamknij:
  mov ah, 3eh
  mov bx, uch1
  int 21h
  mov ah, 3eh
  mov bx, uch2
  int 21h
; zamknicie plikw
  jmp koniec
blad:
  push dx
  cmp ax, 80
  jnz skocz
  mov si, offset jest1
  call piszasc
  pop si
  call piszasc
  mov si, offset jest2
  call piszasc
  jmp koniec
skocz:
  mov si, offset bd
  call piszasc
  pop si
  call piszasc
koniec:
  mov ax, 4c00h
  int 21h
; powrot do DOS-u z kodem powrotu 0
por proc near
; zeruje CF, szuka nastpnego wyrazu w wierszu wejciowym
; oddzielonego spacjami; nie znajdzie => ustawia CF
  clc
powt:
  lodsb
  cmp al, ' '
  loopz powt
  jnz dal
  stc
dal:
  ret
por endp
piszasc proc near
; wypisuje cig ASCIIz spod adresu DS:SI
znowu:
  lodsb
  or al,al
  jz zakoncz
  mov dx,ax
  mov ah, 2
  int 21h
  jmp znowu
zakoncz:
  ret
piszasc endp
nazwa proc near
; oddziela nazw pliku z wiersza wejciowego
; i umieszcza jako ASCIIz pod adresem ES:DI
petla:
  lodsb
  cmp al, ' '
  jz zak
  stosb
  loop petla
zak:
  xor ax, ax
  stosb
  ret
nazwa endp
binarne proc near
; procedura przeczajca operacje w tryb binarny
; przez ustawienie bitu 5. informacji o urzadzeniu
  mov bx, ax
  mov ax, 4400h
  int 21h
  or dl, 20h
  xor dh, dh
  mov ax, 4401h
  int 21h
  ret
binarne endp
komendy proc near
; rozpoznaje i reaguje na komendy
  push cx
  dec byte ptr cmdflg
  jz kaskom
; jeli 0 (bylo 1) to dalszy cig kasowania komendy
  mov bl, byte ptr cmdflg
  cmp bl, 16
  jnl numery
; jeli conajmniej 16 to ustawianie odstpu
; jeli 255 to dopiero rozpozna komend
cmpo:
  cmp al, 'O'
  jnz zwykle
  mov ax, 201bh
  stosw
  mov byte ptr cmdflg, 19
  mov numer, 0
  jmp wyjd1
numery:
  sub al, 30h
  mov ah, numer
  aad
  mov numer, al
  cmp bl, 16
  jnz wyjd1
  mov byte ptr cmdflg, 0
  mov al, numer
  stosb
  jmp wyjd1
zwykle:
  cmp al, 'C'
  jnz nkaskom
  mov byte ptr cmdflg, 1
  jmp wyjd1
nkaskom:
  mov cx, 17
  mov bx, cx
  push di
  mov di, offset komd
  repnz scasb
  jnz pobdi
  sub bx, cx
  dec bx
  shl bx, 1
  shl bx, 1
  add bx, offset zs01
  jmp kontyn
kaskom:
  mov cx, 9
  mov bx, cx
  push di
  mov di, offset kodw
  repnz scasb
  jnz pobdi
  sub bx, cx
  dec bx
  shl bx, 1
  shl bx, 1
  add bx, offset cs03
kontyn:
  pop di
  push si
  mov si, bx
  lodsb
  xor cx, cx
  mov cl, al
  rep movsb
  pop si
  mov byte ptr cmdflg, 0
wyjd1:
  pop cx
  ret
pobdi:
  pop di
  jmp wyjd1
komendy endp
znaki:
;mazovia
db 134,141,145,146,164,162,158,166,167
db 143,149,144,156,165,163,152,160,161
;   ESC '@' ESC '&' nul pocz koniec
;   sekwencja definiujca znaki DOWNLOAD dla bajtw
;   o kodach od 33 do 50
b db 27,64,27,38,00,33,50
;a
a db 10,8,20,64,20,64,20,66,57,4,1,0
;c
  db 136,28,34,0,34,64,162,0,34,0,0,0
;e
  db 9,56,68,16,68,16,70,17,68,49,0,0
;l
  db 135,0,0,138,0,254,0,34,0,0,0,0
;n
  db 136,32,30,32,0,96,128,32,30,0,0,0
;o
  db 137,28,34,0,34,64,162,0,34,28,0,0
;s
  db 137,16,42,0,42,64,170,0,42,4,0,0
;x
  db 135,34,4,34,72,162,16,34,0,0,0,0
;z
  db 135,34,4,34,136,34,16,34,0,0,0,0
;A
  db 135,30,32,72,128,72,34,29,0,0,0,0
;C
  db 135,60,66,32,66,128,66,36,0,0,0,0
;E
  db 136,254,0,146,0,146,0,131,1,0,0,0
;L
  db 137,254,0,18,0,34,0,66,0,2,0,0
;N
  db 136,126,0,32,80,8,132,0,126,0,0,0
;O
  db 135,60,66,32,66,128,66,60,0,0,0,0
;S
  db 135,36,82,0,106,0,202,36,0,0,0,0
;X
  db 135,66,4,106,0,210,32,66,0,0,0,0
;Z
  db 135,66,4,74,128,82,32,66,0,0,0,0
; rozszerzone znaki graficzne: Esc '6'
  db 27, 54
napis   db 9,'Program SDRUK wersja 1.01.',13,10
        db 9,'Drukuje plik zapisany w standardzie Mazovia',13,10
	db 9,'na drukarce zgodnej ze standardem Epson FX.',13,10
        db 9,'Skladnia :  sdruk  plikWE plikWY.',13,10,0
bd      db 'Nie moge otworzyc pliku ',0
odczyt  db 'Mam trudnosci z odczytem!',0
zapis   db 'Mam trudnosci z zapisem!',0
full    db 'Nie ma miejsca na dysku!',0
jest1   db 'Plik ',0
jest2   db ' juz istnieje.',0
komd	db 'FbwcUIEBepWPH^_\$' ; 17 komend
kodw	db 'wcUIEBWPH' ; 9 powrotow
zs01	db 1,12,0,0
zs02	db 1,8,0,0
zs03	db 1,14,0,0
zs04	db 1,15,0,0
zs05	db 3,27,45,1
zs06	db 2,27,52,0
zs07	db 2,27,69,0
zs08	db 2,27,71,0
zs09	db 2,27,77,0
zs10	db 2,27,80,0
zs11	db 3,27,87,1
zs12	db 3,27,112,1
zs13	db 3,27,119,1
zs14	db 1,'^',0,0
zs15	db 1,'_',0,0
zs16	db 1,'\',0,0
zs17	db 1,16,0,0
cs03	db 1,20,0,0
cs04	db 1,18,0,0
cs05	db 3,27,45,0
cs06	db 2,27,53,0
cs07	db 2,27,70,0
cs08	db 2,27,72,0
cs11	db 3,27,87,0
cs12	db 3,27,112,0
cs13	db 3,27,119,0
uch1    dw ?
uch2    dw ?
scrflg	db ?
cmdflg	db ?
numer	db ?
offst	dw ?
plikwe  db 64 dup (?)
plikwy  db 64 dup (?)
bufor1  db 4096 dup (?)
bufor2:
kod ends
end start
