title polstand.asm
; ******************************************************
;      Program POLSTAND wersja 1.13
;      zamieniajcy standardy kodowania polskich liter.
;      Sawomir Stachniewicz, 1994-1996
;
;      Ul. Przybyszewskiego 22
;      30-128 Krakw
;
;      e-mail: STACHNIEWICZ@VSB01.IFJ.EDU.PL
;*******************************************************
;
kod segment
assume cs:kod, ds:kod
org 100h
start:
  cld
; zerowanie wskanika kierunku
  mov si, 80h
; do SI offset wiersza wejciowego (CS:80h)
  lodsb
; wczytanie dugosci acucha
  cbw
; zamiana bajtu (AL) na sowo (AX), AL musi byc poniej 128
  mov cx, ax
  jcxz info1
; jesli wiersz byl pusty (bez parametrw)
;
; dalej nastpuje analiza skadniowa wiersza wejciowego
; i informacja o bdzie w razie niewaciwego formatu
  call por
  jc info1
  call testuj
  jc info1
  mov stand1, al
; "gorca litera" standardu wejciowego
  jcxz info1
  call por
  jc info1
  call testuj
  jc info1
  mov stand2, al
; "gorca litera" standardu wyjciowego
  jcxz info1
  call por
  jcxz info1
  dec si
  mov di, offset plikwe
  call nazwa
  jcxz info1
; nazwa pliku wejciowego do tablicy PLIKWE jako ASCIIz
  call por
  jcxz spral
  jmp kont
info1:
  mov si, offset tekst
  call piszasc
  jmp koniec
blad1:
  jmp blad
spral:
  cmp al, ' '
  jz info1
kont:
  dec si
  inc cx
  mov di, offset plikwy
  call nazwa
; nazwa pliku wyjciowego do tablicy PLIKWY
  mov dx, offset plikwe
  mov ax, 3d00h
  int 21h
  jc blad1
; prba otwarcia pliku wejciowego do odczytu
  mov uch1, ax
; numer identyfikacyjny do UCH1
  call binarne
  mov dx, offset plikwy
  mov ah, 5bh
  xor cx, cx
  int 21h
  jc blad1
; prba utworzenia pliku wyjciowego
  mov uch2, ax
; numer identyfikacyjny do UCH2
  call binarne
  mov cx, 256
  xor ax, ax
  mov di, offset tablzn
ustaw:
  stosb
  inc ax
  loop ustaw
; wypenianie tablicy konwersji znakami 0...255
  mov al, 18
  mul byte ptr stand1
  mov si, offset znaki
  mov di, si
  add si, ax
  mov al, 18
  mul byte ptr stand2
  add di, ax
; do SI offset tablicy standardu wejciowego
; a do DI wyjciowego (rozmiar tablic : 18 bajtow)
  mov cx, 18
  xor ax, ax
ustpol:
  lodsb
  mov bx, ax
  mov al, byte ptr ds:[di]
  inc di
  mov byte ptr tablzn[bx], al
  loop ustpol
; zamiana znakw standardu wejciowego na standard wyjciowy
gpetla:
; gwna ptla programu
  mov ah, 3fh
  mov bx, uch1
  mov cx, 4096
  mov dx, offset bufor
  int 21h
  jc zle1
; odczytanie 4 kB z pliku wejciowego i umieszczenie
; w tablicy BUFOR
  push ax
; zapamitanie liczby odczyt. bajtw
  mov si, offset bufor
  mov di, offset bufor
  mov cx, 4096
  xor ax, ax
mpetla:
; petla biorca kolejne znaki z tablicy BUFOR,
; zmieniajca standard i zapisujca z powrotem
  lodsb
  mov bx, ax
  mov al, byte ptr tablzn[bx]
  stosb
  loop mpetla
  pop cx
; we liczb odczyt. bajtw
  mov dx, offset bufor
  mov ah, 40h
  mov bx, uch2
  int 21h
  jc zle2
; zapisanie tablicy BUFOR do pliku wyjciowego
  cmp ax, cx
  jb pelny
; porwnanie liczby zapisywanych bajtw z liczb
; rzeczywicie zapisanych bajtw
  cmp cx, 4096
  jnb gpetla
; zakocz jesli liczba poniej 4096 (ostatni blok)
  jmp zamknij
zle1:
  mov si, offset odczyt
  jmp pisz
pelny:
  mov si, offset full
  jmp pisz
zle2:
  mov si, offset zapis
pisz:
  call piszasc
zamknij:
  mov ah, 3eh
  mov bx, uch1
  int 21h
  mov ah, 3eh
  mov bx, uch2
  int 21h
; zamknicie obydwu plikw
  jmp koniec
blad:
; komunikaty o bdach przy otwieraniu plikw
  push dx
  cmp ax, 80
  jnz skocz
  mov si, offset jest1
  call piszasc
  pop si
  call piszasc
  mov si, offset jest2
  call piszasc
  jmp koniec
skocz:
  mov si, offset bd
  call piszasc
  pop si
  call piszasc
koniec:
  mov ax, 4c00h
  int 21h
; powrot do DOS-u, kod wyjcia = 0
upper proc near
; zamienia znak w AL na duy znak (tylko Standard ASCII)
  cmp al, 97
  jl fin
  cmp al, 123
  jnl fin
  sub al, 32
fin:
  ret
upper endp
piszasc proc near
; wypisuje na ekranie cig ASCIIz
znowu:
  lodsb
  or al, al
  jz zakoncz
  mov dx, ax
  mov ah, 2
  int 21h
  jmp znowu
zakoncz:
  ret
piszasc endp
por proc near
; zeruje CF i szuka nastpnego wyrazu oddzielonego
; spacjami, jeli koniec acucha to ustawia CF
  clc
powt:
  lodsb
  call upper
  cmp al, ' '
  loopz powt
  jnz dal
  stc
dal:
  ret
por endp
nazwa proc near
; oddziela nazw pliku z wiersza wejciowego
; i umieszcza w ES:DI
petla:
  lodsb
  call upper
  cmp al, ' '
  jz zak
  stosb
  loop petla
zak:
  xor ax, ax
  stosb
  ret
nazwa endp
testuj proc near
; zeruje CF i sprawdza, czy znak w AL jest "gorc liter"
; ktrego standardu; jeli nie, to ustawia CF
  clc
  push cx
  mov cx, 11
  mov di, offset tablica
  repnz scasb
  jz ok
  stc
  jmp konp
ok:
  mov ax, cx
konp:
  pop cx
  ret
testuj endp
binarne proc near
; procedura przeczajca operacje w tryb binarny
; przez ustawienie bitu 5. informacji o urzdzeniu
  mov bx, ax
  mov ax, 4400h
  int 21h
  or dl, 20h
  xor dh, dh
  mov ax, 4401h
  int 21h
  ret
binarne endp
znaki:
; tablice standardw kodowania polskich znakw
; kolejno : a
;Mazovia
db 134,141,145,146,164,162,158,167,166
db 143,149,144,156,165,163,152,161,160
;Latin-2
db 165,134,169,136,228,162,152,190,171
db 164,143,168,157,227,224,151,189,141
;Windows
db 185,230,234,179,241,243,156,191,159
db 165,198,202,163,209,211,140,175,143
;DHN
db 137,138,139,140,141,142,143,144,145
db 128,129,130,131,132,133,134,135,136
;CSK
db 160,161,162,163,164,165,166,167,168
db 128,129,130,131,132,133,134,135,136
;Cyfromat
db 144,145,146,147,148,149,150,151,152
db 128,129,130,131,132,133,134,135,136
;Microvex
db 160,155,130,159,164,162,135,145,168
db 143,128,144,156,165,147,152,146,157
;ISO Latin-2
db 177,230,234,179,241,243,182,191,188
db 161,198,202,163,209,211,166,175,172
;IEA
db 160,155,130,159,164,162,135,145,168
db 143,128,144,156,165,153,235,146,157
;Logic
db 137,138,139,140,141,142,143,145,144
db 128,129,130,131,132,133,134,136,135
;bez polskich liter
db 'acelnoszzACELNOSZZ'
tekst   db 13,10
        db 9,'Program PolStand wersja 1.13.'
        db ' Autor : Slawomir Stachniewicz.',13,10,13,10
        db 9,'Program zamienia kody polskich znakow w'
        db ' plikach.',13,10,13,10
        db 9,'Skladnia :  polstand standard_WE standard_WY'
        db ' plik_WE plik_WY.',13,10,13,10
        db 9,'Standardy : (M)azovia, (L)atin-2, (W)indows,'
        db ' (D)HN, (C)SK,',13,10
        db 9,9,'    C(Y)fromat, M(I)crovex, IS(O) Latin-2,'
	db ' I(E)A,',13,10
        db 9,9,'    Lo(G)ic, (B)ez polskich znakow.',13,10,13,10
        db 9,'Przyklad :  polstand m l mazovia.txt '
        db 'latin2.txt',13,10,0
; informacja o programie wyswietlana jesli wiersz wejsciowy
; byl niepoprawny lub pusty
tablica db 'BGEOIYCDWLM'
; "gorace litery" standardow
bd      db 'Nie moge otworzyc pliku ',0
odczyt  db 'Mam trudnosci z odczytem!',0
zapis   db 'Mam trudnosci z zapisem!',0
full    db 'Nie ma miejsca na dysku!',0
jest1   db 'Plik ',0
jest2   db ' juz istnieje.',0
stand1  db ?
stand2  db ?
uch1    dw ?
uch2    dw ?
plikwe  db 64 dup (?)
plikwy  db 64 dup (?)
tablzn  db 256 dup (?)
bufor   db 4096 dup (?)
kod ends
end start
