kod segment
; ******************************************************
;       Program POLDRUK wersja 1.01
;       drukujcy tekst w standardzie Mazovia
;       na drukarce zgodnej ze standardem EPSON FX.
;       Sawomir Stachniewicz, 1994
;
;       Ul. Przybyszewskiego 22
;       30-128 Krakw
;
;       e-mail: STACHNIEWICZ@VSB01.IFJ.EDU.PL
; ******************************************************
assume cs:kod, ds:kod
org 100h
start:
  cld
; zerowanie wskanika kierunku
  mov si, 80h
; do SI offset wiersza wejciowego (CS:80h)
  lodsb
; wczytanie dugoci wiersza do AL
  cbw
; zamiana bajtu (AL) na sowo (AX)
  mov cx, ax
  jcxz info1
; jeli wiersz by pusty
;
; dalej analiza parametrw
  call por
  jcxz info1
  dec si
  mov di, offset plikwe
  call nazwa
  jcxz info1
; nazwa pliku wejciowego do tablicy PLIKWE jako ASCIIz
  call por
  jcxz info1
  dec si
  inc cx
  mov di, offset plikwy
  call nazwa
; nazwa pliku wyjciowego do tablicy PLIKWY jako ASCIIz
  mov dx, offset plikwe
  mov ax, 3d00h
  int 21h
  jnc dalejxx
; prba otwarcia pliku wejciowego do odczytu
blad1:
  jmp blad
info1:
  mov si, offset napis
  call piszasc
  jmp koniec
dalejxx:
  mov uch1, ax
; numer identyfikacyjny do UCH1
  call binarne
  mov dx, offset plikwy
  mov ah, 5bh
  xor cx, cx
  int 21h
  jc blad1
; prba utworzenia pliku docelowego
  mov uch2, ax
; numer identyfikacyjny do UCH2
  call binarne
  mov dx, offset b
  mov cx, napis-b
  mov ah, 40h
  int 21h
; zapis sekwencji wejciowej (DOWNLOAD)
; w pliku docelowym
  jc zle2
gpetla:
; gwna ptla programu
  mov ah, 3fh
  mov bx, uch1
  mov cx, 4096
  mov dx, offset bufor1
  int 21h
  jc zle1
; odczyt bloku 4 kB i umieszczenie w tablicy BUFOR1
  mov si, offset bufor1
  mov di, offset bufor2
  mov cx, ax
  push ax
mpetla:
  lodsb
  test al, 80h
; nie ma polskich liter dla znakw o kodach poniej 128
; czyli nie trzeba sprawdza wszystkich znakw
  jz niepol1
  push di
; zapamitaj biecy offset
  mov di, offset znaki
  mov dx, 18
petelka:
; ptla sprawdzajca, czy w AL jest jeden z kodw Mazovii
; umieszczonych w tablicy ZNAKI
  scasb
  jz dalej1
  dec dx
  jnz petelka
  jmp niepol
dalej1:
  mov al, 51
  sub al, dl
; podstawienie pod arbitralnie wybrany znak
; o kodzie od 33 do 50
  pop di
; biecy offset
  push ax
; zapamitaj AX
  mov ax, 251bh
; Esc "%", pierwszy w zapisie bajt starszy (pniejszy)
  stosw
  pop ax
; pobierz poprzedni AX
  xchg ah, al
; zamie AH z AL
  mov al, 1
  stosw
; 1 znak
  mov ax, 251bh
  stosw
; Esc "%"
  xor ax, ax
  stosb
; 0
  loop mpetla
  jmp cd
niepol:
  pop di
niepol1:
  stosb
  loop mpetla
cd:
  pop si
; liczba odczyt. bajtw
  mov dx, offset bufor2
  sub di, dx
  mov cx, di
  mov ah, 40h
  mov bx, uch2
  int 21h
  jc zle2
; zapisanie na og ponad 4 kB danych z offsetu UCH2
; do pliku docelowego
  cmp ax, cx
  jb pelny
; czy wszystkie bajty si zapisay ?
  cmp si, 4096
  jnb gpetla
; jeli liczba odczyt. bajtw mniejsza od 4096,
; to ostatni blok
  jmp zamknij
zle1:
  mov si, offset odczyt
  jmp pisz
pelny:
  mov si, offset full
  jmp pisz
zle2:
  mov si, offset zapis
pisz:
  call piszasc
zamknij:
  mov ah, 3eh
  mov bx, uch1
  int 21h
  mov ah, 3eh
  mov bx, uch2
  int 21h
; zamknicie plikw
  jmp koniec
blad:
  push dx
  cmp ax, 80
  jnz skocz
  mov si, offset jest1
  call piszasc
  pop si
  call piszasc
  mov si, offset jest2
  call piszasc
  jmp koniec
skocz:
  mov si, offset bd
  call piszasc
  pop si
  call piszasc
koniec:
  mov ax, 4c00h
  int 21h
; powrt do DOS-u z kodem powrotu 0
por proc near
; zeruje CF, szuka nastpnego wyrazu w wierszu wejciowym
; oddzielonego spacjami; nie znajdzie => ustawia CF
  clc
powt:
  lodsb
  cmp al, ' '
  loopz powt
  jnz dal
  stc
dal:
  ret
por endp
piszasc proc near
; wypisuje cig ASCIIz spod adresu DS:SI
znowu:
  lodsb
  or al,al
  jz zakoncz
  mov dx,ax
  mov ah, 2
  int 21h
  jmp znowu
zakoncz:
  ret
piszasc endp
nazwa proc near
; oddziela nazw pliku z wiersza wejciowego
; i umieszcza jako ASCIIz pod adresem ES:DI
petla:
  lodsb
  cmp al, ' '
  jz zak
  stosb
  loop petla
zak:
  xor ax, ax
  stosb
  ret
nazwa endp
binarne proc near
; procedura przeczajca operacje w tryb binarny
; przez ustawienie bitu 5. informacji o urzdzeniu
  mov bx, ax
  mov ax, 4400h
  int 21h
  or dl, 20h
  xor dh, dh
  mov ax, 4401h
  int 21h
  ret
binarne endp
znaki:
;mazovia
db 134,141,145,146,164,162,158,166,167
db 143,149,144,156,165,163,152,160,161
;   ESC & nul pocz koniec
;   sekwencja definiujca znaki DOWNLOAD dla bajtw
;   o kodach od 33 do 50
b db 27,38,00,33,50
;
a db 10,8,20,64,20,64,20,66,57,4,1,0
;
  db 136,28,34,0,34,64,162,0,34,0,0,0
;
  db 9,56,68,16,68,16,70,17,68,49,0,0
;
  db 135,0,0,138,0,254,0,34,0,0,0,0
;
  db 136,32,30,32,0,96,128,32,30,0,0,0
;
  db 137,28,34,0,34,64,162,0,34,28,0,0
;
  db 137,16,42,0,42,64,170,0,42,4,0,0
;
  db 135,34,4,34,72,162,16,34,0,0,0,0
;
  db 135,34,4,34,136,34,16,34,0,0,0,0
;
  db 135,30,32,72,128,72,34,29,0,0,0,0
;
  db 135,60,66,32,66,128,66,36,0,0,0,0
;
  db 136,254,0,146,0,146,0,131,1,0,0,0
;
  db 137,254,0,18,0,34,0,66,0,2,0,0
;
  db 136,126,0,32,80,8,132,0,126,0,0,0
;
  db 135,60,66,32,66,128,66,60,0,0,0,0
;
  db 135,36,82,0,106,0,202,36,0,0,0,0
;
  db 135,66,4,106,0,210,32,66,0,0,0,0
;
  db 135,66,4,74,128,82,32,66,0,0,0,0
napis   db 9,'Program POLDRUK wersja 1.01.',13,10
        db 9,'Drukuje plik zapisany w standardzie Mazovia.',13,10
        db 9,'Skladnia :  poldruk  plikWE plikWY.',13,10,0
bd      db 'Nie moge otworzyc pliku ',0
odczyt  db 'Mam trudnosci z odczytem!',0
zapis   db 'Mam trudnosci z zapisem!',0
full    db 'Nie ma miejsca na dysku!',0
jest1   db 'Plik ',0
jest2   db ' juz istnieje.',0
uch1    dw ?
uch2    dw ?
plikwe  db 64 dup (?)
plikwy  db 64 dup (?)
bufor1  db 4096 dup (?)
bufor2:
kod ends
end start
