program plutil;
{$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X-}
{$M 2048,0,0}

(*
  Skadnia: polstand komenda standard(y) plikwe plikwy

  Komendy: K - zamiana standardu polskich znakw
	   KD- zamiana polskich znakw na znaki download,
	   T - zamiana polskie znaki <=> komendy TeX-a,
	   S - dodanie znakw sterujcych dla drukarki,
	   SD- znaki sterujce + download.

  Standardy :	(M)azovia, (L)atin II, (W)indows, (D)HN, (C)SK, C(Y)fromat,
		M(I)crovex, IS(O) Latin II, I(E)A, Lo(G)ic, (B)ez PL znakw.

  Standardy TeX :   (T)eX, TeX I(F)J.

  W przypadku komend K i T podawa 2 standardy (np. dla K "ml" oznacza zamian
  z Mazovii na Latin II, dla T "mt" oznacza zamian z Mazovii na TeX).

  Dla komend KD i SD podac tylko 1 standard (standard pliku WE, np. "M"
  w przypadku Mazovii).

  Dla komendy S nie podawac standardu.


  Przykady :

  plutil k mw plik1.txt plik2.txt => zamiana standardu z Mazovii na Windows

  PLUTIL k bd plik1.txt plik2.txt => moliwe, ale bez sensu: zamiana wszystkich
				     a, e itd. na "ogonki" w standardzie DHN
  plutil kd m plik.txt prn	  => drukowanie pliku w standardzie Mazovia
				     na drukarce typu EPSON FX bez wbudowanych
				     polskich znakw
  plutil T LT PLIK.TXT PLIK.TEX	  => zamiana "ogonkw" w standardzie Latin II
				     na standard TeX
  plutil t tl plik.tex plik.txt   => operacja odwrotna

  plutil S plik.txt plik.bin      => zamiana kodw sterujcych programu
				     na kody sterujce drukarki
  plutil SD w plik.txt plik.bin   => jw. lecz z zamian polskich znakw w
				     standardzie Windows na znaki download.


	KODY STERUJCE PROGRAMU (stosowane przy komendach S i SD) :

\b	Backspace	znak w ty

\F	Form Feed	koniec strony

\w	Double Width	podwjna szeroko
			(w ramach 1 linii)

\Cw			powrt do trybu
			zwykego

\c	Condensed	tryb zagszczony

\Cc			powrt

\Onnn			dodatkowy odstp miedzy znakami
			rwny nnn kropek (np. O009 => 9 kropek)

\U	Underline	znaki podkrelone

\CU			powrt

\I	Italic		znaki pochylone
			(kursywa)

\CI			powrt

\E	Emphasized	znaki pogrubione

\CE			powrt

\B	Double Strike	znaki drukowane
			podwjnie

\CB			powrt

\e	Elite		tryb 12 zn/cal

\p	Pica		tryb 10 zn/cal

\W	Double Width	podwjna szeroko

\CW			powrt

\P	Proportional	znaki proporcjonalne

\CP			powrt

\H	Double Height	podwjna wysoko

\CH			powrt

\^			znak "^"

\_			znak "_"

\\			znak "\"

\$			znak "" (uwaga, na niektrych drukarkach moe wyj
			co innego)

^...^	Superscript	indeks grny

_..._	Subscript	indeks dolny


	Przykady zastosowania kodw sterujcych programu :

G^i^_j_			-	znak "G" z indeksem grnym "i" i nieco z przodu
				dolnym "j"

G^i^\b_j_		-	jw., lecz indeksy grny i dolny maj t sam
				pozycj w poziomie

jest \Bbardzo\CB	-	sowo "bardzo" jest drukowane podwjnie

\w\HDawno\CH temu	-	sowo "Dawno" jest drukowane w trybie podwjnej
				wysokoci i szerokoci, "temu" w trybie podwj-
				nej szerokoci

Program powinien dobrze dziaa dla drukarek typu Epson FX lub IBM Graphics
Printer; dla IBM Proprinter oraz dla drukarek 24-igowych nie bdzie dziaa
tryb download oraz (by moe) niektre komendy.

*)

type	tafnt=array[1..11,1..18] of char;
	arrcmd=array[1..18] of string[5];

const	polskie : tafnt =
	('',
	 '䢘',
	 '󜿟ʣӌ',
	 '',
	 '',
	 '',
	 '',
	 '󶿼ʣӦ',
	 '뒝',
	 '',
	 'acelnoszzACELNOSZZ');
	stand : string[13] = 'MLWDCYIOEGB';

download : string[221]=
	#$1B#$26#$00#$21#$32+ {Esc & nul pocz koniec}
	#$0A#$08#$14#$40#$14#$40#$14#$42#$39#$04#$01#$00+ {}
	#$88#$1C#$22#$00#$22#$40#$A2#$00#$22#$00#$00#$00+ {}
	#$09#$38#$44#$10#$44#$10#$46#$11#$44#$31#$00#$00+ {}
	#$87#$00#$00#$8A#$00#$FE#$00#$22#$00#$00#$00#$00+ {}
	#$88#$20#$1E#$20#$00#$60#$80#$20#$1E#$00#$00#$00+ {}
	#$89#$1C#$22#$00#$22#$40#$A2#$00#$22#$1C#$00#$00+ {}
	#$89#$10#$2A#$00#$2A#$40#$AA#$00#$2A#$04#$00#$00+ {}
	#$87#$22#$04#$22#$88#$22#$10#$22#$00#$00#$00#$00+ {}
	#$87#$22#$04#$22#$48#$A2#$10#$22#$00#$00#$00#$00+ {}
	#$87#$1E#$20#$48#$80#$48#$22#$1D#$00#$00#$00#$00+ {}
	#$87#$3C#$42#$20#$42#$80#$42#$24#$00#$00#$00#$00+ {}
	#$88#$FE#$00#$92#$00#$92#$00#$83#$01#$00#$00#$00+ {}
	#$89#$FE#$00#$12#$00#$22#$00#$42#$00#$02#$00#$00+ {}
	#$88#$7E#$00#$20#$50#$08#$84#$00#$7E#$00#$00#$00+ {}
	#$87#$3C#$42#$20#$42#$80#$42#$3C#$00#$00#$00#$00+ {}
	#$87#$24#$52#$00#$6A#$00#$CA#$24#$00#$00#$00#$00+ {}
	#$87#$42#$04#$4A#$80#$52#$20#$42#$00#$00#$00#$00+ {}
	#$87#$42#$04#$6A#$00#$D2#$20#$42#$00#$00#$00#$00; {}

     robdown : string[3]=#27'%'#1;
     robnorm : string[3]=#27'%'#0;

komtex : arrcmd =
	('\c{a}','\''{c}','\c{e}','\l{}','\''{n}','\''{o}','\''{s}','\.{z}','\''{z}',
	 '\c{A}','\''{C}','\c{E}','\L{}','\''{N}','\''{O}','\''{S}','\.{Z}','\''{Z}');
komifj : arrcmd =
	('\,{a}','\''{c}','\,{e}','\l{}','\''{n}','\''{o}','\''{s}','\.{z}','\''{z}',
	 '\,{A}','\''{C}','\,{E}','\L{}','\''{N}','\''{O}','\''{S}','\.{Z}','\''{Z}');

     litwe : string[17] = 'FbwcUIEBepWPH^_\$'; { litery dla kodw po "\" }
     litwy : string[9] = 'wcUIEBWPH'; { litery kodw powrotnych po "\C" }

komwe : array[1..17] of string[3]=
	(#12,#8,#14,#15,#27#45#1,#27#52,#27#69,#27#71,#27#77,#27#80,#27#87#1,
	 #27#112#1,#27#119#1,'^','_','\',#21); { cigi sterujce dla kodw }
komwy : array[1..9] of string[3]=
	(#20,#18,#27#45#0,#27#53,#27#70,#27#72,#27#87#0,#27#112#0,#27#119#0);
	{ cigi sterujce dla kodw powrotnych }

     zngraf : string[2]=#27#54; { rozszerzony zbir znakw }
     indgor : string[3]=#27#83#0; { indeksy grne }
     inddol : string[3]=#27#83#1; { indeksy dolne }
     zakind : string[2]=#27#84; { koniec ind. grnych/dolnych }
     odstep : string[2]=#27#32; { odstp midzy znakami - Esc ' ' nn }

var	bufor:array[0..255] of char; cg1,cg2,cg3,cg4:string;
	plikwe,plikwy:text; ch:char; k,l:word; numer:byte;
	komenda,zak:boolean; tacmd:arrcmd; bufwe,bufwy:array[1..20480] of byte;

function upper(cg:string):string; assembler;
asm
  push ds
  lds si, [cg]
  les di, @result
  lodsb
  stosb
  xor cx, cx
  mov cl, al
@petla:
  lodsb
  and al, 223
 { wyzerow. bitu 6 - procedura dziaa poprawnie tylko dla liter A-Z }
  stosb
  loop @petla
  pop ds
end;

procedure czytnr; assembler;
{ WE: w AL znak, w ES:DI offset cigu
  WY: w AX numer pozycji (0..N-1), CF=1 => bd (nie ma) }
asm
  push ax
  xor ax, ax
  mov al, es:[di]
  inc di
  mov cx, ax
  mov dx, ax
{ w DX i CX dugo acucha }
  pop ax
  repnz scasb
  jnz @blad
  mov ax, cx
  not ax { = (neg AX) -1 }
  add ax, dx
  clc
  jmp @koniec
@blad:
  xor ax, ax
  stc
@koniec:
end;

function czyjest(zn:char; pytciag:string):boolean; assembler;
asm
  mov al, zn
  les di, [pytciag]
  call czytnr
  jc @koniec
  mov al, 1
@koniec:
end;

procedure zlyplik(nazwa:string);
begin
 write(#7+'Nie moge otworzyc pliku ',nazwa,' !');
end;

procedure ustaw(stdwe,stdwy:char); assembler;
asm
  mov di, offset bufor
  push ds
  pop es
  mov cx, 256
  xor ax, ax
@pet:
  stosb
  inc ax
  loop @pet
  mov al, stdwe
  mov di, offset stand
  call czytnr
{ w AL nr standardu WE }
  mov si, offset polskie
  mov ah, 18
  mul ah
  add si, ax
{ do SI offset tablicy WE }
  mov cx, 11
  mov al, stdwy
  mov di, offset stand
  call czytnr
{ w AL nr standardu WE }
  mov di, offset polskie
  mov ah, 18
  mul ah
  add di, ax
{ do DI offset tablicy WY }
  mov cx, 18
  xor ax, ax
@ustpol:
  lodsb
  mov bx, ax
  mov al, byte ptr ds:[di]
  inc di
  mov byte ptr bufor[bx], al
  loop @ustpol
end;

function czypl(zn,std:char):boolean; assembler;
asm
  push ds
  pop es
  mov al, std
  mov di, offset stand
  call czytnr
{ w AL nr standardu WE }
  mov di, offset polskie
  mov ah, 18
  mul ah
  add di, ax
{ do DI offset tablicy WE }
  mov cx, 18
  mov al, zn
  repnz scasb
  jz @ok
  mov al, 0
  jmp @koniec
@ok:
  mov al, 1
@koniec:
  neg cx
  add cx, 17
  mov numer, cl
end;

function czystd(std:char):boolean;
begin
 czystd:=czyjest(std,stand);
end;

procedure piszcg(cg:string);
begin
 for l:=1 to ord(cg[0]) do write(plikwy,cg[l]);
end;

procedure sprcmd(tabl:arrcmd);
begin
 k:=2;
 cg4:='\';
 zak:=false;
 repeat
  komenda:=false;
  read(plikwe,ch);
  for l:=1 to 18 do if ch=tabl[l,k] then komenda:=true;
  cg4:=cg4+ch;
  inc(k);
  for l:=1 to 18 do if cg4=tabl[l] then
  begin
   zak:=true;
   k:=l;
  end;
 until ((zak=true) or (komenda=false) or (k=6));
 if (not zak) then
 begin
  k:=0;
  piszcg(cg4);
 end;
end;

procedure blad; assembler;
asm
  push cs
  pop ds
  mov dx, offset @msg
  mov ah, 9
  int 21h { wypisz komunikat spod DS:DX zakoczony znakiem $ }
  mov ax, 4c01h
  int 21h { powrt do DOS z kodem powrotu 1 }
@msg:
db  9,'Program PLUTIL wersja 1.00. Autor: Slawomir Stachniewicz.',13,10,10
db  9,'Skladnia : PLUTIL komenda standard(y) plik1 plik2.',13,10,10
db  9,'Komendy: K - zamiana standardu polskich liter,',13,10
db  9,'         KD- zamiana polskich znakow na znaki download,',13,10
db  9,'         T - zamiana polskie znaki <=> komendy TeX-a,',13,10
db  9,'         S - dodanie znakow sterujacych dla drukarki,',13,10
db  9,'         SD- znaki sterujace + download.',13,10,10
db  9,'Standardy :	(M)azovia, (L)atin II, (W)indows, (D)HN, (C)SK,',13,10
db  9,'		C(Y)fromat, M(I)crovex, IS(O) Latin II, I(E)A,',13,10
db  9,'		Lo(G)ic, (B)ez PL znakow.',13,10,10
db  9,'Standardy TeX :   (T)eX, TeX I(F)J.',13,10,10
db  9,'W przypadku komend K i T podawac 2 standardy',13,10
db  9,'(np. "ml" - z Mazovii na Latin II).',13,10
db  9,'Dla komend KD i SD podac tylko 1 standard.',13,10
db  9,'Dla komendy S nie podawac standardu.',13,10,'$'
end;

begin
 if paramcount>0 then cg1:=upper(paramstr(1));
 if not (((paramcount=3) and (cg1='S')) or (paramcount=4)) then blad;
 cg2:=upper(paramstr(2));
 if cg1='S' then
 begin
  cg3:=paramstr(2);
  cg4:=paramstr(3);
 end else begin
  cg3:=paramstr(3);
  cg4:=paramstr(4);
 end;
 if not czyjest(cg1[1],'KTS') then blad;
 assign(plikwe,cg3);
 assign(plikwy,cg4);
 settextbuf(plikwe,bufwe);
 settextbuf(plikwy,bufwy);
{ due bufory dla operacji WE/WY }
 filemode:=0;
 reset(plikwe);
 if ioresult<>0 then zlyplik(paramstr(3));
 rewrite(plikwy);
 if ioresult<>0 then zlyplik(paramstr(4));
{ jeli nie mona otworzy plikw to protest }

 if cg1='KD' then { zam. standardw + download }
 begin
  piszcg(download);
  repeat
   read(plikwe,ch);
   if czypl(ch,cg2[1]) then
{ zastpowanie polskich znakw znakami download - przejcie w tryb d.,
  wydrukowanie znaku, wyjcie z trybu d. }
   begin
    ch:=char(numer+33);
{ arbitralnie wybrane znaki o kodach od 33 do 50 }
    piszcg(robdown);
    write(plikwy,ch);
    piszcg(robnorm);
   end else write(plikwy,ch);
  until eof(plikwe);
 end;

 if cg1='K' then { zamiana standardw kodowania PL liter, 1:1 }
 begin
  if ((ord(cg2[0])<2) or (not czystd(cg2[2]))) then blad;
  ustaw(cg2[1],cg2[2]);
  repeat
   read(plikwe,ch);
   write(plikwy,bufor[ord(ch)]);
  until eof(plikwe);
 end;

 if cg1='T' then { PL=>TeX lub TeX=> PL }
 begin
  if (czyjest(cg2[1],'TF') and czystd(cg2[2])) then
  begin
   repeat
    read(plikwe,ch);
    if ch<>'\' then write(plikwy,ch) else
    begin
     if cg2[1]='T' then tacmd:=komtex else tacmd:=komifj;
     sprcmd(tacmd);
     if k<>0 then
     begin
      l:=pos(cg2[2],stand);
      write(plikwy,polskie[l,k]);
     end;
    end;
   until eof(plikwe);
  end else if (czyjest(cg2[2],'TF') and czystd(cg2[1])) then
  begin
   repeat
    read(plikwe,ch);
    if czypl(ch,cg2[1]) then
    begin
     inc(numer);
     if cg2[2]='T' then cg4:=komtex[numer] else cg4:=komifj[numer];
     piszcg(cg4);
    end else write(plikwy,ch);
   until eof(plikwe);
  end;
 end;

 if cg1[1]='S' then
{ z uyciem kodw dla drukarki }
 begin
  if cg1='SD' then piszcg(download); { dodatkowo download }
  piszcg(zngraf);
  komenda:=false; { komenda=TRUE => jeli tryb indeksw grn. lub dln. }
  repeat
   read(plikwe,ch);
   if ((cg1='SD') and czypl(ch,cg2[1])) then
{ jeli download to zastpi polskie znaki }
   begin
    ch:=char(numer+33);
    piszcg(robdown);
    write(plikwy,ch);
    piszcg(robnorm);
   end else begin
    if czyjest(ch,'^_') then { czy indeks grn. lub dln. }
    begin
     if komenda then
     begin
      piszcg(zakind);
      komenda:=false; { koniec ind. grnych/dolnych }
     end else begin
      if ch='^' then piszcg(indgor) else piszcg(inddol);
      komenda:=true; { indeks grny lub dolny }
     end;
    end;
    if ch<>'\' then write(plikwy,ch) else
    begin
{ jeli "\" to prawdopodobnie kod dla drukarki }
     read(plikwe,ch);
     k:=pos(ch,litwe); { k<>0 => jest to komenda nr k }
     if k<>0 then piszcg(komwe[k]) else
     begin
      if ch='O' then { dodatkowy odstp midzy literami }
      begin
       cg4:='';
       for k:=1 to 3 do { koniecznie 3 cyfry !!! }
       begin
	read(plikwe,ch);
	cg4:=cg4+ch;
       end;
       val(cg4,k,l);
       if l=0 then
       begin
	piszcg(odstep); { Esc ' ' }
	write(plikwy,char(k)); { nn }
       end;
      end else if ch='C' then
      begin
       read(plikwe,ch);
       k:=pos(ch,litwy); { k<>0 => powrt z ktrej komendy }
       if k<>0 then piszcg(komwy[k]) else write(plikwy,'\C',ch);
{ jeli nie, to zapisz to, co byo }
      end else write(plikwy,'\',ch); { jw. }
     end;
    end;
   end;
  until eof(plikwe); { UFF ! }
 end;

 close(plikwe);
 close(plikwy);
 { QEC }
end.
