{ LSTCATW.PAS : Listing Catalog - MS-Windows

  Title   : LSTCATW
  Language: Borland Pascal v7.0 with Objects
  Version : 1.6
  Date    : Feb 7, 2000
  Author  : J R Ferguson
  E-mail  : j.r.ferguson@iname.com
  Download: http://hello.to/ferguson
  Usage   : MS-Windows v3.1 application

This program and its source may be used and copied freely without charge,
but  only  for non-commercial purposes. The author is not responsible for
any damage or loss of data that may be caused by using it.

To compile this source file, you wil need  some  units  from  the  JRFPAS
Pascal  routine  library by the same author, which can be downloaded from
the Internet address mentioned above.
}

{ --- Compiler options --- }

{$B-} { Short-circuit Boolean expression evaluation }
{$V-} { Relaxed var-string checking }
{$X+} { Extended syntax }

{$UNDEF  DEBUG}
{$DEFINE AUTOSAVE}

PROGRAM LSTCATW;

Uses BWCC, WinTypes, WinProcs, Objects, OWindows, ODialogs, OStdDlgs, Validate,
     WinDos, Strings, BpwLib, DefLib, SckLib, StpLib, StfLib, StzLib, NumLib, CvtLib, ChrLib;

{$R LSTCATW.RES}    { Resource file }
{$I LSTCATW.INC}    { Resource file related constants }
{$I OBJTYPE.INC}    { Object type Stream registration identification numbers }

const
  C_PrgVersion      = 'v1.6';
  C_PrgTitle        = 'Listing Catalog';
  C_MainWindowClass = 'LSTCATWMAIN';
  C_FileWindowClass = 'LSTCATWFILE';
  C_Env_Setting     = 'SETTING';  { environment variable for setting directory }
  C_SettingExt      = '.SET';
  C_DflOpenMask     = '*.LCA';
  C_MapFileExt      = '.MAP';
  C_FnmPos          = 01;
  C_FnmLen          = 12;
  C_MapPos          = 14;
  C_MapLen          = 03;
  C_DescrLen        = 40;

type
  P_PathStr     = ^T_PathStr;      P_PathStp     = ^T_PathStp;
  P_DirStr      = ^T_DirStr;       P_DirStp      = ^T_DirStp;
  P_NameStr     = ^T_NameStr;      P_NameStp     = ^T_NameStp;
  P_ExtStr      = ^T_ExtStr;       P_ExtStp      = ^T_ExtStp;
  P_MsgStr      = ^T_MsgStr;       P_MsgStp      = ^T_MsgStp;
  P_FnmStr      = ^T_FnmStr;       P_FnmStp      = ^T_FnmStp;
  P_MapStr      = ^T_MapStr;       P_MapStp      = ^T_MapStp;
  P_DescrStr    = ^T_DescrStr;
  P_FnmValidator= ^T_FnmValidator;
  P_List        = ^T_List;
  P_MapIndex    = ^T_MapIndex;
  P_MapList     = ^T_MapList;
  P_InfoRec     = ^T_InfoRec;
  P_EditBuf     = ^T_EditBuf;
  P_EditAddDlg  = ^T_EditAddDlg;
  P_EditChgDlg  = ^T_EditChgDlg;
  P_EditDelDlg  = ^T_EditDelDlg;
  P_FindFnmBuf  = ^T_FindFnmBuf;
  P_FindFnmDlg  = ^T_FindFnmDlg;
  P_FindMapBuf  = ^T_FindMapBuf;
  P_FindMapDlg  = ^T_FindMapDlg;
  P_MapListBuf  = ^T_MapListBuf;
  P_MapListDlg  = ^T_MapListDlg;
  P_FileWindow  = ^T_FileWindow;
  P_MainWindow  = ^T_MainWindow;
  P_Application = ^T_Application;

  T_Order       = (Ord_Fnm,Ord_Map);

  T_PathStr     = array[0..fsPathName]   of char;   T_PathStp  = String[fsPathName];
  T_DirStr      = array[0..fsDirectory]  of char;   T_DirStp   = String[fsDirectory];
  T_NameStr     = array[0..fsFileName]   of char;   T_NameStp  = String[fsFileName];
  T_ExtStr      = array[0..fsExtension]  of char;   T_ExtStp   = String[fsExtension];
  T_FnmStr      = array[0..C_FnmLen]     of char;   T_FnmStp   = String[C_FnmLen];
  T_MapStr      = array[0..C_MapLen]     of char;   T_MapStp   = String[C_MapLen];
  T_TitleStr    = array[0..fsPathName+2] of char;   T_TitleStp = String[fsPathName+2];
  T_MsgStr      = array[0..255]          of char;   T_MsgStp   = String[255];
  T_DescrStr    = array[0..C_DescrLen]   of char;

  T_FnmValidator= Object(TFilterValidator)
    Constructor Init;
    function    IsValidInput(var V_String: String; V_NoFill: boolean):
                  boolean; virtual;
    function    IsValid(const V_String: String): boolean; virtual;
    procedure   Error; virtual;
  end;

  T_MapIndex    = Object(TSortedCollection)
    Constructor Init;
    function    Compare(V_Item1, V_Item2: Pointer): integer; virtual;
    procedure   FreeItem(V_Item: Pointer); virtual;
    procedure   Build(V_List: P_List);
  end;

  T_List        = Object(TStrCollection)
    Constructor Init;
    function    Compare(V_Key1, V_Key2: Pointer): integer; virtual;
  end;

  T_MapList     = Object(TStrCollection)
    Constructor Init;
    function    Compare(V_Key1, V_Key2: Pointer): integer; virtual;
    function    Description(V_Descr: P_DescrStr; const V_Key: P_MapStr): P_DescrStr;
  end;

  T_InfoRec  = record
    IO_Fnm      : T_FnmStr;
    IO_Map      : T_MapStr;
  end;

  T_EditBuf  = record
    IO_Fnm      : T_FnmStr;
    IO_MapList  : P_MapList;
    IO_Map      : T_MapStr;
  end;

  T_EditAddDlg  = Object(TDialog)
    Constructor Init(V_Parent: PWindowsObject; V_IOBuf: P_EditBuf);
  end;

  T_EditChgDlg  = Object(TDialog)
    Constructor Init(V_Parent: PWindowsObject; V_IOBuf: P_EditBuf);
  end;

  T_EditDelDlg  = Object(TDialog)
    Constructor Init(V_Parent: PWindowsObject; V_IOBuf: P_InfoRec);
  end;

  T_FindFnmBuf  = record
    IO_Fnm      : T_FnmStr;
  end;

  T_FindFnmDlg  = Object(TDialog)
    Constructor Init(V_Parent: PWindowsObject; V_IOBuf: P_FindFnmBuf);
  end;

  T_FindMapBuf  = record
    IO_MapList  : P_MapList;
    IO_Map      : T_MapStr;
  end;

  T_FindMapDlg  = Object(TDialog)
    Constructor Init(V_Parent: PWindowsObject; V_IOBuf: P_FindMapBuf);
  end;

  T_MapListBuf  = record
    IO_MapList  : P_MapList;
    IO_Index    : integer;
  end;

  T_MapListDlg  = Object(TDialog)
    Constructor Init(V_Parent: PWindowsObject; V_IOBuf: P_MapListBuf);
  end;

  T_FileWindow  = Object(T_ListWindow)
    Minimized   : boolean;
    FileName    : T_PathStr;
    MapIndex    : P_MapIndex;
    MapList     : P_MapList;
    FindFnm     : T_FnmStr;
    FindMap     : T_MapStr;
    Changed     : boolean;
    Order       : T_Order;
    Constructor Init(V_Parent: PWindowsObject);
    Destructor  Done; virtual;
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var V_Class: TWndClass); virtual;
    Constructor Load (var V_Stream: TStream);
    procedure   Store(var V_Stream: TStream);
    procedure   FileInit;
    procedure   FileTerm;
    function    GetText(V_Row: integer): String; virtual;
    procedure   NewMapList(V_MapList: P_MapList);
    procedure   SetTitle;
    procedure   SetChanged(V_Changed: boolean);
    function    IsChanged: boolean;
    procedure   ProcessItem (V_Row: integer); virtual;
    function    ReadList(const V_Name: T_PathStr): P_List;
    function    ReadMapList(const V_Name: T_PathStr): P_MapList;
    procedure   WriteList(const V_Name: T_PathStr; const V_List: P_List);
    function    CanClose: boolean; virtual;
    function    CurItem: PChar;
    function    DeleteItem: boolean;
    function    AddItem(const V_String: PChar): boolean;
    procedure   AdjustCommands;
    procedure   CMFileNew    (var V_Msg: TMessage); virtual cm_First + cm_FileNew    ;
    procedure   CMFileOpen   (var V_Msg: TMessage); virtual cm_First + cm_FileOpen   ;
    procedure   CMFileSave   (var V_Msg: TMessage); virtual cm_First + cm_FileSave   ;
    procedure   CMFileSaveAs (var V_Msg: TMessage); virtual cm_First + cm_FileSaveAs ;
    procedure   CMEditAdd    (var V_Msg: TMessage); virtual cm_First + cm_EditAdd    ;
    procedure   CMEditChange (var V_Msg: TMessage); virtual cm_First + cm_EditChange ;
    procedure   CMEditDelete (var V_Msg: TMessage); virtual cm_First + cm_EditDelete ;
    procedure   CMFind       (var V_Msg: TMessage); virtual cm_First + cm_Find       ;
    procedure   CMFindAgain  (var V_Msg: TMessage); virtual cm_First + cm_FindAgain  ;
    procedure   CMOptOrdFnm  (var V_Msg: TMessage); virtual cm_First + cm_OptOrdFnm  ;
    procedure   CMOptOrdMap  (var V_Msg: TMessage); virtual cm_First + cm_OptOrdMap  ;
    procedure   CMBottom     (var V_Msg: TMessage); virtual cm_First + cm_Bottom     ;
    procedure   CMTop        (var V_Msg: TMessage); virtual cm_First + cm_Top        ;
    procedure   CMHelpMapList(var V_Msg: TMessage); virtual cm_First + cm_HelpMapList;
    procedure   WMMDIActivate(var V_Msg: TMessage); virtual wm_First + wm_MDIActivate;
    procedure   WMSyscommand (var V_Msg: TMessage); virtual wm_First + wm_Syscommand ;
    procedure   DoFileNew     ;
    procedure   DoFileOpen    ;
    procedure   DoFileSave    ;
    procedure   DoFileSaveAs  ;
    procedure   DoEditAdd     ;
    procedure   DoEditChange  ;
    procedure   DoEditDelete  ;
    procedure   DoFind        ;
    procedure   DoFindFnm     ;
    procedure   DoFindMap     ;
    procedure   DoFindAgain   ;
    procedure   DoFindAgainFnm;
    procedure   DoFindAgainMap;
    procedure   DoOptOrdFnm   ;
    procedure   DoOptOrdMap   ;
    procedure   DoHelpMapList ;
  end;

  T_MainWindow  = Object(TMDIWindow)
    ChildCount  : integer; { number of MDI child windows }
    Constructor Init(V_Title: PChar; V_Menu: HMenu);
    Destructor  Done; virtual;
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var V_Class: TWndClass); virtual;
    function    InitChild: PWindowsObject; virtual;
    procedure   SetupWindow; virtual;
    function    LoadDeskTop: boolean;
    procedure   SaveDeskTop;
    procedure   AdjustCommands;
    procedure   CMFileNew    (var V_Message: TMessage); virtual cm_First + cm_FileNew;
    procedure   CMFileOpen   (var V_Message: TMessage); virtual cm_First + cm_FileOpen;
    procedure   CMFileSaveAll(var V_Message: TMessage); virtual cm_First + cm_FileSaveAll;
    procedure   CMWinNew     (var V_Message: TMessage); virtual cm_First + cm_WinNew;
    procedure   CMHelpAbout  (var V_Message: TMessage); virtual cm_First + cm_HelpAbout;
    procedure   CMHelpInfo   (var V_Message: TMessage); virtual cm_First + cm_HelpInfo;
    procedure   DoFileNew    ;
    procedure   DoFileOpen   ;
    procedure   DoFileSaveAll;
    procedure   DoWinNew     ;
    procedure   DoHelpAbout  ;
    procedure   DoHelpInfo   ;
  end;

  T_Application = Object(TApplication)
    procedure   InitMainWindow; virtual;
    procedure   InitInstance; virtual;
  end;


const
  C_DflOrder    : T_Order = Ord_Fnm;  { default sort order }

  R_FileWindow  : TStreamRec = (
    ObjType : OT_LSTCATW_FileWindow;
    VmtLink : Ofs(TypeOf(T_FileWindow)^);
    Load    : @T_FileWindow.Load;
    Store   : @T_FileWindow.Store
  );

var
  PrgName    : T_NameStr;
  PrgDir     : T_DirStr;
  PrgIdent   : T_MsgStr;
  SettingTag : T_MsgStr;
  SettingPath: T_PathStr;


{ --- General --- }

procedure StreamRegistration;
begin
  RegisterObjects;
  RegisterODialogs;
  RegisterOWindows;
  RegisterBpwLib;
  RegisterType(R_FileWindow);
end;

procedure GetDirs;
var PrgPath: T_PathStr; PrgExt: T_ExtStr; SettingDir : T_PathStr; SRec: TSearchRec; n: StzInd;
begin
  FileExpand(PrgPath,StzStpCpy(PrgPath,ParamStr(0)));
  FileSplit(PrgPath,PrgDir,PrgName,PrgExt);
{$IFDEF DEBUG}
  StzCpy(SettingDir,PrgDir);
{$ELSE}
  FileExpand(SettingDir,GetEnvVar(C_Env_Setting));
  if StzEmpty(SettingDir) then StzCpy(SettingDir,PrgDir)
  else begin
    n:= StzLen(SettingDir)-1;
    if StzcRet(SettingDir,n) = '\' then StzDel(SettingDir,n,1);
    FindFirst(SettingDir,faDirectory,SRec);
    if DosError = 0 then StzcCat(SettingDir,'\')
                    else StzCpy(SettingDir,PrgDir);
  end;
{$ENDIF}
  StzCat(StzcECat(StzECpy(PrgIdent,PrgName),' '),C_PrgVersion);
  StzCat(StzECat(StzECpy(SettingPath,SettingDir),PrgName),C_SettingExt);
  StzCat(StzECpy(SettingTag,PrgIdent),' settings'#26);
end;

procedure ExpandFnm(var V_Fnm: T_FnmStr);
var sp: T_FnmStp;
begin
  StpStzCpy(sp,V_Fnm);
  StpRLS(sp); StpUpp(sp);
  sp:= StfFill(StfBefore(sp,'.'),' ',9)+
       StfFill(StfAfter (sp,'.'),' ',3);
  StzStpCpy(V_Fnm,sp);
end;

procedure ExpandMap(var V_Map: T_MapStr);
begin
  StzRLS(V_Map); StzRTS(V_Map); StzUpp(V_Map);
  if (StzLen(V_Map) = 2) then StzcIns(V_Map,'0',1);
end;

function RecToString(V_String: PChar; V_InfoRec: T_InfoRec): PChar;
begin with V_InfoRec do begin
  ExpandFnm(IO_Fnm);
  ExpandMap(IO_Map);
  RecToString:= StzCat(StzcCat(StzCpy(V_String,IO_Fnm),' '),IO_Map);
end end;

procedure StringToRec(const V_String: PChar; var V_InfoRec: T_InfoRec);
var fnm: T_FnmStr; name: T_NameStr; ext: T_ExtStr;
begin with V_InfoRec do begin
  if StzEmpty(V_String) then StzCpy(IO_Fnm,'')
  else begin
    StzRTS(StzSub(fnm,V_String,C_FnmPos-1,C_FnmLen));
    StzGtw(name,fnm); StzGtw(ext,fnm);
    StzCat(StzCat(StzCpy(IO_Fnm,name),'.'),ext);
  end;
  StzRTS(StzSub(IO_Map,V_String,C_MapPos-1,C_MapLen));
end; end;

procedure AdjustCommand(V_Command: Word; V_Status: Word);
{ V_Status may be mf_Enabled, mf_Disabled or mf_Grayed }
begin
  EnableMenuItem(P_MainWindow(Application^.MainWindow)^.Attr.Menu,
    V_Command, mf_ByCommand or V_Status);
end;

procedure AdjustWinCommands(V_Status: Word);
begin
  AdjustCommand(cm_FileSave       ,V_Status);
  AdjustCommand(cm_FileSaveAs     ,V_Status);
  AdjustCommand(cm_FileSaveAll    ,V_Status);
  AdjustCommand(cm_ArrangeIcons   ,V_Status);
  AdjustCommand(cm_CascadeChildren,V_Status);
  AdjustCommand(cm_CloseChildren  ,V_Status);
  AdjustCommand(cm_TileChildren   ,V_Status);
end;

procedure AdjustEditCommands(V_Status: Word);
begin
  AdjustCommand(cm_EditChange     ,V_Status);
  AdjustCommand(cm_EditDelete     ,V_Status);
  AdjustCommand(cm_Find           ,V_Status);
  AdjustCommand(cm_FindAgain      ,V_Status);
end;


{ --- T_FnmValidator --- }

Constructor T_FnmValidator.Init;
begin
  Inherited Init(
    ['a'..'z']+['A'..'Z']+['0'..'9']+
    ['_','^','$','~','!','#','%','&','-','{','}','(',')','@','''','`','.']
  );
end;

function T_FnmValidator.IsValidInput(var V_String: String; V_NoFill: boolean):
           boolean;
begin
  StpUpp(V_String);
  IsValidInput:= Inherited IsValidInput(V_String,V_NoFill);
end;

function T_FnmValidator.IsValid(const V_String: String): boolean;
var fnm,ext: StpTyp;
begin {T_FnmValidator.IsValid}
  StpBefore(fnm,V_String,'.'); StpAfter(ext,V_String,'.');
  IsValid:= Inherited IsValid(V_String)
        and (StpcPos(ext,'.')=0)
        and (not StpEmpty(fnm))
        and (StpLen(fnm) <= 8)
        and (StpLen(ext) <= 3);
end;

procedure   T_FnmValidator.Error;
begin
  MessageBox(0,
    'Invalid filename'#13'Need "filename[.ext]"',
    PrgName,mb_IconHand or mb_OK);
end;


{ --- T_MapIndex --- }

Constructor T_MapIndex.Init;
begin Inherited Init(1000,200); end;

function    T_MapIndex.Compare(V_Item1, V_Item2: Pointer): integer;
var key1,key2: array[0..C_MapLen+C_FnmLen] of char; fnm1,fnm2: T_FnmStr;
begin
  Compare:= ISign(StzCmp(
    StzCat(StzSub(key1,StzPtr(V_Item1),C_MapPos-1,C_MapLen),
           StzSub(fnm1,StzPtr(V_Item1),C_FnmPos-1,C_FnmLen)),
    StzCat(StzSub(key2,StzPtr(V_Item2),C_MapPos-1,C_MapLen),
           StzSub(fnm2,StzPtr(V_Item2),C_FnmPos-1,C_FnmLen))));
end;

procedure   T_MapIndex.FreeItem(V_Item: Pointer);
begin {no action} end;

procedure   T_MapIndex.Build(V_List: P_List);
  procedure AddIndex(V_Item: Pointer); far;
  begin Insert(V_Item); end;
begin
  DeleteAll;
  if V_List <> nil then V_List^.ForEach(@AddIndex);
end;


{ --- T_List --- }

Constructor T_List.Init;   begin Inherited Init(1000,200); end;

function    T_List.Compare(V_Key1, V_Key2: Pointer): integer;
var key1,key2: T_FnmStr;
begin
  Compare:= ISign(StzCmp(
    StzSub(key1,StzPtr(V_Key1),C_FnmPos-1,C_FnmLen),
    StzSub(key2,StzPtr(V_Key2),C_FnmPos-1,C_FnmLen)));
end;


{ --- T_MapList --- }

Constructor T_MapList.Init;
begin Inherited Init(25,25); end;

function    T_MapList.Compare(V_Key1, V_Key2: Pointer): integer;
var map1,map2: T_MapStr;
begin
  Compare:= ISign(StzCmp(
    StzSub(map1,StzPtr(V_Key1),0,C_MapLen),
    StzSub(map2,StzPtr(V_Key2),0,C_MapLen)));
end;

function T_MapList.Description(V_Descr:P_DescrStr; const V_Key:P_MapStr):P_DescrStr;
var i: integer;
begin
  if Search(V_Key,i)
    then Description:= P_DescrStr(StzSub(StzPtr(V_Descr),StzPtr(At(i)),4,C_DescrLen))
    else StzCpy(StzPtr(V_Descr),'');
  Description:= V_Descr;
end;


{ --- T_EditAddDlg --- }

Constructor T_EditAddDlg.Init(V_Parent: PWindowsObject; V_IOBuf: P_EditBuf);
var p1: PEdit; p2: PCombobox;
begin
  Inherited Init(V_Parent,MakeIntResource(Dlg_EditAdd));
  p1:= New(PEdit,InitResource(@Self,id_AddKey,C_FnmLen+1));
    p1^.SetValidator(New(P_FnmValidator,Init));
  p2:= New(PCombobox,InitResource(@Self,id_AddData,C_MapLen+1));
  TransferBuffer:= V_IOBuf;
end;

{ --- T_EditChgDlg --- }

Constructor T_EditChgDlg.Init(V_Parent: PWindowsObject; V_IOBuf: P_EditBuf);
var p1: PEdit; p2: PCombobox;
begin
  Inherited Init(V_Parent,MakeIntResource(Dlg_EditChange));
  p1:= New(PEdit,InitResource(@Self,id_ChgKey,C_FnmLen+1));
    p1^.SetValidator(New(P_FnmValidator,Init));
  p2:= New(PCombobox,InitResource(@Self,id_ChgData,C_MapLen+1));
  TransferBuffer:= V_IOBuf;
end;


{ --- T_EditDelDlg --- }

Constructor T_EditDelDlg.Init(V_Parent: PWindowsObject; V_IOBuf: P_InfoRec);
var p: PEdit;
begin
  Inherited Init(V_Parent,MakeIntResource(Dlg_EditDelete));
  p:= New(PEdit,InitResource(@Self,id_DelKey,C_FnmLen+1));
  p:= New(PEdit,InitResource(@Self,id_DelData,C_MapLen+1));
  TransferBuffer:= V_IOBuf;
end;


{ --- T_FindFnmDlg --- }

Constructor T_FindFnmDlg.Init(V_Parent: PWindowsObject; V_IOBuf: P_FindFnmBuf);
var p: PEdit;
begin
  Inherited Init(V_Parent,MakeIntResource(Dlg_FindFnm));
  p:= New(PEdit,InitResource(@Self,id_FindFnm,C_FnmLen+1));
    p^.SetValidator(New(P_FnmValidator,Init));
  TransferBuffer:= V_IOBuf;
end;


{ --- T_FindMapDlg --- }

Constructor T_FindMapDlg.Init(V_Parent: PWindowsObject; V_IOBuf: P_FindMapBuf);
var p: PComboBox;
begin
  Inherited Init(V_Parent,MakeIntResource(Dlg_FindMap));
  p:= New(PComboBox,InitResource(@Self,id_FindMap,C_MapLen+1));
  TransferBuffer:= V_IOBuf;
end;


{ --- T_MapListDlg --- }

Constructor T_MapListDlg.Init(V_Parent: PWindowsObject; V_IOBuf: P_MapListBuf);
var p: PListBox;
begin
  Inherited Init(V_Parent,MakeIntResource(Dlg_MapList));
  p:= New(PListBox,InitResource(@Self,id_MapList));
  TransferBuffer:= V_IOBuf;
end;


{ --- T_FileWindow --- }

Constructor T_FileWindow.Init(V_Parent: PWindowsObject);
begin
  Inherited Init(V_Parent,'',New(P_List,Init));
  with ScrnFont^.LogFont do begin lfHeight:= 15; end;
  Minimized:= false;
  StzCpy(FileName,'');
  New(MapIndex,Init);
  MapList:= nil; NewMapList(New(P_MapList,Init));
  Inc(P_MainWindow(Application^.MainWindow)^.ChildCount);
  FileInit;
end;

Destructor  T_FileWindow.Done;
begin
  FileTerm;
  NewMapList(nil);
  Dispose(MapIndex,Done);
  with P_MainWindow(Application^.MainWindow)^ do begin Dec(ChildCount); AdjustCommands; end;
  Inherited Done;
end;

function    T_FileWindow.GetClassName: PChar;   begin GetClassName:= C_FileWindowClass; end;

procedure   T_FileWindow.GetWindowClass(var V_Class: TWndClass);
begin
  Inherited GetWindowClass(V_Class);
  V_Class.hIcon:= LoadIcon(HInstance,MakeIntResource(Ico_File));
end;

Constructor T_FileWindow.Load (var V_Stream: TStream);
begin
  Inherited Load(V_Stream);
  V_Stream.Read(Minimized,SizeOf(Minimized));
  V_Stream.Read(FileName,SizeOf(FileName));
  if StzEmpty(FileName) then begin
    List    := nil; NewList(New(P_List,Init));
    MapList := nil; NewMapList(New(P_MapList,Init));
    MapIndex:= New(P_MapIndex,Init);
  end
  else begin
    List    := nil; NewList(ReadList(FileName));
    MapList := nil; NewMapList(ReadMapList(FileName));
    MapIndex:= New(P_MapIndex,Init);
  end;
  Inc(P_MainWindow(Application^.MainWindow)^.ChildCount);
  FileInit;
end;

procedure   T_FileWindow.Store(var V_Stream: TStream);
begin
  NewList(nil); NewMapList(nil);
  Inherited Store(V_Stream);
  V_Stream.Write(Minimized,SizeOf(Minimized));
  V_Stream.Write(FileName,SizeOf(FileName));
end;

procedure   T_FileWindow.FileInit;
begin
  StzCpy(FindFnm,'');
  StzCpy(FindMap,'');
  Changed:= false;
  Order  := C_DflOrder;
  SetTitle;
  MapIndex^.Build(P_List(List));
  AdjustCommands;
  InvalidateRect(HWindow,nil,true);
end;

procedure   T_FileWindow.FileTerm;
begin
  StzCpy(FileName,'');
  NewList(New(P_List,Init));
  NewMapList(New(P_MapList,Init));
  FileInit;
end;

function    T_FileWindow.GetText(V_Row: integer): String;
var
  S  : array[0..C_FnmLen+1+C_MapLen+1+C_DescrLen] of char;
  map: T_MapStr; descr: T_DescrStr;
begin
  if (V_Row < 0) or (V_Row >= List^.Count) then GetText:= ''
  else begin
    case Order of
       Ord_Fnm: begin
         if (V_Row < 0) or (V_Row >= List^.Count) then StzCpy(S,'')
         else StzCpy(S,StzPtr(List^.At(V_Row)));
       end;
       Ord_Map: begin
         if (V_Row < 0) or (V_Row >= MapIndex^.Count) then StzCpy(S,'')
         else StzCpy(S,StzPtr(MapIndex^.At(V_Row)));
       end;
    end;
    if (MapList <> nil) and (not StzEmpty(S)) then begin
      StzSub(map,S,C_MapPos-1,C_MapLen);
      StzCat(StzCat(S,' '),MapList^.Description(@descr,@map)^)
    end;
    GetText:= StrPas(S);
  end;
end;

procedure   T_FileWindow.NewMapList(V_MapList: P_MapList);
begin
  if MapList <> nil then Dispose(MapList,Done);
  MapList:= V_MapList;
end;

procedure   T_FileWindow.SetTitle;
var S: T_MsgStr;
begin
  if StzEmpty(FileName) then StrCopy(S,'no name') else StrCopy(S,FileName);
  if Changed then begin StzcIns(S,'<',0); StzcCat(S,'>'); end;
  SetCaption(S);
end;

procedure   T_FileWindow.SetChanged(V_Changed: boolean);
var Title: T_TitleStr;
begin if V_Changed <> Changed then begin
  Changed:= V_Changed; SetTitle;
end; end;

function    T_FileWindow.IsChanged: boolean;           begin IsChanged:= Changed; end;
procedure   T_FileWindow.ProcessItem (V_Row: integer); begin DoEditChange; end;

function    T_FileWindow.ReadList(const V_Name: T_PathStr): P_List;
  var p: P_List; F: Text; Line: array[0..255] of char; ok: boolean;
  procedure ErrMsg(V_Msg: String);
   var S: T_MsgStr;
   begin
     MessageBox(HWindow,StrPCopy(S,V_Msg+#13+StrPas(V_Name)),PrgName,mb_IconHand or mb_OK);
   end;
begin {T_FileWindow.ReadList}
  p:= New(P_List,Init);
  Assign(F,V_Name); {$I-} Reset(F); {$I+}
  if IOResult = 0 then begin
    ok:= true;
    while ok and not eof(F) do begin
      {$I-} readln(F,Line); {$I+}
      if IOResult = 0 then p^.Insert(StrNew(Line))
      else begin ok:= false; ErrMsg('Error reading file'); end;
    end;
    System.Close(F);
  end;
  ReadList:= p;
end;

function    T_FileWindow.ReadMapList(const V_Name: T_PathStr): P_MapList;
var p: P_MapList; F: Text; Line: array[0..255] of char; ok: boolean; MapFnm: T_PathStr;
  procedure ErrMsg(V_Msg: String);
   var S: T_MsgStr;
   begin MessageBox(HWindow,StrPCopy(S,
     V_Msg+#13#13+StrPas(MapFnm)),PrgName,mb_IconHand or mb_OK);
   end;
begin {T_FileWindow.ReadList}
  StzCat(StzBefore(MapFnm,V_Name,'.'),C_MapFileExt);
  Assign(F,MapFnm); {$I-} Reset(F); {$I+}
  p:= New(P_MapList,Init);
  if IOResult = 0 then begin
    ok:= true;
    while ok and not eof(F) do begin
      {$I-} readln(F,Line); {$I+}
      if IOResult = 0 then p^.Insert(StrNew(Line))
      else begin ok:= false; ErrMsg('Error reading file'); end;
    end;
    System.Close(F);
  end;
  ReadMapList:= p;
end;

procedure   T_FileWindow.WriteList(const V_Name: T_PathStr; const V_List: P_List);
  var F: Text; Line: String; ok: boolean;
  procedure ErrMsg(V_Msg: String);
    var S: T_MsgStr;
    begin MessageBox(HWindow,StrPCopy(S,
      V_Msg+#13+StrPas(V_Name)),PrgName,mb_IconHand or mb_OK);
    end;
  procedure WriteItem(V_Item: Pointer); far;
    begin if ok then begin {$I-}Writeln(F,P_MsgStr(V_Item)^);{$I+} ok:= IOResult=0; end; end;
begin {T_FileWindow.WriteList}
  Assign(F,V_Name); {$I-} Rewrite(F); {$I+}
  if IOResult <> 0 then ErrMsg('Open error')
  else begin
    ok:= true; V_List^.ForEach(@WriteItem);
    if ok then SetChanged(false) else ErrMsg('Write error');
    System.Close(F);
  end;
end;

function    T_FileWindow.CanClose: boolean;
var S: T_MsgStr; IsOK: boolean;
begin
  IsOK:= true;
  if IsChanged then begin
    case MessageBox(HWindow,StrPCopy(S,'Save changes?'#13#13+StrPas(FileName)),PrgName,
      mb_IconQuestion or mb_YesNoCancel) of
      IDYES    : begin DoFileSave; IsOK:= not IsChanged; end;
      IDNO     : IsOK:= true;
      IDCANCEL : IsOK:= false;
      else       IsOK:= false;
    end;
  end;
  CanClose:= IsOK and Inherited CanClose;
end;

function    T_FileWindow.CurItem: PChar;
begin case Order of
  Ord_Fnm: CurItem:= PChar(P_List(List)^.At(CurRow));
  Ord_Map: CurItem:= PChar(MapIndex^.At(CurRow));
end; end;

function    T_FileWindow.DeleteItem: boolean;
var i: integer; Item: PChar;
begin
  if (List^.Count <= 0) or (CurRow < 0) or (CurRow >= List^.Count)
  then DeleteItem:= false
  else begin
    Item:= CurItem;
    MapIndex^.Delete(Item);
    P_List(List)^.Free(Item);
    SetMaxRow(List^.Count-1);
    DeleteItem:= true;
  end;
end;

function    T_FileWindow.AddItem(const V_String: PChar): boolean;
var i: integer; ok: boolean; S: T_MsgStr; p: PChar;
begin
  ok:= false;
  if P_List(List)^.Search(V_String,i) then MessageBox(HWindow,
    StzCat(StzCat(StzCpy(S,'Cannot add'#13'"'),V_String),'"'#13'duplicate filename.'),
    PrgName,mb_IconHand or mb_OK)
  else begin
    p:= StrNew(V_String);
    P_List(List)^.Insert(p); MapIndex^.Insert(p);
    SetMaxRow(List^.Count-1);
    case Order of
      Ord_Fnm: P_List(List)^.Search(V_String,i);
      Ord_Map: MapIndex^.Search(V_String,i);
    end;
    SetCurRow(i);
    ok:= true;
  end;
  AddItem:= ok;
end;

procedure   T_FileWindow.AdjustCommands;
begin
 if Minimized or (List = nil) then begin
   AdjustEditCommands(mf_Grayed);
   AdjustCommand(cm_EditAdd,mf_Grayed);
   AdjustCommand(cm_OptOrdFnm,mf_Grayed);
   AdjustCommand(cm_OptOrdMap,mf_Grayed);
   AdjustCommand(cm_HelpMapList,mf_Grayed);
 end
 else begin
   AdjustCommand(cm_EditAdd,mf_Enabled);
   if List^.Count = 0 then begin
     AdjustEditCommands(mf_Grayed);
     AdjustCommand(cm_OptOrdFnm,mf_Grayed);
     AdjustCommand(cm_OptOrdMap,mf_Grayed);
   end
   else begin
     AdjustEditCommands(mf_Enabled);
     AdjustCommand(cm_OptOrdFnm,mf_Enabled);
     AdjustCommand(cm_OptOrdMap,mf_Enabled);
     case Order of
       Ord_Fnm: begin
                  AdjustCommand(cm_OptOrdFnm,mf_Grayed );
                  AdjustCommand(cm_OptOrdMap,mf_Enabled);
                  if StzEmpty(FindFnm) then AdjustCommand(cm_FindAgain,mf_Grayed);
                end;
       Ord_Map: begin
                  AdjustCommand(cm_OptOrdFnm,mf_Enabled);
                  AdjustCommand(cm_OptOrdMap,mf_Grayed );
                  if StzEmpty(FindMap) then AdjustCommand(cm_FindAgain,mf_Grayed);
                end;
     end;
   end;
   if (MapList = nil) or (MapList^.Count = 0) then AdjustCommand(cm_HelpMapList,mf_Grayed)
                                              else AdjustCommand(cm_HelpMapList,mf_Enabled);
 end;
end;

procedure   T_FileWindow.CMFileNew    (var V_Msg: TMessage); begin DoFileNew    ; end;
procedure   T_FileWindow.CMFileOpen   (var V_Msg: TMessage); begin DoFileOpen   ; end;
procedure   T_FileWindow.CMFileSave   (var V_Msg: TMessage); begin DoFileSave   ; end;
procedure   T_FileWindow.CMFileSaveAs (var V_Msg: TMessage); begin DoFileSaveAs ; end;
procedure   T_FileWindow.CMEditChange (var V_Msg: TMessage); begin DoEditChange ; end;
procedure   T_FileWindow.CMEditAdd    (var V_Msg: TMessage); begin DoEditAdd    ; end;
procedure   T_FileWindow.CMEditDelete (var V_Msg: TMessage); begin DoEditDelete ; end;
procedure   T_FileWindow.CMFind       (var V_Msg: TMessage); begin DoFind       ; end;
procedure   T_FileWindow.CMFindAgain  (var V_Msg: TMessage); begin DoFindAgain  ; end;
procedure   T_FileWindow.CMOptOrdFnm  (var V_Msg: TMessage); begin DoOptOrdFnm  ; end;
procedure   T_FileWindow.CMOptOrdMap  (var V_Msg: TMessage); begin DoOptOrdMap  ; end;
procedure   T_FileWindow.CMBottom     (var V_Msg: TMessage); begin SetCurRow(MaxRow); end;
procedure   T_FileWindow.CMTop        (var V_Msg: TMessage); begin SetCurRow(0) ; end;
procedure   T_FileWindow.CMHelpMapList(var V_Msg: TMessage); begin DoHelpMapList; end;

procedure   T_FileWindow.WMMDIActivate   (var V_Msg: TMessage);
begin
  if V_Msg.wParam <> 0 then begin
    P_MainWindow(Application^.MainWindow)^.AdjustCommands;
    AdjustCommands;
  end;
  Inherited WMMDIActivate(V_Msg);
end;

procedure   T_FileWindow.WMSyscommand (var V_Msg: TMessage);
begin
  case V_Msg.wParam of
    sc_Minimize           : begin Minimized:= true;  AdjustCommands; end;
    sc_Restore,sc_Maximize: begin Minimized:= false; AdjustCommands; end;
  end;
  Inherited WMSysCommand(V_Msg);
end;

procedure   T_FileWindow.DoFileNew;
begin if CanClose then FileTerm; end;

procedure   T_FileWindow.DoFileOpen;
var Name: T_PathStr;
begin if CanClose then begin
  StzCpy(Name,C_DflOpenMask);
  if Application^.ExecDialog(New(PFileDialog,Init(@Self,MakeIntResource(sd_FileOpen),
    @Name))) = id_OK
  then begin
    FileTerm;
    StzCpy(FileName,Name);
    NewList(ReadList(FileName));
    NewMapList(ReadMapList(FileName));
    FileInit;
  end;
end; end;

procedure   T_FileWindow.DoFileSave   ;
begin if (List <> nil) and (List^.Count > 0) then begin
  if StzEmpty(FileName) then DoFileSaveAs
  else begin WriteList(FileName,P_List(List)); ReDraw; end;
end; end;

procedure   T_FileWindow.DoFileSaveAs ;
var Name: T_PathStr;
begin if (List <> nil) and (List^.Count > 0) then begin
  StzCpy(Name,FileName);
  if Application^.ExecDialog(New(PFileDialog,Init(@Self,MakeIntResource(sd_FileSave),
    @Name))) = id_OK
  then begin
    StzCpy(FileName,Name); WriteList(FileName,P_List(List)); FileInit;
  end;
end; end;

procedure   T_FileWindow.DoEditAdd;
var Buf: T_EditBuf; Info: T_InfoRec; S: array[0..255] of char; i: integer;
begin if List <> nil then with Buf do begin
  StzCpy(IO_Fnm,'');
  StzCpy(IO_Map,'');
  IO_MapList := MapList;
  if Application^.ExecDialog(New(P_EditAddDlg,Init(@Self,@Buf))) = id_OK
  then begin
    StzCpy(Info.IO_Fnm,IO_Fnm);
    StzCpy(Info.IO_Map,IO_Map);
    if AddItem(RecToString(S,Info)) then SetChanged(true);
    AdjustCommands; ReDraw;
  end;
end; end;

procedure   T_FileWindow.DoEditChange;
var Buf: T_EditBuf; Info: T_InfoRec; S0,S: array[0..255] of char; i: integer;
begin if (List <> nil) and (List^.Count > 0) then with Buf do begin
  StzCpy(S0,CurItem); StringToRec(S0,Info);
  StzCpy(IO_Fnm,Info.IO_Fnm);
  StzCpy(IO_Map,Info.IO_Map);
  IO_MapList:= MapList;
  if Application^.ExecDialog(New(P_EditChgDlg,Init(@Self,@Buf))) = id_OK
  then begin
    StzCpy(Info.IO_Fnm,IO_Fnm);
    StzCpy(Info.IO_Map,IO_Map);
    RecToString(S,Info);
    if StzCmp(S,S0) <> 0 then begin
      DeleteItem;
      if AddItem(@S) then SetChanged(true) else AddItem(@S0);
      ReDraw;
    end;
  end;
end; end;

procedure   T_FileWindow.DoEditDelete;
var Buf: T_InfoRec; i: integer;
begin if (List <> nil) and (List^.Count > 0) then begin
  StringToRec(CurItem,Buf);
  if Application^.ExecDialog(New(P_EditDelDlg,Init(@Self,@Buf))) = id_OK
  then begin
    if DeleteItem then SetChanged(true);
    AdjustCommands; ReDraw;
  end;
end; end;

procedure   T_FileWindow.DoFind;
begin case Order of
  Ord_Fnm: DoFindFnm;
  Ord_Map: DoFindMap;
end; end;

procedure   T_FileWindow.DoFindFnm;
var Info: T_InfoRec; Buf: T_FindFnmBuf; S: array[0..255] of char; i: integer;
begin if (List <> nil) and (List^.Count > 0) then begin
  with Buf do begin StzCpy(IO_Fnm,''); end;
  if Application^.ExecDialog(New(P_FindFnmDlg,Init(@Self,@Buf))) = id_OK
  then begin
    StzCpy(FindFnm,Buf.IO_Fnm);
    with Info do begin StzCpy(IO_Fnm,Buf.IO_Fnm); StzCpy(IO_Map,''); end;
    P_List(List)^.Search(RecToString(S,Info),i);
    SetCurRow(i); AdjustCommands; ReDraw;
  end;
end; end;

procedure   T_FileWindow.DoFindMap;
var Info: T_InfoRec; Buf: T_FindMapBuf; S: array[0..255] of char; i: integer;
begin if (MapIndex <> nil) and (MapIndex^.Count > 0) then begin
  with Buf do begin
    StzCpy(IO_Map,'');
    IO_MapList:= MapList;
  end;
  if Application^.ExecDialog(New(P_FindMapDlg,Init(@Self,@Buf))) = id_OK
  then begin
    StzCpy(FindMap,Buf.IO_Map);
    with Info do begin StzCpy(IO_Map,Buf.IO_Map); StzCpy(IO_Fnm,''); end;
    MapIndex^.Search(RecToString(S,Info),i);
    SetCurRow(i); AdjustCommands; ReDraw;
  end;
end; end;

procedure   T_FileWindow.DoFindAgain;
begin case Order of
  Ord_Fnm: DoFindAgainFnm;
  Ord_Map: DoFindAgainMap;
end; end;

procedure   T_FileWindow.DoFindAgainFnm;
var fnm: T_FnmStr; Found: boolean; i: integer; S: T_MsgStr;
begin if (List <> nil) and (List^.Count > 0) and (not StzEmpty(FindFnm)) then begin
  Found:= false; i:= CurRow;
  while (not Found) and (i < List^.Count-1) do begin
    Inc(i);
    Found:= StzPos(StzSub(@fnm,StzPtr(List^.At(i)),C_FnmPos-1,C_FnmLen),FindFnm)
            = @fnm;
  end;
  if Found then begin SetCurRow(i); ReDraw; end
  else MessageBox(HWindow,StrPCopy(S,
    #13+'No files matching'+#13+'"'+StrPas(FindFnm)+'"'+#13+'starting at current row.'),
    PrgName,mb_IconInformation or mb_OK
  );
end; end;

procedure   T_FileWindow.DoFindAgainMap;
var map: T_MapStr; Found: boolean; i: integer; S: T_MsgStr;
begin if (MapIndex <> nil) and (MapIndex^.Count > 0) and (not StzEmpty(FindMap)) then begin
  Found:= false; i:= CurRow;
  while (not Found) and (i < MapIndex^.Count-1) do begin
    Inc(i);
    Found:= StzPos(StzSub(@map,StzPtr(MapIndex^.At(i)),C_MapPos-1,C_MapLen),FindMap)
            = @map;
  end;
  if Found then begin SetCurRow(i); ReDraw; end
  else MessageBox(HWindow,StrPCopy(S,
    #13+'No files with map'+#13+'"'+StrPas(FindMap)+'"'+#13+'starting at current row.'),
    PrgName,mb_IconInformation or mb_OK
  );
end; end;

procedure  T_FileWindow.DoOptOrdFnm;
begin if Order <> Ord_Fnm then begin
  Order:= Ord_Fnm; SetCurRow(0); AdjustCommands; ReDraw;
end; end;

procedure  T_FileWindow.DoOptOrdMap;
begin if Order <> Ord_Map then begin
  Order:= Ord_Map; SetCurRow(0); AdjustCommands; ReDraw;
end; end;

procedure  T_FileWindow.DoHelpMapList;
var Buf: T_MapListBuf;
begin
  with Buf do begin IO_MapList:= MapList; IO_Index:= 0; end;
  Application^.ExecDialog(New(P_MapListDlg,Init(@Self,@Buf)));
end;


{ --- T_MainWindow --- }

Constructor T_MainWindow.Init(V_Title: PChar; V_Menu: HMenu);
begin
  Inherited Init(V_Title, V_Menu);
  ChildMenuPos:= 4; ChildCount:= 0;
end;

Destructor  T_MainWindow.Done;                 begin SaveDeskTop; Inherited Done; end;
function    T_MainWindow.GetClassName: PChar;  begin GetClassName:= C_MainWindowClass; end;

procedure   T_MainWindow.GetWindowClass(var V_Class: TWndClass);
begin
  Inherited GetWindowClass(V_Class);
  V_Class.hIcon:= LoadIcon(HInstance,MakeIntResource(Ico_Main));
end;

function    T_MainWindow.InitChild: PWindowsObject;
begin InitChild:= New(P_FileWindow, Init(@Self)); end;

procedure   T_MainWindow.SetupWindow;
var FirstChild: P_FileWindow;
begin
  Inherited SetupWindow;
  if not LoadDeskTop then begin
    FirstChild:= P_FileWindow(InitChild);
    with FirstChild^.Attr do Style:= Style or ws_Maximize;
    Application^.MakeWindow(FirstChild);
  end;
  AdjustCommands;
end;

function    T_MainWindow.LoadDeskTop: boolean;
var
  Stream : TBufStream;
  ok     : boolean;
  InpTag : T_PathStr;
  Msg,S  : T_MsgStr;
begin
  ok:= false;
{$IFDEF AUTOSAVE}
  Stream.Init(SettingPath,stOpenRead,1024);
  if Stream.Status=stOK then StzCpy(InpTag,Stream.StrRead);
  if (Stream.Status=stOK) and (StzCmp(InpTag,SettingTag)=0) then begin
    CloseChildren;
    GetChildren(Stream);
    CreateChildren;
  end;
  Stream.Done;
  case Stream.Status of
    stOK       : ok:= true;
    stInitError: {file not found, just return false}
    else begin
      StzCat(StzcECat(StzECat(StzECpy(Msg,
        'Unable to load setup file'#13),
        SettingPath),#13),
        StzStpCpy(S,BPWStreamMsg(Stream)));
      MessageBox(HWindow,Msg,PrgName,mb_IconHand or mb_OK);
    end;
  end;
{$ENDIF}
  LoadDeskTop:= ok;
end;

procedure   T_MainWindow.SaveDeskTop;
var Stream: TBufStream; Msg,S: T_MsgStr;
begin
{$IFDEF AUTOSAVE}
  Stream.Init(SettingPath,stCreate,1024);
  Stream.StrWrite(SettingTag);
  PutChildren(Stream);
  Stream.Done;
  if Stream.Status <> StOK then begin
    StzCat(StzcECat(StzECat(StzECpy(Msg,
      'Unable to save setup file'#13),
      SettingPath),#13),
      StzStpCpy(S,BPWStreamMsg(Stream)));
    MessageBox(HWindow,Msg,PrgName,mb_IconHand or mb_OK);
  end;
{$ENDIF}
end;

procedure   T_MainWindow.AdjustCommands;
begin
 if ChildCount > 0 then begin
   AdjustWinCommands(mf_Enabled);
 end
 else begin
   AdjustWinCommands(mf_Grayed);
   AdjustEditCommands(mf_Grayed);
   AdjustCommand(cm_EditAdd    ,mf_Grayed);
   AdjustCommand(cm_OptOrdFnm  ,mf_Grayed);
   AdjustCommand(cm_OptOrdMap  ,mf_Grayed);
   AdjustCommand(cm_HelpMapList,mf_Grayed);
 end;
end;

procedure   T_MainWindow.CMFileNew    (var V_Message: TMessage); begin DoFileNew    ; end;
procedure   T_MainWindow.CMFileOpen   (var V_Message: TMessage); begin DoFileOpen   ; end;
procedure   T_MainWindow.CMFileSaveAll(var V_Message: TMessage); begin DoFileSaveAll; end;
procedure   T_MainWindow.CMWinNew     (var V_Message: TMessage); begin DoWinNew     ; end;
procedure   T_MainWindow.CMHelpAbout  (var V_Message: TMessage); begin DoHelpAbout  ; end;
procedure   T_MainWindow.CMHelpInfo   (var V_Message: TMessage); begin DoHelpInfo   ; end;

procedure   T_MainWindow.DoFileNew    ; begin CreateChild; end;
procedure   T_MainWindow.DoWinNew     ; begin CreateChild; end;

procedure   T_MainWindow.DoFileOpen ;
var p: P_FileWindow;
begin p:= P_FileWindow(CreateChild); if p<>nil then p^.DoFileOpen; end;

procedure   T_MainWindow.DoFileSaveAll;
  procedure FileSave(p: PWindow); far;
  begin if p^.IsFlagSet(wb_MDIChild) then P_FileWindow(p)^.DoFileSave end;
begin {T_MainWindow.DoFileSaveAll} ForEach(@FileSave); end;

procedure   T_MainWindow.DoHelpAbout;
var Msg: T_MsgStr;
begin
(*
  StzCat(StzECat(StzcECat(StzECpy(Msg,PrgIdent),#13),C_PrgTitle),#13#13'(c)1997-2000, J.R. Ferguson');
  MessageBox(HWindow,Msg,'About this program',mb_IconInformation or mb_OK);
*)
  StzCat(StzECpy(Msg,PrgIdent),#13+
   C_PrgTitle+#13+
   '(c)1997-2000, J.R. Ferguson'+#13+
   'j.r.ferguson@iname.com'+#13+
   'http://hello.to/ferguson');
  MessageBox(HWindow,Msg,'About this program',mb_IconInformation or mb_OK);
end;

procedure   T_MainWindow.DoHelpInfo;
var Msg,Caption: T_MsgStr;
begin
  StzECat(StzECat(StzcCpy(Msg,#13),C_PrgTitle),#13'<filename> <ext> <map>');
  MessageBox(HWindow,Msg,PrgName,mb_IconInformation or mb_OK);
end;


{ --- T_Application --- }

procedure   T_Application.InitMainWindow;
begin
  MainWindow:= New(P_MainWindow,
    Init(C_PrgTitle,LoadMenu(HInstance,MakeIntResource(Mnu_Main))));
end;

procedure   T_Application.InitInstance;
begin
  Inherited InitInstance;
  HACCTable:= LoadAccelerators(HInstance,MakeIntResource(Acc_Keys));
end;


{ --- Main program --- }

begin { Main program }
  GetDirs; StreamRegistration;
  Application:= New(P_Application, Init(PrgIdent));
  Application^.Run;
  Dispose(Application,Done);
end.
