{ LSTCATV.PAS : Listing catalog - Dos version

  Title   : LSTCATV
  Language: Borland Pascal v7.0 with Objects + Turbo Vision v2.0
  Version : 1.6
  Date    : Feb 7, 2000
  Author  : J R Ferguson
  E-mail  : j.r.ferguson@iname.com
  Download: http://hello.to/ferguson (DOS Tools English)
  Usage   : Menu oriented DOS application


This program and its source may be used and copied freely without charge,
but  only  for non-commercial purposes. The author is not responsible for
any damage or loss of data that may be caused by using it.

To compile this source file, you wil need  some  units  from  the  JRFPAS
Pascal  routine  library by the same author, which can be downloaded from
the Internet address mentioned above.
}

{$UNDEF  DEBUG}
{$DEFINE AUTOSAVE}


{--- Compiler options ---}

{$B-} { Short-circuit Boolean expression evaluation }
{$V-} { Relaxed var-string checking }
{$X+} { Extended syntax }

PROGRAM LSTCATV;

Uses Objects, App, Dialogs, Drivers, Menus, MsgBox, StdDlg, Validate, Views,
     Dos, BpvLib, DefLib, SckLib, StpLib, StfLib, NumLib, CvtLib, ChrLib;

{$I OBJTYPE.INC}

const
  C_PrgVersion  = 'v1.6';
  C_PrgTitle    = 'Listing Catalog';
  C_Env_Setting = 'SETTING'; { environment var for Setting Directory }
  C_SettingExt  = '.SET';
  C_DflOpenMask = '*.LCA';
  C_DflSaveMask = '*.LCA';
  C_MapFileExt  = '.MAP';
  C_ArrowDown   = #25;
  C_FnmPos      = 01;
  C_FnmLen      = 12;
  C_MapPos      = 14;
  C_MapLen      = 03;
  C_ColsFirst   = true;      { tile columns first }

  cm_FileNew    = 100;
  cm_FileOpen   = 101;
  cm_FileSave   = 102;
  cm_FileSaveAs = 103;
  cm_FileSaveAll= 104;
  cm_FileChDir  = 105;
  cm_FileDos    = cmDosShell;
  cm_FileExit   = cmQuit;
  cm_EditAdd    = 110;
  cm_EditChange = 111;
  cm_EditDelete = 112;
  cm_Find       = 120;
  cm_FindAgain  = 121;
  cm_OptEGA     = 130;
  cm_OptOrdFnm  = 131;
  cm_OptOrdMap  = 132;
  cm_WinCascade = cmCascade;
  cm_WinTile    = cmTile;
  cm_WinNew     = 142;
  cm_WinClose   = 143;
  cm_WinCloseAll= 144;
  cm_HelpInfo   = 150;
  cm_HelpAbout  = 151;
  cm_HelpMapList= 152;

  hl_FileChDir  = 100;
  hl_FileOpen   = 101;
  hl_FileSave   = 102;

  hc0           = hcNoContext;
  kb0           = kbNoKey;
  kbCtrlA       = $1E01;
  kbCtrlE       = $1205;
  kbCtrlF       = $2106;
  kbCtrlN       = $310E;
  kbCtrlM       = $320D;

type
  P_StatusLine  = ^T_StatusLine;
  P_MenuBar     = ^T_MenuBar;
  P_List        = ^T_List;
  P_MapIndex    = ^T_MapIndex;
  P_MapList     = ^T_MapList;
  P_FnmValidator= ^T_FnmValidator;
  P_MapValidator= ^T_MapValidator;
  P_InfoRec     = ^T_InfoRec;
  P_EditDlg     = ^T_EditDlg;
  P_EditAddDlg  = ^T_EditAddDlg;
  P_EditChgDlg  = ^T_EditChgDlg;
  P_EditDelDlg  = ^T_EditDelDlg;
  P_FindFnmBuf  = ^T_FindFnmBuf;
  P_FindFnmDlg  = ^T_FindFnmDlg;
  P_FindMapBuf  = ^T_FindMapBuf;
  P_FindMapDlg  = ^T_FindMapDlg;
  P_MapListBuf  = ^T_MapListBuf;
  P_MapListDlg  = ^T_MapListDlg;
  P_FileWindow  = ^T_FileWindow;
  P_Application = ^T_Application;
  P_StpTyp      = ^StpTyp;
  P_FnmStp      = ^T_FnmStp;
  P_MapStp      = ^T_MapStp;

  T_Order       = (Ord_Fnm,Ord_Map);
  T_CommandSet  = set of Byte;
  T_FnmStp      = String[C_FnmLen];
  T_MapStp      = String[C_MapLen];

  T_MenuBar     = Object(TMenuBar)
    procedure   Draw; virtual;
  end;

  T_StatusLine  = Object(TStatusLine)
    procedure   Draw; virtual;
  end;

  T_MapIndex    = Object(TSortedCollection)
    Constructor Init;
    function    Compare(V_Item1, V_Item2: Pointer): integer; virtual;
    procedure   FreeItem(V_Item: Pointer); virtual;
    procedure   Build(V_List: P_List);
  end;

  T_List        = Object(TStringCollection)
    Constructor Init;
    function    Compare(V_Key1, V_Key2: Pointer): integer; virtual;
  end;

  T_MapList     = Object(TStringCollection)
    Constructor Init;
    function    Compare(V_Key1, V_Key2: Pointer): integer; virtual;
    function    Description(V_Key: P_MapStp): String;
  end;

  T_FnmValidator= Object(TFilterValidator)
    Constructor Init;
    function    IsValidInput(var V_String: String; V_NoFill: boolean):
                  boolean; virtual;
    function    IsValid(const V_String: String): boolean; virtual;
    procedure   Error; virtual;
  end;

  T_MapValidator= Object(TLookupValidator)
    MapList     : P_MapList;
    Constructor Init(V_MapList: P_MapList);
    function    IsValidInput(var V_String: String; V_SuppressFill: boolean):
                  boolean; virtual;
    function    Lookup(const V_String: String): boolean; virtual;
    procedure   Error; virtual;
  end;

  T_InfoRec     = record
    IO_Fnm      : T_FnmStp;
    IO_Map      : T_MapStp;
  end;

  T_EditDlg     = Object(TDialog)
    MapList     : P_MapList;
    MapField    : PInputLine;
    Constructor Init(V_Title: TTitleStr; V_MapList: P_MapList);
    procedure   InsertButtons; virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoHelpMapList; virtual;
  end;

  T_EditAddDlg  = Object(T_EditDlg)
    Constructor Init(V_MapList: P_MapList);
  end;

  T_EditChgDlg  = Object(T_EditDlg)
    Constructor Init(V_MapList: P_MapList);
  end;

  T_EditDelDlg  = Object(T_EditDlg)
    Constructor Init(V_Buf: P_InfoRec);
  end;

  T_FindFnmBuf  = record
    IO_Fnm      : T_FnmStp;
  end;

  T_FindFnmDlg  = Object(TDialog)
    Constructor Init;
  end;

  T_FindMapBuf  = record
    IO_Map      : T_MapStp;
  end;

  T_FindMapDlg  = Object(TDialog)
    MapList     : P_MapList;
    MapField    : PInputLine;
    Constructor Init(V_MapList: P_MapList);
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoHelpMapList;
  end;

  T_MapListBuf  = record
    IO_MapList  : P_MapList;
    IO_Index    : integer;
  end;

  T_MapListDlg  = Object(TDialog)
    Constructor Init;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
  end;

  T_FileWindow  = Object(T_ListWindow)
    FileName    : PathStr;
    MapIndex    : P_MapIndex;
    MapList     : P_MapList;
    FindFnm     : T_FnmStp;
    FindMap     : T_MapStp;
    Changed     : boolean;
    Order       : T_Order;
    Constructor Init(var V_Rect: TRect);
    Destructor  Done; virtual;
    Constructor Load (var V_Stream: TStream);
    procedure   Store(var V_Stream: TStream);
    procedure   FileInit;
    procedure   FileTerm;
    function    GetText(V_Row: integer): String; virtual;
    procedure   NewMapList(V_MapList: P_MapList);
    procedure   SetChanged(V_Changed: boolean);
    function    IsChanged: boolean;
    procedure   ProcessItem (V_Row: integer); virtual;
    function    ReadList(V_Name: PathStr): P_List;
    function    ReadMapList(V_Name: PathStr): P_MapList;
    procedure   WriteList(V_Name: PathStr; V_List: P_List);
    function    Valid(V_Command: Word): boolean; virtual;
    procedure   Draw; virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoFileNew;
    procedure   DoFileOpen;
    procedure   DoFileSave;
    procedure   DoFileSaveAs;
    function    CurItem: PString;
    function    DeleteItem: boolean;
    function    AddItem(V_String: PString): boolean;
    procedure   DoEditChange;
    procedure   DoEditAdd;
    procedure   DoEditDelete;
    procedure   DoFind;
    procedure   DoFindFnm;
    procedure   DoFindMap;
    procedure   DoFindAgain;
    procedure   DoFindAgainFnm;
    procedure   DoFindAgainMap;
    procedure   DoOptOrdFnm;
    procedure   DoOptOrdMap;
    procedure   DoHelpMapList;
  end;

  T_Application = Object(TApplication)
    ChildCount  : integer;
    Constructor Init;
    Destructor  Done; virtual;
    procedure   InitMenuBar; virtual;
    procedure   InitStatusLine; virtual;
    function    CreateChild: P_FileWindow;
    procedure   SaveDeskTop;
    function    LoadDeskTop: boolean;
    procedure   Draw; virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoFileNew;
    procedure   DoFileOpen;
    procedure   DoFileSaveAll;
    procedure   DoFileChDir;
    procedure   DoOptEGA;
    procedure   DoWinNew;
    procedure   DoWinCloseAll;
    procedure   DoHelpInfo;
    procedure   DoHelpAbout;
  end;


const
  C_DflOrder     : T_Order = Ord_Fnm;  { default sort order }

  C_WinCommands  : T_CommandSet =
    [cm_WinCascade, cm_WinTile, cm_WinClose, cm_WinCloseAll,
     cm_FileSave, cm_FileSaveAs, cm_FileSaveAll, cm_EditAdd];

  C_EditCommands : T_CommandSet =
    [cm_EditChange, cm_EditDelete, cm_Find, cm_FindAgain];

  R_FileWindow  : TStreamRec = (
    ObjType : OT_LSTCATV_FileWindow;
    VmtLink : Ofs(TypeOf(T_FileWindow)^);
    Load    : @T_FileWindow.Load;
    Store   : @T_FileWindow.Store
  );


var
  PrgName   : NameStr;
  PrgDir    : PathStr;
  SettingDir: PathStr;
  SettingTag: StpTyp;


{ --- General --- }

procedure StreamRegistration;
begin
  RegisterObjects;
  RegisterApp;
  RegisterDialogs;
  RegisterMenus;
  RegisterViews;
  RegisterBPVLIB;
  RegisterType(R_FileWindow);
end;

procedure GetDirs;
var PrgPath: PathStr; PrgExt: ExtStr; SRec: SearchRec;
begin
  PrgPath:= FExpand(ParamStr(0));
  FSplit(PrgPath,PrgDir,PrgName,PrgExt);
{$IFDEF DEBUG}
  SettingDir:= PrgDir;
{$ELSE}
  SettingDir:= FExpand(GetEnv(C_Env_Setting));
  if StpCRet(SettingDir,StpLen(SettingDir)) = '\' then
    StpDel(SettingDir,StpLen(SettingDir),1);
  FindFirst(SettingDir,Directory,SRec);
  if DosError = 0 then StpcCat(SettingDir,'\')
                  else SettingDir:= PrgDir;
{$ENDIF}
end;

procedure ExpandFnm(var V_Fnm: T_FnmStp);
begin
  StpRLS(V_Fnm); StpUpp(V_Fnm);
  V_Fnm:= StfFill(StfBefore(V_Fnm,'.'),' ',9)
        + StfFill(StfAfter (V_Fnm,'.'),' ',3);
end;

procedure ExpandMap(var V_Map: T_MapStp);
begin
  StpRLS(V_Map); StpRTS(V_Map); StpUpp(V_Map);
  if (StpLen(V_Map) = 2) then V_Map:= V_Map[1]+'0'+V_Map[2];
end;

function RecToString(V_InfoRec: T_InfoRec): String;
begin with V_InfoRec do begin
  ExpandFnm(IO_Fnm);
  ExpandMap(IO_Map);
  RecToString:= IO_Fnm+' '+IO_Map;
end end;

procedure StringToRec(V_String: String; var V_InfoRec: T_InfoRec);
var fnm: T_FnmStp; name: String[8]; ext: String[3];
begin with V_InfoRec do begin
  if V_String = '' then IO_Fnm:= ''
  else begin
    fnm:= StfRTS(StfSub(V_String,C_FnmPos,C_FnmLen));
    StpGtw(name,fnm); StpGtw(ext,fnm);
    IO_Fnm:= name + '.' + ext;
  end;
  IO_Map:= StfRTS(StfSub(V_String,C_MapPos,C_MapLen));
end; end;


{ --- T_MenuBar --- }

procedure   T_MenuBar.Draw;
var R: TRect;
begin
  inherited Draw;
  GetExtent(R);
  WriteStr(R.B.X-StpLen(PrgName+' '+C_PrgVersion)-1,
           R.A.Y,       PrgName+' '+C_PrgVersion,1);
end;


{ --- T_StatusLine --- }

procedure   T_StatusLine.Draw;
begin inherited Draw; end;


{ --- T_MapIndex --- }

Constructor T_MapIndex.Init;
begin Inherited Init(1000,200); end;

function    T_MapIndex.Compare(V_Item1, V_Item2: Pointer): integer;
begin
  Compare:= ISign(StpCmp(
    StfSub(P_StpTyp(V_Item1)^,C_MapPos,C_MapLen) +
    StfSub(P_StpTyp(V_Item1)^,C_FnmPos,C_FnmLen),
    StfSub(P_StpTyp(V_Item2)^,C_MapPos,C_MapLen) +
    StfSub(P_StpTyp(V_Item2)^,C_FnmPos,C_FnmLen)));
end;

procedure   T_MapIndex.FreeItem(V_Item: Pointer);
begin {no action} end;

procedure   T_MapIndex.Build(V_List: P_List);
  procedure AddIndex(V_Item: Pointer); far;
  begin Insert(V_Item); end;
begin
  DeleteAll;
  if V_List <> nil then V_List^.ForEach(@AddIndex);
end;


{ --- T_List --- }

Constructor T_List.Init;
begin Inherited Init(1000,200); end;

function    T_List.Compare(V_key1, V_Key2: Pointer): integer;
begin
  Compare:= ISign(StpCmp(
    StfSub(P_StpTyp(V_Key1)^,C_FnmPos,C_FnmLen),
    StfSub(P_StpTyp(V_Key2)^,C_FnmPos,C_FnmLen)));
end;


{ --- T_MapList --- }

Constructor T_MapList.Init;
begin Inherited Init(25,25); end;

function    T_MapList.Compare(V_Key1, V_Key2: Pointer): integer;
begin
  Compare:= ISign(StpCmp(
    StfSub(P_StpTyp(V_Key1)^,1,C_MapLen),
    StfSub(P_StpTyp(V_Key2)^,1,C_MapLen)));
end;

function    T_MapList.Description(V_Key: P_MapStp): String;
var i: integer;
begin
  if Search(V_Key,i) then
    Description:= StfSub(PString(At(i))^,5,255)
  else
    Description:= '';
end;

{ --- T_FnmValidator --- }

Constructor T_FnmValidator.Init;
begin
  Inherited Init(
    ['a'..'z']+['A'..'Z']+['0'..'9']+
    ['_','^','$','~','!','#','%','&','-','{','}','(',')','@','''','`','.']
  );
end;

function T_FnmValidator.IsValidInput(var V_String: String; V_NoFill: boolean):
           boolean;
begin
  StpUpp(V_String);
  IsValidInput:= Inherited IsValidInput(V_String,V_NoFill);
end;

function T_FnmValidator.IsValid(const V_String: String): boolean;
var fnm,ext: StpTyp;
begin {T_FnmValidator.IsValid}
  StpBefore(fnm,V_String,'.'); StpAfter(ext,V_String,'.');
  IsValid:= Inherited IsValid(V_String)
        and (StpcPos(ext,'.')=0)
        and (not StpEmpty(fnm))
        and (StpLen(fnm) <= 8)
        and (StpLen(ext) <= 3);
end;

procedure   T_FnmValidator.Error;
begin
  MessageBox(
    #3'Invalid filename'#13+
    #3'Need "filename[.ext]"',
    nil,mfError or mfOKButton);
end;


{ --- T_MapValidator --- }

Constructor T_MapValidator.Init(V_MapList: P_MapList);
begin
  Inherited Init;
  MapList:= V_MapList;
end;

function  T_MapValidator.IsValidInput
            (var V_String: String; V_SuppressFill: boolean): boolean;
begin
  StpUpp(V_String);
  Inherited IsValidInput(V_String,V_SuppressFill);
end;

function  T_MapValidator.Lookup(const V_String: String): boolean;
var i: integer; s: T_MapStp;
begin
  s:= StfNCpy(V_String,C_MapLen);
  ExpandMap(s);
  if (MapList = nil) or (MapList^.Count = 0) then
    Lookup:= (StpLen(s) = C_MapLen)
         and StpIsPict('A99',s)
  else
    Lookup:= MapList^.Search(@s,i);
end;

procedure T_MapValidator.Error;
begin
  if (MapList = nil) or (MapList^.Count = 0) then MessageBox(
    #3'Invalid Map'#13+
    #3'Need picture "an[n]"'#13+
    #3'where a = letter, n = digit',
    nil, mfError or mfOKButton)
  else MessageBox(
    #3'Invalid Map'#13+
    #3'Click "'+C_ArrowDown+'" button for list',
    nil, mfError or mfOKButton);
end;


{ --- T_EditDlg --- }

Constructor T_EditDlg.Init(V_Title: TTitleStr; V_MapList: P_MapList);
var R: TRect; p: PView;
begin
  R.Assign(00,00,24,11);
  Inherited Init(R,V_Title);
  MapList := V_MapList;
  MapField:= nil;
  Options:= Options or ofCentered;
  R.Assign(01,01,23,06); p:= New(PStaticText,Init(R,''));
    p^.Options:= p^.Options or ofFramed; Insert(p);
end;

procedure  T_EditDlg.InsertButtons;
var R: TRect;
begin
  R.Assign(02,08,12,10);
  Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));
  R.Assign(12,08,22,10);
  Insert(New(PButton,Init(R,'O~K~',cmOK,bfDefault)));
end;

procedure  T_EditDlg.HandleEvent(var V_Event: TEvent);
  procedure Clear; begin ClearEvent(V_Event); end;
begin {T_EditDlg.HandleEvent}
  Inherited HandleEvent(V_Event);
  with V_Event do case What of
    evCommand  : case Command of
      cm_HelpMapList : begin DoHelpMapList ; Clear; end;
    end;
  end;
end;

procedure   T_EditDlg.DoHelpMapList;
var Buf: T_MapListBuf; Map: T_MapStp;
begin
  if (MapList = nil) or (MapList^.Count=0) then MessageBox(
    #13#3'No map list available',
    nil, mfInformation or mfOKButton)
  else with Buf do begin
    IO_MapList:= MapList; IO_Index:= 0;
    if  (Application^.ExecuteDialog(New(P_MapListDlg,Init),@Buf)<>cmCancel)
    and (MapField <> nil)
    and (IO_Index >= 0)
    and (IO_Index <  MapList^.Count)
    then begin
      StpNCpy(Map,StpPtr(MapList^.At(IO_Index))^,C_MapLen);
      MapField^.SetData(Map);
    end;
  end;
end;


{ --- T_EditAddDlg --- }

Constructor T_EditAddDlg.Init(V_MapList: P_MapList);
var R: TRect; p: PView;
begin
  Inherited Init('Add',V_MapList);

  R.Assign(02,02,07,03); Insert(New(PStaticText,Init(R,'File:')));
  R.Assign(08,02,22,03); p:= New(PInputLine,Init(R,C_FnmLen));
    PInputLine(p)^.SetValidator(New(P_FnmValidator,Init)); Insert(p);

  R.Assign(02,04,07,05); Insert(New(PStaticText,Init(R,'Map :')));
  R.Assign(08,04,13,05); MapField:= New(PInputLine,Init(R,C_MapLen));
    MapField^.SetValidator(New(P_MapValidator,Init(V_MapList)));
    Insert(MapField);

  if (V_MapList <> nil) and (V_MapList^.Count > 0) then begin
    R.Assign(13,04,18,06);
    Insert(New(PButton,Init(R,C_ArrowDown,cm_HelpMapList,bfNormal)));
  end;

  InsertButtons;
  SelectNext(false);
end;


{ --- T_EditChgDlg --- }

Constructor T_EditChgDlg.Init(V_MapList: P_MapList);
var R: TRect; p: PView;
begin
  Inherited Init('Change',V_MapList);

  R.Assign(02,02,07,03); Insert(New(PStaticText,Init(R,'File:')));
  R.Assign(08,02,22,03); p:= New(PInputLine,Init(R,C_FnmLen));
    PInputLine(p)^.SetValidator(New(P_FnmValidator,Init)); Insert(p);

  R.Assign(02,04,07,05); Insert(New(PStaticText,Init(R,'Map :')));
  R.Assign(08,04,13,05); MapField:= New(PInputLine,Init(R,C_MapLen));
    MapField^.SetValidator(New(P_MapValidator,Init(V_MapList)));
    Insert(MapField);

  if (V_MapList <> nil) and (V_MapList^.Count > 0) then begin
    R.Assign(13,04,18,06);
    Insert(New(PButton,Init(R,C_ArrowDown,cm_HelpMapList,bfNormal)));
  end;

  InsertButtons;
  SelectNext(false);
end;


{ --- T_EditDelDlg --- }

Constructor T_EditDelDlg.Init(V_Buf: P_InfoRec);
var R: TRect; p: PView;
begin with V_Buf^ do begin
  Inherited Init('Delete',nil);

  R.Assign(02,02,07,03); Insert(New(PStaticText,Init(R,'File:')));
  R.Assign(08,02,21,03); Insert(New(PStaticText,Init(R,IO_Fnm)));
  R.Assign(02,04,07,05); Insert(New(PStaticText,Init(R,'Map :')));
  R.Assign(08,04,12,05); Insert(New(PStaticText,Init(R,IO_Map)));

  InsertButtons;
end; end;


{ --- T_FindFnmDlg --- }

Constructor T_FindFnmDlg.Init;
var R: TRect; p: PView;
begin
  R.Assign(00,00,24,08);
  Inherited Init(R,'Find file'); Options:= Options or ofCentered;

  R.Assign(08,02,22,03); p:= New(PInputLine,Init(R,C_FnmLen));
    PInputLine(p)^.SetValidator(New(P_FnmValidator,Init)); Insert(p);
  R.Assign(01,02,07,03); Insert(New(PLabel,Init(R,'File:',p)));

  R.Assign(02,05,12,07);
  Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));

  R.Assign(12,05,22,07);
  Insert(New(PButton,Init(R,'O~K~',cmOK,bfDefault)));

  SelectNext(false);
end;


{ --- T_FindMapDlg --- }

Constructor T_FindMapDlg.Init(V_MapList: P_MapList);
var R: TRect; p: PView;
begin
  R.Assign(00,00,24,08);
  Inherited Init(R,'Find map'); Options:= Options or ofCentered;
  MapList := V_MapList;
  MapField:= nil;

  R.Assign(07,02,12,03); MapField:= New(PInputLine,Init(R,C_MapLen));
    MapField^.SetValidator(New(P_MapValidator,Init(nil))); Insert(MapField);
  R.Assign(01,02,06,03); Insert(New(PLabel,Init(R,'Map:',p)));

  if (V_MapList <> nil) and (V_MapList^.Count > 0) then begin
    R.Assign(12,02,17,04);
    Insert(New(PButton,Init(R,C_ArrowDown,cm_HelpMapList,bfNormal)));
  end;

  R.Assign(02,05,12,07);
  Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));

  R.Assign(12,05,22,07);
  Insert(New(PButton,Init(R,'O~K~',cmOK,bfDefault)));

  SelectNext(false);
end;

procedure  T_FindMapDlg.HandleEvent(var V_Event: TEvent);
  procedure Clear; begin ClearEvent(V_Event); end;
begin {T_FindMapDlg.HandleEvent}
  Inherited HandleEvent(V_Event);
  with V_Event do case What of
    evCommand  : case Command of
      cm_HelpMapList : begin DoHelpMapList ; Clear; end;
    end;
  end;
end;

procedure   T_FindMapDlg.DoHelpMapList;
var Buf: T_MapListBuf; Map: T_MapStp;
begin
  if (MapList = nil) or (MapList^.Count=0) then MessageBox(
    #13#3'No channel list available',
    nil, mfInformation or mfOKButton)
  else with Buf do begin
    IO_MapList:= MapList; IO_Index:= 0;
    if  (Application^.ExecuteDialog(New(P_MapListDlg,Init),@Buf)<>cmCancel)
    and (MapField <> nil)
    and (IO_Index >= 0)
    and (IO_Index <  MapList^.Count)
    then begin
      StpNCpy(Map,StpPtr(MapList^.At(IO_Index))^,C_MapLen);
      MapField^.SetData(Map);
    end;
  end;
end;


{ --- T_MapListDlg --- }

Constructor T_MapListDlg.Init;
var R: TRect; sb: PScrollBar; lb: PListBox;
begin
  R.Assign(00,00,40,15);
  Inherited Init(R,'Map list'); Options:= Options or ofCentered;

  R.Assign(37,01,38,11); sb:= New(PScrollBar,Init(R)); Insert(sb);
  R.Assign(02,01,37,11); lb:= New(PListBox,Init(R,1,sb)); Insert(lb);

  R.Assign(15,12,25,14);
  Insert(New(PButton,Init(R,'O~K~',cmOK,bfDefault)));

  SelectNext(false);
end;

procedure   T_MapListDlg.HandleEvent(var V_Event: TEvent);
  const kbGrayEnter=$E00D;
begin
  with V_Event do case What of
    evKeyDown : case KeyCode of
      kbGrayEnter : KeyCode:= kbEnter;
    end;
    evBroadCast : case Command of
      cmListItemSelected : begin What:= evCommand; Command:= cmOK; end;
    end;
  end;
  Inherited HandleEvent(V_Event);
end;


{ --- T_FileWindow --- }

Constructor T_FileWindow.Init(var V_Rect: TRect);
begin
  Inherited Init(V_Rect,'',wnNoNumber,New(P_List,Init));
  Options  := Options or ofTileable;
  FileName := '';
  New(MapIndex,Init);
  MapList:= nil; NewMapList(New(P_MapList,Init));
  Inc(P_Application(Application)^.ChildCount);
  FileInit;
end;

Destructor  T_FileWindow.Done;
begin
  FileTerm;
  NewMapList(nil);
  Dispose(MapIndex,Done);
  Dec(P_Application(Application)^.ChildCount);
  Inherited Done;
end;

Constructor T_FileWindow.Load(var V_Stream: TStream);
begin
  Inherited Load(V_Stream);
  V_Stream.Read(FileName,SizeOf(FileName));
  New(MapIndex,Init);
  if FileName = '' then begin
    NewList(New(P_List,Init));
    NewMapList(New(P_MapList,Init));
  end
  else begin
    NewList(ReadList(FileName));
    NewMapList(ReadMapList(FileName));
  end;
  Inc(P_Application(Application)^.ChildCount);
  FileInit;
end;

procedure   T_FileWindow.Store(var V_Stream: TStream);
begin
  NewList(nil); NewMapList(nil);
  Inherited Store(V_Stream);
  V_Stream.Write(FileName,SizeOf(FileName));
end;

procedure   T_FileWindow.FileInit;
begin
  FindFnm := '';
  FindMap := '';
  Changed := false;
  Order   := C_DflOrder;
  NewTitle(FileName);
  MapIndex^.Build(P_List(List));
  DrawView;
end;

procedure   T_FileWindow.FileTerm;
begin
  FileName:= '';
  NewList(New(P_List,Init));
  NewMapList(New(P_MapList,Init));
  FileInit;
end;

function    T_FileWindow.GetText(V_Row: integer): String;
var S: String; map: T_MapStp;
begin
  if (V_Row < 0) or (V_Row >= List^.Count) then GetText:= ''
  else begin
    case Order of
      Ord_Fnm: begin
        if (V_Row < 0) or (V_Row >= List^.Count) then S:= ''
        else S:= PString(List^.At(V_Row))^;
      end;
      Ord_Map: begin
        if (V_Row < 0) or (V_Row >= MapIndex^.Count) then S:= ''
        else S:= PString(MapIndex^.At(V_Row))^;
      end;
    end;
    if (MapList <> nil) and (S <> '') then begin
      map:= StfSub(S,C_MapPos,C_MapLen);
      S:= S + ' ' + MapList^.Description(@map);
    end;
    GetText:= S;
  end;
end;

procedure   T_FileWindow.NewMapList(V_MapList: P_MapList);
begin
  if MapList <> nil then Dispose(MapList,Done);
  MapList:= V_MapList;
end;

procedure   T_FileWindow.SetChanged(V_Changed: boolean);
begin if V_Changed <> Changed then begin
  Changed:= V_Changed;
  if Changed then NewTitle('<'+FileName+'>') else NewTitle(FileName);
end; end;

function    T_FileWindow.IsChanged: boolean;
begin IsChanged:= Changed; end;

procedure   T_FileWindow.ProcessItem (V_Row: integer);
begin DoEditChange; end;

function    T_FileWindow.ReadList(V_Name: PathStr): P_List;
var p: P_List; F: Text; Line: String; ok: boolean;
  procedure ErrMsg(V_Msg: String);
  begin MessageBox(#3+V_Msg+#13#13#3+V_Name,nil,mfError or mfOKButton); end;
begin {T_FileWindow.ReadList}
  p:= New(P_List,Init);
  Assign(F,V_Name); {$I-} Reset(F); {$I+}
  if IOResult = 0 then begin
    ok:= true;
    while ok and not eof(F) do begin
      {$I-} readln(F,Line); {$I+}
      if IOResult = 0 then p^.Insert(NewStr(Line))
      else begin ok:= false; ErrMsg('Error reading file'); end;
    end;
    System.Close(F);
  end;
  ReadList:= p;
end;

function    T_FileWindow.ReadMapList(V_Name: PathStr): P_MapList;
var p: P_MapList; F: Text; Line: String; ok: boolean; MapFnm: PathStr;
  procedure ErrMsg(V_Msg: String);
  begin MessageBox(#3+V_Msg+#13#13#3+MapFnm,nil,mfError or mfOKButton); end;
begin {T_FileWindow.ReadList}
  p:= New(P_MapList,Init);
  MapFnm:= StfBefore(V_Name,'.') + C_MapFileExt;
  Assign(F,MapFnm); {$I-} Reset(F); {$I+}
  if IOResult = 0 then begin
    ok:= true;
    while ok and not eof(F) do begin
      {$I-} readln(F,Line); {$I+}
      if IOResult = 0 then p^.Insert(NewStr(Line))
      else begin ok:= false; ErrMsg('Error reading file'); end;
    end;
    System.Close(F);
  end;
  ReadMapList:= p;
end;

procedure T_FileWindow.WriteList(V_Name:PathStr; V_List:P_List);
var F: Text; Line: String; ok: boolean;
  procedure ErrMsg(V_Msg: String);
  begin MessageBox(#3+V_Msg+#13#13#3+V_Name,nil,mfError or mfOKButton); end;
  procedure WriteItem(V_Item: Pointer); far;
  begin if ok then begin
    {$I-} Writeln(F,PString(V_Item)^); {$I+}
    ok:= IOResult = 0;
  end; end;
begin {T_FileWindow.WriteList}
  Assign(F,V_Name); {$I-} Rewrite(F); {$I+}
  if IOResult <> 0 then ErrMsg('Open error')
  else begin
    ok:= true; V_List^.ForEach(@WriteItem);
    if ok then SetChanged(false) else ErrMsg('Write error');
    System.Close(F);
  end;
end;

function    T_FileWindow.Valid(V_Command: Word): boolean;
var NameParm: PString; IsOK: boolean;
begin
  IsOK:= true;
  case V_Command of cmClose, cmQuit: if IsChanged then begin
    NameParm:= @FileName;
    case MessageBox(#3'Save changes?'#13#13#3'%s',@NameParm,
      mfWarning or mfYesNoCancel) of
      cmDefault,
      cmYes   : begin DoFileSave; IsOK:= not IsChanged; end;
      cmNo    : IsOK:= true;
      cmCancel: IsOK:= false;
      cmOK    : IsOK:= true;
    end;
  end; end;
  Valid:= IsOK and Inherited Valid(V_Command);
end;

procedure   T_FileWindow.Draw;
begin
  if (List=nil) or (List^.Count = 0) then DisableCommands(C_EditCommands)
  else begin
    EnableCommands(C_EditCommands);
    case Order of
      Ord_Fnm: if FindFnm = '' then DisableCommands([cm_FindAgain]);
      Ord_Map: if FindMap = '' then DisableCommands([cm_FindAgain]);
    end;
    if (MapList <> nil) and (MapList^.Count > 0)
      then EnableCommands ([cm_HelpMapList])
      else DisableCommands([cm_HelpMapList]);
  end;
  StatusLine^.Draw;
  Inherited Draw;
end;

procedure   T_FileWindow.HandleEvent(var V_Event: TEvent);
  procedure Clear; begin ClearEvent(V_Event); end;
begin {T_FileWindow.HandleEvent}
  with V_Event do case What of
    evKeyDown  : case Command of
      kbHome   : Command:= kbCtrlPgUp;
      kbEnd    : Command:= kbCtrlPgDn;
    end;
  end;
  Inherited HandleEvent(V_Event);
  with V_Event do case What of
    evCommand  : case Command of
      cm_FileNew     : begin DoFileNew     ; Clear; end;
      cm_FileOpen    : begin DoFileOpen    ; Clear; end;
      cm_FileSave    : begin DoFileSave    ; Clear; end;
      cm_FileSaveAs  : begin DoFileSaveAs  ; Clear; end;
      cm_EditAdd     : begin DoEditAdd     ; Clear; end;
      cm_EditChange  : begin DoEditChange  ; Clear; end;
      cm_EditDelete  : begin DoEditDelete  ; Clear; end;
      cm_Find        : begin DoFind        ; Clear; end;
      cm_FindAgain   : begin DoFindAgain   ; Clear; end;
      cm_OptOrdFnm   : begin DoOptOrdFnm   ; Clear; end;
      cm_OptOrdMap   : begin DoOptOrdMap   ; Clear; end;
      cm_HelpMapList : begin DoHelpMapList ; Clear; end;
    end;
    evBroadCast: case Command of
      cm_FileSave    : DoFileSave;
      cm_WinClose    : Close;
    end;
  end;
end;

procedure   T_FileWindow.DoFileNew;
begin if Valid(cmClose) then FileTerm; end;

procedure   T_FileWindow.DoFileOpen;
var Name: PathStr;
begin if Valid(cmClose) then begin
  Name:= C_DflOpenMask;
  if Application^.ExecuteDialog(New(PFileDialog,Init(C_DflOpenMask,
       'Open File','~F~ile name',fdOKButton or fdNoLoadDir,
       hl_FileOpen)),@Name) <> cmCancel
  then begin
    FileTerm;
    FileName:= Name;
    NewList(ReadList(FileName));
    NewMapList(ReadMapList(FileName));
    FileInit;
  end;
end; end;

procedure   T_FileWindow.DoFileSave;
begin if (List <> nil) and (List^.Count > 0) then begin
  if (FileName='') then DoFileSaveAs
  else begin WriteList(FileName,P_List(List)); DrawView; end;
end; end;

procedure   T_FileWindow.DoFileSaveAs;
var Name: PathStr;
begin if (List <> nil) and (List^.Count > 0) then begin
  Name:= FileName;
  if Application^.ExecuteDialog(New(PFileDialog,Init(C_DflSaveMask,
       'Save File','~F~ile name',fdOKButton or fdNoLoadDir,
       hl_FileSave)),@Name) <> cmCancel
  then begin
    FileName:= Name; WriteList(FileName,P_List(List)); FileInit;
  end;
end; end;

function    T_FileWindow.CurItem: PString;
begin
  case Order of
    Ord_Fnm: CurItem:= PString(P_List(List)^.At(CurRow));
    Ord_Map: CurItem:= PString(MapIndex^.At(CurRow));
  end;
end;

function    T_FileWindow.DeleteItem: boolean;
var i: integer; Item: PString;
begin
  if (List^.Count <= 0) or (CurRow < 0) or (CurRow >= List^.Count)
  then DeleteItem:= false
  else begin
    Item:= CurItem;
    MapIndex^.Delete(Item);
    P_List(List)^.Free(Item);
    SetMaxRow(List^.Count-1);
    DeleteItem:= true;
  end;
end;

function    T_FileWindow.AddItem(V_String: PString): boolean;
var i: integer; ok: boolean; p: PString;
begin
  ok:= false;
  if P_List(List)^.Search(V_String,i) then MessageBox(
    #3'Cannot add "'+V_String^+'",'#13+
    #3'duplicate filename.',
    nil, mfInformation or mfOKButton)
  else begin
    p:= NewStr(V_String^);
    P_List(List)^.Insert(p); MapIndex^.Insert(p);
    SetMaxRow(List^.Count-1);
    case Order of
      Ord_Fnm: P_List(List)^.Search(V_String,i);
      Ord_Map: MapIndex^.Search(V_String,i);
    end;
    SetCurRow(i);
    ok:= true;
  end;
  AddItem:= ok;
end;

procedure   T_FileWindow.DoEditAdd;
var Buf: T_InfoRec; S: String;
begin if List <> nil then begin
  StringToRec('',Buf);
  if Application^.ExecuteDialog(New(P_EditAddDlg,Init(MapList)),@Buf)
     <> cmCancel
  then with Buf do begin
    S:= RecToString(Buf);
    if AddItem(@S) then SetChanged(true);
    DrawView;
  end;
end; end;

procedure   T_FileWindow.DoEditChange;
var Buf: T_InfoRec; S0,S: String;
begin if (List <> nil) and (List^.Count > 0) then begin
  S0:= CurItem^; StringToRec(S0,Buf);
  if Application^.ExecuteDialog(New(P_EditChgDlg,Init(MapList)),@Buf)
     <> cmCancel
  then with Buf do begin
    S:= RecToString(Buf);
    if S <> S0 then begin
      DeleteItem;
      if AddItem(@S) then SetChanged(true) else AddItem(@S0);
      DrawView;
    end;
  end;
end; end;

procedure   T_FileWindow.DoEditDelete;
var Buf: T_InfoRec; S: String;
begin if (List <> nil) and (List^.Count > 0) then begin
  StringToRec(CurItem^,Buf);
  if Application^.ExecuteDialog(New(P_EditDelDlg,Init(@Buf)),nil) <> cmCancel
  then begin
    if DeleteItem then SetChanged(true);
    DrawView;
  end;
end; end;

procedure   T_FileWindow.DoFind;
begin case Order of
  Ord_Fnm: DoFindFnm;
  Ord_Map: DoFindMap;
end; end;

procedure   T_FileWindow.DoFindFnm;
var Info: T_InfoRec; Buf: T_FindFnmBuf; S: String; i: integer;
begin if (List <> nil) and (List^.Count > 0) then begin
  with Buf do begin IO_Fnm := ''; end;
  if Application^.ExecuteDialog(New(P_FindFnmDlg,Init),@Buf) <> cmCancel
  then begin
    FindFnm:= Buf.IO_Fnm;
    with Info do begin IO_Fnm:= Buf.IO_Fnm; IO_Map:= ''; end;
    S:= RecToString(Info);
    P_List(List)^.Search(@S,i);
    SetCurRow(i); DrawView;
  end;
end; end;

procedure   T_FileWindow.DoFindMap;
var Info: T_InfoRec; Buf: T_FindMapBuf; S: String; i: integer;
begin if (MapIndex <> nil) and (MapIndex^.Count > 0) then begin
  with Buf do begin IO_Map := ''; end;
  if Application^.ExecuteDialog(New(P_FindMapDlg,Init(MapList)),@Buf)
     <> cmCancel
  then begin
    FindMap:= Buf.IO_Map;
    with Info do begin IO_Map:= Buf.IO_Map; IO_Fnm:= ''; end;
    S:= RecToString(Info);
    MapIndex^.Search(@S,i);
    SetCurRow(i); DrawView;
  end;
end; end;

procedure   T_FileWindow.DoFindAgain;
begin case Order of
  Ord_Fnm: DoFindAgainFnm;
  Ord_Map: DoFindAgainMap;
end; end;

procedure   T_FileWindow.DoFindAgainFnm;
var Found: boolean; i: integer; FindParam: PString;
begin
  if (FindFnm <> '') and (List <> nil) and (List^.Count > 0) then begin
    Found:= false; i:= CurRow;
    while (not Found) and (i < List^.Count-1) do begin
      Inc(i);
      Found:= Pos(FindFnm,Copy(PString(List^.At(i))^,C_FnmPos,C_FnmLen))=1;
    end;
    if Found then begin SetCurRow(i); DrawView; end
    else begin
      FindParam:= @FindFnm;
      MessageBox(
        #3'No files matching "%s" found starting at current row',
        @FindParam, mfInformation or mfOKButton);
    end;
  end;
end;

procedure   T_FileWindow.DoFindAgainMap;
var Found: boolean; i: integer; FindParam: PString;
begin
  if (FindMap <> '') and (MapIndex <> nil) and (MapIndex^.Count > 0)
  then begin
    Found:= false; i:= CurRow;
    while (not Found) and (i < MapIndex^.Count-1) do begin
      Inc(i);
      Found:=Pos(FindMap,Copy(PString(MapIndex^.At(i))^,C_MapPos,C_MapLen))=1;
    end;
    if Found then begin SetCurRow(i); DrawView; end
    else begin
      FindParam:= @FindMap;
      MessageBox(
        #3'No files with map "%s" found starting at current row',
        @FindParam, mfInformation or mfOKButton);
    end;
  end;
end;


procedure  T_FileWindow.DoOptOrdFnm;
begin if Order <> Ord_Fnm then begin
  Order:= Ord_Fnm; SetCurRow(0); DrawView;
end; end;

procedure  T_FileWindow.DoOptOrdMap;
begin if Order <> Ord_Map then begin
  Order:= Ord_Map; SetCurRow(0); DrawView;
end; end;

procedure  T_FileWindow.DoHelpMapList;
var Buf: T_MapListBuf;
begin
  with Buf do begin IO_MapList:= MapList; IO_Index:= 0; end;
  Application^.ExecuteDialog(New(P_MapListDlg,Init),@Buf);
end;



{ --- T_Application --- }

Constructor T_Application.Init;
var R: TRect;
begin
  GetDirs; StreamRegistration;
  SettingTag:= PrgName+' '+C_PrgVersion+' settings'#26;
  Inherited Init;
  if not LoadDeskTop then begin
    DeskTop^.TileColumnsFirst:= C_ColsFirst;
    ChildCount:= 0;
    DoFileNew;
  end;
end;

Destructor T_Application.Done;
begin
  SaveDeskTop;
  Inherited Done;
end;

function    T_Application.LoadDeskTop: boolean;
var
  Stream        : TBufStream;
  InpDeskTop    : PDeskTop;
  InpSettingTag : StpTyp;
  R             : TRect;
  ok            : boolean;
begin
  ok:= false;
{$IFDEF AUTOSAVE}
  Stream.Init(SettingDir+PrgName+C_SettingExt,stOpenRead,1024);
  Stream.Read(InpSettingTag,StpLen(SettingTag)+1);
  InpDeskTop:= PDeskTop(Stream.Get);
  Stream.Done;
  if (Stream.Status = StOK)         and
     (InpSettingTag = SettingTag)   and
     (ValidView(InpDeskTop) <> nil)
  then begin
    Delete(DeskTop); Dispose(DeskTop,Done);
    DeskTop:= InpDeskTop; Insert(DeskTop);
    GetExtent(R); R.Grow(0,-1); DeskTop^.Locate(R);
    ok:= true;
  end;
{$ENDIF}
  LoadDeskTop:= ok;
end;

procedure   T_Application.SaveDeskTop;
var Stream: TBufStream;
begin
{$IFDEF AUTOSAVE}
  Stream.Init(SettingDir+PrgName+C_SettingExt,stCreate,1024);
  Stream.Write(SettingTag,StpLen(SettingTag)+1);
  Stream.Put(DeskTop);
  Stream.Done;
  if Stream.Status <> StOK then begin
    MessageBox(
      #3'Unable to save current settings'#13+
      #3+SettingDir+PrgName+C_SettingExt,
      nil,mfError or mfOKButton);
  end;
{$ENDIF}
end;

procedure   T_Application.InitMenuBar;
var R: TRect;
begin
  GetExtent(R); R.B.Y:= R.A.Y+1;
  MenuBar:= New(P_MenuBar,Init(R,NewMenu(
    NewSubMenu('~F~ile'               ,hc0, NewMenu(
      NewItem('~N~ew'                 ,''      ,kb0    ,cm_FileNew     ,hc0,
      NewItem('~O~pen...'             ,'F3'    ,kbF3   ,cm_FileOpen    ,hc0,
      NewItem('~S~ave'                ,'F2'    ,kbF2   ,cm_FileSave    ,hc0,
      NewItem('Save ~a~s...'          ,''      ,kb0    ,cm_FileSaveAs  ,hc0,
      NewItem('Save a~l~l'            ,''      ,kb0    ,cm_FileSaveAll ,hc0,
      NewLine(
      NewItem('~C~hange dir'          ,''      ,kb0    ,cm_FileChDir   ,hc0,
      NewItem('~D~OS shell'           ,''      ,kb0    ,cm_FileDos     ,hc0,
      NewItem('E~x~it'                ,'Alt+X' ,kbAltX ,cm_FileExit    ,hc0,
    nil)))))))))),
    NewSubMenu('~E~dit'               ,hc0, NewMenu(
      NewItem('~A~dd'                 ,'Ins'   ,kbIns  ,cm_EditAdd     ,hc0,
      NewItem('~C~hange'              ,'Enter' ,kbEnter,cm_EditChange  ,hc0,
      NewItem('~D~elete'              ,'Del'   ,kbDel  ,cm_EditDelete  ,hc0,
    nil)))),
    NewSubMenu('~S~earch'             ,hc0, NewMenu(
      NewItem('~F~ind'                ,'Ctrl+F',kbCtrlF,cm_Find        ,hc0,
      NewItem('Find ~a~gain'          ,'Ctrl+A',kbCtrlA,cm_FindAgain   ,hc0,
    nil))),
    NewSubMenu('~O~ptions'            ,hc0, NewMenu(
      NewItem('~E~GA lines'           ,'Ctrl+E',kbCtrlE,cm_OptEGA      ,hc0,
      NewLine(
      NewItem('File~n~ame order'      ,'Ctrl+N',kbCtrlN,cm_OptOrdFnm   ,hc0,
      NewItem('~M~ap order'           ,'Ctrl+M',kbCtrlM,cm_OptOrdMap   ,hc0,
    nil))))),
    NewSubMenu('~W~indow'             ,hc0, NewMenu(
      NewItem('~C~ascade'             ,''      ,kb0    ,cm_WinCascade  ,hc0,
      NewItem('~T~ile'                ,''      ,kb0    ,cm_WinTile     ,hc0,
      NewItem('Cl~o~se all'           ,''      ,kb0    ,cm_WinCloseAll ,hc0,
      NewLine(
      NewItem('~N~ew window'          ,''      ,kb0    ,cm_WinNew      ,hc0,
    nil)))))),
    NewSubMenu('~H~elp'               ,hc0, NewMenu(
      NewItem('~I~nfo'                ,'F1'    ,kbF1   ,cm_HelpInfo    ,hc0,
      NewItem('~A~bout'               ,''      ,kb0    ,cm_HelpAbout   ,hc0,
      NewLine(
      NewItem('~M~ap list'            ,'F4'    ,kbF4   ,cm_HelpMapList ,hc0,
    nil))))),
  nil)))))))));
end;

procedure   T_Application.InitStatusLine;
var R: TRect;
begin
  GetExtent(R); R.A.Y:= R.B.Y-1;
  StatusLine:= New(P_StatusLine,Init(R,
    NewStatusDef($0000,$FFFF,
      NewStatusKey('~F2~ Save'          ,kbF2    ,cm_FileSave,
      NewStatusKey('~Alt+X~ Exit'       ,kbAltX  ,cm_FileExit,
      StdStatusKeys(
    nil))),
  nil)));
end;

function    T_Application.CreateChild: P_FileWindow;
var R: TRect; p: P_FileWindow;
begin
  GetTileRect(R);
  p:= P_FileWindow(InsertWindow(New(P_FileWindow,Init(R))));
  if p <> nil then Cascade;
  CreateChild:= p;
end;

procedure   T_Application.Draw;
begin
  if ChildCount > 0
    then EnableCommands(C_WinCommands)
    else DisableCommands(C_WinCommands+C_EditCommands+[cm_HelpMapList]);
  Inherited Draw;
end;

procedure   T_Application.HandleEvent(var V_Event: TEvent);
  procedure Clear; begin ClearEvent(V_Event); end;
begin {T_Application.HandleEvent}
  Inherited HandleEvent(V_Event);
  with V_Event do case What of
    evCommand: case Command of
      cm_FileNew    : begin DoFileNew    ; Clear; end;
      cm_FileOpen   : begin DoFileOpen   ; Clear; end;
      cm_FileSaveAll: begin DoFileSaveAll; Clear; end;
      cm_FileChDir  : begin DoFileChDir  ; Clear; end;
      cm_OptEGA     : begin DoOptEGA     ; Clear; end;
      cm_WinCloseAll: begin DoWinCloseAll; Clear; end;
      cm_WinNew     : begin DoWinNew     ; Clear; end;
      cm_HelpInfo   : begin DoHelpInfo   ; Clear; end;
      cm_HelpAbout  : begin DoHelpAbout  ; Clear; end;
    end;
  end;
end;

procedure   T_Application.DoFileNew; begin CreateChild; end;

procedure   T_Application.DoFileOpen;
var p: P_FileWindow;
begin p:= CreateChild; if p<>nil then p^.DoFileOpen; end;

procedure   T_Application.DoFileSaveAll;
begin Message(DeskTop,evBroadCast,cm_FileSave,nil); end;

procedure   T_Application.DoFileChDir;
begin ExecuteDialog(New(PChDirDialog, Init(cdNormal,hl_FileChDir)),nil); end;

procedure   T_Application.DoOptEGA;
begin SetScreenMode(ScreenMode xor smFont8x8); end;

procedure   T_Application.DoWinCloseAll;
begin Message(DeskTop,evBroadCast,cm_WinClose,nil); end;

procedure   T_Application.DoWinNew; begin CreateChild; end;

procedure   T_Application.DoHelpInfo;
begin
  MessageBox(
   #3+C_PrgTitle+#13+
   #3'<filename> <ext> <map>',
   nil,mfInformation or mfOKButton);
end;

procedure   T_Application.DoHelpAbout;
var R: TRect;
begin
  R.Assign(20,5,60,17);
  MessageBoxRect(R,
   #3+PrgName+' '+C_PrgVersion+#13+
   #3'Borland Pascal + Turbo Vision'#13#13+
   #3'(C) 1996-2000, J.R. Ferguson'#13+
   #3'j.r.ferguson@iname.com'#13+
   #3'http://hello.to/ferguson',
   nil,mfInformation or mfOKButton);
end;


{ --- main program --- }

begin
  Application:= New(P_Application,Init);
  Application^.Run;
  Dispose(Application,Done);
end.
