{Logfile Cutting Tool 1.0
Delphi 3 sources

-- Main Window --

This file is in the Public Domain
Original programming by Steffen Gerlach <mail@steffengerlach.de>
Please tell him about important modifications you made
Program homepage: http://www.steffengerlach.de/freeware/#log}

unit main;

interface

uses
  Windows, Classes, Controls, Forms, Dialogs, StdCtrls, ComCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    OpenDialog1: TOpenDialog;
    PageControl1: TPageControl;
    SGeneral: TTabSheet;
    Label3: TLabel;
    COutputName: TEdit;
    COutputBrowse: TButton;
    CFileBrowse: TButton;
    Label2: TLabel;
    startdate: TDateTimePicker;
    Label4: TLabel;
    StopDate: TDateTimePicker;
    State: TProgressBar;
    CGo: TButton;
    SExtraction: TTabSheet;
    CBrowser: TCheckBox;
    GroupBox2: TGroupBox;
    COtherReqs: TCheckBox;
    CPost: TCheckBox;
    CGet: TCheckBox;
    GroupBox3: TGroupBox;
    CC200: TCheckBox;
    Label1: TLabel;
    SInfo: TTabSheet;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    CFileName: TMemo;
    CImages: TCheckBox;
    CC2x: TCheckBox;
    CC206: TCheckBox;
    CC3x: TCheckBox;
    CC4x: TCheckBox;
    CZero: TCheckBox;
    SaveDialog1: TSaveDialog;
    CExtraction: TCheckBox;
    CLoggling: TCheckBox;
    procedure CGoClick(Sender: TObject);
    procedure CFileBrowseClick(Sender: TObject);
    procedure COutputBrowseClick(Sender: TObject);
    procedure CExtractionClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  end;

var
  MainForm: TMainForm;

implementation

uses
  registry;

{$R *.DFM}


const
BufferSize=4096; {size of read buffer in bytes}

{definition of logfile structure:}
nItem=11; {number of items in a line}
StopOn: array[0..nItem-1] of char=(' ','[','"','"',' ',' ','"','"','"','"',#10);
  {stop characters of the single items}
MinLen: array[0..nItem-1] of integer=(1,4,28,0,0,3,2,1,1,0,0);
  {minimum length of the single items}
itHost=0; itTime=2; itReq=3; itCode=5; itSize=6; itRef=7; itAgent=9;
  {constants for the items}

MoName: array[0..11] of pchar=('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug',
  'Sep','Oct','Nov','Dec'); {month IDs as they appear in a logfile (first
  character is not being tested)}
startday: array[0..11] of integer=(0,31,59,90,120,151,181,212,243,273,304,334);
  {number of the first day of a month in a year}

nCheckBoxes=13;


var
nBuffer, {number of bytes contained in buffer}
NextPos, {read position in buffer}
LastFoundItem, {last item type found in latest read line}
Total, Progress: integer; {total and processed bytes}
Buffer: array[0..BufferSize-1] of char;
Start: array[0..nItem] of pchar; {start positions in buffer of the items of the
  latest read line}
FirstReqStart, LastReqStart: pchar; {first and last character after ' '
  in request string, FirstReq=nil if no ' '}
f: file;
Last, DotOK: boolean;


function GetLine: boolean;
{read a single line from the logfile, result=false if no more lines in file}
var
Pos0, {line start position in buffer}
item,nRead: integer;
begin
DotOK:=false;
repeat {repeat once if line exceeds buffer}
  if Last and (NextPos>=nBuffer) then
    begin result:=false; exit end; {end of file reached}
  Pos0:=NextPos;
  Start[itHost]:=@Buffer[NextPos];
  Inc(NextPos,MinLen[itHost]);
  item:=itHost;
  FirstReqStart:=nil;
  while (NextPos<nBuffer) and (Buffer[NextPos]<>#10) do
    begin {step through characters until EOL}
    if (item=itReq) and (Buffer[NextPos]=' ') then
      begin {mark FirstReqStart and LastReqStart}
      LastReqStart:=@Buffer[NextPos+1];
      if FirstReqStart=nil then FirstReqStart:=LastReqStart;
      end
    else if (item=itHost) and (Buffer[NextPos]='.') then
      DotOK:=true {loggling save files must contain dot in host string}
    else if Buffer[NextPos]=StopOn[item] then
      begin {next item begins here}
      Inc(item);
      Start[item]:=@Buffer[NextPos+1];
      Inc(NextPos,MinLen[item]);
      end;
    Inc(NextPos);
    end;
  if (NextPos<nBuffer) and (Buffer[NextPos]=#10) or Last then
    begin {complete line in buffer, end reached -- ready}
    LastFoundItem:=item;
    {set items after last found to empty:}
    if Buffer[NextPos-1]=#13 then {Microsoft format}
      while item<nItem do
        begin Inc(item); Start[item]:=@Buffer[NextPos] end
    else {Unix format}
      while item<nItem do
        begin Inc(item); Start[item]:=@Buffer[NextPos+1] end;
    if NextPos<nBuffer then Inc(NextPos);
    result:=true;
    exit
    end;

  {line exceeds buffer -- read more data from file}
  Move(Buffer[Pos0],Buffer[0],nBuffer-Pos0); {move line to buffer begin}
  BlockRead(f,Buffer[nBuffer-Pos0],Pos0,nRead); {fill rest of buffer from file}
  Progress:=Progress+Pos0;
  if nRead<Pos0 then {end of file, buffer no more completely filled}
    begin Dec(nBuffer,Pos0-nRead); Last:=true end;
  NextPos:=0;
until false;
end;


procedure TMainForm.CGoClick(Sender: TObject);
const
NoBrowser='-"'; {replace agent information by this if not chosen}
type
TTimeString=packed record {time string structure}
  d1,d0,x0: byte;
  mo0,mo1,mo2: char;
  x1,y3,y2,y1,y0,x2,h1,h0,x3,m1,m0,x4,s1,s0: byte
  end;
var
nTest, Month, Year, Date, StatePos, StateNew, ExtPos, InputFileNo,
  MinDate, MaxDate: integer; {first and last day}
TimeString: ^TTimeString;
{time0,time1: int64;}
o: file;
get,post,otherreqs,c200,c206,c2x,c3x,c4x,zero,img,browser,loggling,ReqOK,
  CodeOK,ImgOK: boolean;

begin
if COutputName.Text='' then exit;
{$I-}
AssignFile(o,COutputName.Text);
Rewrite(o,1);
{$I+}
if IOResult<>0 then
  begin
  Application.MessageBox('Output file name not vaild.','Error',
    MB_OK or MB_ICONERROR);
  exit;
  end;

if CExtraction.Checked then
  begin
  get:=CGet.Checked;
  post:=CPost.Checked;
  otherreqs:=COtherReqs.Checked;
  c200:=CC200.Checked;
  c206:=CC206.Checked;
  c2x:=CC2x.Checked;
  c3x:=CC3x.Checked;
  c4x:=CC4x.Checked;
  zero:=CZero.Checked;
  img:=CImages.Checked;
  browser:=CBrowser.Checked;
  end
else {no extraction -- all information chosen}
  begin
  get:=true;
  post:=true;
  otherreqs:=true;
  c200:=true;
  c206:=true;
  c2x:=true;
  c3x:=true;
  c4x:=true;
  zero:=true;
  img:=true;
  browser:=true;
  end;
loggling:=CLoggling.Checked;
MinDate:=Trunc(startdate.Date);
MaxDate:=Trunc(StopDate.Date);
{queryperformancecounter(time0);}

Progress:=0;
Total:=0;
{calculate total size:}
for InputFileNo:=0 to CFileName.Lines.Count-1 do
  if CFileName.Lines[InputFileNo]<>'' then
    begin
    {$I-}
    AssignFile(f,CFileName.Lines[InputFileNo]);
    Reset(f,1);
    if IOResult=0 then {file accessable -- sum size}
      begin Inc(Total,FileSize(f)); CloseFile(f) end
    {$I+}
    else Application.MessageBox(pchar('File '+CFileName.Lines[InputFileNo]
      +' not found.'),'Error',MB_OK or MB_ICONERROR);
    end;
if Total=0 then exit; {no data -- don't start processing}

Screen.Cursor:=crHourGlass;
for InputFileNo:=0 to CFileName.Lines.Count-1 do
  if CFileName.Lines[InputFileNo]<>'' then
    begin
    {$I-}
    AssignFile(f,CFileName.Lines[InputFileNo]);
    Reset(f,1);
    {$I+}
    if IOResult<>0 then continue; {file not accessable}

    {initialize buffer:}
    nBuffer:=BufferSize;
    NextPos:=BufferSize;
    Last:=false;
    StatePos:=0;
    Month:=0;
    while GetLine do
      begin {process lines one after one}
      TimeString:=pointer(Start[itTime]);
      nTest:=0;
      while ((TimeString.mo1<>MoName[Month][1])
        or (TimeString.mo2<>MoName[Month][2])) and (nTest<12) do
        begin Month:=(Month+1) mod 12; Inc(nTest) end;
        {identify month, ntest=12 if not found}
      if (nTest<12) {time string ok}
        and (not loggling or DotOK and (FirstReqStart<>nil)
        and (FirstReqStart<>LastReqStart)) {loggling requires three part
          request string}
        and ((LastFoundItem=6) or (LastFoundItem=10)) {CLF or ECLF}
        and (Start[itCode][0]>='2') and (Start[itCode][0]<='5') then
        begin {line ok}
        {calculate day:}
        Year:=TimeString.y3*1000+TimeString.y2*100
          +TimeString.y1*10+TimeString.y0-(48*1111+1900);
        Date:=Year*365+(Year+3) div 4+startday[Month]
          +TimeString.d1*10+TimeString.d0-(48*11);
        if (Year mod 4=0) and (Month>1) then Inc(Date);

        if (Date>=MinDate) and (Date<=MaxDate) then
          begin {day in chosen time range}
          {test if image request, means if request string part before last ends
            in 'jpg', 'gif' or 'png':}
          ImgOK:=img or ((FirstReqStart=nil)
            or (((LastReqStart[-4]<>'j') and (LastReqStart[-4]<>'J')
            or (LastReqStart[-3]<>'p') and (LastReqStart[-3]<>'P'))
            and ((LastReqStart[-4]<>'p') and (LastReqStart[-4]<>'P')
            or (LastReqStart[-3]<>'n') and (LastReqStart[-3]<>'N'))
            or (LastReqStart[-2]<>'g') and (LastReqStart[-2]<>'G'))
            and ((LastReqStart[-4]<>'g') and (LastReqStart[-4]<>'G')
            or (LastReqStart[-3]<>'i') and (LastReqStart[-3]<>'I')
            or (LastReqStart[-2]<>'f') and (LastReqStart[-2]<>'F')));

          if ImgOK then
            begin {no image request or images chosen}
            {test if request type chosen:}
            if (Start[itReq][0]='G') and (Start[itReq][1]='E')
              and (Start[itReq][2]='T') then ReqOK:=get
            else if (Start[itReq][0]='P') and (Start[itReq][1]='O')
              and (Start[itReq][2]='S') and (Start[itReq][3]='T') then
              ReqOK:=post
            else ReqOK:=otherreqs;

            if ReqOK then
              begin {request type chosen}
              {test if status code chosen:}
              if (Start[itCode][0]='2') and (Start[itCode][1]='0')
                and (Start[itCode][2]='0') then
                CodeOK:=c200 and (zero or (Start[itSize][0]<>'-')
                  and (Start[itSize][0]<>'0'))
              else if (Start[itCode][0]='3') and (Start[itCode][1]='0')
                and (Start[itCode][2]='4') then
                CodeOK:=c200
              else if Start[itCode][0]='2' then
                if (Start[itCode][1]='0') and (Start[itCode][2]='6') then
                  CodeOK:=c206
                else CodeOK:=c2x
              else if Start[itCode][0]='3' then CodeOK:=c3x
              else CodeOK:=c4x;

              if CodeOK then {status code chosen}
                if browser or (LastFoundItem=6) then
                  BlockWrite(o,Start[0]^,@Buffer[NextPos]-Start[0])
                    {write complete line to output}
                else
                  begin {write line without agent information to output}
                  BlockWrite(o,Start[0]^,Start[itAgent]-Start[0]);
                  BlockWrite(o,NoBrowser[1],2);
                  BlockWrite(o,Start[10]^,@Buffer[NextPos]-Start[10]);
                  end
              end
            end
          end
        end;
      StateNew:=int64(Progress+NextPos)*128 div Total;
      if StateNew>StatePos then {progress bar update necessary}
        begin State.Position:=StateNew; StatePos:=StateNew end
      end;
    CloseFile(f);
    end;

CloseFile(o);
{queryperformancecounter(time1);
application.messagebox(pchar(floattostrf((time1-time0)*0.00000083,ffFixed,7,2)+'s'),
  'Time',MB_OK);}
MessageBeep(MB_OK);
Screen.Cursor:=crDefault;
State.Position:=0
end;


procedure TMainForm.FormCreate(Sender: TObject);
var
i,CheckBoxState: integer;
Reg: TRegistry;
begin
{load checkbox states from registry:}
Reg:=TRegistry.Create;
if Reg.KeyExists('SOFTWARE\Steffen Gerlach\LCT') then
  begin
  Reg.OpenKey('SOFTWARE\Steffen Gerlach\LCT',false);
  CheckBoxState:=Reg.ReadInteger('CheckBoxState');
  Reg.CloseKey;
  for i:=0 to ComponentCount-1 do
    if Components[i] is TCheckBox then
      TCheckBox(Components[i]).Checked:=
        CheckBoxState and (1 shl Components[i].Tag)>0
  end;
end;


procedure TMainForm.FormDestroy(Sender: TObject);
var
i,CheckBoxState: integer;
Reg: TRegistry;
begin
{save checkbox states to registry:}
CheckBoxState:=0;
for i:=0 to ComponentCount-1 do
  if Components[i] is TCheckBox then
    if TCheckBox(Components[i]).Checked then
      CheckBoxState:=CheckBoxState or 1 shl Components[i].Tag;
Reg:=TRegistry.Create;
Reg.OpenKey('SOFTWARE\Steffen Gerlach\LCT',true);
Reg.WriteInteger('CheckBoxState',CheckBoxState);
Reg.CloseKey;
Reg.Free;
end;


procedure TMainForm.CFileBrowseClick(Sender: TObject);
begin
if OpenDialog1.Execute then
  CFileName.Lines.add(OpenDialog1.FileName)
end;


procedure TMainForm.COutputBrowseClick(Sender: TObject);
begin
if SaveDialog1.Execute then
  COutputName.Text:=SaveDialog1.FileName
end;


procedure TMainForm.CExtractionClick(Sender: TObject);
begin
SExtraction.TabVisible:=CExtraction.Checked
end;


end.

