{
 Program: LC.PAS
  Author: Eric E. A. Schreiber
    Date: April 11, 1998
Function: Count lines in file
}

program LC;

uses Dos;

const { * Typed constants * }
  FileLines  : LongInt = 0;    { * Number of lines in file     * }
  FilePages  : LongInt = 0;    { * Number of pages in file     * }
  TotalLines : LongInt = 0;    { * Number of lines total       * }
  TotalPages : LongInt = 0;    { * Number of pages total       * }
  FileCount  : Integer = 0;    { * Files matching mask         * }
  LF  = #13#10;                { * Carriage return & line feed * }
  HelpSet = ['?', '/', '-'];   { * Command line help char set  * }

var
  sFileSpec     : String;      { * File mask specified by user * }
  bTempFileMode : Byte;        { * Contain starting File Mode  * }

  { * Comma strings for longint output variables listed        * }
  sFileLines,                  { * String for File Line count  * }
  sTotalLines,                 { * String for Total Line count * }
  sTotalPages  : String[14];   { * String for Total Page count * }
  Buf          : Array [1..32766] of Char;      { * 32K buffer * }


{ **** Help/Info screen **** }
procedure HelpScreen;
begin

  Write('LC -- ASCII file line counter  ver 1.2' + LF +
        '      Copyright (c) 1992, 1998 by Eric Schreiber.' + LF +
        '      All rights reserved.' + LF);
  Write(#10 + 'Usage:' + LF +
        '      LC [filename]' + LF +
        '      Where [filename] is the filename that you want to' + LF +
        '      count the lines in.  Wildcards (*.* & ?) are ok.' + LF +
        '      The Pages value assumes 60 lines per page.' + LF);
  Halt;

end;


{ **** Comma string from any integer **** }
function IntToCommaStr (N : Longint) : String;
var
  W: String[14];
  I: Byte;
  D: Byte;

begin

  Str(N,W);
  D := Length(W);
  for I := 3 to (D-1) do
    if I mod 3 = 0
    then Insert(',',W,(D-I+1));
  IntToCommaStr := W;

end;


{ **** Convert string to uppercase **** }
function UpperCase (S: String): String;
var
  I : Integer;

begin

  for I := 1 to Length(S) do
    S[I] := UpCase(S[I]);
  UpperCase := S;

end;


{ **** Main procedure - find/counts files of specified mask **** }
procedure SearchFiles (FileSpec: String);
var
  FInfo   : Searchrec;
  F       : Text;
  TempStr,
  Name    : String;
  Counter : Integer;

begin

  FileLines := 0;
  FindFirst (Filespec, AnyFile, FInfo);
  while DosError = 0 do
  begin

    Assign (F, FInfo.Name);
    SetTextBuf (F, Buf);
    {$I-} Reset (F); {$I+}
    if IOResult = 0 then
    begin

      Inc (FileCount);

      { ** Read/count LF's ** }
      while not EOF (F) do
      begin

        Readln (F);
        Inc (FileLines)

      end;

      Close (F);

      { ** Calculate Pages ** }
      FilePages := 0;
      FilePages := FileLines Div 60;

      if FileLines Mod 60 > 0
      then FilePages := FilePages +1;

      { ** Update totals   ** }
      TotalLines := TotalLines + FileLines;
      TotalPages := TotalPages + FilePages;

      { ** Pad name length to 12 chars ** }
      Name := FInfo.Name;
      if Length(Name) < 12 then
      begin

        TempStr := '';
        for Counter := 1 to (12 - Length (Name)) do
          TempStr := TempStr + ' ';
        Name := Name + TempStr;

      end;

      { ** Output line and page count  ** }
      sFileLines := IntToCommaStr (FileLines);
      if FileLines = 1 then
      begin

        Write ('File ', Name, ' contains ', sFileLines:5, ' line   ');
        if FilePages = 1
          then Writeln ('(', FilePages, ' page )')
          else Writeln ('(', FilePages, ' pages)');

      end
      else
      begin

        Write ('File ', Name, ' contains ', sFileLines:5, ' lines  ');
        if FilePages = 1
          then Writeln ('(', FilePages, ' page )')
          else Writeln ('(', FilePages, ' pages)');

      end;

    end;

    FileLines := 0;
    FindNext (FInfo);

  end;

end;


{ **** Grand totals output to screen **** }
procedure OutputTotals;
begin

  sTotalLines := IntToCommaStr (TotalLines);
  sTotalPages := IntToCommaStr (TotalPages);
  Writeln;
  Writeln ('    File mask: ', sFileSpec);
  Writeln ('  Files found: ', FileCount);
  Writeln ('  Total lines: ', sTotalLines);
  Writeln ('  Total pages: ', sTotalPages);

end;


{ **** Main Line **** }
begin

  Writeln;
  sFileSpec := UpperCase(ParamStr(1));   { * Set sFileSpec             * }

  if (sFileSpec[1] in HelpSet) or (ParamCount = 0)
  then HelpScreen;                       { * Show help screen          * }

  bTempFileMode := FileMode;             { * Store original FileMode   * }
  FileMode      := 0;                    { * Set read-only FileMode    * }
  SearchFiles (sFileSpec);               { * Main search routine       * }
  OutputTotals;                          { * Output totals to screen   * }
  FileMode := bTempFileMode;             { * Restore original FileMode * }

end.
