*+
*+
*+    Source Module => D:\SRC\GSR\GSR_UTIL.PRG
*+
*+    GSR is a Global Search and Replace engine.
*+    
*+    Copyright(C) 1990-1999 by Phil Barnett.
*+       
*+    This program is free software; you can redistribute it and/or modify it
*+    under the terms of the GNU General Public License as published by the
*+    Free Software Foundation; either version 2 of the License, or (at your
*+    option) any later version.
*+    
*+    This program is distributed in the hope that it will be useful, but
*+    WITHOUT ANY WARRANTY; without even the implied warranty of
*+    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*+    General Public License for more details.
*+    
*+    You should have received a copy of the GNU General Public License along
*+    with this program; if not, write to the Free Software Foundation, Inc.,
*+    675 Mass Ave, Cambridge, MA 02139, USA.
*+    
*+    You can contact me at:
*+    
*+    Phil Barnett
*+    Box 944
*+    Plymouth, Florida  32768
*+    
*+    or
*+    
*+    philb@iag.net
*+
*+    Functions: Function ALLKEY()
*+               Function PUSH_ALL()
*+               Function POP_ALL()
*+               Function PUSHDBF()
*+               Function POPDBF()
*+               Function DRAWBOX()
*+               Function SHAD_BOX()
*+               Function message()
*+               Procedure POP_MSG()
*+               Procedure CLR_MSG()
*+               Procedure ATTENTION()
*+               Procedure CNT()
*+               Function c()
*+               Function Amaxstrlen()
*+               Function VERIFY()
*+               Function ASK_FOR()
*+               Function FULLDATE()
*+               Function SCOLORS()
*+               Function MYCOLOR()
*+               Function SAVESETS()
*+               Function RESTSETS()
*+               Function PUTSCREEN()
*+               Function GETSCREEN()
*+               Function RANDOMIZE()
*+               Function random()
*+               Procedure SCRNBLNK()
*+               Function cls()
*+
*+    Reformatted by Click! 2.01 on Jan-9-1999 at  2:05 am
*+
*+

#include "COMMON.CH"
#include "BOX.CH"
#include "SET.CH"
//#include "PRBFUNC5.CH"

static THISSCRN
static TL
static BOXHIGH
static SCR      := {}
static CNT      := 0
static seed     := - 1

static HAD_FILE   := {}
static STAK_POINT := 0
static DBFSTACK   := {}
static SETSTACK   := {}

static c := { 'GR+/B,R/W,,,W+/N', ;     //  1 Main Background & foreground
              'W+/R,GR+/B,,,W+/N', ;    //  2 Editing & deleting Background & foreground
              'W+/RB', ;                //  3 Warning Background for C[2
              'BG/B', ;                 //  4
              'W+/RB', ;                //  5 Copyright Color
              'GR+/R', ;                //  6 Warning & message color for C[1
              'BG+/B', ;                //  7 Title in TITLEBOX.PRG
              'N/W', ;                  //  8 Paper for Calculator
              'R/W', ;                  //  9 Negative for calculator
              'B/N', ;                  // 10 Shadow
              'GR+/GR,W+/B,,,W+/N', ;   // 11 Active message
              'G+/GR,GR+/R,,,W/N', ;    // 12 Active menu
              'N/BG', ;                 // 13 Black on cyan for HELP
              'N/BG', ;                 // 14 foreground for HELP
              'G+/BG', ;                // 15 border for HELP
              'GR+*/R', ;               // 16 Flashing warning for C[1
              'GR+/GB', ;               // 17 Drop down Calculator
              'W+/N', ;                 // 18 Memo Display Colors
              'GR+*/GR', ;              // 19 Active message Flashing
              'W+*/B', ;                // 20
              'GR+/BG', ;               // 21
              'N/BG', ;                 // 22
              'GR+/B', ;                // 23
              'N/BG,R/W', ;             // 24
              'RB/W', ;                 // 25
              'N/W,W+/B', ;             // 26
              'GR+/RB', ;               // 27
              'GR+/RB,N/W', ;           // 28
              'R/B', ;                  // 29
              'G/B', ;                  // 30
              'GB+/G', ;                // 31
              'W+/R', ;                 // 32
              'W+/R,W+/B', ;            // 33
              'B+/W', ;                 // 34
              'N/W,W+/B', ;             // 35
              'GR+/GR,BG+/B,,,W+/N', ;  // 36
              'W/B,N/W,,,W/B', ;        // 37
              'W/N', ;                  // 38
              'W+/GR,W+/B', ;           // 39
              'W+/B' }                  // 40

*+
*+
*+    Function ALLKEY()
*+
*+    Called from ( getsys52.prg )   1 - procedure getreader()
*+                ( gsr.prg      )   1 - static function ok_2_write()
*+                                   1 - static function gsrhelp()
*+                ( gsr_util.prg )   1 - procedure scrnblnk()
*+
*+
*+
function ALLKEY( nWait )

local nKey     := 0
local nTimeOut
local bAction
local nLoopOut

if nextkey() <> 0 .or. nWait == NIL

   nKey := inkey()

elseif nWait <> 0 .and. seconds() > 86200 - nWait

   nKey := inkey( nWait )

else

   if nWait > 0
      nLoopOut := nWait + seconds()
   endif

   nTimeOut := seconds() + 180

   do while nKey == 0

      if nTimeOut < seconds()
         SCRNBLNK()
         nTimeOut := seconds() + 180
      endif

      if nWait > 0 .and. nLoopOut < seconds()
         exit
      endif

      nKey := inkey()
      ol_yield()

   enddo

endif

if ( bAction := setkey( nKey ) ) <> NIL
   eval( bAction, procname( 1 ), procline( 1 ), readvar() )
   if empty( nextkey() )
      keyboard chr( 255 )
      inkey()
      nKey := 0
   endif
endif

return nKey

*+
*+
*+    Function PUSH_ALL()
*+
*+    Called from ( gsr.prg      )   1 - static function gsrhelp()
*+
*+
*+
function PUSH_ALL()

aadd( HAD_FILE, used() )

if HAD_FILE[ ++ stak_point ]
   PUSHDBF()
endif

SAVESETS()

PUTSCREEN()

return NIL

*+
*+
*+    Function POP_ALL()
*+
*+    Called from ( gsr.prg      )   1 - static function gsrhelp()
*+
*+
*+
function POP_ALL()

if STAK_POINT > 0

   if HAD_FILE[ stak_point ]
      POPDBF()
   endif

   STAK_POINT --
   asize( HAD_FILE, STAK_POINT )

   RESTSETS()

   GETSCREEN()

endif

return NIL

*+
*+
*+    Function PUSHDBF()
*+
*+    Called from ( gsr_util.prg )   1 - function push_all()
*+
*+
*+
function PUSHDBF( CALIAS )

if CALIAS <> NIL
   select select( CALIAS )
endif

aadd( DBFSTACK, { select(), indexord(), recno(), dbfilter() } )

return NIL

*+
*+
*+    Function POPDBF()
*+
*+    Called from ( gsr_util.prg )   1 - function pop_all()
*+
*+
*+
function POPDBF( NCOUNT )

local i
local NSIZE := len( DBFSTACK )

default NCOUNT to 1

for i := 1 to NCOUNT
   if !empty( DBFSTACK[ nSize, 1 ] )
      select( DBFSTACK[ nSize, 1 ] )
      dbsetorder( DBFSTACK[ nSize, 2 ] )
      dbgoto( DBFSTACK[ nSize, 3 ] )
      if !empty( DBFSTACK[ nSize, 4 ] )
         dbsetfilter( DBFSTACK[ nSize, 4 ] )
      endif
   endif
   asize( DBFSTACK, -- NSIZE )
next

return NIL

*+
*+
*+    Function DRAWBOX()
*+
*+    Called from ( gsr.prg      )   1 - static function gsrhelp()
*+                ( gsr_util.prg )   1 - function message()
*+
*+
*+
function DRAWBOX( MTOP, MBOTTOM, STR_LEN, WANT_SHADE, BORDCOLOR, CENTERCOLOR, XWRAP, EXPLODE )

local Z

memvar n

if ischar( str_len )
   str_len := len( str_len )
endif

MTOP --
MBOTTOM ++

n := max( 40 - int( str_len / 2 ), 0 )
Z := n + str_len + 1

if MTOP < 2 .or. MBOTTOM > 22 .or. n < 5 .or. Z > 76
   WANT_SHADE := .f.
endif

return SHAD_BOX( MTOP, MBOTTOM, n, Z, WANT_SHADE, BORDCOLOR, CENTERCOLOR, XWRAP, EXPLODE )

*+
*+
*+    Function SHAD_BOX()
*+
*+    Called from ( gsr_util.prg )   1 - function drawbox()
*+
*+
*+
function SHAD_BOX( MTOP, MBOTTOM, n, Z, WANT_SHADE, BORDCOLOR, CENTERCOLOR, XWRAP, EXPLODE )

local HOUR
local STOP
local SLEFT
local SBOT
local SRIGHT
local FINISHED
local STIME

default WANT_SHADE to .t.
default BORDCOLOR to 12
default CENTERCOLOR to 11
default XWRAP to .f.
default EXPLODE to !( 'NO' $ upper( gete( 'EXPLODE' ) ) )

if XWRAP .and. WANT_SHADE
   SHADE_IT( MTOP - 1, n - 5, MBOTTOM + 1, Z + 3 )
endif

if EXPLODE

   STOP     := MBOTTOM - int( ( MBOTTOM - MTOP ) / 2 )
   SLEFT    := Z - int( ( Z - n ) / 2 )
   SBOT     := STOP
   SRIGHT   := SLEFT
   FINISHED := .f.

   do while !FINISHED
      FINISHED := .t.

      MYCOLOR( CENTERCOLOR )
      @ STOP, SLEFT clear to SBOT, SRIGHT
      MYCOLOR( BORDCOLOR )
      @ STOP, SLEFT + 1 to SBOT, SRIGHT - 1

      do case
      case STOP >= MTOP + 2
         STOP     -= 2
         FINISHED := .f.
      case STOP > MTOP
         STOP := MTOP
      endcase

      do case
      case SBOT <= MBOTTOM - 2
         SBOT     += 2
         FINISHED := .f.
      case SBOT < MBOTTOM
         SBOT := MBOTTOM
      endcase

      do case
      case SLEFT >= ( n - 3 ) + 5
         SLEFT    -= 2
         FINISHED := .f.
      case SLEFT > n - 3
         SLEFT := n - 3
      endcase

      do case
      case SRIGHT <= ( Z + 1 ) - 5
         SRIGHT   += 2
         FINISHED := .f.
      case SRIGHT < Z + 1
         SRIGHT := Z + 1
      endcase

   enddo

   MYCOLOR( CENTERCOLOR )
   @ STOP, SLEFT clear to SBOT, SRIGHT
   MYCOLOR( BORDCOLOR )
   @ STOP, SLEFT + 1 to SBOT, SRIGHT - 1

else
   MYCOLOR( CENTERCOLOR )
   @ MTOP, n - 3 clear to MBOTTOM, Z + 1
   MYCOLOR( BORDCOLOR )
   @ MTOP, n - 2 to MBOTTOM, Z
endif

if !XWRAP .and. WANT_SHADE

   HOUR := val( left( time(), 2 ) )

   if HOUR > 11
      HOUR -= 12
   endif

   do case
   case HOUR < 4
      do case
      case HOUR = 0
         SHADE_IT( MTOP - 1, n - 3, MTOP - 1, Z + 1 )
      case HOUR = 1
         SHADE_IT( MTOP - 1, n - 2, MTOP - 1, Z + 2 )
         SHADE_IT( MTOP - 1, Z + 2, MBOTTOM - 1, Z + 2 )
      case HOUR = 2
         SHADE_IT( MTOP - 1, n - 1, MTOP - 1, Z + 3 )
         SHADE_IT( MTOP - 1, Z + 2, MBOTTOM - 1, Z + 3 )
      case HOUR = 3
         SHADE_IT( MTOP, Z + 2, MBOTTOM, Z + 3 )
      endcase
   case HOUR < 8
      do case
      case HOUR = 4
         SHADE_IT( MTOP + 1, Z + 2, MBOTTOM + 1, Z + 3 )
         SHADE_IT( MBOTTOM + 1, n - 1, MBOTTOM + 1, Z + 3 )
      case HOUR = 5
         SHADE_IT( MTOP + 1, Z + 2, MBOTTOM + 1, Z + 2 )
         SHADE_IT( MBOTTOM + 1, n - 2, MBOTTOM + 1, Z + 1 )
      case HOUR = 6
         SHADE_IT( MBOTTOM + 1, n - 3, MBOTTOM + 1, Z + 1 )
      case HOUR = 7
         SHADE_IT( MTOP + 1, n - 4, MBOTTOM + 1, n - 4 )
         SHADE_IT( MBOTTOM + 1, n - 4, MBOTTOM + 1, Z )
      endcase
   otherwise
      do case
      case HOUR = 8
         SHADE_IT( MTOP + 1, n - 5, MBOTTOM + 1, n - 4 )
         SHADE_IT( MBOTTOM + 1, n - 5, MBOTTOM + 1, Z - 1 )
      case HOUR = 9
         SHADE_IT( MTOP, n - 5, MBOTTOM, n - 4 )
      case HOUR = 10
         SHADE_IT( MTOP - 1, n - 5, MTOP - 1, Z - 1 )
         SHADE_IT( MTOP - 1, n - 5, MBOTTOM - 1, n - 4 )
      case HOUR = 11
         SHADE_IT( MTOP - 1, n - 4, MTOP - 1, Z )
         SHADE_IT( MTOP - 1, n - 4, MBOTTOM - 1, n - 4 )
      endcase
   endcase
endif

MYCOLOR( CENTERCOLOR )

return n

*+
*+
*+    Function message()
*+
*+    Called from ( gsr.prg      )   1 - static function process()
*+
*+
*+
function message( STRING, LINE_NUM )

if !ischaracter( STRING )
   STRING := space( if( isnumber( STRING ), STRING, 50 ) )
endif

DRAWBOX( LINE_NUM, LINE_NUM, STRING )
CNT( STRING, LINE_NUM )
MYCOLOR( 1 )

return c( STRING )

*+
*+
*+    Procedure POP_MSG()
*+
*+    Called from ( gsr.prg      )   6 - function gsr()
*+                                   1 - static function process()
*+                                   1 - static function chk_esc()
*+                ( gsr_util.prg )   1 - function verify()
*+                                   1 - function ask_for()
*+
*+
*+
procedure POP_MSG( SOME_TXT, MSG_LOGIC, BORDCOLOR, MAINCOLOR )

local MAXLEN
local x
local ARLEN
local INCOLOR
local CROW
local CCOL
local LC

default MSG_LOGIC to .t.

default BORDCOLOR to 'B+/W'
default MAINCOLOR to 'N/W,W+/B'

if !isarray( SOME_TXT )
   SOME_TXT := { SOME_TXT }
endif

ARLEN := len( SOME_TXT )

TL := ( maxrow() / 2 ) - ( ( ARLEN / 2 ) + 2 )

MAXLEN := min( maxcol() - 4, max( Amaxstrlen( SOME_TXT ), 25 ) + 6 )

BOXHIGH  := ARLEN + 2
THISSCRN := savescreen( TL - 2, 0, BOXHIGH + TL + 1, maxcol() )
CROW     := row()
CCOL     := col()

LC := int( ( maxcol() - MAXLEN ) / 2 )

dispbox( TL - 1, LC, BOXHIGH + TL, LC + MAXLEN - 1, B_DOUBLE_SINGLE + ' ', BORDCOLOR )

dispbegin()

INCOLOR := setcolor( MAINCOLOR )

for x := 1 to ARLEN
   CNT( SOME_TXT[ x ], TL + x )
next

dispend()

if MSG_LOGIC
   ATTENTION( 'Press any key to continue', BOXHIGH + TL )
   inkey( 0 )
   restscreen( TL - 2, 0, BOXHIGH + TL + 1, 79, THISSCRN )
   THISSCRN := ''
   devpos( CROW, CCOL )
endif

setcolor( INCOLOR )

return

*+
*+
*+    Procedure CLR_MSG()
*+
*+    Called from ( gsr_util.prg )   1 - function verify()
*+                                   1 - function ask_for()
*+
*+
*+
procedure CLR_MSG()

restscreen( TL - 2, 0, BOXHIGH + TL + 1, 79, THISSCRN )

THISSCRN := ''

return

*+
*+
*+    Procedure ATTENTION()
*+
*+    Called from ( gsr.prg      )   5 - function gsr()
*+                                   6 - static function process()
*+                                   1 - static function look_in()
*+                                   1 - static function ok_2_write()
*+                                   4 - static function gsrhelp()
*+                ( gsr_util.prg )   1 - procedure pop_msg()
*+
*+
*+
procedure ATTENTION( CSTRING, NLINENUM, CCOLOR )

local COLDCOLOR

default NLINENUM to 24
default CCOLOR to 'GR+/R'

COLDCOLOR := setcolor( CCOLOR )

CSTRING := '  ' + alltrim( CSTRING ) + '  '

devpos( NLINENUM, c( CSTRING ) )

devout( CSTRING )

setcolor( COLDCOLOR )

return

*+
*+
*+    Procedure CNT()
*+
*+    Called from ( gsr.prg      )   6 - function gsr()
*+                                   1 - static function look_in()
*+                                  11 - static function gsrhelp()
*+                                   2 - static function togglesrch()
*+                                   2 - static function togglerepl()
*+                ( gsr_util.prg )   1 - function message()
*+                                   1 - procedure pop_msg()
*+
*+
*+
procedure CNT( CSTRING, NLINENUM )

devpos( NLINENUM, c( CSTRING ) )

devout( CSTRING )

return

*+
*+
*+    Function c()
*+
*+    Called from ( gsr_util.prg )   1 - function message()
*+                                   1 - procedure attention()
*+                                   1 - procedure cnt()
*+                                   2 - function ask_for()
*+
*+
*+
function c( CSTRING )

return max( ( maxcol() / 2 ) - int( len( CSTRING ) / 2 ), 0 )

*+
*+
*+    Function Amaxstrlen()
*+
*+    Called from ( gsr_util.prg )   1 - procedure pop_msg()
*+
*+
*+
function Amaxstrlen( ANARRAY )

local ARLEN
local THISLEN
local max     := 0
local x

if isarray( ANARRAY )

   ARLEN := len( ANARRAY )

   for x := 1 to ARLEN
      THISLEN := len( ANARRAY[ X ] )
      if THISLEN > max
         max := THISLEN
      endif
   next

endif

return max

*+
*+
*+    Function VERIFY()
*+
*+    Called from ( gsr.prg      )   2 - function gsr()
*+                                   1 - static function process()
*+
*+
*+
function VERIFY( SOME_TXT, LNORMANS, YES_PRMPT, NO_PRMPT, BORDCOLOR, MAINCOLOR )

local INCOLOR
local VERI
local ARLEN

default BORDCOLOR to 'W+/R'
default MAINCOLOR to 'W+/R,W+/B'

LNORMANS  := iif( islogic( LNORMANS ), LNORMANS, .t. )
YES_PRMPT := iif( YES_PRMPT = NIL, ' YES ', ' ' + alltrim( YES_PRMPT ) + ' ' )
NO_PRMPT  := iif( NO_PRMPT = NIL, ' NO ', ' ' + alltrim( NO_PRMPT ) + ' ' )

if !isarray( SOME_TXT )
   SOME_TXT := { SOME_TXT }
endif

ARLEN := len( SOME_TXT ) + 2

asize( SOME_TXT, ARLEN )

SOME_TXT[ ARLEN - 1 ] := ''
SOME_TXT[ ARLEN ]     := ''

POP_MSG( SOME_TXT, .f., BORDCOLOR, MAINCOLOR )

VERI := iif( LNORMANS, 1, 2 )

INCOLOR := setcolor( MAINCOLOR )
@ TL - 2 + BOXHIGH, 33 - ( len( YES_PRMPT ) / 2 ) prompt YES_PRMPT
@ TL - 2 + BOXHIGH, 46 - ( len( NO_PRMPT ) / 2 ) prompt NO_PRMPT

menu to VERI

clr_msg()

setcolor( INCOLOR )

return ( VERI == 1 )

*+
*+
*+    Function ASK_FOR()
*+
*+
*+
function ASK_FOR( SOME_TXT, Getvar, PICVAR, BORDCOLOR, MAINCOLOR )

local GETLIST := {}

local INCOLOR  := setcolor()
local INCURSOR := set( _SET_CURSOR )
local ARLEN
local VCNT
local RETVAL
local CROW     := row()
local CCOL     := col()

default BORDCOLOR to 'G+/GR'
default MAINCOLOR to 'GR+/GR,W+/B,,,W+/N'

if !isarray( SOME_TXT )
   SOME_TXT := { SOME_TXT }
endif

ARLEN := len( SOME_TXT ) + 2

asize( SOME_TXT, ARLEN )

do case
case ischaracter( Getvar )
   VCNT := c( Getvar )
case isdate( Getvar )
   VCNT := 35
case isnumber( Getvar )
   VCNT := c( PICVAR )
otherwise
   VCNT := maxcol() / 2
endcase

SOME_TXT[ ARLEN - 1 ] := ''
SOME_TXT[ ARLEN ]     := space( ( ( maxcol() / 2 ) - VCNT ) * 2 )

POP_MSG( SOME_TXT, .f., BORDCOLOR, MAINCOLOR )

setcolor( MAINCOLOR )

if isdate( Getvar )
   @ TL + BOXHIGH - 2, VCNT get Getvar         
else
   @ TL + BOXHIGH - 2, VCNT get Getvar picture PICVAR        
endif

set cursor ( .t. )
read
set( _SET_CURSOR, INCURSOR )

clr_msg()

RETVAL := Getvar

if ischaracter( Getvar )
   Getvar := alltrim( Getvar )
endif

setcolor( INCOLOR )
devpos( CROW, CCOL )

return RETVAL

*+
*+
*+    Function FULLDATE()
*+
*+
*+
function FULLDATE( ANYDATE )

default ANYDATE to date()

return cmonth( ANYDATE ) + ' ' + ltrim( str( day( ANYDATE ), 2 ) ) + ', ' + str( year( ANYDATE ), 4 )

#define NUM_COLORS_AVAILABLE 40

*+
*+
*+    Function SCOLORS()
*+
*+    Called from ( gsr.prg      )   1 - function gsr()
*+
*+
*+
function SCOLORS( MONOCHROME )

default MONOCHROME to !iscolor()

if MONOCHROME
   afill( c, '' )
   //   C[4] := 'W/N'
   c[ 5 ]  := 'n/w'
   c[ 6 ]  := 'n/w'
   c[ 16 ] := 'w+*/n'
   c[ 19 ] := 'w+*/n'
   c[ 20 ] := 'w+*/n'
   c[ 36 ] := 'w+/n'
   c[ 37 ] := 'N/W'
   c[ 38 ] := 'N/W'
   c[ 39 ] := 'N/W'
   c[ 40 ] := 'N/W'
   setcursor( 3 )
endif

return NIL

*+
*+
*+    Function MYCOLOR()
*+
*+    Called from ( gsr.prg      )   2 - static function look_in()
*+                ( gsr_util.prg )   7 - function shad_box()
*+                                   1 - function message()
*+                                   1 - function cls()
*+
*+
*+
function MYCOLOR( WHICHONE )

return setcolor( c[ WHICHONE ] )

/*
*+
*+
*+    Function SETMYCOLOR()
*+
*+
*+
function SETMYCOLOR( WHICHCOLOR, NEWCOLOR )

local OLDCOLOR := ''

if WHICHCOLOR > 0 .and. WHICHCOLOR <= NUM_COLORS_AVAILABLE
   OLDCOLOR        := c[ WHICHCOLOR ]
   c[ WHICHCOLOR ] := NEWCOLOR
endif

return OLDCOLOR
*/

*+
*+
*+    Function SAVESETS()
*+
*+    Called from ( gsr_util.prg )   1 - function push_all()
*+
*+
*+
function SAVESETS()

local i
local SETTINGS := {}

asize( SETTINGS, _SET_COUNT )

for i := 1 to _SET_COUNT
   SETTINGS[ i ] := set( i )
next

aadd( SETSTACK, SETTINGS )

return NIL

*+
*+
*+    Function RESTSETS()
*+
*+    Called from ( gsr_util.prg )   1 - function pop_all()
*+
*+
*+
function RESTSETS()

local i
local SETTINGS
local ELE      := len( SETSTACK )

if ELE > 0
   SETTINGS := SETSTACK[ ELE ]
   for i := 1 to _SET_COUNT
      set( i, SETTINGS[ i ] )
   next i
   asize( SETSTACK, ELE - 1 )
endif

return NIL

*+
*+
*+    Function PUTSCREEN()
*+
*+    Called from ( gsr.prg      )   1 - function gsr()
*+                ( gsr_util.prg )   1 - function push_all()
*+
*+
*+
function PUTSCREEN( T, L, b, r )

default T to 0
default L to 0
default b to maxrow()
default r to maxcol()

aadd( SCR, { T, L, b, r, savescreen( T, L, b, r ), row(), col(), setcolor(), set( _SET_CURSOR ) } )
CNT ++

return NIL

*+
*+
*+    Function GETSCREEN()
*+
*+    Called from ( gsr.prg      )   2 - function gsr()
*+                ( gsr_util.prg )   1 - function pop_all()
*+
*+
*+
function GETSCREEN( OPTION )

default OPTION to 1

do case
case OPTION == 0
   CNT := 0
   SCR := {}
case OPTION == - 1
   asize( SCR, -- CNT )
otherwise
   if CNT > 0
      restscreen( SCR[ cnt, 1 ], SCR[ cnt, 2 ], SCR[ cnt, 3 ], SCR[ cnt, 4 ], SCR[ cnt, 5 ] )
      devpos( SCR[ cnt, 6 ], SCR[ cnt, 7 ] )
      setcolor( SCR[ cnt, 8 ] )
      set( _SET_CURSOR, SCR[ cnt, 9 ] )
      asize( SCR, -- CNT )
   endif
endcase

return NIL

*+
*+
*+    Function RANDOMIZE()
*+
*+    Called from ( gsr_util.prg )   2 - procedure scrnblnk()
*+
*+
*+
function RANDOMIZE( nLimit )

// returns a random number between 1 and nLimit, inclusive
return int( random() * nLimit ) + 1

*+
*+
*+    Function random()
*+
*+    Called from ( gsr_util.prg )   1 - function randomize()
*+
*+
*+
function random()

local p := 335544319
local x := ( 2 ^ 31 ) - 1
local y := x / p
local z := x % p

if seed == - 1
   seed := ( seconds() * day( date() ) * month( date() ) * year( date() ) ) % x
endif

seed := abs( p * ( seed % y ) - z * ( seed / y ) ) % x

return ( seed - 1 ) / ( x - 2 )

*+
*+
*+    Procedure SCRNBLNK()
*+
*+    Called from ( gsr_util.prg )   1 - function allkey()
*+
*+
*+
procedure SCRNBLNK()

local nKey     := 0
local cMessage
local nTotLen
local nRow     := row()
local nCol     := col()
local maxr     := maxrow()
local maxc     := maxcol()
local incolor  := setcolor()
local inscreen := savescreen( 0, 0, maxr, maxc )

set color to

do while empty( nKey )
   clear screen
   cMessage := 'Screen Saver Active. Press a Key'
   nTotLen  := len( cMessage )
   nRow     := randomize( 65535 ) % ( maxr - 2 )
   nCol     := randomize( 65535 ) % ( maxc - ( nTotLen + 3 ) )
   dispbox( nRow, nCol, nRow + 2, nCol + nTotLen + 3 )
   @ nRow + 1, nCol + 2 say cMessage         
   nKey := allkey( 15 )
enddo

restscreen( 0, 0, maxr, maxc, inscreen )

setcolor( incolor )

setpos( nRow, nCol )

return

*+
*+
*+    Function cls()
*+
*+    Called from ( gsr.prg      )   2 - function gsr()
*+                                   3 - static function process()
*+
*+
*+
function cls( NEWCOLOR, BKGCHR )

default NEWCOLOR to 1
default BKGCHR to 32

MYCOLOR( NEWCOLOR )

@  0,  0, maxrow(), maxcol() box replicate( chr( BKGCHR ), 9 )

return NIL

*+ EOF: GSR_UTIL.PRG
