*+
*+
*+    Source Module => D:\SRC\GSR\GSR.PRG
*+
*+    GSR is a Global Search and Replace engine.
*+    
*+    Copyright(C) 1990-1999 by Phil Barnett.
*+       
*+    This program is free software; you can redistribute it and/or modify it
*+    under the terms of the GNU General Public License as published by the
*+    Free Software Foundation; either version 2 of the License, or (at your
*+    option) any later version.
*+    
*+    This program is distributed in the hope that it will be useful, but
*+    WITHOUT ANY WARRANTY; without even the implied warranty of
*+    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*+    General Public License for more details.
*+    
*+    You should have received a copy of the GNU General Public License along
*+    with this program; if not, write to the Free Software Foundation, Inc.,
*+    675 Mass Ave, Cambridge, MA 02139, USA.
*+    
*+    You can contact me at:
*+    
*+    Phil Barnett
*+    Box 944
*+    Plymouth, Florida  32768
*+    
*+    or
*+    
*+    philb@iag.net
*+
*+    Functions: Function gsr()
*+               Static Function treewalk()
*+               Static Function process()
*+               Static Function look_in()
*+               Static Function ok_2_write()
*+               Static Function gsrhelp()
*+               Static Function gettmpfile()
*+               Static Function chk_esc()
*+               Static Function togglesrch()
*+               Static Function togglerepl()
*+
*+       Tables: use gsravoid
*+               use
*+
*+    Reformatted by Click! 2.01 on Jan-9-1999 at  2:04 am
*+
*+

#include "COMMON.CH"
#include "PRBFUNC5.CH"
#include "DIRECTRY.CH"
#include "INKEY.CH"

static Copyright   := "Copyright 1990-99 Phil Barnett.  All Rights Reserved Worldwide."
static lookfor
static looklen
static repwith
static replen
static casesense
static occurrence
static changecount
static avoid       := { ".COM", ".EXE", ".DBF", ".DBT", ".NTX", ".NDX", ".OVL", ".LIB", ".OBJ", ".MEM", ".SYS", ".ZIP", ".ARC", ".PAK", ".IDX", ".MDX", ".DBV", ".LZH", ".CDX", ".FPT", ".ARJ" }
static this_file
static automatic
static subsearch
static file_spec
static title
static origlook
static origrepl
static howmany
static sFileMode   := .f.
static rFileMode   := .f.

*+
*+
*+    Function gsr()
*+
*+
*+
function gsr()

local allparms
local batch_mode
local msg        := {}
local clr        := {}
local getlist    := {}
local _fat
local _lat
local _rat
local _sat
local _cat

local origdir := dirname()

putscreen()

// This makes the colors look correct under WIN95 and NT
clear screen
setmode( 25, 40 )
setmode( 25, 40 )
setmode( 25, 80 )
setmode( 25, 80 )

ol_autoyield( .t. )

if ISCGA( .t. )
   nosnow( .t. )
endif

allparms := dosparam()

allparms := strtran( allparms, ' /f', ' /F' )
allparms := strtran( allparms, ' /l', ' /L' )
allparms := strtran( allparms, ' /r', ' /R' )
allparms := strtran( allparms, ' /s', ' /S' )
allparms := strtran( allparms, ' /c', ' /C' )
allparms := strtran( allparms, ' /w', ' /W' )

batch_mode := '/F' $ allparms .and. '/L' $ allparms .and. '/R' $ allparms

Scolors( "MONO" $ upper( allparms ) .or. "MONO" $ upper( gete( "MONITOR" ) ) )

if '/?' $ allparms
   clear screen
   ? 'Batch Mode Specifications:'
   ?
   ? 'GSR /F<filespec> /L<lookfor> /R<repwith> [/S<Y/N>] [/C<Y/N>]'
   ?
   ? '    /S = Recurse Subdirectories (defaults to N)'
   ? '    /C = Case sensitive         (defaults to N)'
   ?
   ? 'Example:  (Parameters must be in /F /L /R [/S] [/C] order)'
   ?
   ? 'GSR /F*.PRG /LXXyyXX /R123123 /SY /CN'
   ?
   ? '    Replace all occurrances of XXyyXX with 123123 in *.PRG'
   ?
   ? '    Not Case sensitive.'
   ?
   ? '    Include subdirectories in GSR search.'
   ?
   ? 'Batch Mode is always Automatic Replacement.'
   ?
   quit
endif

if batch_mode

   _fat := at( '/F', allparms )
   _lat := at( '/L', allparms )
   _rat := at( '/R', allparms )
   _sat := at( '/S', allparms )
   _cat := at( '/C', allparms )

   if _fat > _lat .or. _lat > _rat
      Pop_msg( 'Parameter List in wrong order' )
      quit
   endif

   subsearch := if( _sat > 0, '/SY' $ upper( allparms ), .F. )

   casesense := if( _cat > 0, '/CY' $ upper( allparms ), .F. )

   file_spec := substr( allparms, _fat + 2, ( _lat - _fat ) - 2 )

   lookfor := alltrim( substr( allparms, _lat + 2, ( _rat - _lat ) - 2 ) )

   do case
   case casesense .and. subsearch
      if _cat < _sat
         repwith := substr( allparms, _rat + 2, ( _cat - _rat ) - 2 )
      else
         repwith := substr( allparms, _rat + 2, ( _sat - _rat ) - 2 )
      endif
   case casesense
      repwith := substr( allparms, _rat + 2, ( _cat - _rat ) - 2 )
   case subsearch
      repwith := substr( allparms, _rat + 2, ( _sat - _rat ) - 2 )
   otherwise
      repwith := substr( allparms, _rat + 2 )
   endcase

   repwith := alltrim( repwith )

   automatic := .t.

   if left( lookfor, 1 ) == '@' .and. file( substr( lookfor, 2 ) )
      sFileMode := .t.
      lookfor   := substr( lookfor, 2 )
   endif

   if left( repwith, 1 ) == '@' .and. file( substr( repwith, 2 ) )
      rFileMode := .t.
      repwith   := substr( repwith, 2 )
   endif

else

   file_spec := space( 12 )
   lookfor   := ''
   repwith   := ''
   casesense := .F.
   automatic := .f.
   subsearch := .f.

endif

occurrence := 0

asize( msg, 13 )
asize( clr, 13 )
afill( clr, 6 )
msg[ 2 ]  := replicate( chr( 196 ), 30 )
msg[ 3 ]  := "Search String:"
clr[ 4 ]  := 22
msg[ 5 ]  := replicate( chr( 196 ), 30 )
msg[ 6 ]  := "Replacement String:"
clr[ 7 ]  := 22
msg[ 8 ]  := replicate( chr( 196 ), 30 )
clr[ 9 ]  := 22
msg[ 10 ] := replicate( chr( 196 ), 30 )
clr[ 11 ] := 22
msg[ 12 ] := replicate( chr( 196 ), 30 )
clr[ 13 ] := 22

set key 28 to gsrhelp
set key K_F2 to togglesrch()
set key K_F3 to togglerepl()

do while .T.
   dirchange( origdir )
   begin sequence
      set( 27, .T. )
      set( 32, .F. )
      cls()
      dispbox( 0, 0, maxrow() - 1, maxcol() )
      TITLE := "Global Search and Replace  v1.84"
      Attention( TITLE, 0 )
      if !batch_mode

         file_spec := pad( file_spec, 12 )
         lookfor   := pad( lookfor, 76 )
         repwith   := pad( repwith, 76 )
         automatic := 'M'

         clear gets
         set confirm ( .T. )

         CNT( "File Spec to Include", 3 )
         @  4, 33 get file_spec picture '@K!'        

         if sFileMode
            CNT( "Enter a filename. The contents will be used as Search data", 6 )
         else
            @  6,  3 clear to 6, 76
            CNT( "Enter Text to Search for", 6 )
         endif
         @  7,  2 get lookfor picture '@K'        

         if rFileMode
            CNT( "Enter a filename. The contents will be used as Replace data", 9 )
         else
            @  9,  3 clear to 9, 76
            CNT( "Enter Text to Replace with", 9 )
         endif
         @ 10,  2 get repwith picture '@K'        

         lCNT( "(A)utomatic  or  (M)anual", 13 )
         @ 14, 19 get automatic picture "@!" valid automatic $ "AM"       

         rCNT( "Case Sensitive Search?", 13 )
         @ 14, 59 get casesense picture "Y"        

         cnt( "Include Subdirectories?", 16 )
         @ 17, 39 get subsearch picture "Y"        

         Attention( "<F1> = Help      <Esc> = Abort", 19 )
         attention( "<F2> Toggles Search Source    <F3> Toggles Replace Source", 21 )
         Attention( Copyright, 23 )

         set cursor ( .T. )
         read
         set cursor ( .F. )

         automatic := ( automatic == 'A' )

      endif

      if lastkey() = 27 .or. empty( file_spec ) .or. empty( lookfor )
         if Verify( "Quit GSR and return to DOS?", .T., 'Quit', 'Continue' )
            erase( '$temp.$$$' )
            getscreen()
            quit
         else
            break
         endif
      endif

      if lookfor == repwith
         Pop_msg( "Both strings are identical. Nothing to do!" )
         break
      endif

      file_spec := alltrim( file_spec )
      lookfor   := trim( lookfor )
      repwith   := trim( repwith )
      origlook  := lookfor
      origrepl  := repwith

      if sFileMode
         if file( lookfor )
            lookfor := memoread( lookfor )
         else
            Pop_msg( "Aborted! " + lookfor + " does not exist!" )
            break
         endif
      endif

      if rFileMode
         if file( repwith )
            repwith := memoread( repwith )
         else
            Pop_msg( "Aborted! " + repwith + " does not exist!" )
            break
         endif
      endif

      looklen := len( lookfor )
      replen  := len( repwith )

      if !ok_2_write( file_spec )
         break
      endif

      cls()
      @  0,  0 to maxrow() - 1, maxcol()
      Attention( TITLE, 0 )
      msg[ 1 ]  := "FileSpec: " + file_spec
      msg[ 4 ]  := lookfor
      msg[ 7 ]  := repwith
      msg[ 9 ]  := '  ' + iif( subsearch, "Include Subdirectories", "Current Directory Only" ) + '  '
      msg[ 11 ] := '  ' + iif( automatic, "Automatic ", "Manual " ) + ' Mode  '
      msg[ 13 ] := '  ' + iif( casesense, '', 'Not ' ) + 'Case Sensitive  '
      if !batch_mode
         if !Verify( msg, .T., 'Confirm', 'Abort', clr )
            break
         endif
      endif

      if !casesense
         lookfor := upper( lookfor )
      endif

      // process current directory
      process( dirname() )

      if subsearch
         // and all of the subs
         if dirname() == '\'
            treewalk( '' )
         else
            treewalk( dirname() )
         endif
         dirchange( origdir )
      endif

      if batch_mode
         break
      endif

      if occurrence > 0
         Pop_msg( str( occurrence, 10 ) + " occurrences found in " + ltrim( trim( str( howmany, 10 ) ) ) + " files." )
      else
         Pop_msg( "No changes made" )
      endif
   end sequence
   if batch_mode
      exit
   endif
enddo

dirchange( origdir )

getscreen()

errorlevel( min( changecount, 250 ) )

return .T.

*+
*+
*+    Static Function treewalk()
*+
*+    Called from ( gsr.prg      )   2 - function gsr()
*+                                   1 - static function treewalk()
*+
*+
*+
static function treewalk( mpath )

local i
local arr := directory( mpath + '\*.*', 'D' )
local mn  := len( arr )

for i := 1 to mn
   if arr[ i, F_ATTR ] == 'D' .and. arr[ i, F_NAME ] <> '.'
      process( mpath + '\' + arr[ i, F_NAME ] )
      Treewalk( mpath + '\' + arr[ i, F_NAME ] )
   endif
next

return NIL

*+
*+
*+    Static Function process()
*+
*+    Called from ( gsr.prg      )   1 - function gsr()
*+                                   1 - static function treewalk()
*+
*+
*+
static function process( cPath )

local buff_size
local temp_file
local ifile
local ofile
local buffer
local num_read
local outstring
local strhowmany
local orig
local bak_name
local x
local file_name  := {}
local file_size  := {}

if dirchange( cPath ) == 0

   cls()
   Attention( TITLE, 0 )
   Attention( "Gathering Matching File Names. . .", 2 )
   howmany := adir( file_spec )
   asize( file_name, howmany )
   asize( file_size, howmany )
   Attention( ". . . . . Filling Arrays . . . . .", 2 )
   adir( file_spec, file_name, file_size )
   setcursor( 0 )
   occurrence := 0
   temp_file  := '$temp.$$$'
   buff_size  := 8192
   buffer     := space( buff_size )

   // ***********************************************
   //  Begin the multi file loop for this directory *
   // ***********************************************

   set confirm ( .F. )
   strhowmany := ltrim( trim( str( howmany, 3 ) ) )
   cls()
   for X := 1 to howmany
      if !automatic
         cls()
      endif
      attention( cPath, 0 )
      Attention( "Replacing " + origlook + " with " + origrepl + " in " + file_spec, 1 )
      chk_esc()
      if !automatic
         @  4,  0 clear to 4, maxcol()
      endif
      this_file := file_name[ x ]
      Attention( "File " + ltrim( trim( str( X, 3 ) ) ) + " of " + strhowmany, 3 )

      if automatic
         Message( 10, 7 )
      endif

      ifile := fopen( this_file )
      ofile := fcreate( temp_file )

      orig        := ''
      changecount := 0
      num_read    := buff_size

      do while num_read == buff_size
         num_read  := fread( ifile, @buffer, buff_size )
         orig      += left( buffer, num_read )
         outstring := look_in( @orig )

         if num_read == buff_size
            orig := right( outstring, looklen - 1 )
            fwrite( ofile, @outstring, ( len( outstring ) - looklen ) + 1 )
         else
            fwrite( ofile, @outstring, len( outstring ) )
         endif

      enddo

      fclose( ifile )
      fclose( ofile )

      if changecount > 0
         bak_name := gettmpfile( this_file )
         if automatic
            rename( this_file ) to ( bak_name )
            rename( temp_file ) to ( this_file )
         else
            if Verify( "Make Changes to " + this_file + " Permanent?", .T., 'Confirm', 'Abort' )
               rename( this_file ) to ( bak_name )
               rename( temp_file ) to ( this_file )
            else
               erase ( temp_file )
            endif
         endif
      else
         erase ( temp_file )
      endif

   next
else
   pop_msg( 'Unable to change directory to ' + cPath )
endif

return NIL

*+
*+
*+    Static Function look_in()
*+
*+    Called from ( gsr.prg      )   1 - static function process()
*+
*+
*+
static function look_in( orig )

local pointer
local pointers
local ctxt        := ''
local ctxtlen
local looktxt
local start_pnt
local changethis
local getlist     := {}
local end_pnt
local srch_string
local start_here

srch_string := iif( casesense, orig, upper( orig ) )

pointer := at( lookfor, srch_string )

if pointer < 1      // not in this piece
   // ctxt := orig
   return orig
endif

do while pointer > 0
   chk_esc()

   if automatic
      occurrence ++
      changecount ++
      srch_string := stuff( srch_string, pointer, looklen, repwith )
      orig        := stuff( orig, pointer, looklen, repwith )
      CNT( str( changecount, 10 ), 7 )
   else
      @  5,  0 say replicate( chr( 205 ), 80 )         
      Attention( this_file, 5 )
      @  6,  0 clear to maxrow(), maxcol()

      ctxtlen   := len( ctxt )
      looktxt   := ctxt + orig
      pointers  := contxt( looktxt, ctxtlen + pointer, looklen, 6, 22 )
      start_pnt := val( pointers )
      end_pnt   := val( substr( pointers, 5, 3 ) )
      ?? substr( looktxt, ( ctxtlen + pointer ) - ( start_pnt ), start_pnt )
      mycolor( 6 )
      ?? substr( looktxt, ctxtlen + pointer, looklen )
      mycolor( 1 )
      ?? substr( looktxt, ctxtlen + pointer + looklen, end_pnt )
      changethis := .f.
      @ maxrow() - 1, 0 say replicate( chr( 205 ), 80 )                                        
      @ maxrow(), 0     say "Replace this occurrence?  (Y/N)" get changethis picture 'Y'       
      set cursor ( .T. )
      read
      set cursor ( .F. )
      chk_esc()
      if changethis
         occurrence ++
         changecount ++
         srch_string := stuff( srch_string, pointer, looklen, repwith )
         orig        := stuff( orig, pointer, looklen, repwith )

         // This is definately experimental and new. If it breaks
         // remove it. It is an attempt to keep the S/R engine from
         // going into a loop when the lookfor is in the repwith.

         pointer += len( repwith )

      endif
   endif
   start_here := pointer + 1
   pointer    := ATNUM( lookfor, srch_string, 1, start_here )
enddo

// ctxt := orig

return orig

*+
*+
*+    Static Function ok_2_write()
*+
*+    Called from ( gsr.prg      )   1 - function gsr()
*+
*+
*+
static function ok_2_write( a_file_name )

local X
local mextension
local arlen
local ok         := .T.

if looklen <> replen
   if file( "GSRAVOID.DBF" )
      use gsravoid
      go top
      do while !eof()
         mextension := gsravoid->extension
         if upper( ltrim( trim( mextension ) ) ) $ a_file_name
            ok := .F.
         endif
         skip
      enddo
      use
   else
      arlen := len( avoid )
      for X := 1 to arlen
         if avoid[ x ] $ a_file_name
            ok := .F.
         endif
      next
   endif
   if !ok
      Attention( "Change NOT allowed. Read Help about GSRAVOID.DBF.", maxrow() - 1 )
      allkey( 0 )
   endif
endif

return ok

*+
*+
*+    Static Function gsrhelp()
*+
*+    Called from ( gsr.prg      )   1 - static function gsrhelp()
*+
*+
*+
static function gsrhelp

set key 28 to
set key K_F1 to
set key K_F2 to

push_all()

setcursor( 0 )

Drawbox( 2, 22, 66 )

Attention( "GSR Help", 1 )

CNT( "GSR is a program that will replace existing text", 3 )
CNT( "with replacement text across multiple files.", 4 )
CNT( "Function Keys F2 and F3 will allow you to read", 6 )
CNT( "the search or replace data from files.", 7 )
CNT( "GSR will process ANY size file.", 9 )

Attention( "GSR HAS THE POWER TO BENEFIT OR DESTROY!", 11 )
Attention( "ALWAYS MAKE A BACKUP FIRST, BEFORE YOU RUN GSR!", 12 )

CNT( "Your original files are renamed with a *.GS? extension.", 14 )

CNT( "Phil Barnett", 16 )
CNT( "philb@iag.net", 17 )
CNT( "Box 944", 18 )
CNT( "Plymouth, Fl 32768", 19 )
CNT( "407-884-5192", 20 )

Attention( Copyright, maxrow() - 1 )

allkey( 0 )

pop_all()

set key 28 to gsrhelp()
set key K_F2 to togglesrch()
set key K_F3 to togglerepl()

return .T.

*+
*+
*+    Static Function gettmpfile()
*+
*+    Called from ( gsr.prg      )   1 - static function process()
*+
*+
*+
static function gettmpfile( a_file_name )

local dot
local counter
local extension
local bak_name

dot     := at( ".", a_file_name )
counter := - 1
do while counter < 99
   if ++ counter == 0
      extension := ".GSR"
   else
      if counter < 10
         extension := ".GS" + str( counter, 1 )
      else
         extension := ".G" + str( counter, 2 )
      endif
   endif
   if dot = 0
      bak_name := alltrim( a_file_name ) + extension
   else
      bak_name := left( a_file_name, dot - 1 ) + extension
   endif
   if !file( bak_name )
      exit
   endif
enddo

return bak_name

*+
*+
*+    Static Function chk_esc()
*+
*+    Called from ( gsr.prg      )   1 - static function process()
*+                                   2 - static function look_in()
*+
*+
*+
static function chk_esc

if inkey() = 27 .or. lastkey() = 27
   Pop_msg( 'Aborting to Main Menu' )
   break
endif

return nil

*+
*+
*+    Static Function togglesrch()
*+
*+    Called from ( gsr.prg      )   1 - function gsr()
*+                                   1 - static function gsrhelp()
*+
*+
*+
static function togglesrch()

local crow := row()
local ccol := col()

sFileMode := !sFileMode

if sFileMode
   CNT( "Enter a filename. The contents will be used as Search data", 6 )
else
   @  6,  3 clear to 6, 76
   CNT( "Enter Text to Search For", 6 )
endif

devpos( crow, ccol )

return NIL

*+
*+
*+    Static Function togglerepl()
*+
*+    Called from ( gsr.prg      )   1 - function gsr()
*+                                   1 - static function gsrhelp()
*+
*+
*+
static function togglerepl()

local crow := row()
local ccol := col()

rFileMode := !rFileMode

if rFileMode
   CNT( "Enter a filename. The contents will be used as Replace data", 9 )
else
   @  9,  3 clear to 9, 76
   CNT( "Enter Text to Replace with", 9 )
endif

devpos( crow, ccol )

return NIL

*+ EOF: GSR.PRG
