/*
 * MULTIPLT
 *
 * Copyright (C) 1998   Michael C. Ring
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear 
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the modified code.  Modifications are to be distributed 
 * as patches to released version.
 *  
 * This software is provided "as is" without express or implied warranty.
 */

/*
 *      Put multiple postscript plots on one sheet of paper.
 *      Post-process the output of FPLOT or GNUPLOT.
 *
 *      $Log: multiplt.c $
 *      Revision 1.4  1998/02/13 22:55:41  mring
 *      removed paper size code
 *
 *      Revision 1.3  1998/02/13 03:06:05  mring
 *      added code to support variable page size
 *
 *      Revision 1.2  1998/02/13 01:21:30  mring
 *      added copyright banner, RCS info
 */

static  char    
RCS_ID[] = "$Id: multiplt.c 1.4 1998/02/13 22:55:41 mring Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

unsigned char   g_str[2048];
int	        g_num_plots;

main(argc,argv)
int  argc;  char *argv[];
{
char    *p, fn[128];
int     k, num_files;
FILE    *ptr;

num_files = argc - 1;

if (num_files < 1 || num_files > 9)
  {
   fprintf(stderr,"Usage : multiplt file-1 file-2 ... file-n\n");
   exit(8);
  }

g_num_plots = num_files;
if (g_num_plots == 5)  g_num_plots = 6;
if (g_num_plots == 7)  g_num_plots = 8;

k = 0;

top_header();

while (1)
  {
   if (++k == argc)  break;

   strcpy(fn,argv[k]);

   if ((ptr = fopen(fn,"r")) == NULL)
     {
      fprintf(stderr,"File %s not found\n",fn);
     }
   else
     {
      header(k);

      fgets(g_str,2047,ptr);
      if (strposition(g_str,"%!") != 0)
	{
         fprintf(stderr,
         "Warning! : File %s does not appear to be a postscript file\n",fn);
	}

      while(fgets(g_str,2047,ptr))    
        {
         replace_crlf(g_str);
   
         if (strposition(g_str,"showpage") == 0)
	    break;
         else
	    printf("%s\n",g_str);
        }
   
      printf("grestore\n");
      fclose(ptr);
     }
  }

trailer();

exit(0);
}  /* end main() */
/***********************************************************************/
top_header()
{
printf("%%!PS\n");
printf("%%%%Creator: multiplt\n");
printf("%%%%Pages: (atend)\n");
printf("%%%%EndComments\n");
printf("/multiplt 22 dict def\n");
printf("multiplt begin\n");

if (g_num_plots == 1)
  {
   printf("/XDIM1 0 def\n");
   printf("/YDIM1 0 def\n");
   printf("/XXSCALE 1.0 def\n");
   printf("/YYSCALE 1.0 def\n");
  }

if (g_num_plots == 2)
  {
   printf("/XDIM1 20 def\n");
   printf("/XDIM2 20 def\n");

   printf("/YDIM1 772 def\n");
   printf("/YDIM2 390 def\n");

   printf("/XXSCALE 0.72 def\n");
   printf("/YYSCALE 0.61 def\n");
  }

if (g_num_plots == 3)
  {
   printf("/XDIM1 116 def\n");
   printf("/XDIM2 116 def\n");
   printf("/XDIM3 116 def\n");

   printf("/YDIM1 770 def\n");
   printf("/YDIM2 520 def\n");
   printf("/YDIM3 270 def\n");

   printf("/XXSCALE 0.475 def\n");
   printf("/YYSCALE 0.4085 def\n");
  }

if (g_num_plots == 4)
  {
   printf("/XDIM1 15 def\n");
   printf("/XDIM2 15 def\n");
   printf("/XDIM3 307 def\n");
   printf("/XDIM4 307 def\n");

   printf("/YDIM1 20 def\n");
   printf("/YDIM2 394 def\n");
   printf("/YDIM3 20 def\n");
   printf("/YDIM4 394 def\n");

   printf("/XXSCALE 0.4724 def\n");
   printf("/YYSCALE 0.4632 def\n");
  }

if (g_num_plots == 6)
  {
   printf("/XDIM1 14 def\n");
   printf("/XDIM2 310 def\n");
   printf("/XDIM3 14 def\n");
   printf("/XDIM4 310 def\n");
   printf("/XDIM5 14 def\n");
   printf("/XDIM6 310 def\n");

   printf("/YDIM1 754 def\n");
   printf("/YDIM2 754 def\n");
   printf("/YDIM3 508 def\n");
   printf("/YDIM4 508 def\n");
   printf("/YDIM5 262 def\n");
   printf("/YDIM6 262 def\n");

   printf("/XXSCALE 0.36 def\n");
   printf("/YYSCALE 0.37 def\n");
  }

if (g_num_plots == 8)
  {
   printf("/XDIM1 16 def\n");
   printf("/XDIM2 308 def\n");
   printf("/XDIM3 16 def\n");
   printf("/XDIM4 308 def\n");
   printf("/XDIM5 16 def\n");
   printf("/XDIM6 308 def\n");
   printf("/XDIM7 16 def\n");
   printf("/XDIM8 308 def\n");

   printf("/YDIM1 768 def\n");
   printf("/YDIM2 768 def\n");
   printf("/YDIM3 581 def\n");
   printf("/YDIM4 581 def\n");
   printf("/YDIM5 394 def\n");
   printf("/YDIM6 394 def\n");
   printf("/YDIM7 207 def\n");
   printf("/YDIM8 207 def\n");

   printf("/XXSCALE 0.3579 def\n");
   printf("/YYSCALE 0.3057 def\n");
  }

if (g_num_plots == 9)
  {
   printf("/XDIM1 16 def\n");
   printf("/XDIM2 16 def\n");
   printf("/XDIM3 16 def\n");
   printf("/XDIM4 210 def\n");
   printf("/XDIM5 210 def\n");
   printf("/XDIM6 210 def\n");
   printf("/XDIM7 404 def\n");
   printf("/XDIM8 404 def\n");
   printf("/XDIM9 404 def\n");

   printf("/YDIM1 16 def\n");
   printf("/YDIM2 270 def\n");
   printf("/YDIM3 524 def\n");
   printf("/YDIM4 16 def\n");
   printf("/YDIM5 270 def\n");
   printf("/YDIM6 524 def\n");
   printf("/YDIM7 16 def\n");
   printf("/YDIM8 270 def\n");
   printf("/YDIM9 524 def\n");

   printf("/XXSCALE 0.315 def\n");
   printf("/YYSCALE 0.315 def\n");
  }

printf("end\n");
printf("%%%%Page: 1 1\n");
printf("%%%%EndProlog\n");
printf("multiplt begin\n");
}
/***********************************************************************/
header(filenum)
int    filenum;
{
printf("gsave\n");

if (filenum == 1)   printf("XDIM1 YDIM1 translate\n");
if (filenum == 2)   printf("XDIM2 YDIM2 translate\n");
if (filenum == 3)   printf("XDIM3 YDIM3 translate\n");
if (filenum == 4)   printf("XDIM4 YDIM4 translate\n");
if (filenum == 5)   printf("XDIM5 YDIM5 translate\n");
if (filenum == 6)   printf("XDIM6 YDIM6 translate\n");
if (filenum == 7)   printf("XDIM7 YDIM7 translate\n");
if (filenum == 8)   printf("XDIM8 YDIM8 translate\n");
if (filenum == 9)   printf("XDIM9 YDIM9 translate\n");

if (g_num_plots == 1 || g_num_plots == 4 || g_num_plots == 9)
   printf("0 rotate\n");
else
   printf("-90 rotate\n");

printf("YYSCALE XXSCALE scale\n");
}
/***********************************************************************/
trailer()
{
printf("end\n");
printf("showpage\n");
printf("%%%%Trailer\n");
printf("%%%%Pages: 1\n");
}
/***********************************************************************/
replace_crlf(s)
char *s;
{
char *p;

p = s;

while (1)
  {
   if (*p == 0 || *p == 0x0A || *p == 0x0D)  break;
   p++;
  }
*p = 0;
}
/***********************************************************************/
/*    returns char position of first occurence of s2 in s1
	  or -1 if no match found
*/
strposition(s1,s2)
char    *s1, *s2;
{
register char  ch1, ch2;
char           *p0, *p1, *p2;
int            ct;

ct = -1;
p0 = s1;

if (*s2 == '\0')  return(-1);

while (1)
  {
   ct++;
   p1  = p0;
   p2  = s2;
   ch2 = *p2;
   
   while (1)                       /* scan until first char matches */
     {
      if ((ch1 = *p1) == '\0')  return(-1);
      if (ch1 == ch2)           break;
      p1++;
      ct++;
     }

   p2++;                           /* check remainder of 2 strings */
   p1++;
   p0 = p1;

   while (1)
     {
      if ((ch2 = *p2) == '\0')  return(ct);
      if (*p1 != ch2)           break;
      p1++;
      p2++;
     }
  }
}
/***********************************************************************/
