/* 
 * FPLOT - fpset.c
 *
 * Copyright (C) 1997, 1998   Michael C. Ring
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear 
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the modified code.  Modifications are to be distributed 
 * as patches to released version.
 *  
 * This software is provided "as is" without express or implied warranty.
 */

/*
 *      fpset.c
 *
 *      $Log: fpset.c $
 *      Revision 1.9  1998/04/03 20:15:30  mring
 *      changed exit codes from 28 to 31
 *
 *      Revision 1.8  1998/03/08 19:50:23  mring
 *      added 'center' and 'rightjustify' to label commands
 *
 *      Revision 1.7  1998/03/07 04:46:01  mring
 *      error on usesamples when both values are the same
 *
 *      Revision 1.6  1998/03/05 03:42:58  mring
 *      update for 0.5a
 *
 *      Revision 1.5  1997/12/06 23:02:05  mring
 *      allow 0 for fielddefinition
 *      split file into 2 source files, created fpcmd.c
 *
 *      Revision 1.4  1997/12/05 02:20:43  mring
 *      update for version 0.4a
 *
 *      Revision 1.3  1997/11/26 23:20:56  mring
 *      added MAX_LINE_LENGTH
 *
 *      Revision 1.2  1997/11/24 01:32:07  mring
 *      added copyright notice
 *
 *      Revision 1.1  1997/11/23 23:08:19  mring
 *      Initial revision
 *
 */

#include "fplot.h"
#include "glob.h"

/* RCS TRACER */
static  char    
RCS_ID[] = "$Id: fpset.c 1.9 1998/04/03 20:15:30 mring Exp $";


/***********************************************************************/
parse_set_command(fieldcount)
int     fieldcount;
{
int     cmd_found, font_flag, label_flag, fielddef;
double  d1, d2, *dx, *dy;
char    **cpp;

fieldcount = reset_field_count(fieldcount);

if (fieldcount <= 2)           /* all set commands have at least 3 fields */
  {
   invalid_set_command(fieldcount,30);
  }

lowercase(g_buf[2]);           /* find out which command */

cmd_found = FALSE;
 
/*
 *      set papersize 8.5, 11.0
 */

if (strposition(g_buf[2],"papersi") == 0) /* accept this for 'papersize' */
  {
   cmd_found = TRUE;

   if (fieldcount != 4)                   /* this command has 4 fields */
     invalid_set_command(fieldcount,31);

   g_papersize_width  = atof(g_buf[3]);
   g_papersize_length = atof(g_buf[4]);

   if (g_papersize_width < 0.90 || g_papersize_length < 0.90)
     invalid_set_command(fieldcount,31);
  }


/*
 *      set outputformat postscript
 */
                                        /* accept this for 'outputformat' */
if (strposition(g_buf[2],"outputfor") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   lowercase(g_buf[3]);

   if (strposition(g_buf[3],"postsc") == 0)    /* postscript */
      g_outputformat = FORMAT_POSTSCRIPT;
   else
      invalid_set_command(fieldcount,31);
  }


/*
 *      set usesamples 50, 100
 */

if (strposition(g_buf[2],"usesampl") == 0) /* accept this for 'usesamples' */
  {
   cmd_found = TRUE;

   if (fieldcount != 4)                   /* this command has 4 fields */
     invalid_set_command(fieldcount,31);

   g_usesamples_low  = atol(g_buf[3]);
   g_usesamples_high = atol(g_buf[4]);

   if (g_usesamples_low >= g_usesamples_high)
     invalid_set_command(fieldcount,31);

   if (g_usesamples_low < 0 || g_usesamples_high < 0)
     invalid_set_command(fieldcount,31);

   g_usesamples = TRUE;
  }


/*
 *      set skipfactor 9
 */

if (strposition(g_buf[2],"skipfa") == 0) /* accept this for 'skipfactor' */
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   if ((g_skip_factor = atol(g_buf[3])) < 0)
     invalid_set_command(fieldcount,31);
  }


/*
 *      set gridlines on
 *      set gridlines off
 */

if (strposition(g_buf[2],"gridli") == 0) /* accept this for 'gridlines' */
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   lowercase(g_buf[3]);

   if (strcmp(g_buf[3],"on") == 0)
      g_gridlines = TRUE;
   else
     {
      if (strcmp(g_buf[3],"off") == 0)
        g_gridlines = FALSE;
      else
        invalid_set_command(fieldcount,31);
     }
  }


/*
 *      set fontsize title 18.0
 *                   xlabel, ylabel, y1label, y2label
 *                   label1-8
 */

if (strposition(g_buf[2],"fontsi") == 0) /* accept this for 'fontsize' */
  {
   cmd_found = TRUE;
   font_flag = FALSE;

   if (fieldcount != 4)                   /* this command has 4 fields */
     invalid_set_command(fieldcount,31);

   if ((d1 = atof(g_buf[4])) < 0.1)
     invalid_set_command(fieldcount,31);

   if (strcmp(g_buf[3],"title") == 0)
     {
      font_flag = TRUE;
      g_fontsize_title = d1;
     }

   if (strcmp(g_buf[3],"xlabel") == 0)
     {
      font_flag = TRUE;
      g_fontsize_xlabel = d1;
     }

   if (strcmp(g_buf[3],"ylabel") == 0 || strcmp(g_buf[3],"y1label") == 0)
     {
      font_flag = TRUE;
      g_fontsize_y1label = d1;
     }

   if (strcmp(g_buf[3],"y2label") == 0)
     {
      font_flag = TRUE;
      g_fontsize_y2label = d1;
     }

   if (strcmp(g_buf[3],"label1") == 0)
     {
      font_flag = TRUE;
      g_fontsize_label1 = d1;
     }

   if (strcmp(g_buf[3],"label2") == 0)
     {
      font_flag = TRUE;
      g_fontsize_label2 = d1;
     }

   if (strcmp(g_buf[3],"label3") == 0)
     {
      font_flag = TRUE;
      g_fontsize_label3 = d1;
     }

   if (strcmp(g_buf[3],"label4") == 0)
     {
      font_flag = TRUE;
      g_fontsize_label4 = d1;
     }

   if (strcmp(g_buf[3],"label5") == 0)
     {
      font_flag = TRUE;
      g_fontsize_label5 = d1;
     }

   if (strcmp(g_buf[3],"label6") == 0)
     {
      font_flag = TRUE;
      g_fontsize_label6 = d1;
     }

   if (strcmp(g_buf[3],"label7") == 0)
     {
      font_flag = TRUE;
      g_fontsize_label7 = d1;
     }

   if (strcmp(g_buf[3],"label8") == 0)
     {
      font_flag = TRUE;
      g_fontsize_label8 = d1;
     }

   if (font_flag == FALSE)
     {
      invalid_set_command(fieldcount,31);
     }
  }


/*
 *      set xoffset -2.0
 */

if (strposition(g_buf[2],"xoffs") == 0) /* accept this for 'xoffset' */
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_xoffset = atof(g_buf[3]);
  }


/*
 *      set yoffset 32.0    (also y1offset)
 */

if (strposition(g_buf[2],"yoffs") == 0 ||
    strposition(g_buf[2],"y1offs") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_y1offset = atof(g_buf[3]);
  }


/*
 *      set y2offset -32.0  
 */

if (strposition(g_buf[2],"y2offs") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_y2offset = atof(g_buf[3]);
  }


/*
 *      set xmultiplier 1000.0
 */

if (strposition(g_buf[2],"xmulti") == 0) /* accept this for 'xmultiplier' */
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_xmultiplier = atof(g_buf[3]);
  }


/*
 *      set ymultiplier 1.0E6      (also y1multiplier)
 */

if (strposition(g_buf[2],"ymulti") == 0 ||
    strposition(g_buf[2],"y1multi") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_y1multiplier = atof(g_buf[3]);
  }


/*
 *      set y2multiplier 10.0     
 */

if (strposition(g_buf[2],"y2multi") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_y2multiplier = atof(g_buf[3]);
  }


/*
 *      set fielddefinition x,1
 *      set fielddefinition y,2
 *      set fielddefinition y1,2
 *      set fielddefinition y2,3
 *      set fielddefinition y12,3              can specify 1-12
 */
                                  /* accept this for 'fielddefinition' */
if (strposition(g_buf[2],"fielddef") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 4)                   /* this command has 4 fields */
     invalid_set_command(fieldcount,31);

   lowercase(g_buf[3]);
   fielddef = FALSE;

   if (strcmp(g_buf[3],"x") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_x = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (strcmp(g_buf[3],"y") == 0 || strcmp(g_buf[3],"y1") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y1 = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (strcmp(g_buf[3],"y2") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y2 = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (strcmp(g_buf[3],"y3") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y3 = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (strcmp(g_buf[3],"y4") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y4 = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (strcmp(g_buf[3],"y5") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y5 = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (strcmp(g_buf[3],"y6") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y6 = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (strcmp(g_buf[3],"y7") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y7 = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (strcmp(g_buf[3],"y8") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y8 = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (strcmp(g_buf[3],"y9") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y9 = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (strcmp(g_buf[3],"y10") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y10 = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (strcmp(g_buf[3],"y11") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y11 = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (strcmp(g_buf[3],"y12") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y12 = atoi(g_buf[4])) < 0)
        invalid_set_command(fieldcount,31);
     }

   if (fielddef == FALSE)
     {
      invalid_set_command(fieldcount,31);
     }
  }


/*
 *      set xaxisscale linear
 *      set xaxisscale log
 */

if (strposition(g_buf[2],"xaxissc") == 0) /* accept this for 'xaxisscale' */
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   lowercase(g_buf[3]);

   if (strcmp(g_buf[3],"linear") == 0)
      g_xaxis_scale = X_AXIS_SCALE_LINEAR;
   else
     {
      if (strcmp(g_buf[3],"log") == 0)
        g_xaxis_scale = X_AXIS_SCALE_LOG;
      else
        invalid_set_command(fieldcount,31);
     }
  }


/*
 *      set graphtype lines
 *      set graphtype points
 *      set graphtype linesandpoints
 */

if (strposition(g_buf[2],"grapht") == 0) /* accept this for 'graphtype' */
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   lowercase(g_buf[3]);

   if (strcmp(g_buf[3],"lines") == 0)
      g_graph_type = GRAPH_TYPE_LINES;
   else
     {
      if (strcmp(g_buf[3],"points") == 0)
         g_graph_type = GRAPH_TYPE_POINTS;
      else
        {
         if (strcmp(g_buf[3],"linesandpoints") == 0)
           g_graph_type = GRAPH_TYPE_LINES_AND_POINTS;
         else
           invalid_set_command(fieldcount,31);
        }
     }
  }


/*
 *      set xrange autorange
 *      set xrange -35.0,45.0
 */

if (strcmp(g_buf[2],"xrange") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount == 3)
     {
      lowercase(g_buf[3]);

      if (strposition(g_buf[3],"auto") == 0)
         g_xrange_auto = TRUE;
      else
         invalid_set_command(fieldcount,31);
     }
   else
     {
      if (fieldcount == 4)
        {
         g_xrange_auto = FALSE;

         g_xrange_low  = atof(g_buf[3]);
         g_xrange_high = atof(g_buf[4]);

         adjust_min_max(&g_xrange_low,&g_xrange_high);

         d1 = fabs(g_xrange_low);
         d2 = fabs(g_xrange_high);

         if (d2 < d1)  d2 = d1;

         if (d2 < 1.0E-12)
           invalid_set_command(fieldcount,31);

         d1 = (g_xrange_high - g_xrange_low) / d2;

         if (fabs(d1) < 1.0E-12)
           invalid_set_command(fieldcount,31);
        }
      else
        {
         invalid_set_command(fieldcount,31);
        }
     }
  }


/*
 *      set yrange autorange       (y1range also)
 *      set yrange -35.0,45.0      
 */

if (strcmp(g_buf[2],"yrange") == 0 || strcmp(g_buf[2],"y1range") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount == 3)
     {
      lowercase(g_buf[3]);

      if (strposition(g_buf[3],"auto") == 0)
         g_y1range_auto = TRUE;
      else
         invalid_set_command(fieldcount,31);
     }
   else
     {
      if (fieldcount == 4)
        {
         g_y1range_auto = FALSE;

         g_y1range_low  = atof(g_buf[3]);
         g_y1range_high = atof(g_buf[4]);

         adjust_min_max(&g_y1range_low,&g_y1range_high);

         d1 = fabs(g_y1range_low);
         d2 = fabs(g_y1range_high);

         if (d2 < d1)  d2 = d1;

         if (d2 < 1.0E-12)
           invalid_set_command(fieldcount,31);

         d1 = (g_y1range_high - g_y1range_low) / d2;

         if (fabs(d1) < 1.0E-12)
           invalid_set_command(fieldcount,31);
        }
      else
        {
         invalid_set_command(fieldcount,31);
        }
     }
  }


/*
 *      set y2range autorange
 *      set y2range y1range           force Y2 the same as Y1
 *      set y2range -35.0,45.0      
 */

if (strcmp(g_buf[2],"y2range") == 0)
  {
   cmd_found = TRUE;

   g_force_y2_y1 = FALSE;

   if (fieldcount == 3)
     {
      lowercase(g_buf[3]);

      if (strposition(g_buf[3],"auto") == 0)
         g_y2range_auto = TRUE;
      else
        {
         if (strposition(g_buf[3],"y1ra") == 0)
            g_force_y2_y1 = TRUE;
         else
            invalid_set_command(fieldcount,31);
        }
     }
   else
     {
      if (fieldcount == 4)
        {
         g_y2range_auto = FALSE;

         g_y2range_low  = atof(g_buf[3]);
         g_y2range_high = atof(g_buf[4]);

         adjust_min_max(&g_y2range_low,&g_y2range_high);

         d1 = fabs(g_y2range_low);
         d2 = fabs(g_y2range_high);

         if (d2 < d1)  d2 = d1;

         if (d2 < 1.0E-12)
           invalid_set_command(fieldcount,31);

         d1 = (g_y2range_high - g_y2range_low) / d2;

         if (fabs(d1) < 1.0E-12)
           invalid_set_command(fieldcount,31);
        }
      else
        {
         invalid_set_command(fieldcount,31);
        }
     }
  }


/*
 *      set outputfile "C:\data.tmp"
 */

if (strcmp(g_buf[2],"outputfile") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   memory_free(g_output_file);
   g_output_file = memory_allocate((strlen(g_buf[3]) + 4) * sizeof(char));
   strcpy(g_output_file,g_buf[3]);
  }


/*
 *      set title "this is the graph title"
 */

if (strcmp(g_buf[2],"title") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   memory_free(g_title);
   g_title = memory_allocate((strlen(g_buf[3]) + 4) * sizeof(char));
   strcpy(g_title,g_buf[3]);
  }


/*
 *      set xlabel "x axis label"
 */

if (strcmp(g_buf[2],"xlabel") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   memory_free(g_xlabel);
   g_xlabel = memory_allocate((strlen(g_buf[3]) + 4) * sizeof(char));
   strcpy(g_xlabel,g_buf[3]);
  }


/*
 *      set ylabel "y axis label"        (also y1label)
 */

if (strcmp(g_buf[2],"ylabel") == 0 || strcmp(g_buf[2],"y1label") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   memory_free(g_y1label);
   g_y1label = memory_allocate((strlen(g_buf[3]) + 4) * sizeof(char));
   strcpy(g_y1label,g_buf[3]);
  }


/*
 *      set y2label "y2 axis label"      
 */

if (strcmp(g_buf[2],"y2label") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   memory_free(g_y2label);
   g_y2label = memory_allocate((strlen(g_buf[3]) + 4) * sizeof(char));
   strcpy(g_y2label,g_buf[3]);
  }


label_flag = FALSE;

/*
 *      set label1 3.0, 4.5, "extra label 1 at 3.0, 4.5"
 */

if (strcmp(g_buf[2],"label1") == 0)
  {
   cmd_found  = TRUE;
   label_flag = TRUE;
   cpp        = &g_label1;
   dx         = &g_label1_x;
   dy         = &g_label1_y;
  }


/*
 *      set label2 3.0, 4.5, "extra label 2 at 3.0, 4.5"
 */

if (strcmp(g_buf[2],"label2") == 0)
  {
   cmd_found  = TRUE;
   label_flag = TRUE;
   cpp        = &g_label2;
   dx         = &g_label2_x;
   dy         = &g_label2_y;
  }


/*
 *      set label3 3.0, 4.5, "extra label 3 at 3.0, 4.5"
 */

if (strcmp(g_buf[2],"label3") == 0)
  {
   cmd_found  = TRUE;
   label_flag = TRUE;
   cpp        = &g_label3;
   dx         = &g_label3_x;
   dy         = &g_label3_y;
  }


/*
 *      set label4 3.0, 4.5, "extra label 4 at 3.0, 4.5"
 */

if (strcmp(g_buf[2],"label4") == 0)
  {
   cmd_found  = TRUE;
   label_flag = TRUE;
   cpp        = &g_label4;
   dx         = &g_label4_x;
   dy         = &g_label4_y;
  }


/*
 *      set label5 3.0, 4.5, "extra label 5 at 3.0, 4.5"
 */

if (strcmp(g_buf[2],"label5") == 0)
  {
   cmd_found  = TRUE;
   label_flag = TRUE;
   cpp        = &g_label5;
   dx         = &g_label5_x;
   dy         = &g_label5_y;
  }


/*
 *      set label6 3.0, 4.5, "extra label 6 at 3.0, 4.5"
 */

if (strcmp(g_buf[2],"label6") == 0)
  {
   cmd_found  = TRUE;
   label_flag = TRUE;
   cpp        = &g_label6;
   dx         = &g_label6_x;
   dy         = &g_label6_y;
  }


/*
 *      set label7 3.0, 4.5, "extra label 7 at 3.0, 4.5"
 */

if (strcmp(g_buf[2],"label7") == 0)
  {
   cmd_found  = TRUE;
   label_flag = TRUE;
   cpp        = &g_label7;
   dx         = &g_label7_x;
   dy         = &g_label7_y;
  }


/*
 *      set label8 3.0, 4.5, "extra label 8 at 3.0, 4.5"
 */

if (strcmp(g_buf[2],"label8") == 0)
  {
   cmd_found  = TRUE;
   label_flag = TRUE;
   cpp        = &g_label8;
   dx         = &g_label8_x;
   dy         = &g_label8_y;
  }

if (label_flag == TRUE)
  {
   if (fieldcount != 5)                   /* label commands have 5 fields */
     invalid_set_command(fieldcount,31);

   d1  = atof(g_buf[3]);
   *dy = atof(g_buf[4]);

   if (d1 < 0.02)		  /* check for 'center' or 'rightjustify' */
     {
      lowercase(g_buf[3]);     

      if (strposition(g_buf[3],"center") == 0)  d1 = -3.01;
      if (strposition(g_buf[3],"right")  == 0)  d1 = -2.01;
     }

   *dx = d1;

   memory_free(*cpp);
   *cpp = memory_allocate((strlen(g_buf[5]) + 4) * sizeof(char));
   strcpy(*cpp,g_buf[5]);
  }

if (cmd_found == FALSE)
  {
   invalid_set_command(fieldcount,31);
  }
}
/***********************************************************************/
