/*--------------------------------------------------------------------------
 * File : fplot.h
 *
 * $Id: fplot.h 1.5 1998/03/08 19:47:01 mring Exp $
 *------------------------------------------------------------------------*/

#ifndef _FPLOT_H_DEFINED
#define _FPLOT_H_DEFINED

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <memory.h>
#include <ctype.h>
#include <signal.h>
#include <time.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <sys/stat.h>

#ifdef MSDOS
#include <process.h>
#else
#include <unistd.h>
#endif

/*
 *      Some function prototypes
 */

char    *filter_input_string();
char    *lowercase();
long    convert_string_to_ps();
long    get_x_coord_labels();

#ifdef MSDOS
void    *memory_allocate(unsigned int);
void    exit_program(int);
#else
void    *memory_allocate();
void    exit_program();
#endif


#define FALSE 0
#define TRUE  1

#define MAX_LINE_LENGTH       8100

#define BIG_BUF_SIZE          16384

#define FORMAT_POSTSCRIPT     1001     /* only postscript supported now */
#define FORMAT_HPGL2          1101
#define FORMAT_EPSON_LQ       1201
#define FORMAT_EPSON_FX       1202

#define X_AXIS_SCALE_LINEAR   3001     /* only linear & log supported now */
#define X_AXIS_SCALE_LOG      3002
#define X_AXIS_SCALE_DATE     3003

#define GRAPH_TYPE_LINES             8001
#define GRAPH_TYPE_POINTS            8002
#define GRAPH_TYPE_LINES_AND_POINTS  8003
#define GRAPH_TYPE_BAR               8004    /* BAR not supported yet */

#define RAW_FILE     101
#define COMMAND_FILE 102

#endif  /* _FPLOT_H_DEFINED */
/*------------------------------------------------------------------------*/
