/* 
 * FPLOT - fplot.c
 *
 * Copyright (C) 1997, 1998   Michael C. Ring
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear 
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the modified code.  Modifications are to be distributed 
 * as patches to released version.
 *  
 * This software is provided "as is" without express or implied warranty.
 */

/*
 *      FAST/EASY postscript plotting program
 *
 *	see the individual mk* scripts/batch files to build
 *	the program under various OS's.
 *
 *
 *	$Log: fplot.c $
 *	Revision 2.10  1998/04/03 20:35:40  mring
 *	set revision to 2.10 for the latest distribution package
 *
 *	Revision 2.0  1998/04/03 20:00:45  mring
 *	version of program is now the RCS version of this file
 *
 *	Revision 1.8  1998/03/15 23:21:57  mring
 *	update version to 0.6b
 *
 *	Revision 1.7  1998/03/07 04:41:55  mring
 *	update version to 0.6a
 *
 *	Revision 1.6  1998/03/05 03:42:35  mring
 *	update for 0.5a
 *
 *	Revision 1.5  1997/12/05 02:20:01  mring
 *	updated to version 0.4a
 *
 *	Revision 1.4  1997/11/26 23:18:02  mring
 *	added MAX_LINE_LENGTH
 *
 *	Revision 1.3  1997/11/24 01:30:23  mring
 *	*** empty log message ***
 *
 *	Revision 1.2  1997/11/24 01:27:35  mring
 *	added copyright notice
 *
 *	Revision 1.1  1997/11/23 23:15:01  mring
 *	Initial revision
 *
 */

#include "fplot.h"

static  char    
RCS_ID[] = "$Id: fplot.c 2.10 1998/04/03 20:35:40 mring Exp $";

/*
 *      Global Variables, update GLOB.H also when adding a variable here
 */

char    (*g_buf)[256],             /* output of parse_line_into_fields */
        *g_input_string,           /* input buffer for reading files   */
        *g_label1,                 /* Label 1                          */
        *g_label2,                 /* Label 2                          */
        *g_label3,                 /* Label 3                          */
        *g_label4,                 /* Label 4                          */
        *g_label5,                 /* Label 5                          */
        *g_label6,                 /* Label 6                          */
        *g_label7,                 /* Label 7                          */
        *g_label8,                 /* Label 8                          */
        *g_xlabel,                 /* X Label     (bottom of plot)     */
        *g_y1label,                /* Y1 Label    (left side of plot)  */
        *g_y2label,                /* Y2 Label    (right side of plot) */
        *g_title,                  /* Title Label (top of plot)        */
	*g_big_buffer,		   /* larger read buffer for file I/O  */
        *g_plot_file,              /* plot file name                   */
        *g_output_file,            /* output file name                 */
        *g_tmp_file,               /* temp file name                   */
        *g_tmp_file2,              /* temp file name                   */
        *g_tmp_file3;              /* temp file name                   */

int     g_raw_mode,                /* BOOL, F=command file, T=raw mode */
        g_usesamples,              /* BOOL                             */
        g_xrange_auto,             /* BOOL, autoscale the x-axis       */
        g_y1range_auto,            /* BOOL, autoscale the y1-axis      */
        g_y2range_auto,            /* BOOL, autoscale the y2-axis      */
        g_gridlines,               /* BOOL, turn on grid lines?        */
	g_force_y2_y1,             /* BOOL, force Y2 range same as Y1  */
        g_xaxis_scale,             /* linear, log, ...                 */
        g_outputformat,
        g_x_divisions,             /* # divisions on x axis            */
        g_y1_divisions,            /* # divisions on y1 axis           */
        g_y2_divisions,            /* # divisions on y2 axis           */
        g_field_def_x,             /* which field is the X data in     */
        g_field_def_y1,            /* which field is the Y1 data in    */
        g_field_def_y2,            /* which field is the Y2 data in    */
        g_field_def_y3,            /* ...                              */
        g_field_def_y4,            /* ...                              */
        g_field_def_y5,            /* ...                              */
        g_field_def_y6,            /* ...                              */
        g_field_def_y7,            /* ...                              */
        g_field_def_y8,            /* ...                              */
        g_field_def_y9,            /* ...                              */
        g_field_def_y10,           /* ...                              */
        g_field_def_y11,           /* ...                              */
        g_field_def_y12,           /* ...                              */
        g_num_y_ranges,            /* how many Y ranges are we plotting*/
        g_graph_type;              /* which kind of graph to draw      */

long    g_skip_factor,             /* skip N data points               */
        g_num_samples_to_plot,
        g_usesamples_low,
        g_usesamples_high;

double  g_graph_x_min,             /* graph x min coord                */
        g_graph_x_max,             /* graph x max coord                */
        g_graph_y1_min,            /* graph y1 min coord               */
        g_graph_y1_max,            /* graph y1 max coord               */
        g_graph_y2_min,            /* graph y2 min coord               */
        g_graph_y2_max,            /* graph y2 max coord               */
        g_true_x_min,              /* need to keep the true min/max    */
        g_true_x_max,              /*   for autoranging in LOG mode    */
        g_papersize_length,        /* nominally 11.0 inches            */
        g_papersize_width,         /* nominally 8.5 inches             */
        g_label1_x,                /* Label 1 X coord                  */
        g_label1_y,                /* Label 1 Y coord                  */
        g_label2_x,                /* Label 2 X coord                  */
        g_label2_y,                /* Label 2 Y coord                  */
        g_label3_x,                /* Label 3 X coord                  */
        g_label3_y,                /* Label 3 Y coord                  */
        g_label4_x,                /* Label 4 X coord                  */
        g_label4_y,                /* Label 4 Y coord                  */
        g_label5_x,                /* Label 5 X coord                  */
        g_label5_y,                /* Label 5 Y coord                  */
        g_label6_x,                /* Label 6 X coord                  */
        g_label6_y,                /* Label 6 Y coord                  */
        g_label7_x,                /* Label 7 X coord                  */
        g_label7_y,                /* Label 7 Y coord                  */
        g_label8_x,                /* Label 8 X coord                  */
        g_label8_y,                /* Label 8 Y coord                  */

	g_fontsize_title,	   /* font size for each label         */
	g_fontsize_xlabel,
	g_fontsize_y1label,
	g_fontsize_y2label,
	g_fontsize_label1,
	g_fontsize_label2,
	g_fontsize_label3,
	g_fontsize_label4,
	g_fontsize_label5,
	g_fontsize_label6,
	g_fontsize_label7,
	g_fontsize_label8,

        g_xrange_low,              /* X axis low limit                 */
        g_xrange_high,             /* X axis high limit                */
        g_y1range_low,             /* Y1 axis low limit                */
        g_y1range_high,            /* Y1 axis high limit               */
        g_y2range_low,             /* Y2 axis low limit                */
        g_y2range_high,            /* Y2 axis high limit               */

        g_xmultiplier,             /* X axis multiplier                */
        g_y1multiplier,            /* Y1 axis multiplier               */
        g_y2multiplier,            /* Y2 axis multiplier               */

        g_xoffset,                 /* X axis offset                    */
        g_y1offset,                /* Y1 axis offset                   */
        g_y2offset;                /* Y2 axis offset                   */

FILE	*g_tmp_ptr,		   /* temp file pointer                */
    	*g_tmp_ptr2,		   /* temp file pointer                */
    	*g_tmp_ptr3;		   /* temp file pointer                */

/*
 *      Start of main source code
 */

main(argc,argv)
int     argc;
char    *argv[];
{
int     k;
char    *buf, fn[128];
FILE    *in_ptr;

init_ctrl_c_handler();

init_globals();

if (argc < 2)
  {
   show_usage();
   exit_program(2);
  }

buf = g_input_string;
for (k=1; k < (argc - 1); k++)      /* process arguments */
  {
   strcpy(buf,argv[k]);

   if ((strcmp(buf,"-r") == 0) || (strcmp(buf,"-R") == 0))
     {
      g_raw_mode = TRUE;
     }
  }

get_tmp_file(g_tmp_file);           /* get a temp file       */
get_tmp_file(g_tmp_file2);          /* get another temp file */
get_tmp_file(g_tmp_file3);          /* get another temp file */

strcpy(fn,argv[argc - 1]);

if (strcmp(fn,"--") == 0)
   in_ptr = stdin;
else
  {
   if ((in_ptr = fopen(fn,"r")) == NULL)
     {
      fprintf(stderr,"File %s not found\n\n",fn);
      show_usage();
      exit_program(4);
     }
  }

g_tmp_ptr = fopen(g_tmp_file,"w");

while (fgets(g_input_string,MAX_LINE_LENGTH,in_ptr))
  {
   replace_crlf(g_input_string);
   fprintf(g_tmp_ptr,"%s\n",g_input_string);
  }

fclose(g_tmp_ptr);
g_tmp_ptr = NULL;

if (in_ptr != stdin)
  fclose(in_ptr);

if (g_raw_mode)     /* input file is just data */
  {
   plot_raw_file();
  }
else                /* input file is a command file */
  {
   plot_command_file();
  }

exit_program(0);
}
/***********************************************************************/
init_ctrl_c_handler()
{
if (signal(SIGINT, exit_program) == SIG_ERR)    /* Needed for graceful */
  {                                             /* shutdown            */
   fprintf(stderr,"ERROR : Couldn't set SIGINT\n");  
   abort();
  }

if (signal(SIGTERM, exit_program) == SIG_ERR)
  {
   fprintf(stderr,"ERROR : Couldn't set SIGTERM\n");  
   abort();
  }

/*
 *  additional signals to capture for unix systems
 */

#if defined(SUN) || defined(HPUX) || defined(LINUX)

if (signal(SIGPIPE, exit_program) == SIG_ERR)
  {
   fprintf(stderr,"ERROR : Couldn't set SIGPIPE\n");  
   abort();
  }

if (signal(SIGHUP, exit_program) == SIG_ERR)
  {
   fprintf(stderr,"ERROR : Couldn't set SIGHUP\n");  
   abort();
  }

#endif
}
/***********************************************************************/
show_usage()
{
parse_line_into_fields(RCS_ID);

fprintf(stderr,
  "Usage : fplot [options] <filename>\t\t\t    [Version %s]\n\n",g_buf[3]);

fprintf(stderr,
     "        options  : -r  file is a raw data file, not a command file\n");

fprintf(stderr,
     "        filename : the file where to read commands from\n");
fprintf(stderr,
     "                   use -- to process stdin\n");
}
/***********************************************************************/
init_globals()
{
static int first_time = TRUE;

if (first_time)
  {
   first_time = FALSE;
   g_raw_mode = FALSE;
   
   g_input_string = memory_allocate((MAX_LINE_LENGTH + 4) * sizeof(char));
   g_buf          = memory_allocate(80 * 256 * sizeof(char));

   g_big_buffer   = memory_allocate(BIG_BUF_SIZE * sizeof(char));

   g_plot_file    = memory_allocate(128 * sizeof(char));
   g_tmp_file     = memory_allocate(128 * sizeof(char));
   g_tmp_file2    = memory_allocate(128 * sizeof(char));
   g_tmp_file3    = memory_allocate(128 * sizeof(char));

   /* the following 'small' allocates with be resized when needed */
   g_output_file  = memory_allocate(2 * sizeof(char));

   g_label1       = memory_allocate(2 * sizeof(char));
   g_label2       = memory_allocate(2 * sizeof(char));
   g_label3       = memory_allocate(2 * sizeof(char));
   g_label4       = memory_allocate(2 * sizeof(char));
   g_label5       = memory_allocate(2 * sizeof(char));
   g_label6       = memory_allocate(2 * sizeof(char));
   g_label7       = memory_allocate(2 * sizeof(char));
   g_label8       = memory_allocate(2 * sizeof(char));

   g_xlabel       = memory_allocate(2 * sizeof(char));
   g_y1label      = memory_allocate(2 * sizeof(char));
   g_y2label      = memory_allocate(2 * sizeof(char));
   g_title        = memory_allocate(2 * sizeof(char));

   g_tmp_file[0]  = '\0';
   g_tmp_ptr      = NULL;

   g_tmp_file2[0] = '\0';
   g_tmp_ptr2     = NULL;

   g_tmp_file3[0] = '\0';
   g_tmp_ptr3     = NULL;
  }

g_plot_file[0]         = '\0';
g_output_file[0]       = '\0';

g_label1[0]            = '\0';
g_label2[0]            = '\0';
g_label3[0]            = '\0';
g_label4[0]            = '\0';
g_label5[0]            = '\0';
g_label6[0]            = '\0';
g_label7[0]            = '\0';
g_label8[0]            = '\0';
g_xlabel[0]            = '\0';
g_y1label[0]           = '\0';
g_y2label[0]           = '\0';
g_title[0]             = '\0';

g_outputformat         = FORMAT_POSTSCRIPT;
g_xaxis_scale          = X_AXIS_SCALE_LINEAR;
g_graph_type           = GRAPH_TYPE_LINES;
g_usesamples           = FALSE;
g_force_y2_y1          = FALSE;        /* do not force Y2 range same as Y1 */

g_xrange_auto          = TRUE;         /* default to autoranging       */
g_y1range_auto         = TRUE;
g_y2range_auto         = TRUE;
g_gridlines            = TRUE;         /* turn on grid lines           */

g_num_y_ranges         = 0;
g_field_def_x          = 0;
g_field_def_y1         = 0;
g_field_def_y2         = 0;
g_field_def_y3         = 0;
g_field_def_y4         = 0;
g_field_def_y5         = 0;
g_field_def_y6         = 0;
g_field_def_y7         = 0;
g_field_def_y8         = 0;
g_field_def_y9         = 0;
g_field_def_y10        = 0;
g_field_def_y11        = 0;
g_field_def_y12        = 0;

g_skip_factor          = 0;
g_num_samples_to_plot  = 0;
g_usesamples_low       = 0;
g_usesamples_high      = 0;

g_papersize_length     = 11.0;         /* in inches                    */
g_papersize_width      = 8.5;

g_xmultiplier          = 1.0;
g_y1multiplier         = 1.0;
g_y2multiplier         = 1.0;

g_xoffset              = 0.0;
g_y1offset             = 0.0;
g_y2offset             = 0.0;

g_fontsize_title       = 14.0;         /* point size for these labels  */
g_fontsize_xlabel      = 14.0;
g_fontsize_y1label     = 14.0;	       /* note : the variable 'dfont'  */
g_fontsize_y2label     = 14.0;         /*        in fpout.c will need  */
g_fontsize_label1      = 10.0;         /*        to change if these    */
g_fontsize_label2      = 10.0;         /*        defaults change       */
g_fontsize_label3      = 10.0;
g_fontsize_label4      = 10.0;
g_fontsize_label5      = 10.0;
g_fontsize_label6      = 10.0;
g_fontsize_label7      = 10.0;
g_fontsize_label8      = 10.0;

g_label1_x             = 1.0;          /* Label 1 X coord              */
g_label1_y             = 1.0;          /* Label 1 Y coord              */
g_label2_x             = 1.5;          /* Label 2 X coord              */
g_label2_y             = 1.5;          /* Label 2 Y coord              */
g_label3_x             = 2.0;          /* Label 3 X coord              */
g_label3_y             = 2.0;          /* Label 3 Y coord              */
g_label4_x             = 2.5;          /* Label 4 X coord              */
g_label4_y             = 2.5;          /* Label 4 Y coord              */
g_label5_x             = 3.0;          /* Label 5 X coord              */
g_label5_y             = 3.0;          /* Label 5 Y coord              */
g_label6_x             = 3.5;          /* Label 6 X coord              */
g_label6_y             = 3.5;          /* Label 6 Y coord              */
g_label7_x             = 4.0;          /* Label 7 X coord              */
g_label7_y             = 4.0;          /* Label 7 Y coord              */
g_label8_x             = 4.5;          /* Label 8 X coord              */
g_label8_y             = 4.5;          /* Label 8 Y coord              */

g_xrange_low           = 0.0;          /* x-axis lower limit           */
g_xrange_high          = 1.0;          /* x-axis upper limit           */
g_y1range_low          = 0.0;          /* y1-axis lower limit          */
g_y1range_high         = 1.0;          /* y1-axis upper limit          */
g_y2range_low          = 0.0;          /* y2-axis lower limit          */
g_y2range_high         = 1.0;          /* y2-axis upper limit          */
}
/***********************************************************************/
void    exit_program(code)
int     code;
{
signal(SIGINT, SIG_IGN);          /* now that we're in here, ignore ^C */

if (g_tmp_file[0] != '\0')
  {
   if (g_tmp_ptr != NULL)
     fclose(g_tmp_ptr);

   delete_file(g_tmp_file);
  }

if (g_tmp_file2[0] != '\0')
  {
   if (g_tmp_ptr2 != NULL)
     fclose(g_tmp_ptr2);

   delete_file(g_tmp_file2);
  }

if (g_tmp_file3[0] != '\0')
  {
   if (g_tmp_ptr3 != NULL)
     fclose(g_tmp_ptr3);

   delete_file(g_tmp_file3);
  }

if (code < 80)
  {
   memory_free(g_input_string);
   memory_free(g_buf);

   memory_free(g_label1);
   memory_free(g_label2);
   memory_free(g_label3);
   memory_free(g_label4);
   memory_free(g_label5);
   memory_free(g_label6);
   memory_free(g_label7);
   memory_free(g_label8);

   memory_free(g_xlabel);
   memory_free(g_y1label);
   memory_free(g_y2label);
   memory_free(g_title);

   memory_free(g_plot_file);
   memory_free(g_big_buffer);
   memory_free(g_tmp_file);
   memory_free(g_tmp_file2);
   memory_free(g_tmp_file3);
   memory_free(g_output_file);
  }

exit(code);
}
/***********************************************************************/
