%pagesize 72,132

; Titel		: FILTLIB
; Function	: Assembler routines for FILTER.PAS
; Version	: 4.0
; Date		: Mar 24,2000
; Author	: J R Ferguson
; Language	: Intel 8068/8088 assembler
; O.S.		: MS-DOS v3.2
; Assembler	: Borland Turbo Assembler
; Remarks	: Borland Turbo Pascal parameter passing conventions

		name	FILTLIB
		.model	TPASCAL
		ideal
		%nomacs
		locals	@@

INPBUFSIZ	=	16 * 1024
MAXTXT		=	255
MAXSEP		=	2

		; Character codes
LF		=	0ah
CR		=	0dh
FF		=	0ch
EofChar 	=	1ah
Escape		=	1bh
SoftCR		=	8dh
HiddenHyphen	=	1eh
ActiveHyphen	=	1fh
FixedBlank	=	0fh
SkipCode	=	-1

		; SwitchTyp values
Neutral 	=	0
Off		=	1
On		=	2

;----------------------------------------------------------------------
		dataseg
;----------------------------------------------------------------------

struc		LineTyp
	sep	db	?
		db	MAXSEP dup (?)
	txt	db	?
		db	MAXTXT dup (?)
ends		LineTyp

	extrn	CurLine 	:LineTyp	;LineTyp
	extrn	CurChar 	:word		;integer
	extrn	SaveSta 	:byte		;boolean
	extrn	InpEof		:byte		;boolean
	extrn	InpInd		:word		;InpBufInd
	extrn	InpTop		:word		;InpBufInd
	extrn	InpBuf		:byte:INPBUFSIZ ;InpBufTyp
	extrn	XlateTbl	:word:256	;array[byte] of integer
	extrn	OptRZero	:byte		;SwitchTyp

%newpage
;----------------------------------------------------------------------
	codeseg
;----------------------------------------------------------------------

extrn	GetBuf	:near	;function GetBuf: boolean;

macro		StoCnd
local	l1
		jcxz	l1
		cld
		stosb
		dec	cx
l1:
endm


macro		pushall
		push	es
		push	si
		push	di
		push	bx
		push	cx
endm


macro		popall
		pop	cx
		pop	bx
		pop	di
		pop	si
		pop	es
endm

%newpage
;
; function GetChar: boolean;
; Result (true/false) both in AL (1/0) and in z-flag (cond NZ/Z)
;
; Called from GetLine: preserve BP,SS,DS,ES,SI,DI,BX,CX
;
proc		GetChar near

		xor	al,al
		cmp	[SaveSta],al		;if SaveSta
		je	@@gc0			;then begin
		mov	[SaveSta],al		; SaveSta:= false;
		jmp	short @@gcRetT		; GetChar:= true;
						;end

@@gc0:		cmp	[InpEof],al		;else if InpEof
		jne	@@gcRet 		;then GetChar:= false

@@gc1:						;else begin
		mov	ax,[InpInd]		; if InpInd < InpTop
		cmp	ax,[InpTop]
		jb	@@gc2
		pushall
		call	GetBuf			; or GetBuf
		popall
		and	al,al
		jz	@@gcRet 		; then begin
@@gc2:		push	si
		mov	si,[InpInd]		;  CurChar:=
		mov	al,[InpBuf+si]		;   XlateTbl[InpBuf[BufInd]];
		inc	si			;   Inc(BufInd);
		mov	[InpInd],si
		xor	ah,ah
		mov	si,ax
		add	si,si
		mov	dx,[XlateTbl+si]
		mov	[CurChar],dx
		pop	si
		sub	al,EofChar		;  if InpBuf[BufInd]=EofChar
		jnz	@@gcRetT		;  then begin
		mov	[InpEof],1		;   InpEof:= true;
		jmp	short @@gcRet		;   GetChar:= false;
						;  end
						;  else GetChar:= true;

@@gcRetT:	mov	al,1			; end
						; else GetChar:= false;
						;end;
@@gcRet:	and	al,al			;set Z-flag to reflect result
		ret

endp		GetChar


%newpage
;
; function GetLine: boolean;
;
; Called from Turbo Pascal: preserve SS,DS,BP
;
; Register usage :
;	es:di	txt ptr
;	ds:si	sep ptr
;	bl	EndLine flag
;	bh	InAnsi state
;	cx	txt char count
;
proc		GetLine near
public		GetLine

		call	GetChar 		;if not GetChar
		jnz	@@gl1
		ret				; then return false;

@@gl1:		mov	ax,ds
		mov	es,ax
		mov	di,offset CurLine.txt	;es:di:= CurLine.txt ptr
		mov	si,offset CurLine.sep	;ds:si:= CurLine.sep ptr
		mov	cx,MAXTXT		;cx = txt byte count

						;with CurLine do begin

		xor	ax,ax
		cld
		stosb				; txt:= ''
		mov	[si],al 		; sep:= ''
		mov	bx,ax			; EndLine:=false; InAnsi:=0;

@@glRepeat:					; repeat
		cmp	[byte ptr OptRZero],On	;  if OptRZero = On
		jne	@@glChr 		;  then case InAnsi of
		and	bh,bh
		jnz	@@glCase1
		cmp	[word ptr CurChar],Escape;   0: if CurChar = Escape
		jne	@@glChr 		;	then begin
		inc	bh			;	  Inc(InAnsi);
		mov	[word ptr CurChar],SkipCode;	  CurChar:= SkipCode;
		jmp	short @@glChr		;	end;
@@glCase1:	cmp	bh,1
		jne	@@glCase2
		cmp	[word ptr CurChar],'['	;    1: if CurChar = '['
		jne	@@glCase1a		;	then begin
		inc	bh			;	  Inc(InAnsi);
		mov	[word ptr CurChar],SkipCode;	  CurChar:= SkipCode;
		jmp	short @@glChr		;	end
@@glCase1a:					;	else begin
		xor	bh,bh			;	  InAnsi:= 0;
		mov	al,Escape		;	  txt:= txt + Escape
		StoCnd
		jmp	short @@glChr		;	end
@@glCase2:	mov	ax,[word ptr CurChar]	;    2: begin
		cmp	al,'A'			;	  if IsAlpha(CurChar)
		jb	@@glCase2b
		cmp	al,'Z'
		jna	@@glCase2a
		cmp	al,'a'
		jb	@@glCase2b
		cmp	al,'z'
		ja	@@glCase2b
@@glCase2a:	xor	bh,bh			;	  then InAnsi:= 0;
@@glCase2b:	mov	[word ptr CurChar],SkipCode;	  CurChar:= SkipCode;
						;	end;
@@glChr:					;  end;

		mov	ax,[CurChar]		;  case CurChar of

		cmp	ax,SkipCode		;   SkipCode: { skip };
		je	@@glEndCase

		cmp	ax,SoftCR		;   SoftCR,
		je	@@glCR
		cmp	ax,CR			;   CR:
		jne	@@glLF			;    begin
@@glCR: 	mov	bx,0001h		;     EndLine:= true;
						;     InAnsi := 0;
		mov	[byte ptr si],1 	;     sep:= chr(CurChar);
		mov	[si+1],al

		call	GetChar 		;     if GetChar
		jz	@@glEndCase		;     then begin
		mov	ax,[CurChar]		;      if CurChar = LF
		cmp	ax,LF
		jne	@@glCR1 		;      then
		mov	[byte ptr si],2 	;	sep:= sep+chr(CurChar)
		mov	[si+2],al
		jmp	short @@glEndCase	;      else
@@glCR1:	mov	[SaveSta],1		;	SaveSta:= true;
		jmp	short @@glEndCase	;     end;

@@glLF: 	cmp	ax,LF			;   LF,
		je	@@glFF
		cmp	ax,FF			;   FF:
		jne	@@glOther		;    begin
@@glFF: 	mov	bx,0001h		;     EndLine:= true;
						;     InAnsi := 0;
		mov	[byte ptr si],1 	;     sep:= chr(CurChar);
		mov	[si+1],al
		jmp	short @@glEndCase	;    end {case LF,FF}

@@glOther:					;   else
		StoCnd				;    txt:= txt + CurChr;

@@glEndCase:					;  end; {all cases}
		and	bl,bl			; until EndLine
		jnz	@@gl2
		call	GetChar 		;    or not GetChar;
		jz	@@gl2
		jmp	@@glRepeat
@@gl2:		mov	ax,di			; set txt length byte
		dec	ax
		mov	di,offset CurLine.txt
		sub	ax,di
		mov	[di],al

		mov	al,1			; return true;
		ret				;end {with CurLine do}

endp		GetLine


		end
