//---------------------------------------------------------------------------
#include <vcl\sysutils.hpp>	// for ExtractFileName() and ExtractFileExt()
#include <vcl/dstring.h>	// for AnsiString
#pragma hdrstop

#include "sysutilsx.h"
//---------------------------------------------------------------------------
AnsiString ExtractFileRoot(AnsiString FileName)
/*
	Extracts the name part of FileName.  The resulting string is the
    leftmost characters of FileName, starting with the first character
    after the colon or backslash that separates the path information
    from the name, through to the last character before the period that
    separates the name from the extension. The resulting string exludes
    the period character that separates the name and extension parts.
    The resulting string is equal to FileName if FileName contains no
    drive, directory and extension parts.
*/
{
	AnsiString root = ExtractFileName(FileName);
	AnsiString ext = ExtractFileExt(FileName);
    if (root.IsEmpty() || ext.IsEmpty())	return root;

	int pos = root.Length() - ext.Length();
    return root.SubString(1,pos);
}
//---------------------------------------------------------------------------
AnsiString ReplaceFileExt(AnsiString FileName, AnsiString ext)
/*
	Substitutes the new extension 'ext' in FileName.  'ext' should
    include the period (.) separator.
*/
{
	return ExtractFilePath(FileName) + ExtractFileRoot(FileName) + ext;
}
//---------------------------------------------------------------------------

