        page    66,80
        TITLE   EJECT 1.3  start a fresh page on LPT1:
Comment 

Copyright (C) 1992, 1996

This program may be freely copied and used for any purpose
except military.


Purpose
*******

EJECT simply emits a FormFeed to LPT1: using the BIOS interrupt.
This makes the printer skip to a new page.  If the FormFeed
could not be sent successfully, the program sets the errorlevel
to 1.

Futures
*******

This is an utterly trivial program.  Cleverer versions might
allow you to say EJECT LPT1: or EJECT LPT2: (or even COM1: LPT4:
etc).


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com

version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address


 ; end of comment


stack   segment stack           ; keep MS link happy by providing null stack
stack   ends

CODE    SEGMENT PARA            ; start off in code.


data    segment byte            ; provide a separate DATA segment
                                ; actually all come after the code

;==============================================================
; E Q U A T E S

ThePort EQU     0               ; 0=LPT1: 1=LPT2:
                                ; change this line to build a version
                                ; that uses port LPT2: instead

;==============================================================

;  V A R I A B L E S


; We don't ever display the banner
BannerMsg DB ' EJECT 1.3 ۲',13,10
        DB      13,10
        DB      'Copyright 1992-1999 by Roedy Green Canadian Mind Products',13,10
        DB      'May be freely copied and used for any purpose but military.',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10

BannerEnd       label   byte


data            ends

                org     100h

com     group   code,data       ; force data segment to go at the end!

        ASSUME  CS:com,DS:com,ES:com,SS:com
                                ; seg regs cover everything
        ORG     100H            ; in Code segment

;==========================

Start   proc    far

;       M A I N L I N E   R O U T I N E

        mov     al,12d          ; FormFeed is chr(12)
        mov     ah,00           ; function code for write char
        mov     dx,ThePort      ; 0=LPT1: 1=LPT2:
        int     17h             ; BIOS printer service
                                ; on return AH has status.

                                ; We want bit 5 = 0 - not out of paper
                                ;             4 = 1 - is selected
                                ;             3 = 0 - not i/o error
                                ;             0 = 0 - not timeout
                                ;      54 3210
                                ;      11 1001 = 39h = mask
                                ;      01 0000 = 10h = desired value
        and     ah,39h          ; mask out irrelevant status
        cmp     ah,10h
        mov     al,0            ; assume all is ok, use 0 errorlevel.
        je      AllOk
        mov     al,1            ; trouble, use 1 errorlevel.
Allok:
        mov     ah,4ch          ; Exit function code
        INT     21H

;=============================

Start   endp

;==========================
CODE    ends                    ; end of code segment
        end     Start
