Program ShowFont;
{$X+}  { Extended syntax ON (TP6+) }


Uses  Graph, CRT;

const InterRows = 3;             { Blank pixels between two rows }
      PathToBGI = 'C:\BP\BGI';   { Insert your path here! }

var   FontName     : string;
      Driver, Mode : integer;
      ErrCode      : integer;
      UserFont     : integer;
      i            : byte;


begin
   if ParamCount = 0 then
      begin
         writeln('Syntax:  SHOWFONT <FontName>');
         halt
      end;

   FontName := ParamStr(1);
   UserFont := InstallUserFont(FontName);
   if GraphResult <> grOk then
      begin
         WriteLn('Error installing ', FontName);
         halt(1)
      end;

   Driver := detect;
   InitGraph(Driver, Mode, PathToBGI);
   ErrCode := GraphResult;
   if ErrCode <> grOk then
      begin
         WriteLn('Graphics error: ', GraphErrorMsg(ErrCode));
         halt(1)
      end;

   SetTextStyle(UserFont, HorizDir, 4);
   ErrCode := GraphResult;
   if ErrCode <> grOK then
      begin
         CloseGraph;
         WriteLn('Graphics error: ', GraphErrorMsg(ErrCode));
         halt(1)
      end;

   bar(0,0, GetMaxX,GetMaxY);    { White background }
   SetTextJustify(LeftText, TopText);
   SetColor(black);

   MoveTo(10,10);
   for i := 0 to 255 do
      if TextWidth(chr(i)) > 0 then     { IF char is defined THEN... }
         begin
            if GetX + TextWidth(chr(i)) >= GetMaxX then      { IF current row is full THEN... }
               if GetY + TextHeight('A')*2 + InterRows < GetMaxY then   { IF there is enough space for a new row THEN.... }
                  MoveTo(10, GetY + TextHeight('A') + InterRows)
               else
                  begin    { The screen is full. }
                     ReadKey;                       { Wait for a key. }
                     while KeyPressed do ReadKey;   { Empty keyboard buffer. }
                     bar(0,0, GetMaxX,GetMaxY);     { Clear screen. }
                     MoveTo(10,10)
                  end;
               OutText(chr(i));
         end;

  ReadKey;                       { Wait for a key. }
  while KeyPressed do ReadKey;   { Empty keyboard buffer. }

  Closegraph
end.
