'
'  DOSPDF Copyright (C) Mateusz Viste "Fox"
'  Written in FreeBASIC v0.17, powered by FreeDOS!
'
' This program is free software; you can redistribute it and/or modify it
' under the terms of the GNU General Public License as published by the Free
' Software Foundation; either version 2 of the License, or (at your option)
' any later version.
'
' This program is distributed in the hope that it will be useful, but WITHOUT
' ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
' FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
' more details.
'
' You should have received a copy of the GNU General Public License along
' with this program; if not, write to the Free Software Foundation, Inc.,
' 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
'----------------------------------------------------------------------------
'
DECLARE SUB SaveExit()
DECLARE SUB SetPath()
DECLARE SUB SetRes()
DECLARE SUB SetScr()
DECLARE SUB DetectDefaults()
DECLARE SUB DetectCurrents()
DECLARE SUB InitScreen()
CONST pVer AS STRING = "0.11"
CONST pDate AS STRING = "2007"
DIM SHARED AS STRING DosPdfPath, TempString
DIM SHARED AS UBYTE Res, Dpi
DIM SHARED AS BYTE Choice, TempByte
DIM SHARED ResTable(1 TO 5) AS STRING
DIM SHARED DpiTable(1 TO 5) AS STRING
DIM SHARED LxPicRes(1 TO 5) AS STRING
ResTable(1) = "640x480" : ResTable(2) = "800x600" : ResTable(3) = "1024x768" : ResTable(4) = "1280x1024" : ResTable(5) = "1600x1200"
DpiTable(1) = "75" : DpiTable(2) = "94" : DpiTable(3) = "120" : DpiTable(4) = "150" : DpiTable(5) = "188"
LxPicRes(1) = "6" : LxPicRes(2) = "9" : LxPicRes(3) = "12" : LxPicRes(4) = "15" : LxPicRes(5) = "18"

DetectCurrents
InitScreen
Choice = 1
DO
   IF Choice > 3 THEN Choice = 0
   IF Choice < 0 THEN Choice = 3
   IF Choice = 1 THEN COLOR 7, 1
   LOCATE 10, 18: PRINT "  DOSPDF path  "; : COLOR 7, 0
   LOCATE 10, 35: PRINT DosPdfPath;
   IF Choice = 2 THEN COLOR 7, 1
   LOCATE 11, 18: PRINT "  Screen Size  "; : COLOR 7, 0
   LOCATE 11, 35: PRINT ResTable(Res);
   IF Choice = 3 THEN COLOR 7, 1
   LOCATE 12, 18: PRINT "  Resolution   "; : COLOR 7, 0
   LOCATE 12, 35: IF Dpi = 0 THEN PRINT "AUTO ["; DpiTable(Res); " dpi]"; ELSE PRINT Dpi; " dpi";
   IF Choice = 0 THEN COLOR 7, 1
   LOCATE 13, 18: PRINT "  SAVE & EXIT  "; : COLOR 7, 0
   DO: TempString = INKEY: LOOP UNTIL TempString <> ""
   IF TempString = CHR(255) + "H" THEN Choice -= 1
   IF TempString = CHR(255) + "P" THEN Choice += 1
   IF TempString = CHR(27) THEN COLOR 7, 0: CLS: PRINT "Aborted.": END(127)
   IF TempString = CHR(13) THEN
      IF Choice = 1 THEN SetPath
      IF Choice = 2 THEN SetScr
      IF Choice = 3 THEN SetRes
      IF Choice = 4 THEN DetectDefaults
      IF Choice = 0 THEN EXIT DO
   END IF
LOOP

SaveExit
COLOR 7, 0
CLS
PRINT "Setup done.  You can use DOSPDF now to read your favorite PDF files!"
END

REM   ****  END OF THE MAIN MODULE  ****

SUB DetectCurrents
  IF DIR("SETUP.CFG") = "" THEN
      DetectDefaults
    ELSE
      OPEN "SETUP.CFG" FOR INPUT AS #1
      LINE INPUT #1, DosPdfPath
      INPUT #1, Res, Dpi
      CLOSE #1
  END IF
END SUB

SUB DetectDefaults
  DosPdfPath = EXEPATH          ' Default = Current path
  DO
    TempByte = INSTR(DosPdfPath, "/")
    IF TempByte > 0 THEN MID(DosPdfPath, TempByte, 1) = "\"
  LOOP UNTIL INSTR(DosPdfPath, "/") = 0
  Res = 1                       ' Default = Max allowed by the video card
  Dpi = 0                       ' AUTO setting
END SUB

SUB SaveExit
  OPEN "DOSPDF.BAT" FOR OUTPUT AS #1
  PRINT #1, "@ECHO OFF"
  PRINT #1, "REM *****************************************************************************"
  PRINT #1, "REM  DOSPDF v"; pVer; " -- http://mateusz.viste.free.fr/dos"
  PRINT #1, "REM  You shouldn't modify this file, as it is automatically generated by DOSPDF."
  PRINT #1, "REM  Any changes will be lost at the next use of DOSPDF setup program."
  PRINT #1, "REM *****************************************************************************"
  PRINT #1, "REM  This batch file is projected to run on FreeDOS. It probably won't run on
  PRINT #1, "REM  any other DOS, as it requires the command 'CDD' to work properly.
  PRINT #1, "REM *****************************************************************************"
  PRINT #1,
  PRINT #1, "SET DOSPDF="; DosPdfPath
  PRINT #1,
  PRINT #1, "IF EXIST %1 GOTO FileFound"
  PRINT #1, "GOTO NoFile"
  PRINT #1, ":FileFound"
  PRINT #1, "IF EXIST %DOSPDF%\TEMP\PAGE??.PCX DEL %DOSPDF%\TEMP\PAGE??.PCX"
  PRINT #1, "%DOSPDF%\PDFTOPS\PDFTOPS %1 %DOSPDF%\TEMP\OUT.PS"
  PRINT #1, "CD %DOSPDF%\GS"
  PRINT #1, "CDD %DOSPDF%\GS"
  IF Dpi = 0 THEN
      PRINT #1, "DOS4GW GS386 -q -sDEVICE=pcx24b -sOutputFile=..\TEMP\page0%d.pcx -dDISKFONTS -dNOPAUSE -r"; DpiTable(Res); " ..\TEMP\OUT.PS QUIT.PS"
    ELSE
      PRINT #1, "DOS4GW GS386 -q -sDEVICE=pcx24b -sOutputFile=..\TEMP\page0%d.pcx -dDISKFONTS -dNOPAUSE -r"; Dpi; " ..\TEMP\OUT.PS QUIT.PS"
  END IF
  PRINT #1, "CD .."
  PRINT #1, "DEL %DOSPDF%\TEMP\OUT.PS"
  PRINT #1, "%DOSPDF%\LXPIC\LXPIC %DOSPDF%\TEMP\PAGE??.PCX /"; LxPicRes(Res)
  PRINT #1, "GOTO KONIEC"
  PRINT #1,
  PRINT #1, ":NoFile"
  PRINT #1, "ECHO The file '%1' can't be found!"
  PRINT #1, "ECHO Usage: DOSPDF file.pdf"
  PRINT #1,
  PRINT #1, ":KONIEC"
  PRINT #1, "SET DOSPDF="
  CLOSE #1
  REM  *** NOW, WRITE THE CFG FILE ***
  OPEN "SETUP.CFG" FOR OUTPUT AS #1
  PRINT #1, DosPdfPath
  PRINT #1, Res, Dpi
  CLOSE #1
END SUB

SUB SetRes
   LOCATE ,,1   ' Enabling the blinking text cursor
   LOCATE 18, 2: PRINT "Ŀ";
   LOCATE 19, 2: PRINT " Enter the resolution [dpi] to use (leave it blank to use automatic value)  ";
   LOCATE 20, 2: PRINT "                                                                            ";
   LOCATE 21, 2: PRINT "";
   LOCATE 20, 4: COLOR 7, 8: PRINT "                                                                          ";
   LOCATE 20, 4: LINE INPUT "", TempString
   Dpi = INT(ABS(VAL(TempString)))
   COLOR 7, 0
   InitScreen
END SUB

SUB SetScr
' ***  1=640x480 * 2=800x600 * 3=1024x768 * 4=1280x1024 * 5=1600x1200
DIM AS BYTE ChoiceX = Res
LOCATE 16, 29: PRINT "Ŀ";
LOCATE 17, 29: PRINT "           ";
LOCATE 18, 29: PRINT "           ";
LOCATE 19, 29: PRINT "           ";
LOCATE 20, 29: PRINT "           ";
LOCATE 21, 29: PRINT "           ";
LOCATE 22, 29: PRINT "";
DO: TempString = INKEY
  IF ChoiceX > 5 THEN ChoiceX = 1
  IF ChoiceX < 1 THEN ChoiceX = 5
  IF ChoiceX = 1 THEN COLOR 7, 1 ELSE COLOR 7, 0
  LOCATE 17, 30: PRINT "  640x480  ";
  IF ChoiceX = 2 THEN COLOR 7, 1 ELSE COLOR 7, 0
  LOCATE 18, 30: PRINT "  800x600  ";
  IF ChoiceX = 3 THEN COLOR 7, 1 ELSE COLOR 7, 0
  LOCATE 19, 30: PRINT " 1024x768  ";
  IF ChoiceX = 4 THEN COLOR 7, 1 ELSE COLOR 7, 0
  LOCATE 20, 30: PRINT " 1280x1024 ";
  IF ChoiceX = 5 THEN COLOR 7, 1 ELSE COLOR 7, 0
  LOCATE 21, 30: PRINT " 1600x1200 ";
  IF TempString = CHR(255) + "H" THEN ChoiceX -= 1
  IF TempString = CHR(255) + "P" THEN ChoiceX += 1
LOOP UNTIL TempString = CHR(13) OR TempString = CHR(27)
IF TempString = CHR(13) THEN Res = ChoiceX
InitScreen
END SUB

SUB SetPath
   LOCATE ,,1   ' Enabling the blinking text cursor
   LOCATE 18, 10: PRINT "Ŀ";
   LOCATE 19, 10: PRINT " Enter the full DOSPDF's path (leave it blank for auto) ";
   LOCATE 20, 10: PRINT "                                                        ";
   LOCATE 21, 10: PRINT "";
   LOCATE 20, 12: COLOR 7, 8: PRINT "                                                      ";
   LOCATE 20, 12: LINE INPUT "", DosPdfPath
   DosPdfPath = TRIM(DosPdfPath)
   IF DosPdfPath = "" THEN DosPdfPath = EXEPATH
   COLOR 7, 0
   DO
     TempByte = INSTR(DosPdfPath, "/")
     IF TempByte > 0 THEN MID(DosPdfPath, TempByte, 1) = "\"
   LOOP UNTIL INSTR(DosPdfPath, "/") = 0
   InitScreen
END SUB

SUB InitScreen
  COLOR 7, 0
  CLS
  COLOR 14, 2
  PRINT SPACE(80);
  LOCATE 1, 2
  PRINT "DOSPDF v"; pVer; " Setup - Copyright (C) Mateusz Viste "; CHR(34); "Fox"; CHR(34); " "; pDate
  COLOR 7, 0
  LOCATE  8, 17: PRINT "ͻ";
  LOCATE  9, 17: PRINT "               ";
  LOCATE 10, 17: PRINT "               ";
  LOCATE 11, 17: PRINT "               ";
  LOCATE 12, 17: PRINT "               ";
  LOCATE 13, 17: PRINT "               ";
  LOCATE 14, 17: PRINT "               ";
  LOCATE 15, 17: PRINT "ͼ";
  COLOR 8, 0
  LOCATE 25,  1: PRINT "Use UP & DOWN arrows to select an option, then ENTER to change it. ESC to abort.";
  COLOR 7, 0
  LOCATE ,,0   ' Hiding the blinking text cursor
END SUB
