/*
    ConvPL by kravietZ

    DispH()     tekst pomocy
    DispL()     licencja uzytkownika
    DispS()     lista zaimplementowanych standardow

    tekst pomocy oraz licencja sa wyswietlane na stdout, aby ulatwic
    skierowanie ich do pliku; pozostale napisy wyswietlane sa na
    stderr
*/

#include <stdio.h>
#include "polish.h"

extern short int ver_hi,ver_lo;

void DispH(void) {    /* display help */
    fprintf(stdout,"Skladnia: cpl <nn>[opcja] [<wejscie.txt>] [<wyjscie.txt>]\
    \nCyfry <nn> okreslaja standard zrodlowy i docelowy. Dostepne standardy:\
    \n  0: bez polskich liter (ASCII)       a: Microvex\
    \n  1: Mazovia                          b: Amiga PL\
    \n  2: FidoMazovia                      c: CP/J (Elwro 800 Junior)\
    \n  3: IBM-Latin/2 (CP852)              d: Amiga FAT\
    \n  4: ISO-Latin/2 (ISO-8859/2)         e: Windows 3.0 (CP1250)\
    \n  5: DHN                              f: Amiga XJP\
    \n  6: CSK                              g: Ventura\
    \n  7: Cyfromat                         h: Macintosh\
    \n  8: IEA                              i: TeX PL\
    \n  9: LOGIC                            j: Corel 2.0\
    \nSkroty <nn>: l: Mazovia->IBM Latin2,  m: IBM Latin2->Mazovia,\
    \n             x: Mazovia->ASCII,       y: IBM Latin2->ASCII,\
    \n             z: Fido-Mazovia->Mazovia L: wyswietlenie licencji programu\
    \n             S: tabelka dostepnych standardow\
    \nOpcje DOS/Unix/Amiga:\
    \n  -: -> Unix, Amiga   (konwersja CR+LF --> NL)\
    \n  =: -> DOS           (konwersja NL --> CR+LF)\
	\nPrzyklady:\
    \n  cpl 30 joke.txt  - IBM Latin2->ASCII  (lub prosciej: cpl y joke.txt)\
    \n  cpl 13- joke.txt  - Mazovia->IBM Latin2, rownolegle DOS --> Unix\
    \nSzczegoly w dokumentacji.                           <ConvPL v%u.%u>\
    \n",ver_hi,ver_lo);
};

void DispL(void) { /* display licence */
fprintf(stdout,"\n\
ConvPL i QueryPL sa programami freeware. Autor zachowuje pelnie praw autorskich\n\
do obu programow. Ich uzywanie jest darmowy tylko w przypadku wykorzystania\n\
przez osoby prywatne lub w instytucjach edukacyjnych. W innych przypadkach\n\
nalezy skontaktowac sie z autorem programu w celu ustalenia warunkow licencji.\n\
Program mozna bez przeszkod kopiowac ale pod warunkiem ze w sklad pakietu\n\
wchodza niezmienione pliki wykonywalne, kod zrodlowy oraz dokumentacja.\n\
Zabronione jest pobieranie oplat za udostepnianie tego programu, za wyjatkiem\n\
niewielkich oplat na wyrownania kosztow nosnika.\n\
AUTOR NIE DAJE ZADNEJ GWARANCJI DZIALANIA I NIE PONOSI ODPOWIEDZIALNOSCI\n\
ZA EWENTUALNE USZKODZENIE LUB UTRATE DANYCH POWSTALA, POSREDNIO LUB\n\
BEZPOSREDNIO, W WYNIKU DZIALANIA PROGRAMU.\n\
\n\
Pawel Krawczyk <kravietz@pipeta.chemia.pk.edu.pk> <2:486/18.4@fidonet>\
\n"); };

void DispS(void) { /* display standards */
    fprintf(stdout,"\
                           ACELNOSZZacelnoszz\n\
                           ------------------\n\
AmigaPL                  : %s\n\
ASCII                    : %s\n\
Corel 2.0                : %s\n\
CP/J (Elwro)             : %s\n\
CSK                      : %s\n\
Cyfromat                 : %s\n\
DHN                      : %s\n\
FAT (Amiga)              : %s\n\
FidoMazovia              : %s\n\
IEA                      : %s\n\
IBM-Latin/2 (CP852)      : %s\n\
ISO-Latin/2 (ISO-8859/2) : %s\n\
Logic                    : %s\n\
Macintosh                : %s\n\
Mazovia                  : %s\n\
Microvex                 : %s\n\
TeX PL                   : %s\n\
Ventura                  : %s\n\
Windows-EE (CP1250)      : %s\n\
XJP (Amiga)              : %s\n\
",p_Ami,p_Asc,p_Cor,p_CPJ,p_CSK,p_Cyf,p_DHN,p_FAT,p_FMaz,p_IEA,p_IBML,
p_ISOL,p_Log,p_Mac,p_Maz,p_Mic,p_TeX,p_Ven,p_Win3,p_XJP);
}
