/*
                               ConvPL by kravietZ
                                      v2.0

          Uniwersalny konwerter standardow polskich znakow, freeware.

          Kontakt: Pawel Krawczyk <kravietz@pipeta.chemia.pk.edu.pl>
                                  <2:486/18.4@fidonet>

          Najnowsza wersja:
          ftp://pipeta.chemia.pk.edu.pl/pub/convpl

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

#ifdef __MSDOS__
#include <io.h>
#include <sys\stat.h>
#endif

#ifdef __GNUC__
#include <sys/file.h>
#include <sys/stat.h>
#endif

#include "polish.h"    /* wersja polish.h: 4.0.20 */
#include "disph.h"
#define TEMP_FILE "tempxx.cpl"
#define BUF_SIZE (4*1024)  /* bufor 4K, optimum */
#define TO_CRLF 1
#define TO_LF 2

#ifdef __MSDOS__  
#pragma warn -pia
#pragma warn -sus
#include <dos.h>
#endif 

typedef unsigned char ubyte;

static char ibuf[BUF_SIZE], obuf[BUF_SIZE];
static int ibuf_ptr = 0, obuf_ptr = 0, ibuf_lim = 0;
static int f_in,f_out,opt_mode=0;

short int ver_lo=0;
short int ver_hi=2;

#ifdef __MSDOS__
const char *f_ext_check[14],*bin_ext_lst=".exe .com .gif .jpg";
#endif

int indexx(ubyte ch, ubyte *ctab)
/*
    zwraca indeks znaku ch w stringu okreslonym przez wskaznik ctab
    lub -1 jesli nie znajdzie znaku; indeksy zaczynaja sie od 0;
*/
{ int poss=0;
while((ch != *(ctab+poss) && (*(ctab+poss) != '\0'))) poss++;
if(*(ctab+poss) == '\0') return(-1);
 else
return(poss);
}; /* postab */

ubyte getxx (void)
{
  if (ibuf_ptr >= ibuf_lim) {               /* odebrane wszystkie? */
    ibuf_lim = read(f_in, ibuf, BUF_SIZE);  /* czytaj z pliku */
    if (ibuf_lim == 0) return -1;           /* nie ma wicej w pliku */
    ibuf_ptr = 0;                           /* inicjuj wskanik znakw */
  }
  return ibuf[ibuf_ptr++];                  /* daj znak, zwiksz wskanik */
}

void putxx (ubyte ch)
{
  if (obuf_ptr >= BUF_SIZE) {                /* bufor peny? */
    write(f_out, obuf, obuf_ptr);           /* zapisz bufor do pliku */
    obuf_ptr = 0;                           /* inicjuj wskanik znakw */
  }
  obuf[obuf_ptr++] = ch;                    /* znak do bufora, zwiksz wsk. */
}

int ConvFile(char *cf_fname,char *cf_fnameo,char st1,char st2)
/*  
    czyta z nazwy cf_fname
    zapisuje do nazwy cf_fnameo
    st1 = std zrodlowy,
    st2 = docelowy
    parametr z zewnatrz: opt_mode (konwersja koncow linii)
*/
{
    ubyte *in_tab, *out_tab;
    int ps1;
    char ch1;

#ifndef NO_LINE_CNT
    long int n_line=0;  /* numer linii */
#endif

switch(st1)     /* najpierw kontrola poprawnosci standardow */
    {
	case '1': in_tab=p_Maz; break;
	case '2': in_tab=p_FMaz; break;
	case '3': in_tab=p_IBML; break;
	case '4': in_tab=p_ISOL; break;
	case '5': in_tab=p_DHN; break;
	case '6': in_tab=p_CSK; break;
	case '7': in_tab=p_Cyf; break;
	case '8': in_tab=p_IEA; break;
	case '9': in_tab=p_Log; break;
	case 'a': in_tab=p_Mic; break;
	case 'b': in_tab=p_Ami; break;
	case 'c': in_tab=p_CPJ; break;
	case 'd': in_tab=p_FAT; break;
	case 'e': in_tab=p_Win3; break;
	case 'f': in_tab=p_XJP; break;
	case 'g': in_tab=p_Ven; break;
	case 'h': in_tab=p_Mac; break;
	case 'i': in_tab=p_TeX; break;
	case 'j': in_tab=p_Cor; break;
    default: fprintf(stderr,"\7\b\b\b\b\bnieznany standard We \"%c\".\n",st1); return(255);
    } /* switch st1 */

switch(st2)
    {
    case '0': out_tab=p_Asc; break;
    case '1': out_tab=p_Maz; break;
    case '2': out_tab=p_FMaz; break;
    case '3': out_tab=p_IBML; break;
    case '4': out_tab=p_ISOL; break;
    case '5': out_tab=p_DHN; break;
    case '6': out_tab=p_CSK; break;
    case '7': out_tab=p_Cyf; break;
    case '8': out_tab=p_IEA; break;
    case '9': out_tab=p_Log; break;
    case 'a': out_tab=p_Mic; break;
    case 'b': out_tab=p_Ami; break;
    case 'c': out_tab=p_CPJ; break;
    case 'd': out_tab=p_FAT; break;
    case 'e': out_tab=p_Win3; break;
    case 'f': out_tab=p_XJP; break;
    case 'g': out_tab=p_Ven; break;
    case 'h': out_tab=p_Mac; break;
    case 'i': out_tab=p_TeX; break;
    case 'j': out_tab=p_Cor; break;
    default: fprintf(stderr,"\7\b\b\b\b\bnieznany standard Wy \"%c\".\n",st2); return(255);
    } /* switch st2 */

    fprintf(stderr,"\n%s:      ",cf_fname);

    if( (f_in=open(cf_fname,O_RDONLY

#ifdef __MSDOS__
    |O_BINARY
#endif

    )) || !strcmp(cf_fname,"stdin") )
    {
    if( (f_out=open(cf_fnameo,O_CREAT|O_TRUNC|O_RDWR
#ifdef __MSDOS__
    |O_BINARY
#endif
    |S_IFREG|S_IREAD|S_IWRITE))
			      || !strcmp(cf_fnameo,"stdout") )
        {

if(!strcmp(cf_fname,"stdin"))
        {
	    fprintf(stderr,"\n");
            while((ch1=fgetc(stdin)) != EOF) switch(opt_mode)
            {
case TO_CRLF: { if(ch1==10) { fputc(13,stdout); fputc(10,stdout); } else { if( (ps1=indexx(ch1,in_tab)) != -1 ) fputc(*(out_tab+ps1),stdout); else fputc(ch1,stdout); }; break; }
case TO_LF: { if(ch1==13) { break; } else {if( (ps1=indexx(ch1,in_tab)) != -1 ) fputc(*(out_tab+ps1),stdout); else fputc(ch1,stdout); }; break; }
default: { if( (ps1=indexx(ch1,in_tab)) != -1 ) fputc(*(out_tab+ps1),stdout); else fputc(ch1,stdout); break; }
             } /* switch */
        return(0);
        } /* if(stdin) */

while((ch1=getxx()) != -1)
    {   /* opt_mode = 0 jesli nie crlf, 1,2 jesli konw. crlf */
    switch(opt_mode) {
case TO_CRLF: { if(ch1==10) { putxx(13); putxx(10);
	  #ifndef NO_LINE_CNT
	    n_line++; fprintf(stderr,"\b\b\b\b\b%-5u",n_line);
	  #endif
	 } else { if( (ps1=indexx(ch1,in_tab)) != -1 ) putxx(*(out_tab+ps1)); else putxx(ch1); }; break; }
case TO_LF: { if(ch1==13) {
	  #ifndef NO_LINE_CNT
	    n_line++; fprintf(stderr,"\b\b\b\b\b%-5u",n_line);
	  #endif
	   break; } else { if( (ps1=indexx(ch1,in_tab)) != -1 ) putxx(*(out_tab+ps1)); else putxx(ch1); }; break; }
default: { if( (ps1=indexx(ch1,in_tab)) != -1 ) putxx(*(out_tab+ps1)); else putxx(ch1);

	  #ifndef NO_LINE_CNT
	    n_line++; fprintf(stderr,"\b\b\b\b\b%-5u",n_line);
	  #endif

	  break; }
    } /* switch */
}; /* while */

/* zrzucamy bufor do pliku */

    if (obuf_ptr < BUF_SIZE) { write(f_out, obuf, obuf_ptr); }

       close(f_out);
     } /* open(f_out) */
       close(f_in);
       fprintf(stderr,"ok.\n");
     } /* open(f_in) */
else { fprintf(stderr,"nie mozna otworzyc pliku"); }

return(0);

} /* convfile */

/*                          --- MAIN ---               */

int main(argc, argv)
int argc;
char **argv;
{

char swt[4];
char *p_swt=swt;
char st_in,st_out;

#ifdef MSDOS
 struct ffblk ffblk; /* struktury dla findnext */
 int ff_result;
 char f_drvx[MAXDRIVE],f_dirx[MAXDIR],f_namx[MAXFILE],f_extx[MAXEXT],fr_name[14];
#endif

fprintf(stderr,"\n[ConvPL] by kravietZ, v%u.%u konwerter standardow polskich \
liter. Freeware.\n",ver_hi,ver_lo);

if(argc>1)
{

/* sprawdz konwersje koncow linii [ uzywam wlasnego index() ]*/
if(indexx('=',argv[1]) != -1) opt_mode=TO_CRLF;
if(indexx('-',argv[1]) != -1) opt_mode=TO_LF;

/* sprawdzanie makr */
switch(*argv[1])
{
    case 'l':   strncpy(p_swt,"13",2); break;
    case 'm':   strncpy(p_swt,"31",2); break;
    case 'x':   strncpy(p_swt,"10",2); break;
    case 'y':   strncpy(p_swt,"30",2); break;
    case 'z':   strncpy(p_swt,"21",2); break;
    case 'S':   DispS(); exit(1); /* lista standardow */
    case 'L':   DispL(); exit(1); /* licencja uzytkownika */
    default:   strcpy(p_swt,argv[1]);
}; /* sprawdzanie makr */

/* -- decode params */

st_in=swt[0];
st_out=swt[1];

if(argc==2) { ConvFile("stdin","stdout",st_in,st_out ); unlink("stdout"); exit(0);  }
  else
   if(argc==3) { ConvFile(argv[2],TEMP_FILE,st_in,st_out );
                 unlink(argv[2]);
                 rename(TEMP_FILE,argv[2]);
/*               exit(0); */
                }
    else if(argc>3) { ConvFile(argv[2],argv[3],st_in,st_out );
/*                    exit(0); */
                    }

/* -- reszta */

}
      else
{
    DispH();
    return(1);
} /* argc<2 */

return(0);
} /* main */
