{ FONT2CHR V1.06                                                           }
{                                                                          }
{ Very crude utility to split a font data file into multiple files, each   }
{ containing data for one character. Allows to collect character bitmap    }
{ files, that might be concatenated to new font files later (with another  }
{ utility).                                                                }
{                                                                          }
{ Written for Borland Pascal 7.0.                                          }
{                                                                          }
{ 18.07.1996 -mp                                                           }

{$IFDEF DEBUG}
{$A+,B-,D+,E+,F-,G-,I+,L+,N-,O-,P-,Q+,R+,S+,T+,V+,X+}
{$ELSE}
{$A+,B-,D-,E+,F-,G-,I+,L-,N-,O-,P-,Q-,R-,S+,T-,V+,X+}
{$ENDIF}
{$M 20000, 0, 65535}
{$D FONT2CHR (C) 1996 by Matthias Paul - Utility to split binary font files to single character files }

Program FONT2CHR;

Uses
 DOS, CUI_Lib;

Const
 MainVerStr = '1';
 SubVerStr  = '06';
 { Application descriptions for Novell's VERSION.EXE utility }
 Version    = 'VeRsIoN='+MainVerStr+'.'+SubVerStr+' (960718)'+Chr(NUL)+Chr(CR)+Chr(LF);
 Copyright  = 'CoPyRiGhT=(C) 1996 by Matthias Paul <MPaul@ibh.rwth-aachen.de>'+Chr(NUL)+Chr(CR)+Chr(LF);

Var
 fontdata : Array [0..32767] Of Byte; { buffer }
 f1, f2   : File;
 in_path  : PathStr;
 dir      : DirStr;
 name     : NameStr;
 ext      : ExtStr;
 pswd     : PassStr;
 index    : Word;
 cellsize : Byte;
 codepage : Word;
 error    : Integer;
 offset   : Word;
 dummy    : String;

Function HexPrint (w: LongInt; nr: Byte): String;
 Const
  hex_table: Array [0..15] Of Char = '0123456789ABCDEF';
 Var
  c: Char;
 Begin
  c:=hex_table[w AND $0F];
  If (nr > 1) Then HexPrint:=HexPrint(w SHR 4, Pred(nr)) + c
  Else             HexPrint:=c;
 End; {HexPrint}

Begin
 offset:=0;
 OrgCmdLine :=OrgCmdLine+' '+EnvCmdLine+' '+ExtCmdLine;
 UpStrC(OrgCmdLine);
 WriteLnANSI(TitleColor, 'FONT2CHR '+VerSym+MainVerStr+SubVerSym+SubVerStr+
             ' '+CopyrightSym+' 1996 by Matthias Paul');
 WriteLn('Utility splits font data to ASCII character files.');
 If (StrCount(OrgCmdLine) In [3, 4]) Then
  Begin
   in_path:=FExpandDR(SubStr(OrgCmdLine, 1));
   FSplitDR(in_path, dir, name, ext, pswd);
   ext:=ToUpperC(ext);
   If (ext <> '.CHR') Then
    Begin
     ValWord(SubStr(OrgCmdLine, 2), index, error);
     If (index In [6, 8, 14, 16]) Then
      Begin
       cellsize:=index;
       ValWord(SubStr(OrgCmdLine, 3), codepage, error);
       If (error = 0) Then
        If (codepage < 4096) Then
         If (StrCount(OrgCmdLine) = 4) Then
          Begin
           ValWord(SubStr(OrgCmdLine, 4), offset, error);
           If (error <> 0) Then
            WriteLnANSI(ErrorColor, '  Error: Parameter <offset> [0..65535] is invalid!');
          End
         Else Begin End
        Else
         Begin
          WriteLnANSI(ErrorColor, '  Error: Parameter <codepage> [0..4095] is invalid!');
          error:=1;
         End
       Else
        WriteLnANSI(ErrorColor, '  Error: Parameter <codepage> [0..4095] is invalid!');;
      End
     Else
      Begin
       WriteLnANSI(ErrorColor, '  Error: Parameter <cellsize> [6, 8, 14, 16] is invalid!');
       error:=1;
      End;
     If (error = 0) Then
      Begin
       WriteLn('  Font filename: ', in_path);
       Assign(f1, in_path);
       Reset(f1, 1);
       WriteLn('  Data offset in file: ', HexPrint(offset, 4), 'h');
       If (((FileSize(f1)-offset) MOD cellsize) = 0) Then
        Begin
         If ((FileSize(f1)-offset) <= SizeOf(fontdata)) Then
          Begin
           Seek(f1, offset);
           BlockRead(f1, fontdata, FileSize(f1)-offset);
           WriteLn('  Creating character files...');
           For index:=0 To Pred((FileSize(f1)-offset) DIV cellsize) Do
            Begin
             name:='D'+HexPrint(index, 3)+HexPrint(codepage, 3)+HexPrint(Pred(cellsize), 1);
             Write(Chr(CR), '  ', name+'.CHR');
             Assign(f2, dir+name+'.CHR');
             Rewrite(f2, 1);
             BlockWrite(f2, fontdata[index*cellsize], cellsize);
             Close(f2);
            End; {For}
           WriteLn(Chr(CR), '              ' , Chr(CR), ' Finished.');
          End
         Else
          WriteLn(ErrorColor, '  Error: Font file too big!');
        End
       Else WriteLnANSI(ErrorColor, '  Error: Font file cannot contain binary font as it''s size does not match!');
       Close(f1);
      End;
    End
   Else
    WriteLnANSI(ErrorColor, '  Error: Extension of input font filename may not be <.CHR>');
  End
 Else
  Begin
   WriteLn;
   WriteLn('  Syntax:');
   WriteLn;
   WriteLn('  FONT2CHR [@] [@] <input font filename> <cellsize> <codepage> [<offset>] [',
           DispParam('?', FALSE), '|', DispParam('&', FALSE), ']');
   Writeln;
   WriteLn('           <input font filename> = binary font data file');
   WriteLn('           <cellsize>            = bytes per character in font');
   WriteLn('           <codepage>            = codepage (for naming conventions)');
   WriteLn('           <offset>              = optionally offset of data in file; <0>');
   WriteLn('           [', DispParam('?', FALSE), '|', DispParam('&', FALSE),
           ']                 = online edit (prompts for parameter input)');
   WriteLn;
   WriteLn('  Output files will follow naming convention: Dxxxyyyz.CHR');
   WriteLn;
   WriteLn('           <xxx>                 = hex chr-no.; 000..7FF, ASCII 000..0FF');
   WriteLn('           <yyy>                 = hex codepage-no.; 000..FFF');
   WriteLn('           <z>                   = hex cellsize-1; 5, 7, D, F');
  End;
 dummy:=Version; { for Novell's VERSION.EXE utility }
 dummy:=Copyright;
End.
