{ ######################################################################### }
{ File     : CUI_LIB.PAS                                                    }
{ Copyright: (C) 1994-1996 by Axel C. Frinke  &  Matthias Paul              }
{                             Steinstrae 11     Ubierstrae 28             }
{                             D-53332 BORNHEIM   D-50321 BRHL              }
{                             GERMANY            GERMANY                    }
{                       <ACFrinke@uni-bonn.de>   <MPaul@ibh.rwth-aachen.de> }
{                          <Frinke@cs.bonn.de>                              }
{ Version  : 1.14                                                           }
{ Last Edit: 18.07.1996 -mp                                                 }
{                                                                           }
{ Purpose  : Unit for generic user interface routines, used in console      }
{            driven DOS utilities [CUI=Console User Interface]. Some items: }
{            ANSI coloring; special environment variable handling; 4DOS/NDOS}
{            description file evaluation; strings processing; evaluation of }
{            values; command line parameter handling; online edit mode.     }
{            For example applications (with sources) and user documentation }
{            have a look at our FreeWare K3PLUS, CPI and COUNTRY packages.  }
{                                                                           }
{ Notes    : To provide almost the same flexible and powerful user interface}
{            with all of our utilities, this unit is (or will be) included  }
{            in each of them.                                               }
{                                                                           }
{           Including unit CRT in an application makes additionally        }
{            handling necessary to allow ANSI-colored strings! Currently,   }
{            including CRT is not recommended, as it generally limits the   }
{            consoles functionality. If CRT is really needed, define the    }
{            symbol "CRT" to make CUI_LIB compatible with CRT. At this      }
{            stage, all ANSI coloring features are disabled, but for the    }
{            reason of source code compatibility with existing CUI_LIB      }
{            applications, where possible, coloring is emulated with CRT    }
{            features. Currently, this is very limited and an applications  }
{            coloring may look different with CRT included. At a later      }
{            stage, we may improve coexistence with CRT or just provide a   }
{            better CRT replacement.                                        }
{                                                                           }
{           To allow easy portation to other languages, this unit          }
{            (currently) is optimized for readability, not for maximal      }
{            speed or minimal resource footprint. Despite of this, in the   }
{            limits of this rule, some speed and size optimizations and a   }
{            special caching strategy were implemented to still provide an }
{            adequate speed with DESCRIPT.ION file processing.              }
{            But, without CUI=FAST, CUI_LIB startup handling is rather slow.}
{            We will improve this in future versions.                       }
{            Some optimizations may only be effective when compiling with   }
{            Borland (Turbo) Pascal, as they depend on some of the compilers}
{            internals.                                                     }
{                                                                           }
{           This unit's concept currently is at a very early stage. Some   }
{            inhomogeneties and design limitations are due to the fact, that}
{            this has been written ad-hoc. At a later stage, we may rewrite }
{            the whole code for speed, size, OS portability (OS/2 CMD and   }
{            Linux), more clarity and flexibility.                          }
{                                                                           }
{           It is quite easy to port all your console driven utilities to  }
{            make them full-featured CUI_LIB applications. Basically, all   }
{            you have to do is including "Uses CUI_LIB" (and - whenever     }
{            possible - exclude CRT) in the sources and adapt parameter     }
{            scanning and some routines calling syntax.                     }
{                                                                           }
{ Description:                                                              }
{            A three staged model is used to get configuration information. }
{            The actual settings can be stored in some special environment  }
{            variables or in description files (as introduced with 4DOS/    }
{            NDOS, but this is functional even without 4DOS/NDOS).          }
{                                                                           }
{           Normally, the unit utilizes the following environment variables}
{            to override internal default settings. By setting these        }
{            environment variables, the user is able to widely customize    }
{            the applications appearance and adapt it to country specific   }
{            or personal favours.                                           }
{            Although this handling is generally preferred, there is a way  }
{            to override the complete startup management and description    }
{            file processing. Than the unit assumes internal defaults.      }
{            This may be used by experiencing unusual compatibility problems}
{            or running on very slow machines to fasten startup:            }
{                                                                           }
{            %CUI%       = Yes/No/<Fast> switch.                            }
{                          Actually, this has to be an environment variable,}
{                          no description file settings are accepted here.  }
{                          If set to 'No', the complete startup management  }
{                          is skipped, internal default values will be      }
{                          used, and no description file processing is done.}
{                          Setting to <No> dramatically fastens startup     }
{                          time, but with the backdraw of reduced func-     }
{                          tionality (recommended for slow XTs and 286,     }
{                          only).                                           }
{                          Setting to <Fast> will reduce the default Yes/No }
{                          and color name strings to their officially       }
{                          (English) names and considerable fastens startup }
{                          management (recommended for 286 - slower 486),   }
{                          without reducing generally functionality.        }
{                          (Without DEFINE FAST, if %CUI% is not set, an    }
{                          informal message will appear at startup.)        }
{                          Currently, CUI=FAST is recommended.              }
{                                                                           }
{            The environment variables in details:                          }
{                                                                           }
{            %YesChar%   = One or more characters or strings, that should   }
{                          be assumed as a valid answer for 'Yes'. If not   }
{                          specified, an internal list of commonly used     }
{                          arguments is used. If only a letter is specified,}
{                          all internal 'Yes' letters are skipped, but not  }
{                          the strings, or else both, the actual value and  }
{                          the internal list are scanned.                   }
{                          (Related to Novell DOS 7 CONFIG.SYS directive    }
{                          YESCHAR=).                                       }
{            %NoChar%    = As with %YesChar%, but for 'No'.                 }
{            %VerChar%   = String or character, that should be used to      }
{                          indicate a version number. If a string is given, }
{                          a pending space is added for better look.        }
{            %SubVerChar%= As with %VerChar%, but for the subversion,       }
{                          release or patchlevel.                           }
{            %SubSubVerChar%= As with %SubVerChar%, but for the subsub-     }
{                          version.                                         }
{            %SwitChar%  = Overriding system switchar setting (recorded at  }
{                          startup) to make it customizable, although       }
{                          support was stripped with MS-DOS 5.0+. Novell    }
{                          DOS 7 still fully supports changing switchars.   }
{            %(C)%       = String or character, used for a copyright symbol }
{                          in messages. If '0' or 'AUTO' is specified, with }
{                          codepages 850 or 857, ASCII(184) is used.        }
{            %_CodePage% = Used, when the current codepage cannot be deter- }
{                          mined automatically (e.g. with Free-DOS or older }
{                          DOS versions).                                   }
{                          (Related to 4DOS/NDOS %_CodePage% pseudo var.)   }
{            %ANSI%      = Contains a Yes/No switch, that should indicate,  }
{                          if an ANSI driver is present, but cannot be      }
{                          detected. Normally, a (very good) autodetection  }
{                          is performed, determining, if emitting ANSI-     }
{                          sequences is useful in a specific situation or   }
{                          not. In redirection, %ANSI% is not evaluated.    }
{            %_ANSI%     = Contains a <Yes>/No switch (overriding %ANSI%),  }
{                          that should indicate, if actually ANSI-sequences }
{                          shall be emitted or skipped. If given, it also   }
{                          overrides autodetection.                         }
{                          Both, %ANSI% and %_ANSI% are only effective      }
{                          without including CRT. Also, see %OutputBIOS%.   }
{                          (Related to 4DOS/NDOS %_ANSI% pseudo variable.)  }
{            %Sound%     = <Yes>/No switch indicating, if sounds are turned }
{                          on or off.                                       }
{            %CheckSnow% = Contains a <Yes>/No switch, indicating the usage }
{                          of a snow detection method for direct video RAM  }
{                          access (currently not used internally). This is  }
{                          for compatibility with unit CRT's CheckSnow      }
{                          variable, and defaults to Yes, if CRT is not     }
{                          included.                                        }
{                          (Related to Borland CRT internal CheckSnow var.) }
{            %OutputBIOS%= Contains a Yes/No switch, indicating the usage   }
{                          of direct video output (No) instead of video BIOS}
{                          functions (Yes). This is for compatibility with  }
{                          unit CRT's DirectVideo variable, that is the     }
{                          opposite to OutputBIOS. If CRT is not included,  }
{                          OutputBIOS defaults to <Yes>, if CRT is included }
{                          it defaults to No (that is the CRT default).     }
{                          ANSI coloring may depend on %OutputBIOS% setting,}
{                          but currently, this is checked.                  }
{                          (Related to 4DOS/NDOS.INI OutputBIOS directive   }
{                          and Borland CRT internal 'NOT DirectVideo'.)     }
{            %_DName%    = Contains an alternative name for a description   }
{                          file. The default name is DESCRIPT.ION.          }
{                          (Related to 4DOS/NDOS %_DName% pseudo variable.) }
{            %Descriptions% = Contains a <Yes>/No switch indicating the     }
{                          usage of description files to get emulated en-   }
{                          vironment variables (see below). This setting    }
{                          can also be given in the description file itself,}
{                          thus disabling any further processing of that    }
{                          file.                                            }
{                          Always evaluated before accepting this setting   }
{                          are: %YesChar%, %NoChar%, %_DName%, and, of      }
{                          course, %Descriptions%.                          }
{                          As an applications description file entries do   }
{                          normally override the environment variables (at  }
{                          least within this unit), setting this entry to   }
{                          'No' can be used to let environment variables    }
{                          take effect over description file entries.       }
{            %DefEnvVars%= Contains a <Yes>/No switch indicating the usage  }
{                          of description file entries of an optional "."   }
{                          line if the system environment does not contain  }
{                          a corresponding value to override this.          }
{                          <Yes>= '.' environment is used as default.       }
{                          No   = '.' is ignored                            }
{            %DBGEcho%   = Contains a Yes/<No> switch indicating, if, at    }
{                          program startup, the description from a          }
{                          description file shall be displayed (as debug    }
{                          information) or not.                             }
{                          (Loosely related to DR DOS 3.41 %Beta% and DBG.) }
{            %<ColName>% = (as LightRed, LightGray, Yellow, White, ...)     }
{                          contains a color name string or value, indicating}
{                          a color that should be used instead of <ColName>.}
{                          (Related to PROSHELL & 4DOS/NDOS color settings.)}
{            %<PrgName>CMD% = Contains a string, that should be given as    }
{                          default parameter (represented in EnvCmdLine) and}
{                          can be processed by the application.             }
{                          (Releated to MS-DOS 6.xx %DIRCMD% and %COPYCMD%  }
{                          and other vendors applications.)                 }
{            %LineEdit%  = Contains a <Yes>/No switch indicating the online }
{                          command line edit feature (activated by a ' ?' at}
{                          the end of the current command line.             }
{                          (Related to MS-DOS 7 (Win95) ' ?' feature.)      }
{            %EnvExpansion% = Contains a <Yes>/No switch, indicating, if    }
{                          recursive evaluation of arguments, containing    }
{                          environment variable references (by %<varname>%) }
{                          should be performed (up to an internal limit, to }
{                          avoid infinite loops) or should just be skipped. }
{                          Yes enables parameters like: LightRed=%Yellow%   }
{            %DOSVersion% = Overrides SYSTEM.DOSVersion, but with swapped   }
{                          bytes. Be carefull with that!!!                  }
{                          Novell DOS 7 %Ver% and 4DOS/NDOS %_Ver% were not }
{                          used, because this setting is dangerous and      }
{                          interferences should be prohibited.              }
{            %FreeDOS%   = Contains a Yes/<No> switch, indicating if        }
{                          Free-DOS is running. Free-DOS currently does not }
{                          support all DOS APIs (e.g. country specific      }
{                          functions), and some applications may need       }
{                          different algorithms, running under Free-DOS.    }
{            %LCMD%      = Contains a <Yes>/No switch to optionally use     }
{                          %CMDLINE% instead of the actual command line to  }
{                          support longer commands than 127 chars. %CMDLINE%}
{                          is used different in 4DOS/NDOS and MS-DOS 7. Both}
{                          flavours are supporte and detected automatically.}
{                          Although this feature runs fine in most situa-   }
{                          tions, it could cause problems when shelling.    }
{                          You can temporarily disable LCMD=On by placing a }
{                          single '@' in the actual command line as first   }
{                          parameter.                                       }
{            %LFN%       = Contains a <Yes>/No switch for MS-DOS 7 Long-    }
{                          File-Names, currently very crude support only.   }
{            %TrueName%  = Contains a <Yes>/No switch for TrueName-support. }
{            %SHARE%     = Contains a <Yes>/No switch for SHARE support.    }
{                          With <Yes> an automatic detection method is used }
{                          and SHARE-modes are used if SHARE functionality  }
{                          has been found.                                  }
{                                                                           }
{           The variables and values names have been selected for maximal  }
{            compatibility with existing names and additional features,     }
{            provided by Novell DOS 7 and/or 4DOS/NDOS (although their      }
{            internal pseudo variables are NOT represented in the environ-  }
{            ment, but may be overridden by actual environment vars, e.g.   }
{            SET _CodePage=%_CodePage% in AUTOEXEC.BAT and after CHCP).     }
{                                                                           }
{           There is another related feature (using DESCRIPT.ION files, as }
{            introduced with 4DOS/NDOS): These files may not only contain   }
{            a files description, but also multiple configuration infor-    }
{            mations for each file. CUI_LIB uses two configuration IDs:     }
{            '%' for all settings, that should be handled like environment  }
{            variables to the program ('%' was choosen as a reminder to     }
{            %environment%), although they are actually not stored in the   }
{            environment. This gives the user a chance to override system-  }
{            wide environment variables settings by file specific           }
{            'attributes' and also saves memory for the actual environment. }
{            The only shortcoming is, that a description file setting cannot}
{            contain more than one string (and therefore <SWC> is forbidden }
{            here).                                                         }
{                                                                           }
{            Another ID ('>', reminds of a DOS-prompt) is used to provide   }
{            an automated command line extension feature:                   }
{            This entry contains strings, that are represented in ExtCmdLine}
{            and can be concatented with the actual command line OrgCmdLine }
{            (after EnvCmdLine) and may override internal default settings. }
{                                                                           }
{            A third ID '#' is reserved by this unit for multiple kinds of  }
{            extended file attributes ('#' looks like a table, somewhat).   }
{            Currently, this unit does not use any of them, but we have     }
{            already defined some attributes:                               }
{                                                                           }
{            CP=codepage                    Indicates the codepage, the file}
{                                           was created under or for. Also a}
{                                           list of valid codepages may be  }
{                                           given. An application may switch}
{                                           to this codepage.               }
{            PC=phonecode                   Country code, the file was      }
{                                           created under or for. Usually   }
{                                           used to indicate the language   }
{                                           used in a document file or .EXE.}
{            XS=x-size (columns)            Only used for text documents.   }
{                                           Could be used for setting up a  }
{                                           printer or document-browser.    }
{                                           0 = free-flow / reserved.       }
{            YS=y-size (lines per page)     Only used for text documents.   }
{                                           Could be used for printer setup.}
{                                           0 = no page formatings.         }
{            XO=x-offset (for punching)     Only used for text documents.   }
{                                           Empty left border used in for-  }
{                                           mated text (e.g. for punching). }
{                                           This value is also included in  }
{                                           XS.                             }
{            YO=y-offset (for printer CSF)  Only used for text documents.   }
{                                           As XO, but for page top format. }
{                                                                           }
{           If a description line for the application can be found, its    }
{            environmental information (ID '%') is used to override actual  }
{            environment variables. If this entry is empty, an environment  }
{            variable is used. If the environment variable is not defined,  }
{            normally the environment information (ID '%') from the optional}
{            ". " line in the description file is used as 'default environ- }
{            ment'.                                                         }
{            Normally, within each group, environment variables are fully   }
{            nestable (depends on %EnvExpansion%).                          }
{            Environment variables and nested variables may be used in ". " }
{            lines. Environment variables and ". " variables may be used in }
{            the applications line. Recursively nested variable definitions }
{            across those groups are not allowed.                           }
{            The ". " line can be used to expand the actual environment by  }
{            variables, that do only make sense in the context of the       }
{            applications directory (configuration hierarchy). The informa- }
{            tion from the applications line can be used to expand variables}
{            to application specific needs. This mixed priority scheme gives}
{            high flexibility in system and application configuration.      }
{                                                                           }
{           Example:                                                       }
{                                                                           }
{            Assume an application APP, the DESCRIPT.ION (or %_DName%) file }
{            contents may be, for example: [ is a placeholder for caret,   }
{            Chr(4), that cannot be reproduced here by some editors. ... is }
{            a placeholder for 'other lines'.]                              }
{                                                                           }
{            . This is the current directory % TestColor=Green             }
{            ...                                                            }
{            APP.EXE This is APP!>/?%LightRed=Red Blue=%LightRed% ...     }
{            ...                      ... Descriptions=Yes EnvExpansion=Yes }
{                                                                           }
{            where "This is APP!" is actually the files description (e.g.   }
{                                 for 4DOS/NDOS DIR or with %DBGEcho%)      }
{                  "/?"           is the 'extended' command line            }
{                  "LightRed=Red ... EnvExpansion=Yes" is the 'emulated'    }
{                                 environment area (Descriptions=Yes), that }
{                                 overrides actual environment vars with    }
{                                 the same name. In this example, the       }
{                                 color, used for LightRed is being         }
{                                 replaced by Red, as with Blue, which      }
{                                 actually refers to the current LightRed   }
{                                 setting (because of EnvExpansion enabled).}
{                                                                           }
{           A description of the DESCRIPT.ION file format in general can   }
{            be found in the 4DOS/NDOS documentation. Currently there is    }
{            one limitation for DESCRIPT.ION files handled by this unit:    }
{            Each line may not exceed 255 chars, whereas the general limit  }
{            is 4096 chars. This is due to the fact, that Pascal strings    }
{            cannot contain more than 255 chars. (Borland Pascal 7.0 allows }
{            handling of null-terminated strings, but this is not a common  }
{            Pascal standard. We might add this at a later stage.)          }
{                                                                           }
{           Online edit mode:                                              }
{            CUI_LIB provides an online edit mode for the applications      }
{            command line. This allows to add more parameters on the fly,   }
{            even when called out of batchjobs. This feature is invoked by  }
{            a single '&' or '?' at the end of one of the three cmd-line    }
{            sources ('&' is related to the older PROSHELL and KEIL-        }
{            assembler command line extension features, and '?' is related  }
{            to a new feature from MS-DOS 7 (Windows95/Chicago). Both are   }
{            basically the same. CUI_LIB combines both methods and adds     }
{            some new features, such as full environment variable and       }
{            parameter evaluation, inline comments, a special token         }
(*           {$CLEAR} and redirection.                                     *)
{                                                                           }
{           Another related feature are special pseudo environment         }
{            functions like %0%..%9% etc. and %?%, %?"text"%, and           }
{            %?"text"default%, processed until all nested evaluations are   }
{            solved (or a limit is reached). These variables may appear     }
{            inside of other strings and may contain spaces in between the  }
{            two % chars:                                                   }
{            %0% etc. are placeholders for substrings in the parameter line }
{            and %?% etc. will prompt for a value. Optionally a text (in "")}
{            is displayable in the question and also optionally after the   }
{            "text", a default value may follow. This value is used if the  }
{            user answers by pressing <Return> solely. A default value      }
{            without a special text can be given by %?""default%.           }
{                                                                           }
{           If you are a software developer, we encourage you to provide   }
{            the same customarization features with your own applications   }
{            to develop a "new standard interface look" for all the console }
{            driven DOS utilities (this could also be done for OS/2 CMD and }
{            Linux). Under the following conditions you are allowed to use  }
{            this unit for your purposes:                                   }
{                                                                           }
{            o  There are no warranties, neither expressed nor implied!     }
{            o  Do not want money etc. for distributing this unit!          }
{            o  Your applications documentation (and the help/about screen, }
{               if any) must mention the usage of this unit (CUI_LIB).      }
{            o  To develop a 'standard', do not alter the environment       }
{               variable names and description files IDs, please!           }
{                                                                           }
{            If you implement further improvements or do translations to    }
{            other languages, we would like to get a copy.                  }
{            If you have questions, feel free to contact us!                }
{                                                                           }
{ History  : V1.00-V1.14 by Matthias Paul                                   }
{ Requires : DOS, video BIOS, and ANSI compatible APIs                      }
{ Compile  : Compile with Borland (Turbo) Pascal 7.0                        }
{ ToDo     : More speedups (ASM); more country specific strings; services   }
{            for multilingual messages, country localization, and time zone;}
{            faster algorithm to get configuration; porting to OS/2 and     }
{            WinDOS; better including CRT. Some improvements in Check-      }
{            Param(): scanning the whole string for a parameter (take last  }
{            matching string); if found, more flexible support to SWC;      }
{            enabling multiple options following a switchar (e.g. /A /B ->  }
{            /AB); enabling for negative options (e.g. /-Y). To provide     }
{            these, some other changes have to be done... IsStdInRedir.     }
{ ######################################################################### }

{ $DEFINE CRT}      { include this, if CRT is included somewhere       }
{ $DEFINE WINCRT}   { include this, if WinCRT is included somewhere    }
{ $DEFINE DEBUG}    { include this for a debug version                 }
{ $DEFINE SPEEDUP}  { replaces Pascal routines by faster ASM routines  }
{ $DEFINE OBSOLETE} { include obsolete code (for troubleshooting only) }
{$DEFINE FAST}     { temporarily workaround: CUI=FAST as default.     }

{$IFDEF DEBUG}
{$A+,B-,D+,E+,F-,G-,I+,L+,N-,O-,P-,Q+,R+,S+,T+,V+,X-}
{$ELSE}
{$A+,B-,D-,E+,F-,G-,I+,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X-}
{$ENDIF}
{ Boolean shortcut is absolutely required here!     }

{$DEFINE CUI_LIB}  { to acknowledge this unit to other sources }

{ All conditional defines for other platforms than Borland Pascal 7 are }
{ untested and very incomplete/nonfunctional at the moment...           }

Unit CUI_Lib;

 Interface

  Uses
   {$IFDEF VIRTUALPASCAL}
   OS2Def, OS2Base,
   {$ENDIF}
   {$IFDEF WINDOWS}
   WinDOS;
   {$DEFINE PCHAR} { WinDOS needs PChar's (ASCIZ)       }
   {$ELSE}         { DOS and DPMI }
   DOS;            { DOS normally uses Strings (PASCAL) }
   {$ENDIF}

  Const
   CUILIB_MainVerStr = '1';
   CUILIB_SubVerStr  = '14';
   FDirection     = $0400;
   MaxWord        = 65535;
   MaxStringLen   = 255;{ Used for performance reasons to allow faster      }
                        { Copy() processing.                                }
                        { Used for size reduction reasons:                  }
   SymStringLen   = 20; { adapt this, if not enough space for symbol strings}
   YNStringLen    = 100;{ adapt this, if not enough space for YN strings    }
   ColStringLen   = 250;{ adapt this on extending the color name list.      }
   {$IFNDEF PCHAR}
   fsPassword     =  9; { semicolon+password (8 chars long)                 }
   {$IFNDEF WINDOWS}
   fsPathName     = 79;
   fsDirectory    = 67;
   fsFileName     =  8;
   fsExtension    =  4;
   {$ENDIF}
   {$ENDIF}

  Type
   {$IFDEF PCHAR}
   PChar          = ^Char;
   {$ELSE}
   {$IFDEF WINDOWS}
   PathStr = String[fsPathName];
   DirStr  = String[fsDirectory];
   NameStr = String[fsFileName];
   ExtStr  = String[fsExtension];
   {$ENDIF}
   PassStr = String[fsPassword]; { for DR DOS/DR Multiuser DOS/FlexOS/Novell DOS passwords }
   {$ENDIF}
   ChrSetT        = Set Of Char;
   ChrArrT        = Array [0..Pred(MaxStringLen)] Of Char; { used for PChar }
   SymStringT     = String[SymStringLen];
   YNStringT      = String[YNStringLen];
   ColStringT     = String[ColStringLen];
   String127      = String[127];
   ReDirT         = (Nothing, ToDevice, ToFile);

  Const
   fmReadOnly     = $00; { only read access needed }
   fmWriteOnly    = $01;
   fmReadWrite    = $02; { default for Reset()     }
   fmCompatibility= $00;
   fmDenyReadWrite= $10;
   fmDenyWrite    = $20; { prohiwrite access by others          }
   fmDenyRead     = $30;
   fmDenyNone     = $40;
   fmInherit      = $80; { don't inherit access rights to child }

   NUL            = $00;              { NUL                                 }
   BS             = $08;              { Backspace       ^ H                 }
   TAB            = $09;              { TAB                                 }
   LF             = $0A;              { Line Feed                           }
   CR             = $0D;              { Carriage Return ^ M                 }
   EOFZ           = $1A;              { old CP/M End Of File                }
   ESC            = $1B;              { ESC             ^ [                 }
   SPACE          = Ord(' ');
   WhiteChrSet    : Set Of Char = [Chr(TAB), Chr(SPACE), Chr(255)];
   SeparatorSet   : Set Of Char = ['=', ':'];
   ListSet        : Set Of Char = [',',';'];
   ConcatSet      : Set Of Char = ['~'];           { exclusive     }
   ExtConcatSet   : Set Of Char = ['_', Chr(255)]; { not exclusive }
   VerSym         : SymStringT = 'V';   { overridden by %VerChar%                }
   SubVerSym      : SymStringT = '.';   { overridden by %SubVerChar%             }
   SubSubVerSym   : SymStringT = '.';   { overridden by %SubSubVerChar%          }
   CopyrightSym   : SymStringT = '(C)'; { overridden by %(C)%                    }
   MainVerStr     : String = '0';       { dummy version number }
   SubVerStr      : String = '01';      { dummy version number }
                    { Currently containing mainly English, German, French,       }
                    { Italian, Dutch, Spanish and Polish strings. More languages }
                    { strings are included because they use similar vocabulary,  }
                    { and some strings are included, where I don't even know     }
                    { from which country they are... ;-)                         }
                    { As some unusual chars are assigned differently in different}
                    { DOS codepages, I tried to cover all codepages known to me  }
                    { (have a look at these strange looking strings ;-) ).       }
                    { (Perhaps it would be better to write all these strings in  }
                    { UniCode and add a Codepage2UniCode translation layer.)     }
                    { Please always use capitalized letters (except for hardware }
                    { codepage 437, where low-case chars may be used if there is }
                    { no capital replacement)! As all strings are capitalized    }
                    { before scanning, strings given with lower chrs will not be }
                    { recognized, if there is a capital replacement char for it. }
                    { As these strings are scanned very frequently, adding more  }
                    { strings dramatically reduces startup time. The first       }
                    { FastYNNames strings may not change in order, as they are   }
                    { 'officially' descriptions and are used with %CUI%=Fast!!!  }
                    { Each string should end with a space, to allow easy         }
                    { concatenation (not required inside of this unit).          }
   FastYNNames    = 4;
   YesStr         : YNStringT = 'ON TRUE YES ENABLE EN HIGH ONE EIN EINS JA WAHR OUI SI '
                                 +'OK AY TAK SIM EVET KYLLO KYLL KYLL IAE ';
   YesChr         : YNStringT = 'Y J O S T H E K I Z + ';
   NoStr          : YNStringT = 'OFF FALSE NO DISABLE DIS LOW NUL AUS NULL NEIN FALSCH NICHT NON NOT NEE NIE ';
   NoChr          : YNStringT = 'N L - ';
                    {With %CUI%=FAST, only the first substring from YesValStr and NoValStr is used. }
   YesValStr      : YNStringT = '1 ';
   NoValStr       : YNStringT = '0 2 255 #255 255D &D255 FF $FF 0XFF FFH &HFF @377 377O &O377 %11111111 11111111B ';
                    {'C' or something like 'Copyright' is not allowed here!   }
                    {'2' is interpreted as 'No' for better compatibility with }
                    { 4DOS/NDOS! Depending on %YesChar% and %NoChar%:         }
   Black          : Byte =  0;
   Blue           : Byte =  1;
   Green          : Byte =  2;
   Cyan           : Byte =  3;
   Red            : Byte =  4;
   Magenta        : Byte =  5;
   Brown          : Byte =  6;
   LightGray      : Byte =  7;
   DarkGray       : Byte =  8;
   LightBlue      : Byte =  9;
   LightGreen     : Byte = 10;
   LightCyan      : Byte = 11;
   LightRed       : Byte = 12;
   LightMagenta   : Byte = 13;
   Yellow         : Byte = 14;
   White          : Byte = 15;
   FastColNames   = 2;
   ColorStrs      : Array[0..15] Of ColStringT =
                    { Contains color names in some languages and different styles, such as:     }
                    { English (std.,4DOS), German (std.,NDOS), French, Dutch, Spanish, Italian, }
                    { Catalan, Polish, but currently, only English and German strings have      }
                    { been completed. Up to now, codepages 437,850,852,853,857,860,863,865,866  }
                    { are covered.                                                              }
                    { The first FastColNames names may not change in order, as they are the     }
                    { officially names and used with %CUI%=Fast. The very first entry should    }
                    { always be the number, the second entry the full English name.             }
                    { Each string should end with a space, to avoid errors when concatenating   }
                    { strings (this is not required internally). Also see YesStr, NoStr!        }
           {  88 }  ('0 BLACK BLA SCHWARZ SCH NOIR ZWART NERO NEGRO CZARNY PRETO ALTO SVART FERNY ERNY ERN ',
           { 132 }   '1 BLUE BLU BLAU BLA BLEU BLAUW BLU AZUL AZUR NIEBIESKI BLEKITNY BLKITNY MODRY GRANATOWY '
                        +'MAVI SININEN MODRA MODR MODR BLO BL BL ',
           { 184 }   '2 GREEN GRE GRUEN GR VERT GRN GROEN VERDE ZIELONY CIEMNOZIELONY GRONN GR0NN GRNN GRNN GRNN '
                        +'GRN GRON GR0N GRN GRN VIHREO VIHER VIHER ZELENY ZELEN ZELENA ZELEN ZELEN ZELEN ',
           { 133 }   '3 CYAN CYA ZYAN ZYA TUERKIS TRKIS CIAN CIN CIN CIN CIANO AZZURRO AQUAMARIN AGUAMARINA '
                        +'BLUEVERT AZULVERDE VERDEACQUA VERDEAZULADO ',
           { 139 }   '4 RED ROT DUNKELROT ROUGE ROOT ROSSO ROCHA CZERWONY CIEMNOCZERWONY ROOD ROJO RD R0D RD RD '
                        +'MARCIUME ENCARDNADO VERMELHO FERVENY ERNVEN ',
           { 175 }   '5 MAGENTA MAG VIOLET VIOLETT LILA FUCHSIN FUCHSINROT VIOLACE VIOLAC LILIOWY FIOLETOWY PURPURA PURPRA '
                        +'MAGENTAROD MAGENTAR0D MAGENTARD MAGENTARD FUCHSIA FUCSIA FUCSIA LILAS ',
           { 245 }   '6 BROWN BRO YEL BRAUN ORANGE GEL BRUN MARRON MARRN MARRONE MORENO MARROM HAVANE BRUIN DONKERGEEL '
                        +'CASTANO CASTANHO CASTAO CHATAIN CHTAIN BRAZOWY BRZOWY BRUNATNY POMARANCZOWY POMARACZOWY BRUNO '
                        +'ARANCIO ARANCIA NARANJA ORANJE ORANSJE ARANCIONE ',
           { 135 }   '7 LIGHTGRAY WHI LIGHTGREY WEI GRAY GREY GRAU HELLGRAU GRISCLAIR GRIS GRIJS GRS GRAUW SZARY JANOSZORY '
                        +'GRIGIO GRA GR CINZA GRO GR GR ',                                                { JASNOZORY??? }
           { 246 }   '8 DARKGRAY DARKGREY BRIGHTBLACK BRIBLA DUNKELGRAU DUNKEL LEUCHTENDSCHWARZ LEUSCH OBSCUR FONCE FONC '
                        +'GRISFONCE GRISFONC DONKERGRIJS DONKERGRS DONKERGRAUW GRIGIOSCURO CIEMNOSZARY CIEMNY KOYUGRI '
                        +'GRISOSCURO CINZAESCURO MORKGRA MRKGRA TUMMANHARMAA ',
                     '9 LIGHTBLUE BRIGHTBLUE BRIBLU HELLBLAU LEUCHTENDBLAU LEUBLA BLEUCLAIR LICHTBLAUW JASNONIEBIESKI ',
                     '10 LIGHTGREEN BRIGHTGREEN BRIGRE HELLGRUEN HELLGRN LEUCHTENDGRUEN LEUCHTENDGRN LEUGR VERTCLAIR '
                      +'LICHTGROEN JASNOZIELONY ',
                     '11 LIGHTCYAN BRIGHTCYAN BRICYA HELLCYAN HELLZYAN HELLTUERKIS HELLTRKIS LEUCHTENDZYAN LEUCHTENDCYAN '
                      +'LEUZYA ',
                     '12 LIGHTRED BRIGHTRED BRIRED HELLROT LEUCHTENDROT LEUROT ROUGECLAIR LICHTROOT JASNOCZERWONY ',
                     '13 LIGHTMAGENTA BRIGHTMAGENTA BRIMAG PINK HELLMAGENTA ROSE ROSA HELLVIOLETT HELLFUCHSIN HELLFUCHSINROT '
                      +'LEUMAG LEUCHTENDMAGENTA LEUCHTENDVIOLETT ROZOWY ROWY ',
           { 153 }   '14 YELLOW BRIGHTYELLOW BRIYEL HELLBRAUN GELB LEUCHTENDGELB LEUGEL JAUNECLAIR JAUNE GEEL LICHTGEEL '
                      +'MARILLION ZOLTY TY ZOTY GUL AMARILLO GIALLA GIALLO ',
           { 169 }   '15 WHITE BRIGHTWHITE BRIWHI WEISS WEI LEUCHTENDWEISS LEUCHTENDWEI LEUWEI HIGHLIGHT BLANC WIT VIT '
                      +'HVID HVIT HVITT BIALY BIAY SIYAH BLANCO BIANCO BRANCO BILA VALKOINEN ');
   ExpandEnvVars  : Boolean = TRUE;   { overridden by %EnvExpansion%        }
   ANSI           : Boolean = TRUE;   { overridden by %ANSI% and %_ANSI%    }
   Beeps          : Boolean = TRUE;   { overridden by %Sound%               }
   {$IFNDEF CRT}
   {$IFNDEF WinCRT}
   CheckSnow      : Boolean = TRUE;   { overridden by %CheckSnow%           }
   DirectVideo    : Boolean = FALSE;  { overridden by NOT %OutputBIOS%      }
   {$ENDIF}
   {$ENDIF}
   UseDescriptions: Boolean = TRUE;   { overridden by %Descriptions%        }
   UseDefEnvVars  : Boolean = TRUE;   { overridden by %DefEnvVars%          }
   UseLFN         : Boolean = TRUE;   { overridden by %LFN%                 }
   UseTrueName    : Boolean = TRUE;   { overridden by %TrueName%            }
   UseCmdLine     : Boolean = TRUE;   { overridden by %LCMD%                }
   UseSHARE       : Boolean = TRUE;   { overridden by %SHARE%               }
   DBGEcho        : Boolean = FALSE;  { overridden by %DBGEcho%             }
   OnLineEdit     : Boolean = TRUE;   { overridden by %LineEdit%            }
   AccessDisk     : Boolean = TRUE;   { switched to FALSE by @ @ in the PSP }
                                      { cmdline.                            }
   INT2FValid       : Boolean = FALSE;
   DescriptionEnvID : Byte  = Ord('%'); { for pseudo-environment            }
   DescriptionCmdID : Byte  = Ord('>'); { for extended default command line }
   DescriptionAttrID: Byte  = Ord('#'); { reserved for extended attributes  }
   OrgCmdLine     : String  = '';     { contains programs original cmdline  }
   EnvCmdLine     : String  = '';     { contains %<filename>CMD%            }
   ExtCmdLine     : String  = '';     { contains cmd line from description  }
                                      { file (DescriptionCmdID)             }
   ParHelp1       = '?';              { Parameters can be abbreviated       }
   ParHelp2       : String = 'Help';  { as long as the capitalized          }
   ParAbout1      = '!';              { letters can be found.               }
   ParAbout2      : String = 'About'; {                                     }

  Var
   TitleColor     : Byte Absolute Yellow;
   HighLightColor : Byte Absolute White;
   ErrorColor     : Byte Absolute LightRed;

  Var
   PSPCmdLineCopy : String127;        { A 1:1 copy of the original cmdline  }
                                      { +80h in the PSP, as this would be   }
                                      { destroyed when using FCBs or default}
                                      { DTA.                                }
  Function IsWINDOWSRunning: Boolean;

  Function IsDESQViewRunning: Boolean;
   { DESQView/TopView/TaskView etc. }

  Function IsTaskSwitcherRunning: Boolean;

  Function IsTASKMGRRunning: Boolean;
   { Also affects Windows DOS-Boxes if Novell DOs 7 TASKMGR is }
   { used instead of the original Windows TASKMAN.             }

  Function Displayable(c: Char): Char;
   { Replaces non-displayable chars by spaces }

  Function HexPrint(value: LongInt; nr: Byte): String;
   { Returns a hex-string from w }

  Function ChrSet2Str(chr_set: ChrSetT): String;
   { Converts a ChrSet to a string containing the same chars }

  Procedure Str2ChrSet(chr_str: String; Var chr_set: ChrSetT);
   { Converts a string to a ChrSetT containing the same chars }

  Function Str2Chr(str: String; pos: Byte): Char;
   { Returns #0 if pos out of range }

  Function PosC(chr: Char; str: String): Byte;
   { Faster replacement for Pos(chr, str) }

  Function IsStdOutRedir: Boolean;
   { TRUE if Standard Output is redirected }

  Procedure WriteANSI(col: Byte; str: String);
   { Writes a message in color col using ANSI sequences, if ANSI is enabled. }
   { If the cursor is not in column 0, a WriteLn is performed first.         }

  Procedure WriteLnANSINorm;
   { WriteLn message color back to 'Gray': Normal.  }
   { Use only at the end of a line (the cursor must }
   { not be nearer than 9 spaces to the lines end!) }

  Procedure WriteLnANSI(col: Byte; str: String);
   { A combination of WriteANSI and WriteLnANSINorm. }

  Procedure Beep;
   { Emits a short Beep, if enabled }

  Procedure UpStr(Var str: String);
   { Capitalizes str by explicit usage of Borlands UpCase }
   { (for reasons of consistency)                         }

  Procedure UpStrC(Var str: String);
   { Country depending capitalizes str (if possible, by DOS) }

  Function ToUpper(str: String): String;
   { Returns a country capitalized string (as UpStr) }

  Function ToUpperC(str: String): String;
   { Returns a country dependend capitalized string (if possible, by DOS). }

  Function UpCaseC(chr: Char): Char;
   { Country depending UpCase (if possible, by DOS). }

  Procedure AppendChr(Var str: String; chr: Char);
   { Faster replacement routine for                          }
   { "str:=str+chr;" or "Insert(chr, str, Length(str)+1)"    }

  Procedure AppendStr(Var str: String; append_str: String);
   { Faster replacement routine for                          }
   { "str:=str+append_str" or "str:=Concat(str, append_str)" }

  Procedure Str2ASCIZ(str: String; Var p_chr: ChrArrT);
   { Converts a Pascal string to an ASCIZ string.                        }
   { Adds a #0 at the end of the string, even if the string is too long. }

  Function ASCIZ2Str(p_chr: PChar): String;
   { Converts an ASCIZ string to a Pascal string                         }

  Function JustifyR(str: String; len: Byte; pad_chr: Char): String;
   { Right-justify str to len, padding with pad_chr }

  Function IntToStr(value: LongInt; width: Byte): String;
   { Makes string from any Integer type. }
   { If width is not used, set to 0.     }

  Function LeadingCAPS(search_str: String): Byte;
   { Gets count of leading capitalized chars in string. }

  Function DispParam(par:String; SWC_flag: Boolean): String;
   { Utility routine for application syntax screens }

  Procedure DelLeadIn(Var str: String; leadin_set: ChrSetT);
   { Strips leading spaces from <leadin_set> from str }

  Procedure DelLeadOut(Var str: String; leadout_set: ChrSetT);
   { Strips leadout chars from <leadout_set> from str }

  Function PosSet(char_set: ChrSetT; str: String): Byte;
   { Works like Pos(), but checks for first occurence of char from char_set }

  Function SubStr(str: String; number: Byte): String;
   { Gets substring[number] from str, separated by WhiteChrSet or SWC }
   { A SWC followed by a WhiteChr is handled like a part of the       }
   { former parameter.                                                }
   { When using this function for general purposes, always remind that}
   { it has been specially designed to handle parameter strings. Using}
   { SWCs, the results may be (but generally are not) much different  }
   { from a generic SubStr only handling WhiteChrSet.                 }

  Function StrCount(str: String): Byte;
   { Returns the number of SubStr, as they are determined by SubStr, }
   { separated by WhiteChrSet and SWC. A SWC followed by a WhiteChr  }
   { is handled like a part of the former parameter.                 }

  Function XParamCount: Word;
   { Virtually a replacement for ParamCount(), but optionally uses   }
   { %CMDLINE%, used by 4DOS/NDOS and MS-DOS 7.                      }

  Function XParamStr(index: Word): String;
   { Virtually a replacement for ParamStr(), but optionally uses %CMDLINE%  }
   { instead of the actual command line. %CMDLINE% is supported by 4DOS/NDOS}
   { and by MS-DOS 7 and provides a way to pass long strings (e.g. LFN) to  }
   { the parameter interface.                                               }
   { Note, that currently the handling of substring is somewhat different   }
   { from the general substring separation, as SwitChars are interpreted.   }

  Function IsInStr(sub_str, str: String): Boolean;
   { Returns TRUE, if one of the substrings in sub_str can be found as }
   { a substring in str. Else, this function returns FALSE.            }
   { A substring is a string, that is separated from others by chars   }
   { out of the WhiteChrSet or SWC.                                    }

  Function XGetEnv(env_var: String): String;
   { Replacement for GetEnv(), but also utilizes description file      }
   { entries (with DescriptionEnvID).                                  }

  Procedure ValWord(str: String; Var value: Word; Var error: Integer);
   { As Val() for value:Word, evaluates value from str. Can handle all }
   { kinds of decimal, hex, octal, binary and character strings.       }
   {                                                                   }
   {             default  prefix              postfix  digits(w/o fix) }
   { decimal strings: 10  #10, &D10              10d             0..5 }
   { hex strings:         $0F, xF, 0xF, &HF      Fh, 0Fh, 0F$    0..4  }
   { binary strings:      %1001, 0%1001, &B1001  1001b           0..16 }
   {                      Instead of [0,1] digit set, [H,L], [T,F]     }
   {                      are also accepted.                           }
   { octal strings:       @137, &O137            137o            0..6 }
   { characters:          'a', "a", 'ab', "ab"                   0..2  }
   { environment vars:                   %value%                       }
   { ext. command line params:           %x%, x=[0..9]                 }
   { A prefix or postfix without digits will result in zero.           }
   { System environment will be overridden by description file entries }
   { (not recursively).                                                }

  Procedure LockRecord(Var f; unlock: Boolean; start, count: LongInt; retries: Byte);
   { Locks/Unlocks a file record from offset <start> for <count> Bytes.}
   { If retries > 0, retries automatically after a random time.        }
   { If SHARE not supported, results in IOResult > 0.                  }

  Function IsSHARESupported: Boolean;
   { TRUE, if SHARE-API is functional (that is SHARE loaded or support }
   { provided by another driver).                                      }

  Function CheckParam(search_str, cmd_line: String;
                      value_flag, yesno_flag, yesno_val_flag: Boolean;
                      Var ret_value: Word; Var ret_str: String): Boolean;
   { Scans cmd_line for search_str and returns TRUE, if found, else FALSE.  }
   { The comparison is not case-sensitive. To make further processing more  }
   { simple, the functions exact behaviour can be controlled by the two     }
   { boolean flags value_flag (<FALSE>) and yesno_flag (<YES>).             }
   {                                                                        }
   { value_flag yesno_flag.                                                 }
   { FALSE      FALSE       The function scans for the parameter search_str }
   {                        and results TRUE, if found. ret_value is always }
   {                        zero and ret_str contains an optional argument  }
   {                        to the parameter.                               }
   { FALSE      TRUE        As with (FALSE, FALSE), but the function checks }
   {                        for a valid Yes/No argument. A 'No' argument    }
   {                        disables the parameter, as if it wasn't set.    }
   {                        The function results FALSE, ret_value is zero   }
   {                        and ret_str is ''.                              }
   {                        With no valid Yes/No parameter or a valid 'Yes' }
   {                        parameter, the function results TRUE, ret_value }
   {                        is zero and ret_str contains the 'Yes'-string.  }
   { TRUE       FALSE       As with (FALSE, FALSE), but the function tries  }
   {                        to evaluate an argument to the parameter.       }
   {                        If no parameter can be found, the function      }
   {                        results FALSE, else TRUE and ret_value contains }
   {                        a valid value or zero, if invalid (or no arg.). }
   {                        If evaluation resulted in 'invalid value', ret_ }
   {                        str returns the argument (which is obviously a  }
   {                        textual argument).                              }
   { TRUE       TRUE        As with (FALSE, FALSE), but the function evals  }
   {                        ret_value. If ret_value is invalid, the function}
   {                        checks for Yes/No (as with (FALSE,TRUE)).       }
   {                                                                        }
   { The yesno_val_flag indicates, if Yes/No determination should stick to  }
   { strings/chars only, or should check for some special numbers as Yes/No,}
   { too (e.g. 0=No, 1=Yes). Generally, this should be TRUE, but in rare    }
   { cases, where argument numbers should not be tested on Yes/No, it is    }
   { adequate to set to FALSE.                                              }
   {                                                                        }
   { To enable returning of case-sensitive strings, ret_str is not converted}
   { to uppercased letters. When additionally parameters are be found, only }
   { the first value is returned with ret_str.                              }
   { The minimal matching length, needed for search_str to be found, has to }
   { be indicated by leading capitalized letters in search_str.             }

  Function GetTrueDOSVersion: Word;
   { Returns true DOS version, if DOS >= 5.0, else zero }

  Function GetCPMVersion: Word;
   { Contains Digital Research/Novell CP/M kernel version (DR DOS/Novell DOS etc.)}
   { Returns 0 if not found.                                                      }

  Function DOSVersion: Word;
   { As SYSTEM.DOSVersion. Overridden by SETVERXX.SYS and %DOSVersion% }
   { %DOSVersion% has swapped bytes, that means DOS 5.0 is $0500 (not  }
   { $0050), but DOSVersion still is $0050, to be compatible with      }
   { SYSTEM.DOSVersion.                                                }

  Function IsFreeDOS: Boolean;
   { TRUE, if running under Free-DOS. Overridden by %FreeDOS%          }

  Procedure FSplitDR(path: PathStr; Var dir: DirStr; Var name: NameStr;
                    Var ext: ExtStr; Var password: PassStr);
   { Full replacement for DOS.FSplit, but also splits DR DOS/Novell DOS     }
   { file/directory passwords, that are appended to a filespec, separated   }
   { by a semicolon, e.g. c:\dummy\foo.bar;password                         }
   { In fact, a FSplitDR replacement routine is only necessary, because     }
   { the original FSplit routine skips/truncates a password from the files  }
   { extension (fsExt=4).                                                   }
   { To be compatible with existing sources using FSplit, passwords given   }
   { inside the directory will not be passed to the password variable, if   }
   { it does not end the string, e.g. in 'c:\dummy;dirpass\foo.bar' the     }
   { password would still be passed back as part of the dir, not as         }
   { password, which returns an empty string. This is absolutely compatible }
   { with existing software, as these implicity usage of directory passwords}
   { is not used when creating passwords protected directories. In a string }
   { 'c:\dummy;dirpass\foo.bar;password' the variable password would contain}
   { 'password', not 'dirpass'.                                             }
   { Also, FSplitDR replaces any '/' by '\' in the path. As only filespecs  }
   { should be given as argument to this function, SwitChar is "don't care" }
   { here.                                                                  }
   { If possible, new multiple directory dots (4DOS/NDOS/MS-DOS 7) are      }
   { resolved to the old style, e.g. '...' -> '..\..'.                      }
   { Doubled semicolons are replaced by single semicolons for better        }
   { compatibility with 4DOS/NDOS.                                          }
   { Notes: If a file/dir already is password protected, a password is      }
   { required to get access to the file/dir. If the file should be created  }
   { a pending password will automatically protect the file with maximum    }
   { protection level.                                                      }
   { Similar to DOS.FSplit's handling of ExtStr, FSplitDR will return the   }
   { password including the semicolon. A password can be up to eight chars  }
   { long and normally should only contain valid 'filename' chars.          }
   { Internally FSplit is still used to keep track of enhancements in       }
   { Borlands libraries (FSplit is far away from being perfect...).         }

  Function FExpandDR(path: PathStr): PathStr;
   { Replacement for original FExpand function. Also translates 4DOS/NDOS & }
   { MS-DOS 7 new directory dots to old style, thus allows support on older }
   { DOSes. Replaces doubled semicolons by single semicolons and '/' by '\' }

  Function FileExists(path: PathStr): Boolean;
   { Checks for file existence. Works with any kind of files. }

  Function LFN2Old83Name(LFN_str: String): String;
   { This is only a partially solution to give a bit more support to LFN    }
   { to old style 8.3 DOS applications.                                     }
   { If a LFN does not exceeds 255 chars (unfortunately, a LFN can be       }
   { somewhat longer), it can be converted to an old-style name. This       }
   { allows to use older library functions that cannot solve the new name   }
   { format. Currently this works only for existing files and is untested!  }

  Function TrueName(file_name: PathStr): PathStr;
   { Truename: Returns a canonized filename, if it matches in the length }
   { of PathStr. Under MS-DOS 7 also returns a short 8.3 filename for a  }
   { given LFN and thus is a very good solution to give some support to  }
   { LFN with older sources.                                             }
   { Can be disabled with TRUENAME=Off                                   }

  Function SwitChar: Char;
   { Gets current SwitChar }

  Function SWC: Char;
   { SwitChar, as recorded at startup, overridden by %SwitChar% }

  Function SCS: Boolean;
   { CheckSnow, as recorded at startup, overridden by %CheckSnow% }

  Function SDV: Boolean;
   { DirectVideo, as recorded at startup, overridden by NOT %OutputBIOS% }

 Implementation

  {$IFDEF CRT}
  Uses          { Include this only, if already included by another unit or }
   CRT;         { the main application!!! Not recommented!!!                }
  {$ENDIF}
  {$IFDEF WinCRT}
  Uses
   WinCRT;
  {$ENDIF}

  { Optionally replace Pascal implementations by better assembler routines }
  { $IFDEF SPEEDUP}
  { $L CUI_LIB.OBJ}  { for future use... }
  { $ENDIF}

  Type
   CurDescriptionT = Record { Caching current description line:         }
                      {$IFDEF PCHAR}
                      {$ELSE}
                      dname : PathStr; { Name of current file entry      }
                      {$ENDIF}
                      line  : String;  { Description to <name> file line }
                      ready : Boolean;
                     End;
   {$IFDEF WINDOWS}
   Registers=TRegisters;
   {$ENDIF}

  Const
   MaxLoops        = 10; { How many recursive loops before stopping }
                         { to evaluate ReplaceEnvVars and _DName.   }
   No              = 0;
   Yes             = 1;
   Neither         = 2;
   SW_char         : Char    = '/';
   CS_f            : Boolean = TRUE;
   DV_f            : Boolean = TRUE;
   SHARE_f         : Byte    = 0;
   CUI             : Boolean = TRUE;
   
   DescriptionName : NameStr = 'DESCRIPT';
   DescriptionExt  : ExtStr  = '.ION';
   DescriptionEnd  = Chr(4);
   Copyright       = 'CoPyRiGhT=CUI_LIB V'+CUILib_MainVerStr+'+'+CUILIB_SubVerStr
                     +' (C) 1994-1996 by Axel C. Frinke & Matthias Paul'+Chr(NUL)+Chr(CR)+Chr(LF);

   x_param_flag    : Boolean = FALSE; { internal use by XParamCount }
   x_param_count   : Word    = 0;     { internal use by XParamCount }

  Var
   old_exit_proc   : Pointer; { Pointer to old ExitProc.                                       }
   in_ANSI_sequence: Boolean; { Flag to restore old colors, if aborted inside a sequence.      }
   in_ValWord      : Boolean; { Flag to avoid endless recursion in ValWord() with XGetEnv().   }
   stdout_redir    : Boolean; { Reflects if output redirection has been performed by this unit.}
   stdin_redir     : Boolean; { Reflects if input redirection has been performed by this unit. }
   counter         : Word;
   bool_buf        : Boolean;
   str_buf         : String;
   sym_str         : SymStringT;
   dir_buf         : DirStr;
   name_buf        : NameStr;
   ext_buf         : ExtStr;
   psp_cmd_line    : ^String127;
   l_cmd_dec       : Byte;

   priv_desc, dir_desc, user_desc: CurDescriptionT; { Used for caching }
   str_counter     : Byte; { Used exclusively by SubStr and StrCount!!! }
   DOS_version     : Word;
   free_DOS        : Boolean;

  Function IsINT2FValid: Boolean;
   { Internal routine: Returns TRUE if INT2F is predefined }
   Var
    regs: Registers;
   Begin
    With regs Do
     Begin
      AX:=$352F;         { get INT2F vector }
      Flags:=FDirection;
      MSDOS(regs);
      IsINT2FValid:= ((BX OR ES) > 0);
     End; {With}
   End; {IsINT2FValid}

  Function IsWINDOWSRunning: Boolean;
   Var
    regs: Registers;
   Begin
    With regs Do
     Begin
      IsWINDOWSRunning:=FALSE;
      If INT2FValid Then
       Begin
        AX:=$1600;
        Intr($2F, regs);
        Case AL Of
         $01, $FF, $03..$7F: IsWINDOWSRunning:=TRUE;
        End; {Case}
       End;
     End; {With}
   End; {IsWINDOWSRunning}

  Function IsDESQViewRunning: Boolean;
   { DESQView/TopView/TaskView etc. }
   Var
    regs: Registers;
   Begin
    With regs Do
     Begin
      AX:=$1022;
      BX:=0;
      Intr($15, regs);
      IsDESQViewRunning:=(BX > 0);
     End; {With}
   End; {IsDESQViewRunning}

  Function IsTaskSwitcherRunning: Boolean;
   Var
    regs: Registers;
   Begin
    With regs Do
     Begin
      If INT2FValid Then
       Begin
        AX:=$4B02;
        BX:=0;
        ES:=0;
        DI:=0;
        Intr($2F, regs);
        IsTaskSwitcherRunning:=((ES OR DI) > 0);
       End
      Else
       IsTaskSwitcherRunning:=FALSE;
     End; {With}
   End; {IsTaskSwitcherRunning}

  Function IsTASKMGRRunning: Boolean;
   Var
    { Also affects Windows DOS-Boxes if Novell DOs 7 TASKMGR is }
    { used instead of the original Windows TASKMAN.             }
    regs: Registers;
   Begin
    With regs Do
     Begin
      If INT2FValid Then
       Begin
        AX:= $2700;
        Intr($2F, regs);
        IsTASKMGRRunning:=(AL = $FF);
       End
      Else
       IsTASKMGRRunning:=FALSE;
     End; {With}
   End; {IsTASKMGRRunning}

  Function Displayable(c: Char): Char;
   { Replaces non-displayable chars by spaces }
   Begin
    Case c Of
     #0..#31: Displayable:=Chr(SPACE)
     Else     Displayable:=c;
    End {Case}
   End; {Displayable}

  Function HexPrint(value: LongInt; nr: Byte): String;
   { Returns a hex-string from w }
   Const
    hex_table: Array [0..15] Of Char = '0123456789ABCDEF';
   Var
    c: Char;
   Begin
    c:=hex_table[value AND $0F];
    If (nr > 1) Then HexPrint:=Concat(HexPrint(value SHR 4, Pred(nr)), c)
    Else HexPrint:=c;
   End; {HexPrint}

  Function ChrSet2Str(chr_set: ChrSetT): String;
   { Converts a ChrSet to a string containing the same chars }
   Var
    str    : String;
    counter: Byte;
   Begin
    str:='';
    For counter:=0 To 255 Do
     If (Chr(counter) In chr_set) Then AppendChr(str, Chr(counter));
    ChrSet2Str:=str;
   End; {ChrSet2Str}

  Procedure Str2ChrSet(chr_str: String; Var chr_set: ChrSetT);
   { Converts a string to a ChrSetT containing the same chars }
   Var
    counter: Byte;
   Begin
    chr_set:=[]; { empty set }
    For counter:=1 To Length(chr_str) Do
     chr_set:=chr_set+[chr_str[counter]];
   End; {Str2ChrSet}

  Function Str2Chr(str: String; pos: Byte): Char;
   { Returns #0 if pos out of range }
   Begin
    If ((Length(str) >= pos) And (pos > 0)) Then Str2Chr:=str[pos]
    Else Str2Chr:=#0;
   End; {Str2Chr}

  {$IFDEF SPEEDUP}
  Function PosC(chr: Char; str: String): Byte; Assembler;
   { Faster replacement for Pos(chr, str) }
   { Not yet tested!                      }
   ASM
    LES  DI, str       { address in ES:DI    }
    MOV  CL, ES:[DI]   { get length of str   }
    AND  CX, 00FFh     { pad CH              }
    MOV  BX, CX        { store CX            }
    JZ   @zero         { length zero? zero   }
    MOV  AL, chr       { get chr in AL       }
    CLD                { clear direction bit }
    REPNE SCASB        { scan str for AL     }
    JNE  @zero         { not found? zero     }
    MOV  AX, BX        { get old length      }
    SUB  AX, CX
    JMP  @skip
    @zero:
    XOR  AX, AX        { assume: result=0    }
    @skip:
   End; {ASM/PosC}
  {$ELSE}
  Function PosC(chr: Char; str: String): Byte;
   Begin
    PosC:=Pos(chr, str);
   End; {PosC}
  {$ENDIF}

  Function ANSIColorStr(color, back_color: Byte): String;
   { Returns a ANSI color sequence (currently maximal length is 11 chars). }
   Type
    String4 = String[4];
   Const
    ANSINorm     = '0';
    ANSIHigh     = '1;';
    ANSIBlack    = '30';
    ANSIRed      = '31';
    ANSIGreen    = '32';
    ANSIBrown    = '33';
    ANSIBlue     = '34';
    ANSIMagenta  = '35';
    ANSICyan     = '36';
    ANSIWhite    = '37';
    ANSIBlackH   = '40';
    ANSIRedH     = '41';
    ANSIGreenH   = '42';
    ANSIBrownH   = '43';
    ANSIBlueH    = '44';
    ANSIMagentaH = '45';
    ANSICyanH    = '46';
    ANSIWhiteH   = '47';
    ANSICols     : Array [0..15] Of String4 =
                   (ANSIBlack, ANSIBlue, ANSIGreen, ANSICyan,
                    ANSIRed, ANSIMagenta, ANSIBrown, ANSIWhite,
                    ANSIHigh+ANSIBlack, ANSIHigh+ANSIBlue,
                    ANSIHigh+ANSIGreen, ANSIHigh+ANSICyan,
                    ANSIHigh+ANSIRed, ANSIHigh+ANSIMagenta,
                    ANSIHigh+ANSIBrown, ANSIHigh+ANSIWhite);
    ANSIColsH    : Array [0..15] Of String4 =
                   (ANSIBlackH, ANSIBlueH, ANSIGreenH, ANSICyanH,
                    ANSIRedH, ANSIMagentaH, ANSIBrownH, ANSIWhiteH,
                    ANSIHigh+ANSIBlackH, ANSIHigh+ANSIBlueH,
                    ANSIHigh+ANSIGreenH, ANSIHigh+ANSICyanH,
                    ANSIHigh+ANSIRedH, ANSIHigh+ANSIMagentaH,
                    ANSIHigh+ANSIBrownH, ANSIHigh+ANSIWhiteH);
   Begin
    If (color In [0..15]) Then
     ANSIColorStr:=Concat(ANSINorm,';',ANSICols[color],';',ANSIColsH[back_color])
    Else        { length: 1         2  3456             7  8901 = 11 }
     ANSIColorStr:=ANSINorm;
   End; {ANSIColorStr}

  Function IsStdOutRedir: Boolean;
   { TRUE if Standard Output is redirected.                           }
   { Currently not related with internal standard output redirection! }
   Var
    regs: Registers;
   Begin
    With regs Do
     Begin
      AX:=$4400;       { DOS function "Get device attributes"     }
      BX:=TextRec(OutPut).Handle; { Handle 1 (standard output)    }
      MSDOS(regs);
      IsStdOutRedir:=Not ((DL AND $82)=$82); { DEVICE/FILE & StdOut bits    }
     End; {With}
   End; {IsStdOutRedir}

  Function CursorY: Byte;
   Var
    columns: Byte;
   Begin
    If IsStdOutRedir Then
     CursorY:=0 { Assuming it was at the start of a line is all we can do }
    Else
     Begin
      ASM
       {$IFDEF OBSOLETE}
       PUSH DS
       {$ENDIF}
       CLI             { Do not disturb                           }
       MOV  AX, 0F03h  { Get current video mode                   }
       XOR  BX, BX     { assume default                           }
       XOR  SI, SI     { to strip off other Non-BIOS providers    }
       INT  10h        { Call video BIOS: BH = current page       }
       MOV  AX, 0300h  { Get cursor position & size (in page BH)  }
       INT  10h        { Call video BIOS: DH = row, DL = column   }
       MOV  columns, DL
       STI
       {$IFDEF OBSOLETE}
       POP DS
       {$ENDIF}
      End; {ASM}
      CursorY:=columns;
     End;
   End; {CursorY}

  Function MaxY: Word;
   Var
    columns: Byte;
   Begin
    If IsStdOutRedir Then
     MaxY:=80 { Assuming 80xyy 'screen' mode is all we can do here }
    Else
     Begin
      ASM
       {$IFDEF OBSOLETE}
       PUSH DS
       {$ENDIF}
       MOV  AX, 0F03h  { Get current video mode                   }
       XOR  BX, BX     { to select from other Non-BIOS providers  }
       XOR  SI, SI     {                                          }
       INT  10h        { Call video BIOS: AH = max chars / line   }
       MOV  columns, AH
       {$IFDEF OBSOLETE}
       POP  DS
       {$ENDIF}
      End; {ASM}
      MaxY:=columns;
     End;
   End; {MaxY}

  Function GetVMode: Byte;
   Var
    mode: Byte;
   Begin
    ASM
     {$IFDEF OBSOLETE}
     PUSH DS
     {$ENDIF}
     MOV  AX, 0F03h    { Get current video mode                   }
     XOR  BX, BX       { to select from other Non-BIOS providers  }
     XOR  SI, SI       {                                          }
     INT  10h          { Call video BIOS: AL=mode                 }
     MOV  mode, AL
     {$IFDEF OBSOLETE}
     POP  DS
     {$ENDIF}
    End; {ASM}
    GetVMode:=mode;
   End; {MaxY}

  Procedure SetVMode(mode: Byte);
   { This routine is designed to set 'standard' video modes, and therefor }
   { may be conflictive with special 'modes' 70h, 7Eh, 7Fh, used by some  }
   { Everex or Paradise video adapters.                                   }
   Begin
    ASM
     {$IFDEF OBSOLETE}
     PUSH DS
     {$ENDIF}
     XOR  AX, AX       { Set video mode: AH=0                    }
     MOV  BX, 0FFFFh   { to decide from other APIs at INT10h/00h }
     MOV  AL, mode     { (as best as can be)                     }
     INT  10h          { Call video BIOS                         }
     {$IFDEF OBSOLETE}
     POP  DS
     {$ENDIF}
    End; {ASM}
   End; {SetVMode}

  Procedure AlignStartupVMode(columns_needed: Byte);
   { Aligns to 80x25 mode, if less than 80 cols at startup }
   { columns_needed currently may only be LE 80!           }
   Begin
    If (MaxY < columns_needed) Then { set a higher videomode }
     { No easy way known to decide mono/color modes without direct access }
     { to BIOS data area. If you know of a better mechanism, please tell  }
     { us.                                                                }
     If (GetVMode <> 7) Then
      Begin
       If (MemW[$0040:$0063] = $03D4) Then SetVMode(3)
       Else
        If (MemW[$0040:$0063] = $03B4) Then SetVMode(7);
        { Else: very unusual: better do nothing }
      End
     Else SetVMode(7); { Very unusual, mono mode with less than 80 cols }
   End; {AlignStartupVMode}

  Procedure WriteANSI(col: Byte; str: String);
   { Writes a message in color col using ANSI sequences, if ANSI is enabled. }
   { If the cursor is not in column 0, a WriteLn is performed first.         }
   Begin
    If ANSI Then
     Begin
      {$IFDEF CRT}
      If (col In [0..15]) Then TextColor(col)
      Else TextColor(LightGray);
      {$ELSE}
      If (CursorY > 0) Then WriteLn; { Must start in column 0 }
      in_ANSI_sequence:=TRUE;
      Write(Concat(Chr(ESC),'[',ANSIColorStr(col, Black),'m',Chr(CR)));
      {$ENDIF}
     End;
    Write(str);
   End; {WriteANSI}

  Procedure WriteLnANSINorm;
   { WriteLn message color back to 'Gray': Normal.  }
   { Use only at the end of a line (the cursor must }
   { not be nearer than 7 spaces to the lines end!) }
   Var
    ansi_str: String[16]; { Currently, the maximal string length is 16 here. }
   Begin
    If ANSI Then
     Begin    { Length: 1234  5         6  7                     8  9       10      11      12       3456 = 16 }
      {$IFNDEF CRT}
      ansi_str:=Concat('    ',Chr(ESC),'[',ANSIColorStr(16, 16),'m',Chr(BS),Chr(BS),Chr(BS),Chr(BS),'    ');
      If (CursorY+Length(ansi_str)-4 > MaxY) Then
       Begin { Not enough room at the end of the line }
        WriteLn;         { First, go in the next line }
        Write(Concat(ansi_str, Chr(CR))); { Emit ansi sequence }
       End
      Else { Enough room at the end of the line to emit ansi sequence }
       WriteLn(ansi_str)
      {$ELSE}
      TextColor(LightGray);
      TextBackGround(Black);
      WriteLn;
      {$ENDIF}
     End
    Else
     WriteLn;
    in_ANSI_sequence:=FALSE;
   End; {WriteLnANSINorm}

  Procedure WriteLnANSI(col: Byte; str: String);
   { As WriteANSI, but actually a WriteLn }
   Begin
    WriteANSI(col, str);
    WriteLnANSINorm;
   End; {WriteLnANSI}

  Function IsANSIAPI: Boolean;
   Var
    regs: Registers;
   Begin
    If INT2FValid Then
     With regs Do
      Begin
       AX:=$1A00;           { Installation check for ANSI driver   }
       BX:=$0000;           { to select from other version checks  }
       Intr($2F, regs);     { (Works for ANSIPLUS & AVATAR, too,   }
       IsANSIAPI:=(AL=$FF); { but not for EANSI and other clones.) }
      End {With}            { Also supported by K3PLUS v6.50+.     }
    Else
     IsANSIAPI:=FALSE;
   End; {IsANSIAPI}

  Function DetectANSI: Boolean;
   { This is a very good dynamical detection method. Works with all kinds   }
   { of ANSI implementations (ANSI.SYS, EANSI, ANSIPLUS, etc.), and also in }
   { CONFIG.SYS (many other dynamical detection methods do NOT work during  }
   { CONFIG.SYS).                                                           }
   { As this detection method needs some feedback (via BIOS function), it   }
   { does not work during output redirection and common remote ANSI terminal}
   { sessions (CTTY comx:). (Virtual) remote sessions based on the OS may   }
   { work. But, if the (remoted) ANSI driver supports the standard ANSI-API,}
   { a remote session is also detected. If your ANSI driver does not support}
   { the ANSI-API (e.g. EANSI and many SuperVGA drivers do not), you can try}
   { our much extended keyboard driver K3PLUS, that automatically fakes an  }
   { ANSI-API, if it detects an ANSI driver that does not support the API by}
   { itself. As - in such case - the API is tested on the remote machine    }
   { and not on the terminal machine, this method is not absolutely fool-   }
   { proof. But, if an ANSI driver is loaded (on the remote machine), we    }
   { can assume, that it should be allowed to be used, and that a terminal, }
   { connected to it, would also support ANSI sequences. If not, variables  }
   { %ANSI% and %_ANSI% are used to override this.                          }
   { To avoid misbehaviour, it results FALSE in cases, where no ANSI driver }
   { can be detected.                                                       }
   Var
    flags: Word;
   Label
    Start, Found, ANSICursorRightSeq, ANSIRemoveSeq;
   Begin
    WriteLn; { *Always* start in a new line (align cursor pos) }
    If (Not IsStdOutRedir) Then
     Begin
      ASM
       PUSH DS
       JMP  Start
      { Subject to be improved if cursor not placed in first column   }
      { ANSI sequence to get current cursor position does not work    }
      { during CONFIG.SYS, so ANSI sequence to change cursor position }
      { was used instead, but this does not work in remote terminal   }
      { sessions.                                                     }
      ANSICursorRightSeq: DB 1Bh,'[C$'
      ANSIRemoveSeq:      DB BS,BS,BS,BS,'    ',BS,BS,BS,BS,'$'
      Start:
       CLI             { Do not disturb (if possible...)          }
       MOV  AX, 0F03h  { Get current video mode                   }
       XOR  BX, BX     { to select from other Non-BIOS providers  }
       XOR  SI, SI
       INT  10h        { Call video BIOS: BH = current page       }
       MOV  AX, 0300h  { Get cursor position & size (in page BH)  }
       INT  10h        { Call video BIOS: DH = row, DL = column   }
       PUSH DX         { Store                                    }
       PUSH CS         { Align DS:=CS                             }
       POP  DS
       MOV  DX, OFFSET ANSICursorRightSeq
       MOV  AH, 9      { DS:DX                                    }
       INT  21h        { Output ANSI sequence via standard output }
       MOV  AX, 0300h  { Again, get cursor position & size        }
       INT  10h        {          DL = new column value           }
       POP  CX         { Restore: CL = old column value           }
       PUSH CX         { Store again                              }
       INC  CX         { Align old position to expected position  }
       CMP  DL, CL     { Has ANSI moved the cursor?               }
       JE   Found      { Yes: ok, ANSI is active                  }
       PUSHF           { Store flags                              }
       MOV  DX, OFFSET ANSIRemoveSeq { ANSI not active (or remote }
       MOV  AH, 9      { session), so remove the former sequence  }
       INT  21h        { DS:DX                                    }
       POPF            { Restore flags                            }
      Found:           {                                          }
       POP  DX         { Restore old cursor position in DX        }
       PUSHF           { Store flags                              }
       MOV  AX, 0200h  { DX=pos, BH=page                          }
       INT  10h        {                                          }
       POP  flags      { Restore flags (JZ if ANSI found)         }
       STI             {                                          }
       POP  DS
      END; {ASM}
      If ((flags AND fZero) <> fZero) Then { No ANSI detected.            }
       DetectANSI:=IsANSIAPI { If a (remote) session supports ANSI API    }
      Else                   { this can be used to assume ANSI installed. }
       DetectANSI:=TRUE;     { ANSI has been functional. }
     End
    Else
     DetectANSI:=FALSE; { Cannot actually detect with output redirected }
   End; {DetectANSI}

  Procedure Beep;
   { Emits a short Beep, if enabled }
   Begin
    If Beeps Then
     Write(#7);
   End; {Beep}

  { $IFDEF SPEEDUP}
  { Procedure UpStr(Var str: String); External; }
  { $ELSE}
  Procedure UpStr(Var str: String);
   { Capitalizes str by explicit usage of Borlands UpCase }
   { (for reasons of consistency)                         }
   Var
    counter: Byte;
   Begin
    For counter:=1 To Length(str) Do
     str[counter]:=UpCase(str[counter]);
   End; {UpStr}
  { $ENDIF}

  Procedure UpStrC(Var str: String);
   { Country depending capitalizes str (if possible, by DOS) }
   Var
    len : Word;
    segm: Word;
    ofst: Word;
    regs: Registers;
   Begin
    len:=Length(str);
    If (len > 0) Then { Only with len>0: at least Novell DOS 7 (Update 15)  }
     With regs Do { Delays for seconds or crashes with EMM386 protection    }
      Begin       { fault or stack overflow when called with len=0!!!       }
       {$B-}
       If ((Lo(DOSVersion) >= 4) And (Not IsFreeDOS)) Then
        Begin
         segm:=Seg(str);
         ofst:=Succ(Ofs(str));
         AX  :=$6521;
         CX  :=len;
         DS  :=segm;
         DX  :=ofst;
         MSDOS(regs);
        End
       Else
        Flags:=FCarry; { simulate error }
       If ((Flags AND FCarry) <> 0) Then { error }
        UpStr(str);
      End; {With}
   End; {UpStrC}

  Function ToUpper(str: String): String;
   { Returns a capitalized string (as UpStr) }
   Begin
    UpStr(str);
    ToUpper:=str;
   End; {ToUpper}

  Function ToUpperC(str: String): String;
   { Returns a country dependend capitalized string (if possible, by DOS). }
   Begin
    UpStrC(str);
    ToUpperC:=str;
   End; {ToUpperC}

  Function UpCaseC(chr: Char):Char;
   { Country depending UpCase (if possible, by DOS) }
   Var
    str: String[1];
   Begin
    str:=chr;
    str:=ToUpperC(str);
    UpCaseC:=str[1];
   End; {UpCaseC}

  {$IFDEF SPEEDUP}
  Procedure AppendChr(Var str: String; chr: Char); Assembler;
   { Faster replacement routine for                          }
   { "str:=str+chr;" or "Insert(chr, str, Length(str)+1)"    }
   ASM
    LES  DI, str        { get address of str }
    MOV  CL, ES:[DI]    { get length in CL   }
    INC  CL             { add one (255->0)   }
    XOR  CH, CH         { pad high byte      }
    JCXZ @skip          { overrun (CX=0)?    }
    MOV  ES:[DI], CL    { place new length   }
    ADD  DI, CX         { pointer to next pos}
    MOV  AL, chr        { store chr...       }
    MOV  ES:[DI], AL    { ...at end of string}
    @skip:
   End; {ASM/AppendChr}
  {$ELSE}
  Procedure AppendChr(Var str: String; chr: Char);
   { Replace by Pascal routine. It would be best if this was a macro. }
   Begin
    Insert(chr, str, Succ(Length(str)));
   End; {AppendChr}
  {$ENDIF}

  {$IFDEF SPEEDUP}
  Procedure AppendStr(Var str: String; append_str: String); Assembler;
   { Very fast replacement routine for                       }
   { "str:=str+append_str" or "str:=Concat(str, append_str)" }
   ASM
    LES  DI, str        { get address of str }
    MOV  AL, ES:[DI]    { in ES:DI; length   }
    XOR  AH, AH         { in AL; AH:=0       }
                        {                    }
    PUSH DS             { save DS            }
    LDS  SI, append_str { get address or app }
    MOV  CL, DS:[SI]    { str in DS:SI; len  }
    XOR  CH, CH         { in CL; CH:=0       }
    JCXZ @skip          { empty(CX=0)? skip  }
                        {                    }
    MOV  BX, DI         { store DI           }
    INC  DI
    INC  SI
    ADD  DI, AX         { point to end of str}
    CLD                 { clear direction bit}
    @add_chr:           {                    }
    CMP  AL, 0FFh       { length=255? full   }
    JE   @full          {                    }
    INC  AX             { inc length of str  }
    MOVSB               { ES:[DI]:=DS:[SI]   }
    LOOP @add_chr       { CX zero? loop/exit }
    @full:              {                    }
    MOV  DI, BX         { restore DI         }
    MOV  ES:[DI], AL    { store new length   }
    @skip:              {                    }
    POP  DS             { restore old DS     }
   End; {ASM/AppendStr}
  {$ELSE}
  Procedure AppendStr(Var str: String; append_str: String);
   { Replace by Pascal routine. It would be best if this was a macro. }
   Begin
    Insert(append_str, str, Succ(Length(str)));
   End; {AppendStr}
  {$ENDIF}

  Procedure Str2ASCIZ(str: String; Var p_chr: ChrArrT);
   { Converts a Pascal string to an ASCIZ string.                        }
   { Adds a #0 at the end of the string, even if the string is too long. }
   Var
    counter: Byte;
   Begin
    For counter:=1 To Length(str) Do p_chr[Pred(counter)]:=str[counter];
    p_chr[Length(str)]:=#0;
   End; {Str2ASCIZ}

  Function ASCIZ2Str(p_chr: PChar): String;
   { Converts an ASCIZ string to a Pascal string. }
   Type
    chr_ptr = ^ChrArrT;
   Var
    counter: Byte;
    new_str: String;
    c      : Char;
   Begin
    new_str:='';
    For counter:=0 To Pred(MaxStringLen) Do
     Begin
      c:= chr_ptr(p_chr)^[counter];
      If (c = #0) Then Break;
      AppendChr(new_str, c);
     End; {For}
    ASCIZ2Str:=new_str;
   End; {ASCIZ2Str}

  Function JustifyR(str: String; len: Byte; pad_chr: Char): String;
   { Right-justify str to len, padding with pad_chr }
   Var
    counter: Byte;
    pad_str: String;
   Begin
    If (len > Length(str)) Then
     Begin
      pad_str:='';
      For counter:=Succ(Length(str)) To len Do
       AppendChr(pad_str, pad_chr); { work 'in place' }
      JustifyR:=Concat(pad_str, str);
     End
    Else
     JustifyR:=str;
   End; {JustifyR}

  Function IntToStr(value: LongInt; width: Byte): String;
   { Makes string from any Integer type. }
   { If width is not used, set to 0.     }
   Var
    str_: String;
   Begin
    If (width = 0) Then Str(value, str_)
    Else Str(value:width, str_);
    IntToStr:=str_;
   End; {IntToStr}

  Function LeadingCAPS(search_str: String): Byte;
   { Gets count of leading capitalized chars in string. }
   Var
    min_len: Byte;
   Begin
    { As a 'For' instructions loop variable is undefined after exiting }
    { the loop, this normally cannot be replaced by a faster 'For'     }
    { implementation.                                                  }
    min_len:=1;
    {$B-}
    While ((min_len <= Length(search_str)) And
           (search_str[min_len] = UpCaseC(search_str[min_len])) ) Do
     Inc(min_len);
    LeadingCAPS:=Pred(min_len);
   End; {LeadingCAPS}

  Function GetANSIColoredStr(str: String; col, len: Byte): String;
   { Get an ANSI colored string (color <col>), if ANSI is enabled. }
   { Can be used to concat partially colored strings for a message }
   { line. Colors only the first <len> Chars of the string.        }
   { The result should only be displayed via WriteLnANSI, because  }
   { of the internal ANSI handling.                                }
   { Attention: This routine may corrupt display, if ANSI is not   }
   { set correctly.                                                }
   Begin
    If ANSI Then
     Begin
      {$IFNDEF CRT}
      { should start in a new line }
      str:=Concat(Chr(ESC),'[',ANSIColorStr(col, Black),'m',
                  Copy(str, 1, len),
                  Chr(ESC),'[',ANSIColorStr(16, 16),'m',
                  Copy(str, Succ(len), MaxStringLen));
      {$ENDIF}
     End;
    GetANSIColoredStr:=str;
   End; {GetANSIColoredStr}

  Function DispParam(par:String; SWC_flag: Boolean): String;
   { Utility routine for application syntax screens }
   Begin
    If SWC_flag Then
     DispParam:=GetANSIColoredStr(Concat(SWC, par), HighLightColor, Succ(LeadingCAPS(par)))
    Else
     DispParam:=GetANSIColoredStr(par, HighLightColor, LeadingCAPS(par));
   End; {DispParam}

  Procedure DelLeadIn(Var str: String; leadin_set: ChrSetT);
   { Strips leading spaces <leadin_set> from str }
   Var
    leadin: Byte;
   Begin
    { As a 'For' instructions loop variable is undefined after exiting }
    { the loop, this normally cannot be replaced by a faster 'For'     }
    { implementation.                                                  }
    leadin:=1;
    {$B-}
    While ((leadin <= Length(str)) And (str[leadin] In leadin_set)) Do
     Inc(leadin); { work 'in place' }
    Delete(str, 1, Pred(leadin));
   End; {DelLeadIn}

  Procedure DelLeadOut(Var str: String; leadout_set: ChrSetT);
   { Strips leadout chars from <leadout_set> from str }
   Var
    leadout: Byte;
   Begin
    { As a 'For' instructions loop variable is undefined after exiting }
    { the loop, this normally cannot be replaced by a faster 'For'     }
    { implementation.                                                  }
    leadout:=Length(str);
    {$B-}
    While ((leadout > 0) And (str[leadout] In leadout_set)) Do
     Dec(leadout); { work 'in place' }
    Delete(str, Succ(leadout), MaxStringLen);
   End; {DelLeadOut}

  Function PosSet(char_set: ChrSetT; str: String): Byte;
   { Works like Pos(), but checks for first occurence of char from char_set }
   Var
    counter: Byte;
    found  : Boolean;
   Begin
    PosSet :=0; {assume: not found}
    counter:=1;
    found  :=FALSE;
    While ((Not found) And (counter <= Length(str))) Do
     Begin
      If (str[counter] In char_set) Then
       Begin
        found :=TRUE;
        PosSet:=counter;
       End;
      Inc(counter);
     End; {While}
   End; {PosSet}

  Function SubStr(str: String; number: Byte): String;
   { Gets substring[number] from str, separated by WhiteChrSet or SWC }
   { A SWC followed by a WhiteChr is handled like a part of the       }
   { former parameter.                                                }
   { When using this function for general purposes, always remind that}
   { it has been specially designed to handle parameter strings. Using}
   { SWCs, the results may be (but generally are not) much different  }
   { from a generic SubStr only handling WhiteChrSet.                 }
   Var
    position: Byte;
    pos_offs: Byte;
    sub_str, tmp_str : String;
   Begin
    str_counter:=0;
    sub_str    :=str;
    DelLeadIn(str, WhiteChrSet); { delete spaces, but not SWC! }
    While ((Length(str) > 0) And (str_counter < number)) Do
     Begin
      position:=PosSet(WhiteChrSet+[SWC], str);
      If (position > 0) Then { found }
       Begin
        {$B-}
        If ((str[position] = SWC) And
            ((position = Length(str)) Or
             ((position < Length(str)) And (str[Succ(position)] In WhiteChrSet)))) Then
         { This is a 'postfixed' SWC and should not be handled like a new }
         { parameter, but as part of the former parameter!                }
         { So, strip off all including the SWC.                           }
         Begin
          sub_str:=Copy(str, 1, position);
          Delete(str, 1, position);
         End
        Else
         { If a SWC is found, it is not a 'postfix', but a new parameter.   }
         { If a WhiteChr is found, this is a new parameter, too.            }
         { So, don't strip off the char[position], as it's part of the next }
         { parameter (if any).                                              }
         If (str[1]=SWC) Then { position=1, here }
          Begin
           While ((position < Length(str)) And (str[Succ(position)] = SWC)) Do
            { skip a sequence of SWCs (like '////') }
            Inc(position);
           If ((SWC = '-') And (position > 1)) Then
            Dec(position); { don't delete a doubled '-' prefix, e.g. /-Y }
           { position now points to the last prefix SWC of the first parameter }
           tmp_str :=Copy(str, Succ(position), MaxStringLen); { rest of string }
           pos_offs:=PosSet(WhiteChrSet+[SWC], tmp_str);
           If ((position = Length(str)) Or (pos_offs = 0)) Then
            Begin { has been only a sequence of SWCs, so handle like parameter }
             sub_str:=str;
             str:='';
            End
           Else { pos_offs > 0 here }
            Begin { (pos_offs pointing at first occurence of WhiteChr+SWC. }
             { Actually there are more parameters in string.               }
             If ((tmp_str[pos_offs] = SWC) And
                 (((Length(tmp_str) > pos_offs) And
                  (PosSet(WhiteChrSet, tmp_str[Succ(pos_offs)])=1)) Or
                  (Length(tmp_str) = pos_offs)                  )) Then
              Begin { string ending with SWC followed by WhiteChar }
               sub_str:=Copy(str, 1, position+pos_offs);
               str:=Copy(tmp_str, Succ(pos_offs), MaxStringLen);
              End
             Else { string ending with SWC as first char of next parameter }
              Begin { or ending separator was a WhiteChar }
               sub_str:=Copy(str, 1, Pred(position+pos_offs));
               str:=Copy(tmp_str, pos_offs, MaxStringLen);
              End;
            End;
          End
         Else { not a SWC at position 1 }
          Begin
           sub_str:=Copy(str, 1, Pred(position));
           Delete(str, 1, Pred(position));
          End;
        { Delete WhiteChrs now, but not SWCs! }
        DelLeadIn(str, WhiteChrSet);
       End
      Else { not found }
       Begin
        sub_str:=str; { if any, than this is the (last) parameter }
        str:='';      { this is the last loop }
       End;
      Inc(str_counter);
     End; {While}
    If (str_counter = number) Then SubStr:=sub_str
    Else SubStr:='';
   End; {SubStr}

  Function StrCount(str: String): Byte;
   { Returns the number of SubStr, as they are determined by SubStr, }
   { separated by WhiteChrSet and SWC. A SWC followed by a WhiteChr  }
   { is handled like a part of the former parameter.                 }
   Var
    dummy_s: String;
   Begin
    dummy_s:=SubStr(str, MaxStringLen); { 255 is impossible to reach for a }
                                  { 'Pascal String', but sets str_counter. }
    StrCount:=str_counter;        { get the implementation-global variable }
                                  { str_counter which was set by SubStr.   }
   End; {StrCount}

  Function GetParamStr(index: Word; Var par_dec: Byte; Var str: String): Boolean;
   { internal only }
   Var
    psp_cmd: ^String127;
    len    : Byte;
   Begin
    GetParamStr:=FALSE;
    str:=GetEnv('CMDLINE');
    psp_cmd:=Addr(PSPCmdLineCopy); { check copy of original command line }
    len:=Ord(psp_cmd^[0]);
    {$B-}
    If ((Length(str) > 0) And (len >= 127)) Then
     Begin { ok, check CMDLINE }
      If (len > 127) Then len:=127; { Borland BP 7.0 IDE sets 128 here!!! }
      If (psp_cmd^[len] = Chr(13)) Then Dec(len);
      Case Pos(Copy(psp_cmd^, 1, len), str) Of
       0: { not matching: MS-DOS 7 remaining part of cmd or error }
          str:=Concat(Copy(psp_cmd^, 1, len), str);
       1: { identical, that's unusual: take CMDLINE as command line, but }
          { don't strip off first param                                  }
          Begin End
       Else Inc(par_dec); {=1}
       { else: match at offset pos: 4DOS CMDLINE style: take CMDLINE as  }
       { command line, but strip off first parameters, as it's the       }
       { applications name.                                              }
      End; {Case}
      If (index > 0) Then
       Begin
        If ((index+par_dec) <= MaxWord) Then str:=SubStr(str, index+par_dec)
        Else str:='';
        GetParamStr:=TRUE;
       End;
     End
    Else
     str:=''; { always use PSP command line if shorter than 127 chars }
   End; {GetParamStr}

  Function XParamCount: Word;
   { Virtually a replacement for XParamCount(), but optionally uses         }
   { %CMDLINE%, used by 4DOS/NDOS and MS-DOS 7. Automatically adapts to     }
   { different usage of CMDLINE.                                            }
   Var
    str    : String;
    par_dec: Byte;
   Begin
    par_dec:=l_cmd_dec;
    If (Not x_param_flag) Then
     Begin
      str:='';
      If (UseCMDLine And (par_dec = 0)) Then
       Begin
        If GetParamStr(0, par_dec, str) Then Begin End;
        If (Length(str) > 0) Then x_param_count:=StrCount(str)-par_dec;
       End;
      If (Length(str) = 0) Then
       Begin
        x_param_count:=ParamCount;
        If (x_param_count > 0) Then Dec(x_param_count, par_dec);
       End;
      x_param_flag:=TRUE;
     End;
    XParamCount:=x_param_count;
   End; {XParamCount}

  Function XParamStr(index: Word): String;
   { Virtually a replacement for ParamStr(), but optionally uses %CMDLINE%  }
   { instead of the actual command line. %CMDLINE% is supported by 4DOS/NDOS}
   { and by MS-DOS 7 and provides a way to pass long strings (e.g. LFN) to  }
   { the parameter interface.                                               }
   { Note, that currently the handling of substring is somewhat different   }
   { from the general substring separation, as SwitChars are interpreted.   }
   Var
    str    : String;
    found  : Boolean;
    par_dec: Byte;
   Begin
    str:='';
    found:=FALSE;
    par_dec:=l_cmd_dec;
    If ((UseCMDLine And (index > 0) And (par_dec = 0)) And (index <= MaxWord) And (index > 0)) Then
     found:=GetParamStr(index, par_dec, str); { index must be > 0 here }
    If (index = 0) Then str:=ParamStr(0)
    Else
     If ((Length(str) = 0) And (Not found) And ((index+par_dec) <= MaxWord)) Then
      str:=ParamStr(index+par_dec);
    XParamStr:=str;
   End; {XParamStr}

  Function LeadingStrs(str: String; count: Byte): String;
   { Get first count strings from str, also reformating the gaps }
   { between the strings.                                        }
   Var
    counter         : Byte;
    sub_str, tmp_str: String;
   Begin
    sub_str:='';
    For counter:=1 To count Do
     Begin
      tmp_str:=SubStr(str, counter);
      If (Length(tmp_str) = 0) Then Break { no string -> exit loop }
      Else
       Begin
        If (counter > 1) Then AppendChr(sub_str, Chr(SPACE)); { not first loop }
        AppendStr(sub_str, tmp_str);
       End;
     End; {For}
    LeadingStrs:=sub_str;
   End; {LeadingStrs}

  Function IsInStr(sub_str, str: String): Boolean;
   { Returns TRUE, if one of the substrings in sub_str can be found as }
   { a substring in str. Else, this function returns FALSE.            }
   { A substring is a string, that is separated from others by chars   }
   { out of the WhiteChrSet or SWC.                                    }
   Label
    done;
   Var
    counter1, counter2: Byte;
    tmp_str1, tmp_str2: String;
    found             : Boolean;
   Begin
    IsInStr:=FALSE; { assume: 'not found'}
    For counter1:=1 To MaxStringLen Do { FOR loops are faster than WHILE }
     Begin
      tmp_str1:=SubStr(sub_str, counter1);
      If (Length(tmp_str1) = 0) Then Break { exit outer loop }
      Else
       For counter2:=1 To MaxStringLen Do
        Begin
         tmp_str2:=SubStr(str, counter2);
         If (Length(tmp_str2) = 0) Then Break { exit inner loop }
         Else
          If (tmp_str1=tmp_str2) Then
           Begin
            IsInStr:=TRUE;
            Goto done;
           End;
        End; {For2}
     End; {For1}
    done:
   End; {IsInStr}

  Function ReplaceEnvVar(Var str: String): Boolean;
   { TRUE if new variable (derived from str) is to replace (str contains }
   { new string), FALSE if nothing to replace.                           }
   Begin
    ReplaceEnvVar:=FALSE;
    If (ExpandEnvVars And (Length(str) > 2)) Then
     If ((str[1] = '%') And (str[Length(str)] = '%')
        { And (StrCount(str) = 1)}) Then
      Begin { this is NOT conflictive with binary values (Prefix %) }
       str:=Copy(str, 2, Length(str)-2); { strip '%' characters }
       ReplaceEnvVar:=TRUE;
      End;
   End; {ReplaceEnvVar}

  Function GetSetting(str: String; ID: Byte): String; Forward;
   { Forward declaration necessary for XGetEnv. }

  Function XGetEnv(env_var: String): String;
   { Replacement for GetEnv(), but also utilizes description file      }
   { entries (with DescriptionEnvID).                                  }
   { Normally should not be used internaly to avoid recursion and      }
   { stack overflows.                                                  }
   Begin
    If UseDescriptions Then XGetEnv:=GetSetting(env_var, DescriptionEnvID)
    Else XGetEnv:=GetEnv(env_var);
   End; {XGetEnv}

  Function ExpandVar(Var str: String; ask_flag: Boolean): Boolean;
   { If str is an environment string, then replace it by it's value }
   { Also replace %0% .. %9% etc. by the corresponding values.      }
   { Replaces %?%, %?"text"% and %?"text"default%.                  }
   { If ask_flag=TRUE, then %?% will ask for a replacement.         }
   Var
    value, error : Integer;
    replace      : Boolean;
    tmp_str      : String;
    counter      : Byte;
    def_str      : String;
   Begin
    replace:=ReplaceEnvVar(str); { strips off '%'<var>'%' characters }
    If replace Then      { str contains old str without %      }
     Begin               { get new variable from str           }
      tmp_str:=str;
      Val(str, value, error);
      If ((error=0) And (value In [0..(MaxStringLen SHR 2)])) Then
       If (value = 0) Then str:=XParamStr(0) { get string from command line }
       Else
        str:=SubStr(Concat(OrgCmdLine, Chr(SPACE), EnvCmdLine, Chr(SPACE), ExtCmdLine), Byte(value))
      Else { not a value }
       If in_ValWord Then str:=GetEnv(str)  { get string from environment }
       Else
        Begin
         in_ValWord:=TRUE;  { set flag to avoid recursion }
         str:=XGetEnv(str); { get string from environment }
         in_ValWord:=FALSE;
        End;
      If (Length(str) = 0) Then { if no value, then skip looping }
       {$B-}
       If (ask_flag And (Length(tmp_str) > 0) And (tmp_str[1] = '?') And
           ((Length(tmp_str) = 1) Or
            ((Length(tmp_str) > 2) And (tmp_str[2] = '"') And
             (PosC('"', Copy(tmp_str, 3, Length(tmp_str)-2)) > 0)) { with default }
          )) Then
        Begin { ask, if '%?%' or '%?""%' or '%?"text"%' (without the '%')}
         If (Length(tmp_str) > 2) Then
          def_str:=Copy(tmp_str, 3+PosC('"', Copy(tmp_str, 3, Length(tmp_str)-2)), MaxStringLen)
         Else def_str:='';
         If (Not IsStdOutReDir) Then
          Begin
           If (CursorY > 0) Then WriteLn; { Must start in column 0 }
           If (Length(tmp_str) = 1) Then Write('[?]<= ') { was '%?%' }
           Else
            Begin { was '%?"text"% or %?"text"default%' (without the '%')}
             tmp_str:=Copy(tmp_str, 3, Length(tmp_str)-3-Length(def_str)); { extract text }
             For counter:=1 To Length(tmp_str) Do
              If (tmp_str[counter] In ConcatSet) Then tmp_str[counter]:=Chr(SPACE);
             Write('[', tmp_str); { display text }
             If (Not (tmp_str[Length(tmp_str)]='?')) Then Write('?'); { add question mark }
             If (Length(def_str) > 0) Then
              Write('<',def_str,'>');
             Write(']<= '); { display input prompt }
            End;
           ReadLn(str);
          End;
         If (Length(str) = 0) Then { if str still empty, then use default string }
          str:=def_str;
        End
       Else
        replace:=FALSE;
     End;
    ExpandVar:=replace;
   End; {ExpandVar}

  Procedure ValWord(str: String; Var value: Word; Var error: Integer);
   { As Val() for value:Word, evaluates value from str. Can handle all }
   { kinds of decimal, hex, octal, binary and character strings.       }
   {                                                                   }
   {             default  prefix              postfix  digits(w/o fix) }
   { decimal strings: 10  #10, &D10              10d             0..5 }
   { hex strings:         $0F, xF, 0xF, &HF      Fh, 0Fh, 0F$    0..4  }
   { binary strings:      %1001, 0%1001, &B1001  1001b           0..16 }
   {                      Instead of [0,1] digit set, [H,L], [T,F]     }
   {                      are also accepted.                           }
   { octal strings:       @137, &O137            137o            0..6 }
   { characters:          'a', "a", 'ab', "ab"                   0..2  }
   { environment vars:                   %value%                       }
   { ext. command line params:           %x%, x=[0..9]                 }
   { A prefix or postfix without digits will result in zero.           }
   { System environment will be overridden by description file entries }
   { (not recursively).                                                }
   Const
    DecPrefix='#';
    DecPostfix='D';
    HexPrefix='$';
    HexPostfix='H';
    BinPrefix='%';
    BinPostfix='B';
    OctPrefix='@';
    OctPostfix='O';
    ChrFixSet=[Chr($27),'"'];
   Var
    str_tmp   : String;
    error_tmp : Integer;
    prefix    : Boolean;
    replace   : Boolean;
    loops     : Byte;
   Procedure Eval(str: String; Var value: Word; base: Byte; Var error: Integer);
    { No Prefix or Postfix should reach this routine!!! Any invalid char }
    { will result in an error!                                           }
    Var
     index : Byte;
     digits: Byte; { maximal digits for based str to fit in value:Word }
     dig_ok, hl_ok, tf_ok: Boolean;
    Begin
     value  :=0; { assume: zero     }
     index  :=1; { digit counter    }
     error  :=0; { assume: no error }
     dig_ok :=TRUE;
     hl_ok  :=TRUE;
     tf_ok  :=TRUE;
     Case base Of { evaluate maximal count of digits to avoid overflow }
      { more allowed bases can be inserted here }
      2  : digits:=16;
      8  : digits:=6;
      255: digits:=2; { actually this is base 256... }
      Else digits:=0;
     End; {Case}
     While ((index <= Length(str)) And (error=0) And (index <= digits)) Do
      Begin
       If (base <> 255) Then { binary and octal evaluation }
        If (dig_ok And (str[index] In ['0'..Pred(Chr(Ord('0')+base))])) Then
         Begin
          value:=value*base+(Ord(str[index])-Ord('0'));
          hl_ok:=FALSE; { exclude other sets of digits }
          tf_ok:=FALSE;
         End
        Else
         If (hl_ok And (base = 2) And (str[index] In ['H', 'L'])) Then
          Begin { 'High'/'Low' evaluation }
           value:=(value SHL 1); { times two }
           If (str[index]='H') Then Inc(value);
           tf_ok :=FALSE;
           dig_ok:=FALSE;
          End
         Else
          If (tf_ok And (base = 2) And (str[index] In ['T', 'F'])) Then
           Begin { 'True'/'False' evaluation }
            value:=(value SHL 1); { times two }
            If (str[index]='T') Then Inc(value);
            hl_ok :=FALSE; { exclude other sets of digits }
            dig_ok:=FALSE;
           End
          Else { error }
           Begin
            value:=0;
            error:=index;
           End
       Else { character evaluation }
        value:=(value SHL 8)+Ord(str[index]); { SHL 8 = times 256 }
       Inc(index);
      End; {While}
    End; {Eval}
   Function ShortenPrefix(Var str: String; long_prefix, short_prefix: String): Boolean;
    Begin
     If (Pos(long_prefix, str) = 1) Then
      Begin
       str:=Concat(short_prefix, Copy(str, Succ(Length(long_prefix)), {Length(str)-Length(long_prefix)} MaxStringLen));
       ShortenPrefix:=TRUE; { done }
      End
     Else
      ShortenPrefix:=FALSE; { search on }
    End; {ShortenPrefix}
   Begin {ValWord}
    { At a first glance, this routine appears to be much more complicated   }
    { than necessary. The reason for this is, it actually should use Val()  }
    { for decimal and hex values' evaluation to allow further improvements  }
    { by just replacing the standard Val() routine.                         }
    { If a stand-alone algorithm would have been used, it wasn't possible   }
    { to automatically keep track with enhancements provided by forthcoming }
    { Borland libraries' functionality (if any...) so easily.               }
    loops:=0;
    Repeat
     replace:=FALSE;
     prefix :=FALSE;
     UpStrC(str);
     str_tmp:=str;
     DelLeadIn(str, WhiteChrSet+ConcatSet);
     DelLeadOut(str, WhiteChrSet);
     { process hex prefix }
     If (Length(str) > 0) Then
      If (str[1] = 'X') Then
       str[1]:=HexPrefix
      Else { process long 'BASIC' prefixes }
       If Not ShortenPrefix(str, '0X', HexPrefix) Then
        If Not ShortenPrefix(str, '&H', HexPrefix) Then
         If Not ShortenPrefix(str, '&O', OctPrefix) Then
          If Not ShortenPrefix(str, '&B', BinPrefix) Then
           If Not ShortenPrefix(str, '&D', DecPrefix) Then
            If Not ShortenPrefix(str, '0%', BinPrefix) Then
             Begin End;
     { process hex postfix and decimal prefix }
     If (Length(str) > 0) Then
      If (str[1] In [DecPrefix]+[HexPrefix]) Then
       Begin
        If (str[1] = DecPrefix) Then
         Delete(str, 1, 1); { if so, delete the prefix (is default) }
        prefix:=TRUE;
       End
      Else { is a hex postfix? }
       If ((PosC(HexPostfix, str) > 0) Or (PosC(HexPrefix, str) > 0)) Then
        str:=Concat(HexPrefix, str); { make prefix, but do not set prefix=TRUE }
     { evaluate str }
     Val(str, value, error); { first try (proceed with decimal or hex values) }
     { check for errors }
     If (Length(str) > 0) And (error In [1..Length(str)]) Then { error occured: }
      Case str[error] Of
       BinPrefix : Begin
                    Eval(Copy(str, 2, {Pred(Length(str))} MaxStringLen), value, 2, error); { assume binary values }
                    If (error <> 0) Then { error, try environment variable }
                     replace:=ExpandVar(str, FALSE);
                   End;
       OctPrefix : Eval(Copy(str, 2, {Pred(Length(str))} MaxStringLen), value, 8, error); { assume octal values  }
       BinPostfix: Eval(Copy(str, 1, Pred(Length(str))), value, 2, error); { assume binary values }
       OctPostfix: Eval(Copy(str, 1, Pred(Length(str))), value, 8, error); { assume octal values  }
       Else { character, hex|dec postfix or really invalid }
        If ((str[1] In ChrFixSet) And (Length(str) In [2..4]) And
            (str[Length(str)] In ChrFixSet)) Then { assume characters }
         Eval(Copy(str, 2, Length(str)-2), value, 255, error) { ok, str is one or two character(s) }
        Else
         If ((str[error] In (WhiteChrSet+ConcatSet+[SWC])) Or
             ((str[error] In ([DecPostfix]+[HexPostfix]+[HexPrefix])) And (prefix=FALSE))) Then
          Begin
           Val(Copy(str, 1, Pred(error)), value, error_tmp); { try once more }
           If (error_tmp = 0) Then
            If (Length(str)=error) Then
             error:=0 { ok, error occured with postfix. It actually is a valid value! }
            Else
             If (str[error] In (WhiteChrSet+ConcatSet+[SWC])) Then
              error:=0;
          End;
      End; {Case}
     Inc(loops);
    Until ((Not replace) Or (loops >= MaxLoops));
    { return value management }
    If (error <> 0) Then { could not evaluate }
     Begin { evaluate 'correct' error index for given string }
      Val(str_tmp, value, error);
      value:=0;
     End;
   End; {ValWord}

  Procedure ChkYesNo(Var value: Boolean; yesno_val_flag: Boolean; str: String); Forward;

  Function CheckParam(search_str, cmd_line: String;
                      value_flag, yesno_flag, yesno_val_flag: Boolean;
                      Var ret_value: Word; Var ret_str: String): Boolean;
   { Scans cmd_line for search_str and returns TRUE, if found, else FALSE.  }
   { The comparison is not case-sensitive. To make further processing more  }
   { simple, the functions exact behaviour can be controlled by the two     }
   { boolean flags value_flag (<FALSE>) and yesno_flag (<YES>).             }
   {                                                                        }
   { value_flag yesno_flag.                                                 }
   { FALSE      FALSE       The function scans for the parameter search_str }
   {                        and results TRUE, if found. ret_value is always }
   {                        zero and ret_str contains an optional argument  }
   {                        to the parameter.                               }
   { FALSE      TRUE        As with (FALSE, FALSE), but the function checks }
   {                        for a valid Yes/No argument. A 'No' argument    }
   {                        disables the parameter, as if it wasn't set.    }
   {                        The function results FALSE, ret_value is zero   }
   {                        and ret_str is ''.                              }
   {                        With no valid Yes/No parameter or a valid 'Yes' }
   {                        parameter, the function results TRUE, ret_value }
   {                        is zero and ret_str contains the 'Yes'-string.  }
   { TRUE       FALSE       As with (FALSE, FALSE), but the function tries  }
   {                        to evaluate an argument to the parameter.       }
   {                        If no parameter can be found, the function      }
   {                        results FALSE, else TRUE and ret_value contains }
   {                        a valid value or zero, if invalid (or no arg.). }
   {                        If evaluation resulted in 'invalid value', ret_ }
   {                        str returns the argument (which is obviously a  }
   {                        textual argument).                              }
   { TRUE       TRUE        As with (FALSE, FALSE), but the function evals  }
   {                        ret_value. If ret_value is invalid, the function}
   {                        checks for Yes/No (as with (FALSE,TRUE)).       }
   {                                                                        }
   { The yesno_val_flag indicates, if Yes/No determination should stick to  }
   { strings/chars only, or should check for some special numbers as Yes/No,}
   { too (e.g. 0=No, 1=Yes). Generally, this should be TRUE, but in rare    }
   { cases, where argument numbers should not be tested on Yes/No, it is    }
   { adequate to set to FALSE.                                              }
   {                                                                        }
   { To enable returning of case-sensitive strings, ret_str is not converted}
   { to uppercased letters. When additionally parameters will be found, only}
   { the first value is returned with ret_str.                              }
   { The minimal matching length, needed for search_str to be found, has to }
   { be indicated by leading capitalized letters in search_str.             }
   Var
    position, sub_pos: Byte;
    found            : Boolean;
    error            : Integer;
    value            : Word;
    index, min_len   : Byte;
    tmp_cmd_str      : String;
   Begin
    { reset to defaults: }
    ret_value       :=0;
    ret_str         :='';
    tmp_cmd_str     :=cmd_line;
    UpStrC(cmd_line);
    { Evaluate minimal length of parameter (depends on capitalized letters):}
    If (Length(search_str) > 0) Then
     search_str[1]:=UpCaseC(search_str[1]);
    min_len:=LeadingCAPS(search_str);
    UpStrC(search_str);

    { Search for matching parameter (from full to minimal length): }
    index  := Length(search_str);
    found  := FALSE;
    sub_pos:= 0;

    While ((Not found) And (index >= min_len)) Do
     Begin
      position:=Pos(Copy(search_str, 1, index), Copy(cmd_line, Succ(sub_pos), MaxStringLen));
      If (position > 0) Then { if found, then calculate actual position }
       Inc(position, sub_pos);
      If (position > 1) Then { found at offset }
       If (cmd_line[Pred(position)] In (WhiteChrSet+[SWC])) Then found:=TRUE
       Else { not valid, because part of another string        }
        sub_pos:=position { check rest of string from there on }
      Else { not found or found at first position }
       If (position = 1) Then { found at start position }
        found:=TRUE
       Else
        Begin
         Dec(index); { not found, try with shorter matching parameter }
         sub_pos:=0; { reset sub_pos                                  }
        End;
     End; {While}

    error:=0; {???}
    If found Then { check for value }
     If (position + Length(Copy(search_str, 1, index)) <= Length(cmd_line)) Then
      Begin
       Inc(position, Length(Copy(search_str, 1, index)));
       If (cmd_line[position] In SeparatorSet) Then
        Begin
         Inc(position);
         {error:=0;} { init }
        End
       Else { no separator found }
        If (index < Length(search_str)) Then { and not full parameter }
         error:=1; { then simulate an error }
       { strip matching parameter string }
       Delete(cmd_line, 1, Pred(position));
       Delete(tmp_cmd_str, 1, Pred(position));
       If (error = 0) Then { if valid parameter found }
        Begin
         If value_flag Then ValWord(cmd_line, value, error)
         Else error:=1; { simulate an error }
         If (yesno_flag And (error <> 0)) Then  { (Not value_flag) Or error }
          ChkYesNo(found, yesno_val_flag, SubStr(cmd_line, 1)); { 'No' found -> ignore parameter (FALSE) }
        End;
       If Not (yesno_flag And (Not found)) Then { do not ignore parameter }
        If (error = 0) Then ret_value := value
        Else
         Begin { error }
          position:=PosSet(WhiteChrSet+[SWC], cmd_line);
          If (position > 0) Then { end of parameter }
           ret_str:=Copy(tmp_cmd_str, 1, Pred(position))
          Else { no new parameter evaluable }
           ret_str := tmp_cmd_str;
         End;
      End;
    CheckParam := found;
   End; {CheckParam}

  Function CreateTempFile(dir_str: DirStr; attr: Word): PathStr;
   { Creates a unique temp file (closed) }
   Var
    regs    : Registers;
    f       : File;
    path_arr: ChrArrT;
    path_str: String;
    cnt_str : String[6];
    counter : Word;
    result  : Integer;
   Begin
    If ((Lo(DOSVersion) >= 3) And (InOutRes = 0)) Then
     Begin
      Str2ASCIZ(dir_str, path_arr);
      With regs Do
       Begin
        AH:=$5A;
        CX:=0;
        DS:=Seg(path_arr);
        DX:=Ofs(path_arr);
        MSDOS(regs);
        If ((Flags AND FCarry) > 0) Then InOutRes:=AX;
       End; {With}
      path_str:=ASCIZ2Str(Addr(path_arr[0]));
      CreateTempFile:=path_str;
     End
    Else
     Begin
      If (InOutRes = 0) Then { DOS lower 3.0 }
       Begin
        InOutRes:=1;
        {$B-}
        If ((Length(dir_str) > 0) And (Not (dir_str[Length(dir_str)] In ['\', '/']))) Then
         dir_str:=Concat(dir_str, '\'); { append \ at the end (same as DOS would do) }
        For counter:=0 To MaxWord Do
         Begin
          Str(counter, cnt_str);
          path_str:=Concat(dir_str, cnt_str);
          If (Not FileExists(path_str)) Then
           Begin
            InOutRes:=0; { take that path_str }
            Break;
           End;
         End; {For}
       End;
      If (InOutRes = 0) Then
       Begin
        FileMode:=fmReadWrite;
        {$I-}
        Assign(f, path_str);
        Rewrite(f, 1); { Create file }
        {$I+}
        result:=IOResult;
        {$I-}
        Close(f);
        {$I+}
        result:=IOResult;
        CreateTempFile:=path_str;
       End
      Else CreateTempFile:=dir_str;
     End;
   End; {CreateTempFile}

  Procedure LockRecord(Var f; unlock: Boolean; start, count: LongInt; retries: Byte);
   { Locks/Unlocks a file record from offset <start> for <count> Bytes. }
   { If retries > 0, retries automatically after a random time.         }
   { If SHARE not supported, results in IOResult > 0.                   }
   Label
    retry_label;
   Var
    regs   : Registers;
    counter: Word;
   Begin
    If (InOutRes = 0) Then
     If (UseSHARE And (SHARE_f > 0) And (Lo(DOSVersion) >= 3)) Then
      With regs Do
       Begin
        retry_label:
        AX:=$5C00;              { 00 = lock   }
        If unlock Then Inc(AL); { 01 = unlock }
        BX:=FileRec(f).Handle;  { handle of open file         }
        CX:=(start SHR 16);     { start lock/unlock at offset }
        DX:=(start AND $FFFF);
        SI:=(count SHR 16);     { lock/unlock count bytes     }
        DI:=(count AND $FFFF);
        Flags:=FCarry;          { assume error }
        MSDOS(regs);
        If ((Flags AND FCarry) > 0) Then
         Begin
          If ((AX In [33, 36]) And (retries > 0)) Then { file locked by someone else }
           Begin
            Dec(retries);
            Randomize;
            For counter:=0 To Random(1000) Do
             Begin End; { wait a random time to avoid deadlocks }
             { this should be somewhat aligned to system speed  }
             { Another way is INT21h/440Bh...                   }
            Goto retry_label;
           End;
          InOutRes:=Integer(AX);
         End
        Else
         InOutRes:=0; { "no errors" }
       End {With}
     Else
      InOutRes:=1; { result "invalid function" }
   End; {LockRecord}

  Function IsSHARESupported: Boolean;
   { TRUE, if SHARE-API is functional (that is SHARE loaded or support }
   { provided by another driver).                                      }
   Var
    f       : File;
    regs    : Registers;
    dummy   : Word;
    path_str: PathStr;
   Begin
    If ((SHARE_f=0) And UseSHARE And (Lo(DOSVersion) >= 3) And (INT2FValid)) Then
     { only with SHARE_f=0!!! to avoid recursion overflows }
     With regs Do
      Begin
       AX:=$1000;
       Intr($2F, regs);
       Inc(SHARE_f); { SHARE_f = 1 and avoid recursion overflows!!! }
       If (AL = $FF) Then
        Begin
         IsSHARESupported:=TRUE;
         If (AccessDisk And (Lo(DOSVersion) >= 3)) Then { SHARE API supported }
          Begin { perform another check... }
           { XGetEnv is recursive!!! }
           path_str:=XGetEnv('TMP'); { in this order }
           If (Length(path_str) = 0) Then path_str:=XGetEnv('TEMP');
           path_str:=CreateTempFile(path_str, 0);
           FileMode:=fmReadWrite;
           {$I-}
           Assign(f, path_str);
           Reset(f, 1);
           {$I+}
           If (IOResult = 0) Then
            Begin
             dummy:=0;
             {$I-}
             BlockWrite(f, dummy, 1, dummy);
             {$I+}
             If ((IOResult = 0) And (dummy = 1)) Then
              Begin
               {$I-}
               LockRecord(f, FALSE, 0, 1, 0);
               {$I+}
               If (IOResult <> 0) Then
                Begin
                 IsSHARESupported:=FALSE;
                 Inc(SHARE_f); { SHARE_f = 2}
                End;
               {$I-}
               LockRecord(f, TRUE, 0, 1, 0);
               {$I+}
               dummy:=Word(IOResult);
              End;
            End;
           {$I-}
           Close(f);
           {$I+}
           dummy:=Word(IOResult);
           {$I-}
           Erase(f);
           {$I+}
           dummy:=Word(IOResult);
          End;
        End
       Else
        Begin
         IsSHARESupported:=FALSE;
         Inc(SHARE_f); { SHARE_f = 2 }
        End;
      End {With}
    Else
     IsSHARESupported:=(SHARE_f = 1); { SHARE_f=1 is TRUE, =2 is FALSE }
   End; {IsSHARESupported}

  Procedure MakeOldStylePath(Var path: PathStr);
   { Replaces '/' by '\' and new multiple dots (e.g. '...') by old style }
   { \..\.. Also, doubled semicolons (only) are replaced by a single     }
   { semicolon for better compatibility with 4DOS/NDOS, when processing  }
   { DR DOS/Novell DOS file/directory passwords.                         }
   Var
    index, sub_index, old_index, counter: Byte;
    semicolon_found            : Boolean;
    dot_str                    : PathStr;
   Begin
    index:=1;
    semicolon_found:=FALSE;
    While (index <= Length(path)) Do
     Begin
      Case path[index] Of
       '/': { 'new' directory delimiter found }
            Begin { Replace new style '/' by old DOS style '\' }
             semicolon_found:=FALSE;
             path[index]:='\';
             Inc(index);
            End;
       ';': Begin
             Inc(index);
             {$B-}
             If ((semicolon_found=FALSE) And
                 (index <= Length(path)) And (path[index]=';') And { semicolon doubled }
                 ((index = Length(path)) Or
                  ((index < Length(path)) And (path[Succ(index)]<>';'))
                )) Then
              Delete(path, index, 1); { delete one semicolon }
             semicolon_found:=TRUE;
            End;
       '.': Begin
             counter:=0;
             old_index:=index;
             semicolon_found:=FALSE;
             {$B-}
             While ((index <= Length(path)) And (path[index] = '.')) Do
              Begin
               Inc(counter);
               Inc(index);
              End; {While}
             If (counter >= 3) Then
              Begin
               dot_str:='..';
               For sub_index:=3 To counter Do { Append at end of string }
                Insert('\..', dot_str, Succ(Length(dot_str)));
               If ((Length(path)-counter+Length(dot_str)) <= fsPathName) Then
                Begin { if possible, resolve multiple dots to old style }
                 Delete(path, old_index, counter); { replace string }
                 Insert(dot_str, path, old_index);
                End; { if not enough space for old style dots, a partially    }
                { solution would be to resolve redundant entries like \dir\.. }
                { At a first glance this looks simple, but the opposite is    }
                { true, as UNC and netware notations must be taken into       }
                { account, requiring some more pages of sourcecode for        }
                { multiple parsing of the filespec with many case decisions.  }
              End;
            End;
       Else Begin
             Inc(index);
             semicolon_found:=FALSE;
            End;
      End; {Case}
     End; {While}
   End; {MakeOldStylePath}

  Procedure FSplitDR(path: PathStr; Var dir: DirStr; Var name: NameStr;
                    Var ext: ExtStr; Var password: PassStr);
   { Full replacement for DOS.FSplit, but also splits DR DOS/Novell DOS     }
   { file/directory passwords, that are appended to a filespec, separated   }
   { by a semicolon, e.g. c:\dummy\foo.bar;password                         }
   { In fact, a FSplitDR replacement routine is only necessary, because     }
   { the original FSplit routine skips/truncates a password from the files  }
   { extension (fsExt=4).                                                   }
   { To be compatible with existing sources using FSplit, passwords given   }
   { inside the directory will not be passed to the password variable, if   }
   { it does not end the string, e.g. in 'c:\dummy;dirpass\foo.bar' the     }
   { password would still be passed back as part of the dir, not as         }
   { password, which returns an empty string. This is absolutely compatible }
   { with existing software, as these implicitely usage of directory pass-  }
   { words is not used when creating passwords protected directories. In a  }
   { string 'c:\dummy;dirpass\foo.bar;password' the variable password would }
   { contain 'password', not 'dirpass'.                                     }
   { Also, FSplitDR replaces any '/' by '\' in the path. As only filespecs  }
   { should be given as argument to this function, SwitChar is "don't care" }
   { here.                                                                  }
   { If possible, new multiple directory dots (4DOS/NDOS/MS-DOS 7) are      }
   { resolved to the old style, e.g. '...' -> '..\..'.                      }
   { Doubled semicolons are replaced by single semicolons for better        }
   { compatibility with 4DOS/NDOS.                                          }
   { Notes: If a file/dir already is password protected, a password is      }
   { required to get access to the file/dir. If the file should be created  }
   { a pending password will automatically protect the file with maximum    }
   { protection level.                                                      }
   { Similar to DOS.FSplit's handling of ExtStr, FSplitDR will return the   }
   { password including the semicolon. A password can be up to eight chars  }
   { long and normally should only contain valid 'filename' chars.          }
   { Internally FSplit is still used to keep track of enhancements in       }
   { Borlands libraries (FSplit is far away from being perfect...).         }
   Var
    index, counter, marker: Byte;
    pass_str: String;
   Begin
    MakeOldStylePath(path);
    { To be compatible with 4DOS/NDOS filelists, multiple implicitely    }
    { given passwords and Chicago/Windows95/MS-DOS 7 long filenames, the }
    { following routine gets the substring after the very last semicolon,}
    { only.                                                              }
    password:='';
    marker:=0;
    For counter:=1 To Length(path) Do { scan for *last* semicolon }
     If (path[counter] = ';') Then marker:=counter;
    If (marker > 0) Then
     Begin
      pass_str:=Copy(path, marker, MaxStringLen); { get pending string }
      If PosSet(['\','.',':','/'], pass_str) = 0 Then
       Begin
        password:=Copy(pass_str, 1, 8); { extract password  }
        Delete(path, marker, MaxStringLen); { truncate path }
       End; { all *valid* syntaxis for DR/Novell passwords are handled now }
     End;
    FSplit(path, dir, name, ext);
   End; {FSplitDR}

  Function FExpandDR(path: PathStr): PathStr;
   { Replacement for original FExpand function. Also translates 4DOS/NDOS & }
   { MS-DOS 7 new directory dots to old style, thus allows support on older }
   { DOSes. Replaces doubled semicolons by single semicolons and '/' by '\' }
   Begin
    MakeOldStylePath(path);
    FExpandDR:=FExpand(path);
   End; {FExpandDR}

  Function FileExists(path: PathStr): Boolean;
   { Checks for file existence. Works with any kind of files. }
   Var
    result: SearchRec;
   Begin
    DOSError:=0;
    FindFirst(path, AnyFile, result);
    FileExists := ((DOSError = 0) And (path <>''));
   End; {FileExists}

  Function LFN2Old83Name(LFN_str: String): String;
   { This is only a partially solution to give a bit more support to LFN    }
   { to old style 8.3 DOS applications.                                     }
   { If a LFN does not exceeds 255 chars (unfortunately, a LFN can be       }
   { somewhat longer), it can be converted to an old-style name. This       }
   { allows to use older library functions that cannot solve the new name   }
   { format. Currently this works only for existing files and is untested!  }
   Var
    regs     : Registers;
    lfn_arr  : ChrArrT;
    asciz_arr: ChrArrT;
   Begin
    LFN2Old83Name:=LFN_str;
    If UseLFN Then
     With regs Do
      Begin { Although Novell DOS 7 (Update 15) does not support this }
            { function, it always clears CF!                          }
       Str2ASCIZ(LFN_str, LFN_arr);   { preset                     }
       Str2ASCIZ(LFN_str, asciz_arr); { preset to help with non-   }
                                      { support under Novell DOS 7 }
       AX:=$7160;
       CX:=$8001;           { return path with SUBST-drives     }
       DS:=Seg(LFN_arr);    { DS:SI -> ASCIZ filename           }
       SI:=Ofs(LFN_arr);
       ES:=Seg(asciz_arr);  { ES:DI -> buffer to ASCIZ filename }
       DI:=Ofs(asciz_arr);
       Flags:=FCarry;
       MSDOS(regs);
       If ((Flags And FCarry) = 0) Then
        LFN2Old83Name:=ASCIZ2Str(Addr(asciz_arr[0])); { convert ASCIZ -> Pascal string }
      End; {With}
   End; {LFN2Old83Name}

  Function TrueName(file_name: PathStr): PathStr;
   { Truename: Returns a canonized filename, if it matches in the length }
   { of PathStr. Under MS-DOS 7 also returns a short 8.3 filename for a  }
   { given LFN and thus is a very good solution to give some support to  }
   { LFN with older sources.                                             }
   { Can be disabled with TRUENAME=Off                                   }
   Var
    regs           : Registers;
    in_arr, out_arr: ChrArrT;
    str            : String;
   Begin
    If UseTrueName Then
     With regs Do
      Begin
       Str2ASCIZ(file_name, in_arr);
       Str2ASCIZ(file_name, out_arr); { prophylactical only }
       AX:=$6000;
       DS:=Seg(in_arr);
       SI:=Ofs(in_arr);
       ES:=Seg(out_arr);
       DI:=Ofs(out_arr);
       Flags:=FCarry;
       MSDOS(regs);
       If ((Flags And FCarry) = 0) Then
        Begin
         str:=ASCIZ2Str(Addr(out_arr[0]));
         If (Length(str) < SizeOf(PathStr)) Then { new length is matching }
          file_name:=str { if string to long then try something else      }
         Else
          Begin
           str:=LFN2Old83Name(file_name); { last restort }
           If (Length(str) < SizeOf(PathStr)) Then { new length is matching }
            file_name:=str { if string to long then try something else      }
          End;
        End;
      End; {With}
    TrueName:=file_name;
   End; {TrueName}

  Procedure ResetCurDescription(Var cur_desc: CurDescriptionT);
   { Resets current description file information. On next demand          }
   { this forces the description routines actually to reload information  }
   { from description file.                                               }
   Begin
    With cur_desc Do
     Begin
      dname :=''; { if empty, line should not be used }
      line  :='';
      ready :=FALSE;
     End; {With}
   End; {ResetCurDescription}

  Function GetDescription(file_name: PathStr): String;
   { Returns the description line for a file <file_name>, derived from a  }
   { DESCRIPT.ION file in the programs directory.                         }
   { Uses two different cach buffers, a private to always hold the files }
   { description info, and a user buffer, that is used in the case of     }
   { other requests (e.g. an application searching for info about one of  }
   { its data files).                                                     }
   Var
    dir          : DirStr;
    name         : NameStr;
    ext          : ExtStr;
    path         : PathStr;
    password     : PassStr;
    descript_file: Text;
    cur_line     : String;
    found        : Boolean;
   Procedure BufUpdateDesc(Var cur_desc: CurDescriptionT; dname: PathStr; line: String);
    Begin
     cur_desc.dname :=dname;
     cur_desc.line  :=line;
     cur_desc.ready :=TRUE;
    End; {BufUpdateDesc}
   Function BufGetDesc(Var cur_desc: CurDescriptionT; path: PathStr;
                       name: NameStr; ext: ExtStr;
                       Var cur_line: String): Boolean;
    Begin
     With cur_desc Do
      Begin
       If (ready And (dname = path) And
           (SubStr(line, 1) = ConCat(name, ext))) Then
        Begin
         BufGetDesc:=TRUE;
         cur_line:=line;
        End
       Else
        BufGetDesc:=FALSE;
      End; {With}
    End; {BufGetDesc}
   Begin
    FSplitDR(ToUpperC(TrueName(FExpandDR(file_name))), dir, name, ext, password);
    If ((Length(name)=0) And (Length(ext)=0)) Then ext:='.';
    path:=TrueName(Concat(dir, DescriptionName, DescriptionExt));
    { get current description from internal cach buffers }
    If BufGetDesc(priv_desc, path, name, ext, cur_line) Then GetDescription:=cur_line
    Else
     If BufGetDesc(dir_desc, path, name, ext, cur_line) Then GetDescription:=cur_line
     Else
      If BufGetDesc(user_desc, path, name, ext, cur_line) Then GetDescription:=cur_line
      Else
       Begin { cannot be found in internal cach, so actually get from file }
        found:=FALSE;
        If (AccessDisk And FileExists(path)) Then
         Begin
          {$I-}
          Assign(descript_file, Concat(path, password));
          FileMode:=fmReadOnly;
          If IsSHARESupported Then Inc(FileMode, fmDenyWrite);
          Reset(descript_file);
          FileMode:=fmReadWrite;
          {$I+}
          If (IOResult = 0) Then
           {$I-}
           While Not ((IOResult <> 0) Or EOF(descript_file) Or found) Do
            Begin
             {$I-}
             ReadLn(descript_file, cur_line);
             {$I+}
             If ((IOResult = 0) And ((Length(name)+Length(ext)) > 0) And
                (ToUpperC(SubStr(cur_line, 1)) = Concat(name, ext))) Then
              Begin
               found:=TRUE;
               BufUpdateDesc(user_desc, path, cur_line);
               If (Concat(name, ext) = '.') Then { if dir, not applications file }
                Begin
                 If (Not dir_desc.ready) Then BufUpdateDesc(dir_desc, path, cur_line);
                End
               Else { if not dir }
                If (Not priv_desc.ready) Then
                 BufUpdateDesc(priv_desc, path, cur_line);
              End;
            End; {While}
          {$I-}
          Close(descript_file);
          {$I+}
          If (IOResult=0) Then Begin End; { dummy }
         End;
        If found Then GetDescription:=cur_line
        Else { avoid from further searching }
         Begin { No description file or no matching description in file }
          GetDescription:='';
          BufUpdateDesc(user_desc, path, '');
          If (Not priv_desc.ready) Then
           BufUpdateDesc(priv_desc, path, '');
          If (Not dir_desc.ready) Then
           BufUpdateDesc(dir_desc, path, '');
         End;
       End;
   End; {GetDescription}

  Function GetConfiguration(file_name: PathStr; ID: Byte): String;
   Var
    line    : String;
    found   : Boolean;
    position: Byte;
   Begin
    GetConfiguration:='';
    line :=GetDescription(file_name);
    found:=FALSE;
    position:=Pos(DescriptionEnd, line);
    While ((position > 0) And (Not found)) Do { search for ID }
     Begin         {1}
      If ((Length(line) > position) And (Ord(line[Succ(position)]) = ID)) Then
       found:=TRUE
      Else
       Begin { strip header }
        Delete(line, 1, position);
        position:=Pos(DescriptionEnd, line);
       End;
     End; {While}
    If found Then { strip tail and return }
     Begin
      Delete(line, 1, Succ(position));
      position:=Pos(DescriptionEnd, line);
      If (position > 0) Then
       Begin
        Delete(line, position, {} MaxStringLen);
        GetConfiguration:=line;
       End
      Else GetConfiguration:=line;
     End;
   End; {GetConfiguration}

  Function GetSetting(str: String; ID: Byte): String;
   { Should be optimized by some kind of buffer holding results of }
   { similar requests.                                             }
   Var
    org_buf: String;
    loops  : Byte;
   Function GetSettingFromFile(str: String; ID: Byte): String;
    { Gets setting from environment variable or DESCRIPT.ION file. }
    Var
     ret_str: String;
     value  : Word;
    Begin
     GetSettingFromFile:=GetEnv(str); { Never use XGetEnv() here!!! }
     If (CUI And UseDescriptions) Then
      { settings from description files shall be used }
      Begin
       If CheckParam(ToUpperC(str), GetConfiguration(XParamStr(0), ID),
                     FALSE, FALSE, TRUE, value, ret_str) Then
        GetSettingFromFile:=ret_str { found, update result }
       Else { not valid or not found }
        If (UseDefEnvVars And (Length(GetEnv(str))=0)) Then { never XGetEnv!!! }
         { no actual environment variable, get default values from ". " }
          If CheckParam(ToUpperC(str), GetConfiguration('.\', ID), FALSE, FALSE, TRUE, value, ret_str) Then
           GetSettingFromFile:=ret_str; { Assume this now. }
         { else assume environment variable as default }
      End;
    End; {GetSettingFromFile}
   Begin
    loops:=0;
    Repeat
     str:=GetSettingFromFile(str, ID);
     If (loops = 0) Then org_buf:=str; { store first evaluation }
     Inc(loops);
    Until ((Not ReplaceEnvVar(str)) Or (loops >= MaxLoops));
    If (loops >= MaxLoops) Then GetSetting:=org_buf { recursion error, return first evaluation }
    Else GetSetting:=str;      { no error }
   End; {GetSetting}

  Procedure QuerySetting(Var value: Word; set_str: String);
   { Changes <value> to a valid <set_str> setting. }
   { Does not change <value> if invalid.           }
   Var
    str   : String;
    val   : Word;
    error : Integer;
   Begin
    str:=GetSetting(set_str, DescriptionEnvID); { using ValWord internally }
    If (Length(str) > 0) Then
     Begin
      ValWord(str, val, error); { ValWord is not used recursively here }
      If (error = 0) Then value:=val; { use it, if valid }
     End;
   End; {QuerySetting}

  Function GetTrueDOSVersion: Word;
   { Returns true DOS version, if DOS >= 5.0, else zero }
   Var
    regs: Registers;
   Begin
    With regs Do
     Begin
      AX   :=$3306; { check for real DOS version }
      Flags:=0;
      Intr($21, regs);
      If (((AX = 1) And ((Flags AND FCarry) > 0)) Or (AL = $FF)) Then
       GetTrueDOSVersion:=0 { DR DOS 3.41-6.0 and MS-DOS before 5.0 }
      Else
       GetTrueDOSVersion:=AX;
     End; {With}
   End; {GetTrueDOSVersion}

  Function GetCPMVersion: Word;
   { Contains Digital Research/Novell CP/M kernel version (DR DOS/Novell DOS etc.)}
   { Returns 0 if not found.                                                      }
   Var
    regs: Registers;
   Begin
    With regs Do
     Begin
      AX   :=$4452; { check for single user variants }
      Flags:=FCarry;
      Intr($21, regs);
      If ((Flags And FCarry) = 0) Then GetCPMVersion:=AX
      Else
       Begin
        AX   :=$4451; { check for multi user variants }
        Flags:=FCarry;
        Intr($21, regs);
        If ((Flags And FCarry) = 0) Then GetCPMVersion:=AX
        Else GetCPMVersion:=0;
       End;
     End; {With}
   End; {GetCPMVersion}

  Function GetDOSVersion: Word; { internal only!!! }
   Var
    regs: Registers;
   Begin
    With regs Do
     Begin
      AX:=$3000;            { get DOS version                         }
      BX:=0; DX:=0; SI:=0;  { to select from other version checks     }
      MSDOS(regs);
      If (AL=0) Then AL:=1; { MS-DOS 1.x returns AL=0 instead of AL=1 }
      GetDOSVersion:=AX
     End; {With}
   End; {GetDOSVersion}

  Function DOSVersion: Word;
   { As SYSTEM.DOSVersion. Overridden by SETVERXX.SYS and %DOSVersion% }
   { %DOSVersion% has swapped bytes, that means DOS 5.0 is $0500 (not  }
   { $0050), but DOSVersion still is $0050 to be compatible with       }
   { SYSTEM.DOSVersion.                                                }
   Begin
    DOSVersion:=DOS_version;
   End; {DOSVersion}

  Function ChkFreeDOS: Boolean; { internal }
   Var
    regs: Registers;
   Begin
    With regs Do
     Begin
      AX:=$3000;           { get DOS version                     }
      BX:=0; DX:=0; SI:=0; { to select from other version checks }
      MSDOS(regs);
      ChkFreeDOS:=((AL > 1) And (BH = $FD));
     End; {With}
   End; {ChkFreeDOS}

  Function IsFreeDOS: Boolean;
   { TRUE, if running under Free-DOS. Overridden by %FreeDOS%          }
   Begin
    IsFreeDOS:=free_DOS;
   End; {IsFreeDOS}

  Function CodePage: Word;
   Var
    regs : Registers;
    str  : String;
    cp   : Word;
    error: Integer;
   Begin
    cp      :=437;
    CodePage:=cp; { default }
    { Free-DOS currently does not support country specific functions, but }
    { traps programs that use unsupported APIs. To avoid this, we may not }
    { call those functions under Free-DOS.                                }
    If ((Not IsFreeDOS) And (Swap(DOSVersion) >= $0303)) Then
     With regs Do
      Begin
       AX:=$6601;     { Get CodePage Info                   }
       BX:=437;       { assume: default codepage            }
       Flags:=fCarry; { assume: CF set                      }
       MSDOS(regs);
       If ((Flags AND fCarry) = 0) Then
        CodePage:=BX; { if CF cleared, BX contains CodePage }
      End {With}
    Else { if cannot be determined automatically, check for %_CODEPAGE% }
     Begin
      QuerySetting(cp, '_CodePage');
      CodePage:=cp;
     End;
   End; {CodePage}

  Function YesNo(chr: Char): Word;
   { Returns Yes, No, Neither (Neither=Unknown) }
   Var
    regs: Registers;
   Begin
    YesNo:=Neither;
    If ((Lo(DOSVersion) >= 4) And (Not IsFreeDOS)) Then
     With regs Do
      Begin
       AX:=$6523;
       DH:=0; { DBCS support??? }
       DL:=Ord(chr);
       MSDOS(regs);
       If ((Flags AND fCarry) = 0) Then
        YesNo:=AX;
     End; {With}
   End; {YesNo}

  Function IsYN(str: String; yesno_val_flag: Boolean; env_str: String; YN: Byte; YNStr, YNChr, YNValStr: YNStringT): Boolean;
   { internal only                                                     }
   { Returns TRUE, if str is a string in YNStr or (%env_str% or YNChr) }
   { Returns FALSE, if not.                                            }
   { yesno_val_flag indicates, if special numbers should be interpreted as   }
   { Yes/No <TRUE>, or should be ignored (FALSE).                            }
   Var
    test_str: String;
   Begin
    test_str:= ToUpperC(GetSetting(env_str, DescriptionEnvID));
    If ((Length(test_str)=0) And (Length(str)=1) And (YesNo(str[1])=YN)) Then
     IsYN:=TRUE
    Else
     Begin
      If (Length(test_str) > 0) Then
       test_str:=ConCat(test_str, Chr(SPACE), YNStr) { is str in test_str+YNStr? }
      Else
       test_str:=Concat(YNStr, Chr(SPACE), YNChr);   { is str in YNStr+YNChr? }
      If yesno_val_flag Then
       test_str:=Concat(test_str, Chr(SPACE), YNValStr); { add yes/no values }
      IsYN:=IsInStr(str, test_str);
     End;
   End; {IsYN}

  Function IsYes(str: String; yesno_val_flag: Boolean): Boolean;
   { Returns TRUE, if str is a string in YesStr or (%YesChar% or YesChr) }
   { Returns FALSE, if not.                                              }
   { yesno_val_flag indicates, if special numbers should be interpreted as   }
   { Yes/No <TRUE>, or should be ignored (FALSE).                            }
   Begin
    IsYes:=IsYN(str, yesno_val_flag, 'YesChar', Yes, YesStr, YesChr, YesValStr);
   End; {IsYes}

  Function IsNo(str: String; yesno_val_flag: Boolean): Boolean;
   { Returns TRUE, if str is a string in NoStr or (%NoChar% or NoChr) }
   { Returns FALSE, if not.                                           }
   { yesno_val_flag indicates, if special numbers should be interpreted as   }
   { Yes/No <TRUE>, or should be ignored (FALSE).                            }
   Begin
    IsNo:=IsYN(str, yesno_val_flag, 'NoChar', No, NoStr, NoChr, NoValStr);
   End; {IsNo}

  Procedure ChkYesNo(Var value: Boolean; yesno_val_flag: Boolean; str: String);
   { Checks str for Yes/No string/chr and changes value to the corresponding }
   { setting, if found. Else, the value is not altered.                      }
   { yesno_val_flag indicates, if special numbers should be interpreted as   }
   { Yes/No <TRUE>, or should be ignored (FALSE).                            }
   Begin
    If (Not IsStdOutReDir) Then
     Write(Chr(SPACE), Chr(BS)); { to allow <Ctrl>+<C> breaking... }
    UpStrC(str);
    If IsYes(str, yesno_val_flag) Then
     value:=TRUE
    Else
     If IsNo(str, yesno_val_flag) Then
      value:=FALSE;
   End; {ChkYesNo}

  Procedure ChkColor(Var color: Byte; str: String);
   { Checks str for color string/chr/number and changes value to the         }
   { corresponding setting, if found. Else, the value is not altered.        }
   Var
    col  : Word;
    found: Boolean;
    error: Integer;
   Begin
    If (Not IsStdOutReDir) Then
     Write(Chr(SPACE),Chr(BS)); { to allow <Ctrl>+<C> breaking... }
    UpStrC(str);
    col  :=0;
    ValWord(str, col, error);
    If ((error <> 0) Or Not (col In [0..15])) Then
     Begin
      col  :=0; { start with Black }
      found:=FALSE;
      While ((Not Found) And (col In [0..15])) Do
       If (Length(ColorStrs[col]) > 0) Then
        Begin
         found:=IsInStr(str, ColorStrs[col]); { is str in color? }
         If found Then color:=col
         Else Inc(col);
        End;
     End
    Else color:=col;
   End; {ChkColor}

  Function SwitChar: Char;
   { Gets current SwitChar }
   Var
    regs: Registers;
   Begin
    With regs Do
     Begin
      AX:=$3700;    { get SwitChar setting   }
      DL:=Ord(SWC); { assume default setting }
      MSDOS(regs);
      If (AL=$00) Then SwitChar:=Char(DL)
      Else             SwitChar:=SWC;
     End;
   End; {SwitChar}

  Function SWC: Char;
   { SwitChar, as recorded at startup, overridden by %SwitChar%        }
   { Normally this should be used instead of Switchar to be consistent }
   { during application runtime.                                       }
   Begin
    SWC:=SW_char;
   End; {SWC}

  Function SCS: Boolean;
   { CheckSnow, as recorded at startup, overridden by %CheckSnow% }
   Begin
    SCS:=CS_f;
   End; {SCS}

  Function SDV: Boolean;
   { DirectVideo, as recorded at startup, overridden by NOT %OutputBIOS% }
   Begin
    SDV:=DV_f;
   End; {SDV}

  Function ChkOnlineEdit(Var line: String): Boolean;
   { Results TRUE if last parameter in line is '?' or '&' (not '/?'!!!).   }
   { If found, the '?' or '&' is truncated.                                }
   { Basically emulates MS-DOS 7 (Windows95/Chicago) '?' online edit       }
   { feature (without a timeout) and the older PROSHELL's and KEIL         }
   { assemblers '&' command line extention feature. Both are basically     }
   { the same, but '&' may not be given as a single parameter to a program }
   { Should not conflict with MS-DOS 7 internal feature (as COMMAND.COM    }
   { will process the command line before CUI_LIB) and for the same reason }
   { (plus slightly different syntax) also should not be conflictive with  }
   { 4DOS/NDOS, 4OS2 and 4NT command and parameter chars ('&'), .          }
   Const
    CommentSet = [';','#'];
   Var
    ask, asked    : Boolean;
    new_line, par : String;
    counter       : Byte;
    error         : Integer;
    loops, end_pos: Byte;
    found         : Boolean;
   Begin
    DelLeadOut(line, WhiteChrSet);

    loops:=0;
    found:=TRUE;
    While ((loops < MaxLoops) And found) Do
     Begin
      new_line:= '';
      found   := FALSE;
      counter := 1;
      While (counter <= Length(line)) Do
       Begin
        end_pos:=0;
        If (line[counter] = '%') Then
         Begin
          end_pos:=PosC('%', Copy(line, Succ(counter), Length(line)-counter));
          par:=Copy(line, counter, Succ(end_pos)); { separate %variable% }
          If (Length(par) > 1) Then { end_pos>0 }
           If ExpandVar(par, TRUE) Then found:=TRUE;
          AppendStr(new_line, par); { is only a char here (end_pos=0) }
         End
        Else { no match, move char to new string (end_pos=0) }
         AppendChr(new_line, line[counter]);
        Inc(counter, Succ(end_pos));
       End; {While}
      line:=new_line;
      Inc(loops);
     End; {While}

    ask  :=TRUE;
    asked:=FALSE;
    While (ask And (Length(line) > 0) And (line[Length(line)] In ['?','&'])) Do
     Begin
      If ((Length(line) = 1) And (line[Length(line)] = '?')) Then
       Begin { delete the single '?' parameter, but not a single '&' }
        line:='';
        ask:=TRUE;
       End
      Else { more than one character or single '&' }
       {$B-}
       If ((Length(line) > 1) And (line[Pred(Length(line))] In WhiteChrSet)) Then
        Begin { delete the ' ?' or ' &' parameter, prepended by space }
         Delete(line, Pred(Length(line)), 2);
         ask:=TRUE;
        End
       Else  { the '?', '&' is part of another parameter, or single '&' }
        ask:=FALSE; { (this is compatible with 4DOS/NDOS, 4OS2 and 4NT) }
      If ask Then
       Begin
        If (Not IsStdOutReDir) Then
         If (Not asked) Then Write(XParamStr(0), ' ', line, '[?]< ') { online edit prompt }
         Else Write('[?]< ');
        new_line:='';
        ReadLn(new_line); { Todo: <better check for IsStdInRedir here>!!! }
        If (Length(new_line) > 0) Then
         Begin
          DelLeadIn(line, WhiteChrSet);
          If ToUpper(Copy(new_line, 1, 8)) = '{$CLEAR}' Then
           line:=' &' { delete current line }
          Else
           If ((new_line[1] In CommentSet-[SWC]) Or
               (Copy(new_line, 1, 2) = '/*') Or { don't ask for '*/' because of REXX LeadIn }
               (ToUpper(Copy(new_line, 1, 3)) = 'REM') Or
               (ToUpper(Copy(new_line, 1, 7)) = 'COMMENT') Or
               ((Copy(new_line, 1, 2) = '(*') And (Copy(new_line, Pred(Length(line)), 2) = '*)')) Or
               ((new_line[1] = '{') And (new_line[Length(new_line)] = '}'))
              ) Then
            line:=Concat(line, ' &') { for comments fake request for next line }
           Else
            line:=Concat(line, Chr(SPACE), new_line);
         End;
        DelLeadOut(line, WhiteChrSet);
        counter:=Pos('>', line);
        If (counter > 0) Then { check for output redirection }
         Begin
          new_line:=Copy(line, Succ(counter), MaxStringLen);
          Delete(line, counter, MaxStringLen); { delete redirection symbol }
          { assign output redirection }
          stdout_redir:=TRUE;
          {$I-}
          Close(output);
          {$I+}
          error:=IOResult;
          If (error = 0) Then
           {$B-}
           If ((Length(new_line) > 0) And (new_line[1] = '>')) Then { append }
            Begin
             Delete(new_line, 1, 1);
             DelLeadIn(new_line, WhiteChrSet);
             {$I-}
             Assign(output, new_line);
             Append(output);
             {$I+}
            End
           Else { create new file }
            Begin
             DelLeadIn(new_line, WhiteChrSet);
             {$I-}
             Assign(output, new_line);
             Rewrite(output);
             {$I+}
            End;
          If ((IOResult <> 0) Or (error <> 0)) Then { on error, switch back to STDOUT }
           Begin
            {$I-}
            Assign(output, '');
            Rewrite(output);
            {$I+}
            stdout_redir:=(IOResult<>0);
           End
          Else
           stdout_redir:=(Length(new_line)>0);
         End
        Else
         Begin
          counter:=Pos('<', line);
          If (counter > 0) Then { check for input redirection }
           Begin
            new_line:=Copy(line, Succ(counter), MaxStringLen);
            Delete(line, counter, MaxStringLen); { delete redirection symbol }
            stdin_redir:=TRUE;
            {$I-}
            Close(input);
            {$I+}
            error:=IOResult;
            FileMode:=fmReadOnly;
            If IsSHARESupported Then Inc(FileMode, fmDenyWrite);
            If (error = 0) Then
             Begin
              DelLeadIn(new_line, WhiteChrSet);
              {$I-}
              Assign(input, new_line);
              Reset(input);
              {$I+}
             End;
            If ((IOResult <> 0) Or (error <> 0)) Then { on error, switch back to STDIN }
             Begin
              {$I-}
              Assign(input, '');
              Reset(input);
              {$I+}
              stdin_redir:=(IOResult<>0);
             End
            Else
             stdin_redir:=(Length(new_line)>0);
            FileMode:=fmReadWrite;
           End;
         End;
        asked:=TRUE;
       End;
     End; {While}
    ChkOnlineEdit:=ask;
   End; {ChkOnlineEdit}

  Procedure ChkSym(Var str: SymStringT; set_str: String; sep_flag: Boolean);
   { Aligns str to %<set_str>%, if valid. Some formatings are done here,    }
   { depending on sep_flag.                                                 }
   Begin
    If (Not IsStdOutReDir) Then
     Write(Chr(SPACE),Chr(BS)); { to allow <Ctrl>+<C> breaking... }
    set_str:=GetSetting(set_str, DescriptionEnvID);
    If ((Length(set_str) > 0) And (Length(set_str) <= 15)) Then
     Begin {set_str in valid range of length }
      If (Length(set_str) = 1) Then str:=set_str { just a symbol }
      Else { actually a string }
       If ((Not sep_flag) Or (set_str[Length(set_str)] In ['.',',',':', Chr(SPACE), Chr(TAB)])) Then
        str:=set_str
       Else
        str:=Concat(set_str, Chr(SPACE)); { add a separating space }
     End;
   End; {GetSym}

  Procedure InitYesNoStr(Var str_str, chr_str: YNStringT; set_str: String);
   { If %<set_str>% contains a valid Yes/No char/string than str_str or }
   { chr_str are adapted to this setting.                               }
   Var
    str_buf: String;
   Begin
    str_buf:=ToUpperC(GetSetting(set_str, DescriptionEnvID));
    If ((Length(str_buf)>0) And ((Not IsYes(str_buf, TRUE)) And (Not IsNo(str_buf, TRUE)))) Then
     { if currently not used, then add to internal strings }
     If (Length(str_buf)=1) Then chr_str:=Concat(str_buf, Chr(SPACE), chr_str)
     Else str_str:=Concat(set_str, Chr(SPACE), str_str);
   End; {InitYesNoStr}

  Procedure InitDName(Var priv_desc, user_desc: CurDescriptionT;
                      Var DescriptionName: NameStr;
                      Var DescriptionExt: ExtStr);
   Var
    buf       : String;
    loops     : Byte;
    refresh   : Boolean;
    d_n       : NameStr;
    d_e       : ExtStr;
    password  : PassStr;
    str_buf   : String;
   Begin
    loops:=0;
    Repeat
     ResetCurDescription(priv_desc); { Init }
     ResetCurDescription(dir_desc);  { Init }
     ResetCurDescription(user_desc); { Init }
     refresh:= FALSE;
     d_n    := DescriptionName;
     d_e    := DescriptionExt;
     str_buf:= GetSetting('_DName', DescriptionEnvID);
     If (Length(str_buf) > 0) Then
      Begin
       FSplitDR(ToUpperC(str_buf), dir_buf, DescriptionName, DescriptionExt, password);
       If ((d_n <> DescriptionName) Or (d_e <> DescriptionExt)) Then
        refresh:= TRUE; { if name or extension have changed }
      End;
     Inc(loops);
    Until ((Not refresh) Or (loops >= MaxLoops));
   End; {InitDName}

  Procedure StoreStartupContext;
   Begin
    {Currently nothing, but more could be done... }
    in_ANSI_sequence:=FALSE;
   End; {StoreStartupContext}

  Procedure RestoreStartupContext;
   Begin
    If in_ANSI_sequence Then
     Begin
      Write(Chr(SPACE));      { escape from pending sequence }
      WriteLnANSINorm; { in_ANSI_sequence cleared     }
     End;
    { <more could be done here...> }
    If stdout_redir Then { if output was redirected, switch back to stdout }
     Begin
      {$I-}
      Close(output);
      {$I+}
      stdout_redir:=(IOResult<>0);
      FileMode:=fmReadWrite;
      {$I-}
      Assign(output, '');
      Reset(output);
      {$I+}
      stdout_redir:=(IOResult<>0);
     End;
    If stdin_redir Then { if input was redirected, switch back to stdin }
     Begin
      {$I-}
      Close(input);
      {$I+}
      stdin_redir:=(IOResult<>0);
      FileMode:=fmReadOnly;
      If IsSHARESupported Then Inc(FileMode, fmDenyWrite);
      {$I-}
      Assign(input, '');
      Reset(input);
      {$I+}
      stdin_redir:=(IOResult<>0);
      FileMode:=fmReadWrite;
     End;
   End; {RestoreStartupContext}

  Procedure CUIExitHandling; Far;
   Begin
    ExitProc:=old_exit_proc;
    RestoreStartupContext;
   End; {CUIExitHandling}

  Begin {Init}
   { Copy original command line in buffer, as FCBs oparations or usage  }
   { of the default DTA would overwrite the orignal command line in the }
   { PSP.                                                               }
   psp_cmd_line:=Ptr(PrefixSeg, $80);
   If (Ord(psp_cmd_line^[0]) > 127) Then psp_cmd_line^[0]:=Chr(127); { BP 7.0 sets 128 here }
   For counter:=0 To 127 Do
    PSPCmdLineCopy[counter]:=psp_cmd_line^[counter];

   If (ParamStr(1) = '@') Then
    Begin
     l_cmd_dec:=1;
     If (ParamStr(2) = '@') Then
      Begin
       Inc(l_cmd_dec); { = 2 }
       AccessDisk:=FALSE;
       { Disable most of the disk access to allow fast startup }
       { when booting from floppy.                             }
      End;
    End
   Else l_cmd_dec:=0;

   stdout_redir   :=FALSE;
   stdin_redir    :=FALSE;
   priv_desc.ready:=FALSE;
   dir_desc.ready :=FALSE;
   user_desc.ready:=FALSE;
   in_ValWord     :=FALSE;
   INT2FValid     :=IsINT2FValid;
   SW_char        :=SwitChar;
   CS_f           :=CheckSnow;
   DV_f           :=DirectVideo;
   DOS_version    :=GetDOSVersion; { get DOS version from system             }
   free_DOS       :=ChkFreeDOS;    { check for Free-DOS                      }
                                   { [update DOS_version & free_DOS as early }
                                   { as possibly (but avoid recursion).]     }
   str_buf        :=Copyright;     { fake usage of Copyright                 }

   StoreStartupContext;
   old_exit_proc:=ExitProc;
   ExitProc:=@CUIExitHandling;

   { Shall CUI extensions be processed at startup? }
   str_buf:=ToUpperC(GetEnv('CUI'));
   If (Length(str_buf)=0) Then
    Begin
     {$IFNDEF FAST}
     If (Not IsStdOutRedir) Then
      Begin
       If (CursorY > 0) Then WriteLn;
       Write('[CUI_LIB: If you notice a long delay, type "SET CUI=FAST" at the prompt!]');
      End;
     {$ELSE}
     str_buf:='FAST';
     {$ENDIF}
    End;
   If (str_buf='FAST') Then
    Begin { Fasten startup management by reducing Yes/No and Color strings }
     CUI:=TRUE;
     YesStr:=Concat(LeadingStrs(YesStr, FastYNNames), Chr(SPACE));
     NoStr :=Concat(LeadingStrs(NoStr, FastYNNames), Chr(SPACE));
     YesValStr:=Concat(LeadingStrs(YesValStr, 1), Chr(SPACE));
     NoValStr :=Concat(LeadingStrs(NoValStr, 1), Chr(SPACE));
     For counter:=0 To 15 Do
      ColorStrs[counter]:=LeadingStrs(ColorStrs[counter], FastColNames);
    End
   Else
    ChkYesNo(CUI, TRUE, str_buf);

   If CUI Then
    Begin
     { determine current DESCRIPT.ION file name:                           }
     { [does not need DOS_version or free_DOS]                             }
     InitDName(priv_desc, user_desc, DescriptionName, DescriptionExt);

     { check Yes/No strings:                                               }
     { [cannot use DOS_version or free_DOS, cannot be disabled by          }
     {  Descriptions=No]                                                   }
     InitYesNoStr(YesStr, YesChr, 'YesChar');
     InitYesNoStr(NoStr, NoChr, 'NoChar');

     { shall description files be used to get 'simulated' environment vars? }
     ChkYesNo(UseDescriptions, TRUE, GetSetting('Descriptions', DescriptionEnvID));

     { shall description file '.' env-vars entries be used as default values }
     { for system environment?                                               }
     ChkYesNo(UseDefEnvVars, TRUE, GetSetting('DefEnvVars', DescriptionEnvID));

     { check for CUI settings: }
     ChkYesNo(ExpandEnvVars, TRUE, GetSetting('EnvExpansion', DescriptionEnvID));

     counter:=Swap(DOSVersion);             { gets DOS_version }
     QuerySetting(counter, 'DOSVersion');           { override }
     DOS_version:=Swap(counter); { update internal DOS_version }
     ChkYesNo(free_DOS, TRUE, GetSetting('FreeDOS', DescriptionEnvID));
     {$B-}
     If ((Length(str_buf) = 0) And (Not IsStdOutRedir)) Then
      { %CUI% has been empty... }
      { 74 is length of the message [CUILIB: ...] emitted before }
      Write(Chr(SPACE),Chr(BS):74,Chr(SPACE):74,Chr(BS):74);
    End;

   AlignStartupVMode(80); { 80 chars needed. }

   If CUI Then
    Begin
     ChkYesNo(UseSHARE, TRUE, GetSetting('SHARE', DescriptionEnvID));
     ChkYesNo(DBGEcho, TRUE, GetSetting('DBGEcho', DescriptionEnvID));
     ChkYesNo(UseTrueName, TRUE, GetSetting('TrueName', DescriptionEnvID));
     ChkYesNo(UseLFN, TRUE, GetSetting('LFN', DescriptionEnvID));
     If UseCmdline Then UseCmdLine:=UseLFN;
     ChkYesNo(UseCmdLine, TRUE, GetSetting('LCMD', DescriptionEnvID));
     If (ParamStr(1) = '@') Then UseCmdLine:=FALSE;
    End;

   For counter:=1 To XParamCount Do
    If (Length(OrgCmdLine)=0) Then OrgCmdLine:=XParamStr(counter)
    Else OrgCmdLine:=Concat(OrgCmdLine, Chr(SPACE), XParamStr(counter));

   FSplit(XParamStr(0), dir_buf, name_buf, ext_buf); { FSplitDR not required here }
   If CUI Then EnvCmdLine:=GetSetting(Concat(name_buf,'CMD'), DescriptionEnvID)
   Else        EnvCmdLine:=GetEnv(Concat(name_buf,'CMD'));

   If CUI Then
    Begin
     If UseDescriptions Then
      ExtCmdLine:=GetConfiguration(XParamStr(0), DescriptionCmdID);

     { Maybe it should be better to scan all 16 colors, but currently only }
     { those four colors are used internally.                              }
     ChkColor(Red, GetSetting(SubStr(ColorStrs[4], 2), DescriptionEnvID));
     ChkColor(LightGray, GetSetting(SubStr(ColorStrs[7], 2), DescriptionEnvID));
     ChkColor(Yellow, GetSetting(SubStr(ColorStrs[14], 2), DescriptionEnvID));
     ChkColor(White, GetSetting(SubStr(ColorStrs[15], 2), DescriptionEnvID));

     { initialize switchar: }
     sym_str:=SW_char; { get internal setting }
     ChkSym(sym_str, 'SwitChar', FALSE);
     If (Length(sym_str) = 1) Then
      SW_char:=sym_str[1];

     { check for video settings (currently not used): }
     ChkYesNo(CheckSnow, TRUE, GetSetting('CheckSnow', DescriptionEnvID));
    End;
   CS_f:=CheckSnow;

   If CUI Then
    Begin
     bool_buf:= Not DirectVideo;
     ChkYesNo(bool_buf, TRUE, GetSetting('OutputBIOS', DescriptionEnvID));
     DirectVideo:= Not bool_buf;
    End;
     DV_f:=DirectVideo;

   ANSI:=DetectANSI; { check for ANSI detection }

   If CUI Then
    Begin
     { check for ANSI setting: }
     If (Not IsStdOutRedir) Then
      ChkYesNo(ANSI, TRUE, GetSetting('ANSI', DescriptionEnvID)); { check for overriding environment variable }
     ChkYesNo(ANSI, TRUE, GetSetting('_ANSI', DescriptionEnvID)); { check for overriding environment variable }
     { %_ANSI% is overriding %ANSI% (if used), because the former is the name of a }
     { internal 4DOS/NDOS variable, that isn't actually stored in environment, but }
     { may be overridden by a environment variable with the same name.             }

     ChkYesNo(Beeps, TRUE, GetSetting('Sound', DescriptionEnvID));

     { startup }
     If DBGEcho Then
      Begin
       str_buf:=GetDescription(XParamStr(0));
       If (Pos(DescriptionEnd, str_buf) > 0) Then { strip configuration data }
        Delete(str_buf, Pos(DescriptionEnd, str_buf), MaxStringLen);
       If (Length(str_buf) > 0) Then
        Begin
         If (CursorY > 0) Then WriteLn;
         WriteLn(str_buf);
        End;
      End;

     { check for CopyrightSym setting: }
     sym_str:=CopyrightSym;
     ChkSym(sym_str, '(C)', FALSE);
     If ((ToUpperC(sym_str) = 'AUTO') Or (sym_str = '0')) Then
      Begin
       If ((CodePage = 850) Or (CodePage = 857)) Then
        CopyrightSym:=Chr(184); { the copyright symbol in those codepages }
      End
     Else
      If Not IsNo(sym_str, TRUE) Then          { possibly no inversion... }
       If (Pos('C', ToUpperC(sym_str))>0) Then { and something with 'C'...}
        CopyrightSym:=sym_str;

     { check for VerSym setting: }
     ChkSym(VerSym, 'VerChar', TRUE);

     { check for SubVerSym setting: }
     ChkSym(SubVerSym, 'SubVerChar', TRUE);

     { check for SubSubVerSym setting: }
     ChkSym(SubSubVerSym, 'SubSubVerChar', TRUE);

     ChkYesNo(OnlineEdit, TRUE, GetSetting('LineEdit', DescriptionEnvID));
     If OnlineEdit Then
      If (Not ChkOnlineEdit(OrgCmdLine)) Then
       If (Not ChkOnlineEdit(EnvCmdLine)) Then
        If (Not ChkOnlineEdit(ExtCmdLine)) Then
         Begin End;
    End;
  End. {Init}
