{ CPI.EXE - Analyzer utility for DOS code page files (.CPI).                }
{                                                                           }
{ Copyright: 1995-1996 by Axel C. Frinke    &    Matthias Paul              }
{                         Steinstrae 11         Ubierstrae 28             }
{                         D-53332 Bornheim       D-50321 BRHL              }
{                         <ACFrinke@uni-bonn.de> <MPaul@ibh.rwth-aachen.de> }
{                         <Frinke@cs.bonn.edu>                              }
{ All rights reserved.                                                      }
{                                                                           }
{ Version  : 3.03 (English)                                                 }
{ Last Edit: 18.07.1996 -mp                                                 }
{                                                                           }
{ Infos    : - Own debugging sessions (most of the material)                }
{            - "Gnther Born / MS-DOS 6.2 Handbuch zur Programmierung"      }
{              Microsoft press, chapter 10, page 655ff.                     }
{            - "Thom Hogan / Die PC-Referenz fr Programmierer"             }
{              SYSThema Verlag GmbH, Microsoft press                        }
{              2nd German edition, page 91                                  }
{            - "William S. Hall & others / Windows 3.1 Developer's Workshop"}
{              Microsoft press, chapter 1, page 2-90                        }
{            - Novell DOS 7, DR DOS 3.41-6.0, MS-DOS 3.3-7 documentation    }
{            - ftp://ftp.uni-kl.de/pub1/packages/kermit/charsets/           }
{            - ftp://ftp.switch.ch/mirror/unicode/MappingTables/
{                    VendorMaps/Microsoft/pc                                }
{                                                                           }
{ Notes:                                                                    }
{                                                                           }
{ - Compile with Borland (Turbo) Pascal 7.0.                                }
{ - As CPI.EXE is utilizing CUI_LIB, you are able to use a very enhanced    }
{   command line interface (see CUI_LIB.PAS and docs for details).          }
{   Using an environment variable CUI you can customize CPI in respect of   }
{   CUI handling and multilingual string processing. As currently CUI_LIB   }
{   is very slow doing multilingual string processing, the default setting  }
{   is 'FAST', enabling only English strings. If you have a very fast       }
{   machine, you can set CUI=ON to enabling multilingual support. If you    }
{   don't want CUI_LIB features at all, set CUI=OFF. In the future, we'll   }
{   optimize CUI_LIB for speed and the default setting will change to 'ON'. }
{ - If you have problems with ANSI sequences, try variables %ANSI%=On/Off   }
{   and %_ANSI%=On/Off.                                                     }
{ - Tested with .CPI files from MS-DOS 3.30, German 4.01, 5.0, 6.20, 6.22,  }
{   MS Windows95/Chicago/MS-DOS 7, PC-DOS 6.1, Novell DOS 7, DR DOS 3.40,   }
{   3.41, 5.0 and 6.0, and Dimitri Vulis' XTRA.CPI (880 and 866) file.      }
{ - Currently not tested with PC-DOS 6.3 & 7 and Asian DOS versions.        }
{   Free-DOS (1.04) currently has no codepage support. Reports welcome.     }
{ - DR DOS 6.0 / Novell DOS 7 enhanced compressed display-font (DRFONT)     }
{   format currently is only supported when containing 4 fonts (as with all }
{   the existing files, so far).                                            }
{ - CPI.EXE currently cannot handle record sizes larger than 64KB (e.g. the }
{   binary font data). This should never become a problem, as MS-DOS /      }
{   PC-DOS cannot handle .CPI files larger 64KB, although some of the       }
{   structures pointers are 32bit wide (This could be because of the        }
{   similarities between .CPI files and their representation in memory).    }
{   Novell DOS 7 / DR DOS 6.0 appears to support .CPI files larger than     }
{   64KB, but this is not yet completely proved.                            }
{ - The printer font data appears to be somewhat curious (with DR DOS 6.0   }
{   and Novell DOS 7 files), but seems to be ok.                            }
{ - Despite the officially specification, some printer font data headers    }
{   are not indicated to be 28 bytes long, but 26 bytes instead. I don't    }
{   know, if this matters (CPI.EXE handles them the same as if it was 28    }
{   bytes)...                                                               }
{ - In some MS-DOS / PC-DOS 4208.CPI files, the count of codepages is       }
{   invalid. Instead of the last codepage, the file may contain extra data. }
{ - Please report any bugs, necessary changes and enhancements to the above }
{   address(es), to allow global maintainment.                              }
{ - File IO-conditions occuring when writing a report file, will result in  }
{   a runtime error message, as I did not want to implement a special error }
{   handler for this sole purpose.                                          }
{   All other file IO-errors are handled internally and should never result }
{   in a generic runtime error message.                                     }
{                                                                           }
{ History:                                                                  }
{                                                                           }
{ V1.00       by Axel C. Frinke: [12/1995, SHOWCP.EXE]:                     }
{                                Original basic version for some MS-DOS     }
{                                display .CPI files (German).               }
{ V2.00-V2.07 by Matthias Paul:  [01-02/1996, CPINFO.EXE & CPI.EXE]:        }
{                                Massive enhancements to handle .CPI files  }
{                                from older DOSes; added support to printer }
{                                .CPI files; added support for PC-DOS,      }
{                                DR DOS, Novell DOS .CPI files, including   }
{                                enhanced DRFONT display files; enhanced    }
{                                parameter evaluation; conceptual changes   }
{                                to include CUI_LIB library; enhanced checks}
{                                for validation and specification and added }
{                                messages; translation to English; bugfixes.}
{ V3.00-V3.01 by Matthias Paul : [02-03/1996, CPI.EXE]:                     }
{                                Massive enhancements in parameter handling,}
{                                including help/about pages and many new    }
{                                parameters; optionally dumps font data in  }
{                                different modes; optionally disects .CPI   }
{                                files into font data files (for standard   }
{                                display fonts, printer fonts, or DRFONT, in}
{                                both, original DRFONT format and a trans-  }
{                                lation to standard display font format),   }
{                                allowing easier patching and creating of   }
{                                customized .CPI files; more validation     }
{                                checks; speedups; bugfixes.                }
{ V3.02       by Matthias Paul : [30.03.-01.07.1996]:                       }
{                                Many new codepages from MS-DOS 7 (from     }
{                                Windows95/Chicago) and Windows/NT 3.5;     }
{                                CUI_LIB V1.12; special handling for /C:    }
{                                parameter; codepage registery reporter;    }
{                                now should be able to handle files larger  }
{                                64KB (but it appears as if MS-DOS cannot   }
{                                handle them), structure size (e.g. binary  }
{                                font data) still is limited to 64KB;       }
{                                smaller corrections.                       }
{ V3.03       by Matthias Paul : [04.07.-18.07.1996]:                       }
{                                New DR DOS 5.0+ & Novell DOS 7 KEYB code-  }
{                                page 999, some Russian and many new MAC,   }
{                                EBCDIC codepages; changes in naming conven-}
{                                tions to better cope with ISO terms (but I }
{                                still prefer the DOS terms where adequate);}
{                                small adaptations for CUI_LIB V1.14.       }

{ $DEFINE DEBUG}

{$IFDEF DEBUG}
{$A+,B-,D+,E+,F-,G-,I+,L+,N-,O-,P-,Q+,R+,S+,T+,V+,X-}
{$ELSE}
{$A+,B-,D-,E+,F-,G-,I+,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X-}
{$ENDIF}
{$M 20000, 0, 150000}
{$D CPI (C) 1995-1996 by Axel C. Frinke & Matthias Paul - Utility to analyze .CPI DOS codepage files and extract font data }

Program CPI;

 Uses
  DOS, CUI_Lib;

 Const
  MainVerStr   = '3';
  SubVerStr    = '03';
  { Application descriptions for Novell's VERSION.EXE utility }
  Copyright    = 'CoPyRiGhT=(C) 1995-1996 by Axel C. Frinke & Matthias Paul'+Chr(NUL)+Chr(CR)+Chr(LF);
  Version      = 'VeRsIoN='+MainVerStr+'.'+SubVerStr+' (960718)'+Chr(NUL)+Chr(CR)+Chr(LF);
  MaxCPEntries = 25;

  { At the time of this writing, the following codepages have been registrated  }
  { by us. If you encounter new codepages in your files, please let us know!!!  }
  { With %DBGEcho%=On, CPI.EXE will automatically show a message if a file is   }
  { not yet archivated by us.                                                   }
  DisplayCPRegistery = '437 850 852 853 855 857 860 861 863 865 866 869 737';
  PrinterCPRegistery = '1 437 850 851 853 855 860 862 863 864 865';

  ParCPIFile   = 'Cpifile';
  ParRptFile   = 'Report';
  ParShowFont  = 'Verbose';
  ParGetFonts  = 'Fonts';
  ParGetDRFonts= 'Drfonts';
  ParDRTableFileName='Map';
  ParDRLUT     = 'Lut';
  ParOverWrite = 'Overwrite';

 Type
  CPFileHeadT= Record { FontFileHeader }
                ID             : Byte;
                IDStr          : Array[1..7] Of Char;
                Reserved       : Array[0..7] Of Byte;
                NrOfPtrs       : Word;
                TypeOfPtrs     : Byte;
                AbsDisplacement: Word; { or DWord of displacement      }
                EndMarker      : Word; { in conjunction with EndMarker }
                NrOfCPEntries  : Word;
               End;
  DRFontXCPFHeadT= Record { Extended FontFileHeader with DRFONT }
                NrOfFonts      : Byte;    { currently 4 }
                CellSizeFont1  : Byte;    { 06(x08)     }
                CellSizeFont2  : Byte;    { 08(x08)     }
                CellSizeFont3  : Byte;    { 14(x08)     }
                CellSizeFont4  : Byte;    { 16(x08)     }
                DataPosFont1   : LongInt; { pointers to fontX data          }
                DataPosFont2   : LongInt; { (normally each font contains    }
                DataPosFont3   : LongInt; {  data for more than 256 chars!) }
                DataPosFont4   : LongInt;
               End;
  FntInfoHeadT=Record { Font Info Header }
                NrOfCPEntries  : Word;
               End;
  ExtraDataT = Array [0..511] Of Byte;
  CPHeadT    = Record { CPEntryHeader }
                CPHSize : Word;                { should be 28 with MS-DOS 5.0  }
                                               { but sometimes is 26 instead.  }
                NextCPH : LongInt;             { 0000 = for the last header    }
                UnitType: Word;                { 1 = display, 2 = printer      }
                FontName: Array[0..7] Of Char; { device name padded with space }
                CP_ID   : Word;                { codepage e.g. 437             }
                Reserved: Array[0..2] Of Word; { reserved                      }
                Ptr2Font: LongInt;             { pointer to font-info          }
               End;
  CPDataHeadT =Record { FontDataHeader }
                RecordType,                  { 1 = MS-DOS, 2 = DR DOS 6.0/Novell DOS 7 }
                NrOfFonts,
                FontAreaLength: Word;
               End;
  DispFontHeaderT = Record
               Height       : Byte;
               Width        : Byte;
               AspectRatioH : Byte; { currently not used: 0   }
               AspectRatioW : Byte; { currently not used: 0   }
               NrOfChars    : Word; { normally 256            }
              End;
  DispFontT = Record { ScreenFontHeader }
               Header       : DispFontHeaderT;
               PixelBuffer  : Array [0..$FFF0] Of Byte;
              End;
  DispDRFontT = Record { DR DOS 6.0/Novell DOS 7 DRFONT type }
               Header1      : DispFontHeaderT;
               Header2      : DispFontHeaderT;
               Header3      : DispFontHeaderT;
               Header4      : DispFontHeaderT;
               UniTable     : Array[0..255] Of Word; { index in table }
              End;
  PrintFontT= Record { PrintFontHeader }
               PrinterType  : Word; { 1=4201, 2=5202, ...     }
               NrOfBytes    : Word;
               CmdEscSeq    : Array [1..$FFF0] Of Byte;
               { contains ESC-sequences to switch to hardware-CP, }
               { download-CP, and contains the download font.     }
              End;

 Var
  CPFPath, RptPath, DRFPath, FntPath, DRFntPath, LUTPath: PathStr;
  CPFDir,  RptDir,  DRFDir,  FntDir,  DRFntDir,  LUTDir : DirStr;
  CPFName, RptName, DRFName, FntName, DRFntName, LUTName: NameStr;
  CPFExt,  RptExt,  DRFExt,  FntExt,  DRFntExt,  LUTExt : ExtStr;
  CPFPass, RptPass, DRFPass, FntPass, DRFntPass, LUTPass: PassStr;

  CPF               : File;
  DRF               : Text;

  BytesRead         : Word;
  Stop, DRFont      : Boolean;
  MaxChrCode        : Word;
  MaxFileIndex      : LongInt;
  ExtraDataIndex    : Word;
  OldANSIStatus     : Boolean;
  io_error_flag     : Boolean;

  ShowFont          : Boolean; { switch to show font data on screen      }
  ShowBitMap        : Boolean; { switch to show bitmaps with ShowFont    }
  ShowDRLUT         : Boolean;
  ExtractDRFONTMAP  : Boolean; { switch to create a list of DRFONT LUTs   }
  ExtractDRFONTLUT  : Boolean; { switch to extract DRFONT LUTs to files   }
  ExtractFonts      : Boolean; { switch to extract fonts to single files  }
                               { With DRFONTs they are converted to FONT  }
                               { format.                                  }
  ExtractDRFonts    : Boolean; { switch to extract DRFONTs to single files}
  OverwriteFile     : Boolean; { switch to allow overwriting files.       }
  RequestFile       : Boolean; { show message for file request.           }

  CPFileHead        : CPFileHeadT; { small records are defined statically }
  DRFontXCPFHead    : DRFontXCPFHeadT;
  FntInfoHead       : FntInfoHeadT;
  ExtraData         : ExtraDataT;
  CPHead            : CPHeadT;
  CPDataHead        : CPDataHeadT;

  DispFontDataArea  : ^DispFontT; { large records are defined dynamically }
  DispDRFontDataArea: ^DispDRFontT;
  PrintFontDataArea : ^PrintFontT;

  dummy             : String;

 Function Min(a, b: LongInt): LongInt;
  Begin
   If (a > b) Then Min:=b
   Else            Min:=a;
  End; {Min}

 Function IsRegistered(CP_ID: Word; UnitType: Word): Boolean;
  Begin
   IsRegistered:=FALSE; { assume: request for file }
   Case UnitType Of
    1: If IsInStr(IntToStr(CP_ID, 0), DisplayCPRegistery) Then
        IsRegistered:=TRUE; { display codepage already archivated }
    2: If IsInStr(IntToStr(CP_ID, 0), PrinterCPRegistery) Then
        IsRegistered:=TRUE; { printer codepage already archivated }
   End; {Case}
  End; {IsRegistered}

 Procedure UpdateEndIndex(offset: LongInt; len: Word);
  Begin
   If ((offset+len) > MaxFileIndex) Then
    MaxFileIndex:=offset+len;
  End; {UpdateEndIndex}

 Function ReadFileOK(Var f: File; Var p; Start: LongInt; Bytes2Read: Word; Var BytesRead: Word): Boolean;
  Begin
   BytesRead :=0;
   ReadFileOK:=(Bytes2Read=0);
   If (Bytes2Read > 0) Then
    Begin { ReadFileOK=FALSE here. }
     {$I-}
     Seek(f, Start);
     {$I+}
     If (IOResult = 0) Then
      Begin
       {$I-}
       BlockRead(f, p, Bytes2Read, BytesRead);
       {$I+}
       If ((IOResult = 0) And (BytesRead=Bytes2Read)) Then
        Begin;
         ReadFileOK:=TRUE;
         UpdateEndIndex(Start, BytesRead);
        End;
      End;
    End;
  End; {ReadFileOK}

 Function WriteFileOK(path: PathStr; Var buf; count: Word): Boolean;
  Var
   f     : File;
   result: Word;
  Begin
   If ((Not FileExists(path)) Or OverwriteFile) Then
    Begin
     {$I-}
     Assign(f, path);
     Rewrite(f, 1);
     BlockWrite(f, buf, count, result);
     Close(f);
     {$I+}
     WriteFileOk:=((IOResult = 0) And (count=result));
    End
   Else WriteLnANSI(ErrorColor, Concat(' Error: A file already exists. Use ', SWC, ParOverwrite, ' to overwrite files.'));
  End; {WriteFileOK}

 Procedure WriteLnTextFile(Var f: Text; str: String);
  Var
   result: Integer;
  Begin
   {$I-}
   WriteLn(f, str);
   {$I+}
   result:=IOResult;
   If ((result = 0) And (Not io_error_flag)) Then
    Begin
     io_error_flag:=TRUE;
     WriteLnANSI(ErrorColor, Concat(' Error: An DOS-error ', IntToStr(result,0), ' occured writing lookup table file.'));
    End; {dummy}
  End; {WriteLnTextFile}

 Procedure OutCPFileHead;
  Var
   b: Byte;
   w: Word;
  Begin
   With CPFileHead Do
    Begin
     WriteLn;
     WriteLn('Data from file ', CPFPath, ':');
     WriteLn;
     WriteLnANSI(HighLightColor, 'FontFileHeader:');
     Write('Start: ', HexPrint(ID, 2), 'h');
     Case ID Of
      $FF: WriteLn(' (as usual)');
      $7F: WriteLn(' (DR DOS 6', SubVerSym, '0 / Novell DOS 7 enhanced display font).');
      Else WriteLn(' (unusual)');
     End; {Case}
     Write('Name: "', IDStr, '"');
     If (IDStr='FONT   ') Then
      Begin
       Write(' (as usual)');
       ExtractDRFONTMAP:=FALSE;
      End
     Else
      If (IdStr='DRFONT ') Then
       Begin
        Write (' (DR DOS 6', SubVerSym, '0/Novell DOS 7 enhanced display font)');
        DRFont:=TRUE;
       End
      Else
       Begin
        Write(' (normally "FONT   ")');
        ExtractDRFONTMAP:=FALSE;
       End;
     WriteLn('.');
     Write('Reserved entries are');
     b:=0;
     While ((b < 8) And (Reserved[b] = 0)) Do
      Begin
       Write(' ', HexPrint(Reserved[b], 2), 'h');
       Inc(b);
      End;
     If (b = 8) Then
      Write(' (as expected).')
     Else
      Write(' (unexpected)!');
     WriteLn;
     Write(NrOfPtrs, ' pointer');
     If (NrOfPtrs > 1) Then Write('s');
     Write(' in header');
     If (NrOfPtrs <> 1) Then Write(' (normally 1)')
     Else                    Write(' (as expected)');
     Write(', type of info pointer: ', TypeOfPtrs);
     If (TypeOfPtrs <> 1) Then Write(' (normally 1)')
     Else                      Write(' (as expected)');
     WriteLn('.');
     WriteLn('Start of the info block at offset ', HexPrint(AbsDisplacement, 4), 'h.');
     Write('The end marker in header is ', HexPrint(EndMarker, 4), 'h');
     If (EndMarker = 0) Then
      WriteLn(' (as expected).')
     Else
      Begin
       WriteLn('.');
       WriteLn('Actually, this is offset ', HexPrint((EndMarker*$10000)+AbsDisplacement, 8),'h.');
      End;
     If ((EndMarker*$1000+AbsDisplacement) < $17) Then
      WriteLnANSI(ErrorColor, ' Offset invalid! Overlapping with FontFileHeader block!');

     If ((EndMarker*$1000+AbsDisplacement) > $17) Then
      If DRFont Then
       Begin { DRFONT }
        If ExtractDRFONTMAP Then
         If ((Not FileExists(DRFPath)) Or OverwriteFile) Then
          Begin
           {$I-}
           Assign(DRF, DRFPath);
           Rewrite(DRF);
           {$I+}
           If (IOResult <> 0) Then
            Begin
             {$I-}
             Close(DRF);
             {$I+}
             If (IOResult = 0) Then Begin End; {dummy}
             WriteLnANSI(ErrorColor,' Error opening DRFONT character lookup table file!');
             ExtractDRFONTMAP:=FALSE;
            End;
          End
         Else
          Begin
           WriteLnANSI(ErrorColor, Concat(' Error: File already exists. Use ', SWC, ParOverwrite, ' to overwrite file.'));
           ExtractDRFONTMAP:=FALSE;
          End;
        WriteLn;
        WriteLnANSI(HighLightColor, 'DRFONT enhanced FontInfoHeader:');
        If ReadFileOk(CPF, DRFontXCPFHead, $17, SizeOf(DRFontXCPFHead), BytesRead) Then
         Begin End; {Dummy}
        If (BytesRead > 0) Then
         With DRFontXCPFHead Do
          Begin
           WriteLn('Count of font tables: ', NrOfFonts);
           Write('Font cell size per char (in bytes): ');
           If (NrOfFonts >=1) Then Write(CellSizeFont1);
           If (NrOfFonts >=2) Then Write(', ', CellSizeFont2);
           If (NrOfFonts >=3) Then Write(', ', CellSizeFont3);
           If (NrOfFonts >=4) Then Write(', ', CellSizeFont4);
           WriteLn;
           If (NrOfFonts >=4) Then
            Begin
             WriteLn('Offset for data of font ', CellSizeFont1:2, 'x8: ',
                     HexPrint(DataPosFont1, 8), 'h.');
             WriteLn('Offset for data of font ', CellSizeFont2:2, 'x8: ',
                     HexPrint(DataPosFont2, 8), 'h.');
             WriteLn('Offset for data of font ', CellSizeFont3:2, 'x8: ',
                     HexPrint(DataPosFont3, 8), 'h.');
             WriteLn('Offset for data of font ', CellSizeFont4:2, 'x8: ',
                     HexPrint(DataPosFont4, 8), 'h.');
             If (NrOfFonts > 4) Then
              WriteLnANSI(ErrorColor,'Currently more fonts are not supported! ');
            End;
          End; {With}
       End
      Else
       Begin { unknown }
        WriteANSI(ErrorColor,'');
        WriteLn('Extra data (', EndMarker*$1000+AbsDisplacement-$17,' bytes) in datablock at offset 0017h!');
        If ReadFileOk(CPF, ExtraData, $17, Min(SizeOf(ExtraData), EndMarker*$1000+AbsDisplacement-$17), BytesRead) Then
         Begin End; {Dummy}
        If (BytesRead > 0) Then
         Begin
          For w := 0 To Pred(BytesRead) Do
           Begin
            Write(HexPrint(ExtraData[w], 2), 'h');
            If (w < Pred(BytesRead)) Then Write(', ')
            Else Write('.');
           End;
          If (Succ(w) < EndMarker*$1000+AbsDisplacement-$17) Then Write('..');
         End;
        WriteLnANSINorm;
       End;
     WriteLn;
     WriteLnANSI(HighLightColor, 'FontInfoHeader:');
     If ReadFileOK(CPF, FntInfoHead, EndMarker*$1000+AbsDisplacement, SizeOf(FntInfoHead), BytesRead) Then
      Begin
       If (FntInfoHead.NrOfCPEntries > MaxCPEntries) Then WriteANSI(ErrorColor,'');
        Write('Count of supported codepages: ', FntInfoHead.NrOfCPEntries);
       If (FntInfoHead.NrOfCPEntries > MaxCPEntries) Then Write(' (too high!)');
       WriteLnANSINorm;
       NrOfCPEntries:=FntInfoHead.NrOfCPEntries; { align to actually count of entries }
      End;
    End; {With}
  End; {OutCPFileHead}

 Procedure OutCPInfo;
  Type
   FontDataAreaT = Array [1..$FFF0] Of Byte;
  Var
   SrchIndex: LongInt;
   CPCounter: Byte;
   b        : Byte;
   dev_name : String[8];
   cp_str   : String[5];
  Procedure WriteFont(write_file: Boolean; FntDir: DirStr; FntName: NameStr; FntExt:ExtStr;
                      font, CellSize, width: Byte; NrOfChars: Word; DataPosFont: LongInt);
   Var
    count       : Word;
    chr_counter : Word;
    cell_counter: Byte;
    FontDataArea: ^FontDataAreaT;
    path        : PathStr;
    font_str    : String[3];
   Procedure DisplayBitMap(value, width, scanline: Byte);
    Var
     index : Byte;
     bitmap: Byte;
    Begin
     bitmap:= value;
     Write(HexPrint(scanline, 2),'h ');
     For index:=1 To width Do
      Begin
      If ((bitmap AND $80) > 0) Then Write(#219)
      Else Write('.');
      bitmap:=((bitmap AND $7F) SHL 1);
      End;
     Write('  ', HexPrint(value, 2),'h');
    End; {DisplayBitMap}
   Begin {WriteFont}
    If ((CellSize*NrOfChars) <= SizeOf(FontDataAreaT)) Then { if not structure too large... }
     Begin
      GetMem(FontDataArea, CellSize*NrOfChars); { always assume width=8 here...}
      If ReadFileOK(CPF, FontDataArea^, DataPosFont, CellSize*NrOfChars, count) Then
       Begin
        If write_file Then
         Begin
          Str(font, font_str);
          If (Length(FntName)+Length(font_str) > 8) Then
           path:=Concat(FntDir,Copy(FntName, 1+Length(font_str), Length(FntName)), font_str, FntExt)
          Else
           path:=Concat(FntDir, FntName, font_str, FntExt);
          If Not WriteFileOK(path, FontDataArea^, count) Then
           Begin End;
         End;
        If ShowFont Then
         Begin
          If (Not ShowBitMap) Then
           Begin
            Write('Scanline  : ');
            For cell_counter:=1 To CellSize Do
             Write(HexPrint(cell_counter, 2), 'h ');
            WriteLn;
           End;
          For chr_counter:=1 To NrOfChars Do
           Begin
            If ShowBitMap Then Write('        ');
            Write('Chr(', HexPrint(Pred(chr_counter), 4), 'h): ');
            For cell_counter:=1 To CellSize Do
             If ShowBitMap Then
              Begin
               WriteLn;
               Write('                    ');
               DisplayBitMap(FontDataArea^[Pred(chr_counter)*CellSize+cell_counter], width, cell_counter)
              End
             Else
              Write(HexPrint(FontDataArea^[Pred(chr_counter)*CellSize+cell_counter], 2), 'h ');
            WriteLn;
           End; {For}
         End;
       End;
      FreeMem(FontDataArea, CellSize*NrOfChars);
     End;
   End; {WriteFont}
  Procedure OutputCPDataHead;
   Var
    SrchIndex: LongInt;
   Procedure OutputScreenFontHead;
    Var
     b    : Byte;
     si   : LongInt;
    Begin
     With CPDataHead Do
      Begin
       si:=SrchIndex;
       GetMem(DispFontDataArea, FontAreaLength);
       Inc(si, SizeOf(CPDataHead));
       For b := 1 To NrOfFonts Do
        Begin
         If ReadFileOK(CPF, DispFontDataArea^, si, FontAreaLength, BytesRead) Then
          Begin End;
         If (BytesRead > 0) Then
          With DispFontDataArea^.Header Do
           Begin
            WriteLn('Font ', b, ': Offset ', HexPrint(si, 8), 'h');
            WriteLn('        ', NrOfChars, ' chars  ', Height, 'x', Width,
                    ' pixels (', Height*NrOfChars {width is 8bit},
                    ' bytes at offset ', HexPrint((si+6), 8), 'h).');
            Write('        AspectRatio is ', AspectRatioH, '/', AspectRatioW);
            If ((AspectRatioH = 0) And (AspectRatioW = 0)) Then Write (' (as expected)');
            WriteLn('.');
            If ShowFont Then WriteLn('        Font data:');
            If (ShowFont Or ExtractFonts) Then
             WriteFont(ExtractFonts, FntDir, FntName, FntExt, b, Height, Width, NrOfChars, si+6);
            Inc(si, Height*NrOfChars+6); {Height*Width*(NrOfChars SHR 3)+6;}
            UpdateEndIndex(si, 0);
           End; {With}
        End; {For}
       FreeMem(DispFontDataArea, FontAreaLength);
      End; {With}
    End; {OutputScreenFontHead}
   Procedure OutputDRFontHead;
    Var
     b, z        : Byte;
     si          : LongInt;
     hd_buf      : DispFontHeaderT;

     FontDataArea: ^FontDataAreaT;
     chr_buf     : Array[0..255] Of Byte;
     f_pos       : LongInt;
     ascii       : Byte;
     font_str    : String[3];

    Begin
     With CPDataHead Do
      Begin
       si := SrchIndex;
       GetMem(DispDRFontDataArea, SizeOf(DispDRFontT));
       Inc(si, SizeOf(CPDataHead));
       If ReadFileOK(CPF, DispDRFontDataArea^, si, SizeOf(DispDRFontT), BytesRead) Then
        Begin End; {???}
       If (BytesRead > 0) Then
        With DispDRFontDataArea^ Do
         Begin
          WriteLn('Offset ', HexPrint(si, 8), 'h:');
          For b:=1 To NrOfFonts Do
           Begin
            Case b Of
             1: hd_buf:=DispDRFontDataArea^.Header1;
             2: hd_buf:=DispDRFontDataArea^.Header2;
             3: hd_buf:=DispDRFontDataArea^.Header3;
             4: hd_buf:=DispDRFontDataArea^.Header4;
             Else WriteLnANSI(ErrorColor, ' Currently not supported!');
            End; {Case}
            If b In [1..4] Then
             With hd_buf Do
              Begin
               WriteLn('Font ', b, ': ', NrOfChars, ' chars  ', Height, 'x', Width,
                       ' pixels.');
               Write('        AspectRatio is ', AspectRatioH, '/', AspectRatioW);
               If ((AspectRatioH = 0) And (AspectRatioW = 0)) Then Write (' (as expected)');
               WriteLn('.');
               If ExtractFonts Then
                Begin { Collecting font data and write into file }
                 With DRFontXCPFHead Do
                  Case b Of
                   1: f_pos:=DataPosFont1;
                   2: f_pos:=DataPosFont2;
                   3: f_pos:=DataPosFont3;
                   4: f_pos:=DataPosFont4;
                  End; {Case}
                 GetMem(FontDataArea, NrOfChars*Height); { temp buffer for font data }
                 For ascii:=0 To Pred(NrOfChars) Do { collect character bitmaps from DRFONT data to font data }
                  If ReadFileOk(CPF, chr_buf, f_pos+Height*UniTable[ascii], Height, BytesRead) Then
                   For z:=0 To Pred(Height) Do FontDataArea^[Succ(ascii*Height+z)]:=chr_buf[z]
                  Else WriteLnANSI(ErrorColor, ' Error reading .CPI file!');
                 Str(b, font_str); { create a filename for font file }
                 If (Length(FntName)+Length(font_str) > 8) Then
                  FntPath:=Concat(FntDir, Copy(FntName, Succ(Length(font_str)), Length(FntName)), font_str, FntExt)
                 Else
                  FntPath:=Concat(FntDir, FntName, font_str, FntExt);
                 If Not WriteFileOK(FntPath, FontDataArea^, Height*NrOfChars) Then
                  Begin End; { write font buffer to file }
                 FreeMem(FontDataArea, NrOfChars*Height); { free temp buffer }
                End;
              End; {With}
           End; {For}
          { the following indexed table is not calculated in the FontAreaLength, as }
          { with record type 2 this isn't actually the FontAreaLength, but the Font-}
          { header length (without the following 512 byte table).                   }
          If ShowDRLUT Then
           Begin
            WriteLn('Character assignment lookup table (ASCII code -> Index in font data):');
            Write('01h -> 0001h to FFh -> 00FFh');
           End;
          If ExtractDRFONTMAP Then
           WriteLnTextFile(DRF, 'Character assignment lookup table (ASCII code -> Index in font data):');
          If ExtractDRFONTLUT Then
           If WriteFileOK(Concat(LUTDir, LUTName, LUTExt), UniTable, 512) Then
            Begin End;
          z:=0;
          For b:=0 To 255 Do
           Begin
            If (UniTable[b] > MaxChrCode) Then
             MaxChrCode:=UniTable[b];
            If ExtractDRFONTMAP Then
             WriteLnTextFile(DRF, Concat(HexPrint(b, 2),'h ', Displayable(Chr(b)),' -> ', HexPrint(UniTable[b],4), 'h'));
            If (ShowDRLUT And (b <> UniTable[b])) Then
             Begin
              If (z = 0) Then WriteLn(' except:')
              Else
               If ((z MOD 5) <> 0) Then Write(', ');
              Write(HexPrint(b,2),'h ', Displayable(Chr(b)), ' -> ', HexPrint(UniTable[b], 4), 'h');
              Inc(z);
              If ((z MOD 5) = 0) Then WriteLn;
             End;
           End; {For}
          If ShowDRLUT Then
           If ((z MOD 5) <> 0) Then WriteLn
           Else
            If (z = 0) Then WriteLn;
          WriteLn('Highest character index in font table, so far: ', HexPrint(MaxChrCode, 4), 'h.');
          If ExtractDRFONTMAP Then
           WriteLnTextfile(DRF, Concat('Highest character index in font table, so far: ', HexPrint(MaxChrCode, 4), 'h.'));
         End; {With}
       FreeMem(DispDRFontDataArea, SizeOf(DispDRFontT));
      End; {With}
    End; {OutputDRFontHead}
   Procedure OutputPrinterFontHead;
    Var
     b      : Byte;
     offs, c: Word;
     si     : LongInt;
    Begin
     With CPDataHead Do
      Begin
       GetMem(PrintFontDataArea, FontAreaLength); {???}
       si:=SrchIndex+SizeOf(CPDataHead);
       For b := 1 To NrOfFonts Do
        Begin {???}
         If ReadFileOK(CPF, PrintFontDataArea^, si, FontAreaLength, BytesRead) Then
          Begin End;
         If (BytesRead > 0) Then
          With PrintFontDataArea^ Do
           Begin
            Case b Of
             1: Begin
                 WriteLn('Font ', b, ': Offset ', HexPrint(si, 8), 'h');
                 Write  ('        Printer type: ', PrinterType);
                 Case PrinterType Of
                  1: WriteLn(' (as IBM Proprinter 4201/4202, Epson FX850/1050, EPS)');
                  2: WriteLn(' (as IBM Proprinter 4207/4208, Quietwriter 5202, PPDS)');
                  Else WriteLn(' (unknown type)');
                 End; {Case}
                 offs:=1;
                 WriteLn('        Length of sequence: ', NrOfBytes);
                 Write  ('        Hardware codepage:  ');
                 For c:=offs To Pred(offs+NrOfBytes) Do
                  Write(HexPrint(CmdESCSeq[c], 2), 'h ');
                 WriteLn;
                 Inc(offs, NrOfBytes);
                 Write('        Download codepage:  ');
                 For c:=offs To Pred(offs+NrOfBytes) Do
                  Write(HexPrint(CmdESCSeq[c], 2), 'h ');
                 WriteLn;
                 Inc(offs, NrOfBytes);
                 Write('        Download data    :  ');
                 If ExtractFonts Then
                  If Not WriteFileOK(Concat(FntDir, FntName, FntExt), CmdESCSeq[offs], FontAreaLength-2*NrOfBytes-4) Then
                   Begin End;
                 If ShowFont Then
                  Begin
                   For c:=offs To (FontAreaLength-2*NrOfBytes-5+offs) Do
                    Write(HexPrint(CmdESCSeq[c], 2), 'h ');
                   WriteLn;
                  End
                 Else
                  If (PrinterType <> 2) Then
                   WriteLn('Size is ', FontAreaLength-2*NrOfBytes-4)
                  Else
                   WriteLn('Size is ', FontAreaLength, ' (???)');
                 UpdateEndIndex(si, FontAreaLength);
                End;
             2: Begin
                 WriteANSI(ErrorColor, '');
                 WriteLn('Font ', b, ': Offset ', HexPrint(si, 8), 'h');
                 WriteLn('        More than one printer font is not usual!');
                 WriteLn('        With DR DOS 6', SubVerSym, '0/Novell DOS 7, more fonts are introduced,');
                 Write('        but they don''t really exist!');
                 WriteLnANSINorm;
                End
             Else
              Begin
               WriteANSI(ErrorColor, ''); { is impossible... }
               WriteLn('Font ', b, ': Offset ', HexPrint(si, 8), 'h currently not supported.');
               WriteLnANSINorm;
              End;
            End; {Case}
            Inc(si, FontAreaLength); {??? perhaps depends on printer type}
           End; {With}
        End; {For}
       FreeMem(PrintFontDataArea, FontAreaLength);
      End; {With}
    End; {OutputPrinterFontHead}
   Begin {OutputCPDataHead}
    SrchIndex := CPHead.Ptr2Font;
    If ReadFileOK(CPF, CPDataHead, SrchIndex, SizeOf(CPDataHead), BytesRead) Then
     Begin
      With CPDataHead Do
       Begin
        WriteLnANSI(HighLightColor, 'FontDataHeader:');
        If (RecordType <> 1) Then WriteANSI(ErrorColor,'');
        Write('Record type: ', RecordType);
        Case RecordType Of
         1:   Write(' (as expected).');
         2:   If DRFont Then Write(' (as usual with DRFONT)')
              Else Write(' (unexpected: DR DOS 6', SubVerSym, '0/Novell DOS 7).');
              { should only be accepted when DRFONT instead of FONT }
         Else Write(' (unexpected).');
        End; {Case}
        WriteLnANSINorm;
        WriteLn('Count of supported fonts: ', NrOfFonts,
                ', size of data block: ', FontAreaLength, ' bytes.');
             { this value is interpreted differently with printer type 2 fonts }
        If (MaxAvail >= FontAreaLength) Then
         Begin
          Case CPHead.UnitType Of
           1: Case RecordType Of
               1: OutputScreenFontHead;
               2: OutputDRFontHead;
               Else WriteLnANSI(ErrorColor, 'Format not supported!');
              End; {Case}
           2: OutputPrinterFontHead
           Else WriteLn('Currently cannot analyze this type.'); { impossible }
          End; {Case}
         End;
       End; {With}
     End;
   End; {OutputCPDataHead}
  Procedure OutPutExtraData(SrchIndex: Word);
   Var
    b: Word;
   Begin
    If ReadFileOK(CPF, ExtraData, SrchIndex, SizeOf(ExtraData), BytesRead) Then
     Begin End;
    If (BytesRead > 0) Then
     Begin
      WriteLn;
      WriteLnANSI(HighLightColor, Concat('Extra data at end of file (Offset ', HexPrint(SrchIndex, 8), 'h):'));
      For b:=0 To Pred(BytesRead) Do
       Write(Displayable(Chr(ExtraData[b])));
      WriteLn;
     End;
   End; {OutPutExtraData}
  Begin {OutCPInfo}
   CPCounter:= 0;
   SrchIndex:= (CPFileHead.EndMarker*$1000+CPFileHead.AbsDisplacement)+2;
   While ((CPCounter < CPFileHead.NrOfCPEntries) And
          (ReadFileOK(CPF, CPHead, SrchIndex, SizeOf(CPHead), BytesRead))) Do
    Begin
     Inc (CPCounter);
     With CPHead Do
      Begin
       WriteLn;
       WriteLnANSI(HighLightColor, 'CPEntryHeader:');
       Write('The header size of ', CPCounter, '. codepage is ', CPHSize, ' bytes');
       If (CPHSize <> 28) Then WriteLn(' (unusual).') { often with printer files }
       Else WriteLn(' (as with MS-DOS 5', SubVerSym, '0).');
       dev_name:='';
       For b:=0 To 7 Do dev_name:=Concat(dev_name, FontName[b]);
       Write('Output unit is ', UnitType);
       Case UnitType Of
        1:   Begin
              WriteLn(' (Display).');
              If ((dev_name = '4201    ') Or (dev_name = '4208    ') Or
                  (dev_name = '5202    ') Or (dev_name = '1050    ')) Then
               Begin
                WriteLnANSI(ErrorColor, Concat('Obviously wrong type marker (DR DOS 3', SubVerSym, '40-5', SubVerSym, '0)!'));
                WriteLnANSI(ErrorColor, 'File will be further processed as with printer type!');
                UnitType:=2;
               End;
             End;
        2:   WriteLn(' (Printer).');
        Else WriteLn(' (unknown).');
       End; {Case}
       WriteLn('Fontname: "', dev_name, '".');
       If ExtractDRFONTMAP Then
        Begin
         WriteLnTextFile(DRF,'');
         WriteLnTextFile(DRF, Concat('Fontname: "', dev_name, '"'));
         WriteLnTextFile(DRF, Concat('Codepage No.: ', IntToStr(CP_ID, 0), ':'));
        End;
       Write('Codepage No.: ', CP_ID, ' (');
       Str(CP_ID, cp_str);
       Delete(cp_str, 1, Length(cp_str)-3);
       If ExtractFonts Then
        FntExt:=Concat('.', cp_str);
       If ExtractDRFONTLUT Then
        LUTExt:=Concat('.', cp_str);
       Case CP_ID Of
         { Not all these codepages are actually included in stock versions of DOS,   }
         { but as with CPI.EXE it is possible to prepare for creating your own .CPI  }
         { files, all codepage IDs ever used (and known to me) are included here for }
         { reference.                                                                }
           0: Write('Unusual (Default) [DOS/V]');           { not used in .CPI files            }
           1: Write('Unknown [Buggy MS 4208.CPI]');         { buggy MS-DOS 6.xx 4208.CPI file   }
          37: Write('EBCDIC: English (US / Canada) [370]'); { IBM 370, terminals, International }
         237: Write('EBCDIC: German [370]');                { IBM 370, terminals                }
         277: Write('EBCDIC: Danish, Norwegian [370]');     { IBM 370, terminals                }
         278: Write('EBCDIC: Finnish, Swedish [370]');      { IBM 370, terminals                }
         280: Write('EBCDIC: Italian [370]');               { IBM 370, terminals                }
         284: Write('EBCDIC: Latin-American / Spanish [370]');{ IBM 370, terminals              }
         285: Write('EBCDIC: English (UK) [370]');          { IBM 370, terminals                }
         297: Write('EBCDIC: French [370]');                { IBM 370, terminals                }
         437: Write('English / Europe (Standard)');         { MS-DOS 3.30+, DR DOS 3.40+, OS/2, }
                                                            { Win95/MS-DOS 7, NetWare 3.xx+     }
         500: Write('EBCDIC: Belgium, Switzerland, International [370, Win/NT]');
                                                            { old Multilingual, Win/NT 3.5,     }
                                                            { IBM 370, terminals                }
         646: Write('Reserved for various ISO 7bit codepages');{ (just my proposal)             }
         708: Write('Arabic / Middle East [Win95]');        { Win95                             }
         737: Write('Greek (2)');                           { MS-DOS 6.2?+, Win95/MS-DOS 7      }
         775: Write('Baltic (BaltRim) [Win95]');            { Win95                             }
         850: Write('International / Multilingual (Latin 1)');{ MS-DOS 3.30+, DR DOS 3.40+, OS/2, Win95/MS-DOS 7, NetWare 3.xx}
         851: Write('Undocumented [MS-DOS 4', SubVerSym, '00-6', SubVerSym, '22]'); { not with Win95/MS-DOS 7                }
         852: Write('Slavic / Eastern Europe (Latin 2)');   { MS-DOS 5.0+, DR DOS 6.0+, OS/2, Win95/MS-DOS 7, Win/NT         }
         853: Write('Undocumented [MS 4', SubVerSym, '00-6', SubVerSym, '22/DR 6',SubVerSym,'0+]'); { not with Win95/MS-DOS 7}
         854: Write('Spanish (old)???');                    { found in SYSthema book, page 227. typoerror???                 }
         855: Write('Cyrillic 1');                          { MS-DOS 4.00+?, Win95/MS-DOS 7, Win/NT                          }
         857: Write('Turkish');                             { PC-DOS 6.1+?, DR DOS 6.0+, OS/2, Win95/MS-DOS 7, Win/NT        }
         860: Write('Portuguese');                          { MS-DOS 3.30+, DR DOS 3.40+, OS/2, Win95/MS-DOS 7, NetWare 3.xx }
         861: Write('Icelandic');                           { PC-DOS 6.1+?, OS/2, MS-DOS 7, Win/NT                           }
         862: Write('Hebrew');                              { MS-DOS 4.00+, DR DOS 3.40-5.0 (DR DOS 6.0+), OS/2, MS-DOS 7    }
         863: Write('Franco-Canadian (French)');            { MS-DOS 3.30+, DR DOS 3.40+, OS/2, NetWare 3.xx, Win/NT, MS-DOS 7}
         864: Write('Arabic / Middle East');                { MS-DOS 3.30+, DR DOS 3.40+, OS/2, not with MS-DOS 7            }
       { 864: Write('Latin-American / Brasilian???'); }     { cannot remember source of supply...                            }
         865: Write('Nordic (Norwegian / Danish)');         { MS-DOS 3.30+, DR DOS 3.40+, OS/2, NetWare 3.xx, Win/NT, MS-DOS 7}
         866: Write('Russian (Cyrillic 2)');                { PC-DOS 6.1?+, DR DOS 6.0+, Win95, Win/NT, MS-DOS 7             }
         869: Write('Greek (1)');                           { PC-DOS 6.1+?, Win/NT, MS-DOS 7                                 }
         874: Write('Thailand [Win95]');                    { Win95, NetWare Client32                                        }
         875: Write('EBCDIC: Greek [370, Win/NT]');         { IBM mainframes, terninals, Win/NT 3.5                          }
         880: Write('Russian (Cyrillic GOST)');             { GOST, Dimitri Vulis                                            }
         897: Write('Japanese etc. (Shift-JIS) [NetWare]'); { NetWare 3.xx                                                   }
         932: Write('Japanese (Shift-JIS)');                { (MS-DOS 4.00+), (Eastern DR DOS 6.0+), OS/2, Win95,NetWare 3.xx+}
         934: Write('Korean');                              { (MS-DOS 4.00+), (Eastern DR DOS 6.0+), OS/2                    }
         936: Write('Chinese (PRC) (Simplified, Ext. GB)'); { MS-DOS 4.00+, Win95, Client32                                  }
         938: Write('Taiwan [OS/2: Chinese (PRC)]');        { MS-DOS 4.00+, [OS/2], trad. China                              }
         942: Write('SAA: Japanese [OS/2]');                { OS/2 2.0+                         }
         944: Write('SAA: Korean [OS/2]');                  { OS/2 2.0+                         }
         948: Write('SAA: Chinese (PRC) [OS/2]');           { OS/2 2.0+                         }
         949: Write('Korean (Unified Hangul, Extented Wansung)'); { Win95                       }
         950: Write('Chinese Traditional (Big5) (Taiwan, Hong Kong)'); { Win95, Client32        }
         966: Write('Saudi Arabic [Win95]');                { Win95                             }
         999: Write('Reserved [DR DOS 5.0+ / NWDOS 7 KEYB]');{ reserved for patched user-definable codepages in }
                                                            { DR DOS 5.0+/Novell DOS 7 KEYB     }
        1026: Write('EBCDIC: Turkish (Latin 5) [370, Win/NT]');{ Win/NT 3.5                     }
        1047: Write('EBCDIC: International / Multilingual (defacto EBCDIC)');
                                                            { US, defacto EBCDIC, proposal      }
        1250: Write('WIN: Eastern Europe (Latin 2) [95/NT]'); { Win95, Win/NT, Client32         }
        1251: Write('WIN: Cyrillic [Win95, Win/NT]');       { Win95, Win/NT, Client32           }
        1252: Write('WIN: English/Western Europe [Win, NetW]');{ Latin 1                        }
                                                            { Novell PNW 1.0, (Win3.1), Win95, NetWare 3.xx, Win/NT, Client32 }
        1253: Write('WIN: Greek (GRC) [Win95, Win/NT]');    { Win95, Win/NT, Client32           }
        1254: Write('WIN: Turkish [Win95, Win/NT]');        { Win95, Win/NT, Client32           }
        1255: Write('WIN: Hebrew [Win95]');                 { Win95, Client32                   }
        1256: Write('WIN: Arabic [Win95]');                 { Win95, Client32                   }
        1257: Write('WIN: Baltic [Win95]');                 { Win95, Client32                   }
        1258: Write('WIN: Vietnamese');                     { Win???                            }
        1361: Write('ANSI???: Korean (Johab) [Win95]');     { Win95                             }
       10000: Write('MAC: International / Standard [Win/NT]');{ Macintosh, Win/NT               }
       10006: Write('MAC: Greek [Win/NT]');                 { Macintosh, Win/NT                 }
       10007: Write('MAC: Cyrillic [Win/NT]');              { Macintosh, Win/NT                 }
       10029: Write('MAC: Latin 2 [Win/NT]');               { Macintosh, Win/NT                 }
       10079: Write('MAC: Icelandic');                      { Macintosh                         }
       10081: Write('MAC: Turkish');                        { Macintosh                         }
       10646: Write('Reserved for global ISO 32bit codepage');{ (just my proposal)              }
       Else   Write('Unknown');
       End; {Case}
       WriteLn(').');
       If (DBGEcho And (Not IsRegistered(CP_ID, UnitType))) Then
        RequestFile:=TRUE;
       Write('Reserved entries are');
       b := 0;
       While ((b < 3) And (Reserved[b] = 0)) Do
        Begin
         Write(' ', HexPrint(Reserved[b], 4), 'h');
         Inc(b);
        End;
       If (b = 3) Then WriteLn(' (as expected).')
       Else WriteLn(' (unusual)!');
       WriteLn('Offset of font block is ', HexPrint(Ptr2Font, 8), 'h.');
       If ((NextCPH = 0) Or (NextCPH = $FFFFFFFF)) Then
        Begin { end of list }
         Write('No more CPEntryHeader pending. Entry is ', HexPrint(NextCPH, 8), 'h)');
         If (NextCPH <> 0) Then
          Begin
           WriteLn('!');
           WriteANSI(ErrorColor,'');
           If (CPCounter < CPFileHead.NrOfCPEntries) Then
            Write(' (Calculating on FontInfoHeader there should be more codepages here!)')
           Else
            Write(' (This does not follow specifications! Usual is 00000000h.)');
           WriteLnANSINorm;
          End
         Else WriteLn('.');
         NextCPH:=0; { to avoid overflow }
        End
       Else { not end of list }
        Begin
         WriteLn('Offset of the following CPEntryHeader is ', HexPrint(NextCPH, 8), 'h.');
         If (Not (CPCounter < CPFileHead.NrOfCPEntries)) Then
          Begin
           WriteLnANSI(ErrorColor, ' (Calculating on FontInfoHeader, no more codepages available!)');
           If ((UnitType <> 1) And (UnitType <> 2)) Then
            Begin
             NextCPH:=0; { avoid overflow with some strange 4208.CPI files }
             Stop   :=TRUE;
            End;
          End;
        End;
       SrchIndex:=NextCPH;
      End; {With}
     If (Not Stop) Then OutputCPDataHead;
     If ((SrchIndex = 0) XOr (CPCounter < CPFileHead.NrOfCPEntries)) Then
      ExtraDataIndex:=MaxFileIndex
     Else
      ExtraDataIndex:=SrchIndex;
    End; {While}
   If ExtractDRFONTMAP Then
    Begin
     {$I-}
     Close(DRF);
     {$I+}
     If (IOResult <> 0) Then Begin End;
    End;
   If DRFont Then
    With DRFontXCPFHead Do
     Begin
      If (ShowFont Or ExtractDRFonts) Then
       Begin
        If ShowFont Then WriteLn;
        If (NrOfFonts > 0) Then
         Begin
          If ShowFont Then WriteLnANSI(HighLightColor, 'Font 1 data:');
          WriteFont(ExtractDRFonts, DRFntDir, DRFntName, '.6x8', 1, CellSizeFont1, 8, Succ(MaxChrCode), DataPosFont1);
         End;
        If (NrOfFonts >= 4) Then
         Begin
          If ShowFont Then WriteLnANSI(HighLightColor, 'Font 2 data:');
          WriteFont(ExtractDRFonts, DRFntDir, DRFntName, '.8x8', 2, CellSizeFont2, 8, Succ(MaxChrCode), DataPosFont2);
         End;
        If (NrOfFonts >= 4) Then
         Begin
          If ShowFont Then WriteLnANSI(HighLightColor, 'Font 3 data:');
          WriteFont(ExtractDRFonts, DRFntDir, DRFntName, '.148', 3, CellSizeFont3, 8, Succ(MaxChrCode), DataPosFont3);
         End;
        If (NrOfFonts >= 4) Then
         Begin
          If ShowFont Then WriteLnANSI(HighLightColor, 'Font 4 data:');
          WriteFont(ExtractDRFonts, DRFntDir, DRFntName, '.168', 4, CellSizeFont4, 8, Succ(MaxChrCode), DataPosFont4);
         End;
       End;
      If (NrOfFonts > 0)  Then UpdateEndIndex(DataPosFont1, CellSizeFont1*Succ(MaxChrCode));
      If (NrOfFonts >= 4) Then UpdateEndIndex(DataPosFont2, CellSizeFont2*Succ(MaxChrCode));
      If (NrOfFonts >= 4) Then UpdateEndIndex(DataPosFont3, CellSizeFont3*Succ(MaxChrCode));
      If (NrOfFonts >= 4) Then UpdateEndIndex(DataPosFont4, CellSizeFont4*Succ(MaxChrCode));
      If (ExtraDataIndex < MaxFileIndex) Then ExtraDataIndex:=MaxFileIndex;
     End; {With}
   OutPutExtraData(ExtraDataIndex);
  End; {OutCPInfo}

 Procedure CheckParameters;
  Type
   MethodT = (DisplayHelp, DisplayAbout, Nothing);
  Var
   method  : MethodT;
   dummy_w : Word;
   dummy_s : String;
   error   : Integer;
  Procedure DispHelp;
   Begin
    WriteLn;
    WriteLn('  Syntax: CPI [@] [@] ', DispParam(ParHelp1, TRUE),
              '] [', DispParam(ParHelp2, TRUE),
              '] [', DispParam(ParAbout1, TRUE),
              '] [', DispParam(ParAbout2, TRUE), ']');
    WriteLn('              [', DispParam(ParCPIFile, TRUE),
              '[=filespec]] [', DispParam(ParRptFile, TRUE),
              '[=filespec]] [', DispParam(ParShowFont, TRUE),
              '[=0..5]]');
    WriteLn('              [', DispParam(ParGetFonts, TRUE),
              '[=filespec]] [', DispParam(ParGetDRFonts, TRUE),
              '[=filespec]]');
    WriteLn('              [', DispParam(ParDRTableFileName, TRUE),
              '[=filespec]] [', DispParam(ParDRLUT, TRUE),
              '[=filespec]] [', DispParam(ParOverWrite, TRUE),
              '] [', DispParam('?', FALSE), '|', DispParam('&', FALSE),']');
    WriteLn;
    WriteLn('  ', DispParam(ParHelp1, TRUE),', ', DispParam(ParHelp2, TRUE),
            '   : This help screen.');
    WriteLn('  ', DispParam(ParAbout1, TRUE), ', ', DispParam(ParAbout2, TRUE),
            '  : The ''about'' info screen.');
    WriteLn('  ', DispParam(ParCPIFile, TRUE),
            '    : DOS .CPI file name <EGA.CPI>; extension: <.CPI>.');
    WriteLn('                When specifying ''CPI.EXE'' or '''', StdIn will be used.');
    WriteLn('                When only one parameter is given, ',
            DispParam(ParCPIFile, TRUE), ' is obsolete.');
    WriteLn('  ', DispParam(ParRptFile, TRUE),
            '     : Report file name <''''=StdOut>; extension: <.RPT>.');
    WriteLn('  ', DispParam(ParShowFont, TRUE),
            '    : Dump mode <0>; 0=no; <1>,3,5=DRFONT LUT; 2,3=font; 4,5=bitmaps.');
    WriteLn('  ', DispParam(ParGetFonts, TRUE),
            '      : Extract font data to files *<font>; extensions: <codepage>.');
    WriteLn('  ', DispParam(ParGetDRFonts, TRUE),
            '    : Extract DRFONT data to files *<font>; extensions: <font-spec>.');
    WriteLn('  ', DispParam(ParDRTableFileName, TRUE),
            '        : Extract DRFONT character lookup table (LUT) to list file;');
    WriteLn('                extension: <.MAP>.');
    WriteLn('  ', DispParam(ParDRLUT, TRUE),
            '        : Extract DRFONT LUTs to binary files; extensions: <codepage>.');
    WriteLn('  ', DispParam(ParOverwrite, TRUE),
            '  : Force to overwrite existing files.');
    WriteLn('  ', DispParam('?', FALSE), ', ', DispParam('&', FALSE),
            '        : Online edit mode (prompts for additional parameter input).');
   End; {DispHelp}
  Procedure DispAbout;
   Begin
    WriteLn;
    WriteLn('  Effective command line is: ', OrgCmdLine);
    WriteLn;
    WriteLn('  This FreeWare utility utilizes our CUI_LIB ',
             VerSym, CUILIB_MainVerStr, SubVerSym, CUILIB_SubVerStr,' library.');
    WriteLn('  For detailed infos on CPI and CUI_LIB configuration features have a look');
    WriteLn('  at the documentation. The user interface is widely customizable.');
    WriteLn;
    WriteLn('  For reports, suggestions or more information, feel free to contact us:');
    WriteLn;
    WriteLn('  <MPaul@ibh.rwth-aachen.de>, <ACFrinke@uni-bonn.de>, <Frinke@cs.bonn.edu>');
    WriteLn;
    WriteLn('  Matthias Paul               Axel C. Frinke');
    WriteLn('  Ubierstrae 28              Steinstrae 11');
    WriteLn('  D-50321 BRHL               D-53332 BORNHEIM');
    WriteLn('  GERMANY                     GERMANY');
   End; {DispAbout}
  Begin {CheckParameters}
   method:=Nothing;
   If CheckParam(ParHelp1, OrgCmdLine, FALSE, TRUE, TRUE, dummy_w, dummy_s)       Then method:=DisplayHelp
   Else If CheckParam(ParHelp2, OrgCmdLine, FALSE, TRUE, TRUE, dummy_w, dummy_s)  Then method:=DisplayHelp
   Else If CheckParam(ParAbout1, OrgCmdLine, FALSE, TRUE, TRUE, dummy_w, dummy_s) Then method:=DisplayAbout
   Else If CheckParam(ParAbout2, OrgCmdLine, FALSE, TRUE, TRUE, dummy_w, dummy_s) Then method:=DisplayAbout;
   Case method Of
    DisplayHelp: Begin
                  DispHelp;
                  Halt(255);
                 End;
    DisplayAbout:Begin
                  DispAbout;
                  Halt(254);
                 End;
    Else
     Begin
      { Init: }
      RptPath:='';
      ShowFont:=FALSE;
      ShowBitMap:=FALSE;
      ShowDRLUT:=FALSE;
      ExtractFonts:=FALSE;
      ExtractDRFonts:=FALSE;
      ExtractDRFONTMAP:=FALSE;
      ExtractDRFONTLUT:=FALSE;
      OverwriteFile:=FALSE;

      { CPI filename evaluation: }
      If CheckParam(ParCPIFile, OrgCmdLine, FALSE, FALSE, TRUE, dummy_w, dummy_s) Then
       Begin
        CPFPath:=ToUpperC(FExpandDR(dummy_s));
        If ((StrCount(OrgCmdLine)=1) And
            (ToUpperC(Copy(SubStr(OrgCmdLine,1),1,2))='C:') And
            (Not FileExists(CPFPath))) Then
         Begin { if not found, so drive C: could be misinterpreted as /C: parameter }
          dummy_s:=ToUpperC(dummy_s);
          FSplitDR(dummy_s, CPFDir, CPFName, CPFExt, CPFPass);
          If (Pos(':', CPFDir) = 0) Then { no (local) drive specified }
           Begin
            dummy_s:=Concat('C:', dummy_s); { add drive C: (that was truncated) }
            If FileExists(dummy_s) Then CPFPath:=dummy_s;
           End;
         End;
       End
      Else
       If (StrCount(OrgCmdLine) = 1) Then CPFPath:=SubStr(OrgCmdLine, 1)
       Else CPFPath:='EGA.CPI';
      FSplitDR(CPFPath, CPFDir, CPFName, CPFExt, CPFPass);
      If (Length(CPFExt) = 0) Then CPFExt:='.CPI';
      If (Length(CPFName) = 0) Then CPFName:='EGA';
      If (CPFPath=XParamStr(0)) Then
       Begin
        CPFPath:=''; { Input redirection }
        FSplitDR(CPFPath, CPFDir, CPFName, CPFExt, CPFPass);
       End;
      CPFPath:=Concat(CPFDir, CPFName, CPFExt, CPFPass);

      If StrCount(OrgCmdLine) > 1 Then
       Begin
        { Report filename evaluation: }
        If CheckParam(ParRptFile, OrgCmdLine, FALSE, FALSE, TRUE, dummy_w, dummy_s) Then
         Begin
          RptPath:=ToUpperC(FExpandDR(dummy_s));
          FSplitDR(RptPath, RptDir, RptName, RptExt, RptPass);
          If (Length(RptName) = 0) Then RptName:=CPFName;
          If ((Length(RptExt) = 0) Or
              (RptExt='.CPI') Or (RptExt='.EXE') Or (RptExt='.COM') Or
              (RptExt='.BAT') Or (RptExt='.BTM') Or (RptExt='.CMD') Or
              (RptExt='.REX') Or (RptExt='.XMF') Or (RptExt='.OVL') Or
              (RptExt='.SYS')) Then
           RptExt:='.RPT';
          RptPath:=Concat(RptDir, RptName, RptExt, RptPass);
          If (RptPath=CPFPath) Or (RptPath=XParamStr(0)) Then RptPath:='';
          If (Length(RptPath) > 0) Then
           WriteLn(' Report file: ', RptPath);
         End;
        { ShowFont variable evaluation: }
        ShowDRLUT:=CheckParam(ParShowFont, OrgCmdLine, FALSE, TRUE, FALSE, dummy_w, dummy_s);
        If ShowDRLUT Then
         Begin
          ValWord(dummy_s, dummy_w, error);
          If ((error = 0) And (dummy_w <= 255)) Then
           Begin
            If (Byte(dummy_w) In [0, 2, 4]) Then ShowDRLUT:=FALSE;
            If (Byte(dummy_w) In [2, 3, 4, 5]) Then ShowFont:=TRUE;
            If (Byte(dummy_w) In [4, 5]) Then ShowBitMap:=TRUE;
           End;
         End;
        { Overwrite variable evaluation: }
        OverwriteFile:=CheckParam(ParOverwrite, OrgCmdLine, FALSE, TRUE, TRUE, dummy_w, dummy_s);
        { ExtractFonts evaluation: }
        ExtractFonts:=CheckParam(ParGetFonts, OrgCmdLine, FALSE, FALSE, TRUE, dummy_w, dummy_s);
        If ExtractFonts Then
         Begin
          FntPath:=ToUpperC(FExpandDR(dummy_s));
          FSplitDR(FntPath, FntDir, FntName, FntExt, FntPass);
          If (Length(FntName) = 0) Then FntName:=CPFName;
          FntExt:='.FNT';
          FntPath:=Concat(FntDir, FntName, FntExt, FntPass);
          WriteLn(' Font binary data files: ', Concat(FntDir, FntName), '?.???', FntPass);
         End;
        { ExtractDRFonts evaluation: }
        ExtractDRFonts:=CheckParam(ParGetDRFonts, OrgCmdLine, FALSE, FALSE, TRUE, dummy_w, dummy_s);
        If ExtractDRFonts Then
         Begin
          FntPath:=ToUpperC(FExpandDR(dummy_s));
          FSplitDR(DRFntPath, DRFntDir, DRFntName, DRFntExt, DRFntPass);
          If (Length(DRFntName) = 0) Then DRFntName:=CPFName;
          DRFntExt:='.DRF';
          DRFntPath:=Concat(DRFntDir, DRFntName, DRFntExt, DRFntPass);
          WriteLn(' DRFONT binary data files: ', Concat(DRFntDir, DRFntName), '?.???', DRFntPass);
         End;
        { ExtractDRFONTMAP evaluation: }
        ExtractDRFONTMAP:=CheckParam(ParDRTableFileName, OrgCmdLine, FALSE, FALSE, TRUE, dummy_w, dummy_s);
        If ExtractDRFONTMAP Then
         Begin
          DRFPath:=ToUpperC(FExpandDR(dummy_s));
          FSplitDR(DRFPath, DRFDir, DRFName, DRFExt, DRFPass);
          If (Length(DRFName) = 0) Then DRFName:=CPFName;
          If ((Length(DRFExt) = 0) Or
              (DRFExt='.CPI') Or (DRFExt='.EXE') Or (DRFExt='.COM') Or
              (DRFExt='.BAT') Or (DRFExt='.BTM') Or (DRFExt='.CMD')) Then
           DRFExt:='.MAP';
          DRFPath:=Concat(DRFDir, DRFName, DRFExt, DRFPass);
          If ((DRFPath = CPFPath) Or (DRFPath = RptPath)) Then
           Begin { cannot do this }
            ExtractDRFONTMAP:=FALSE;
            WriteLnANSI(ErrorColor, Concat(' Error with DRFONT table file: ', DRFPath, '!'));
           End
          Else
           Begin
            WriteLn(' DRFONT character lookup map file: ', DRFPath);
            If (FileExists(DRFPath) And (Not OverwriteFile)) Then
             Begin
              WriteLnANSI(ErrorColor, Concat(' Error: File already exists. Use ', SWC, ParOverwrite, ' to overwrite file.'));
              ExtractDRFONTMAP:=FALSE;
             End;
           End;
         End;
        { ExtractDRFONTLUT evaluation: }
        ExtractDRFONTLUT:=CheckParam(ParDRLUT, OrgCmdLine, FALSE, FALSE, TRUE, dummy_w, dummy_s);
        If ExtractDRFONTLUT Then
         Begin
          LUTPath:=ToUpperC(FExpandDR(dummy_s));
          FSplitDR(LUTPath, LUTDir, LUTName, LUTExt, LUTPass);
          If (Length(LUTName) = 0) Then LUTName:=CPFName;
          LUTExt:='.LUT';
          LUTPath:=Concat(LUTDir, LUTName, LUTExt, LUTPass);
          WriteLn(' DRFONT LUT data files: ', Concat(LUTDir,LUTName), '.???', LUTPass);
         End;
       End;
     End;
   End; {Case}
  End; {CheckParameters}

 Begin {Main}
  { Init }
  Stop          :=FALSE;
  DRFont        :=FALSE;
  io_error_flag :=FALSE;
  RequestFile   :=FALSE;
  MaxChrCode    :=0;
  MaxFileIndex  :=0;
  ExtraDataIndex:=0;
  OrgCmdLine    :=Concat(OrgCmdLine,Chr(SPACE),EnvCmdLine,Chr(SPACE),ExtCmdLine);
  UpStrC(OrgCmdLine);
  { Title }
  WriteLnANSI(TitleColor, 'CPI '+VerSym+MainVerStr+SubVerSym+SubVerStr+
              ' '+CopyrightSym+' 1995-1996 by Axel C. Frinke & Matthias Paul');
  WriteLn('Analyzer utility for .CPI DOS codepage files.');
  { Check parameters }
  CheckParameters;
  {$I-}
  OldANSIStatus:=ANSI;
  If (Length(RptPath) > 0) Then
   ANSI:=FALSE;
  Assign(Output, RptPath);
  Rewrite(Output);
  {$I+}
  If (IOResult = 0) Then
   Begin
    {$I-}
    Assign(CPF, CPFPath);
    FileMode:=fmReadOnly;
    If IsShareSupported Then Inc(FileMode, fmDenyWrite);
    Reset(CPF, 1);
    FileMode:=fmReadWrite;
    {$I+}
    If (IOResult = 0) Then
     If ReadFileOK(CPF, CPFileHead, 0, SizeOf(CPFileHead), BytesRead) Then
      Begin
       If (Length(RptPath) > 0) Then
        Begin
         WriteLn;
         WriteLn('Report created by CPI '+VerSym+MainVerStr+SubVerSym+SubVerStr+
                 ' '+CopyrightSym+' 1995-1996 by Axel C. Frinke & Matthias Paul.');
         WriteLn('No warranties and responsibility of any kind.');
         WriteLn;
         WriteLn('Remainder:');
         WriteLn('The .CPI file to be analyzed eventually could contain copyrighted material!');
         WriteLn('Do not use these informations for commercial issues of any kind!');
        End;
       OutCPFileHead; { FontFileHeader & FontInfoHeader }
       OutCPInfo;     { CPEntryHeader & FontDataHeader  }
       If RequestFile Then
        Begin
         WriteLn;
         WriteLnANSI(HighLightColor, 'File/codepage not yet in our registery! Please report this to us!');
        End;
      End
     Else
      Begin
       WriteANSI(ErrorColor,' ');
       If (BytesRead > 0) Then
        Write('File ', CPFPath,' too small to be a valid .CPI file!')
       Else
        Write('Error when accessing .CPI file: ', CPFPath, '!');
       WriteLnANSINorm;
      End
    Else { file-error }
     Begin
      WriteLnANSI(ErrorColor, Concat(' Error when opening CPI file: ', CPFPath, '!'));
      If (StrCount(OrgCmdLine) = 0) Then
       WriteLn(' Easy calling syntax (complete info with ', SWC, ParHelp1, '): CPI [<.CPI filename>]');
     End;
    {$I-}
    Close(CPF);
    {$I+}
   End
  Else
   Begin
    {$I-}
    Close(OutPut);
    Assign(OutPut,'');
    Rewrite(OutPut);
    {$I+}
    ANSI:=OldANSIStatus;
    WriteLnANSI(ErrorColor, ' Error when opening report file: '+RptPath+'!');
   End;
  {$I-}
  Close(Output);
  {$I+}
  BytesRead:=IOResult; { dummy var }
  dummy:=Version; { for Novell's VERSION.EXE utility }
  dummy:=Copyright;
 End. {Main}
