/*
  
  THIS IS PROVIDED "AS IS" WITHOUT ANY WARRANTIES OF ANY KIND.

  cp853.c.

  Produces a table of IBM Code Page 853 as it is used by DR DOS 6.0 and
  Novell DOS 7 in their EGA.CPI file (undocumented). The codepage is mostly
  derived from codepages 850, 852 and 857, but also contains unique character
  derivatives of C, G, H, J, S, U and more (if this helps someone to find
  out it's origin). All four font sizes are supported in EGA.CPI (including
  the undocumented 6x8 font).

  MS-DOS/PC-DOS 4.00-6.22 also contained an undocumented codepage 853 in
  one of their printer codepage files, but as there is no support in their
  EGA.CPI, I cannot prove, if it is equal to Novell's definition. By the way,
  there is another undocumented codepage in MS-DOS/PC-DOS printer codepage
  files: 851, also supported from 4.00-6.22.

  Does anybody know the corresponding countries or languages???
  Would be quite interestingly for me to including this in the next
  release of my .CPI codepage file recompiler...

   URL: http://www.rhrz.uni-bonn.de/~uzs180/mpdokger.html
   URL: ftp://ftp.uni-stuttgart.de/pub/systems/pc/util/system/cpi???.zip

  Matthias Paul <MPaul@ibh.rwth-aachen.de>

  Last edit:  08.07.96 -mp

*/

char *name[] = {                      /* 0..127 equal to codepage 850, only */
                                      /* 96 has a slightly different shape  */
    "C cedilla",                               /* 128 equal to codepage 850 */
    "u diaeresis",                             /* 129 equal to codepage 850 */
    "e acute",                                 /* 130 equal to codepage 850 */
    "a circumflex",                            /* 131 equal to codepage 850 */
    "a diaeresis",                             /* 132 equal to codepage 850 */
    "a grave",                                 /* 133 equal to codepage 850 */
    "c circumflex",                            /* 134 */
    "c cedilla",                               /* 135 equal to codepage 850 */
    "e circumflex",                            /* 136 equal to codepage 850 */
    "e diaeresis",                             /* 137 equal to codepage 850 */
    "e grave",                                 /* 138 equal to codepage 850 */
    "i diaeresis",                             /* 139 equal to codepage 850 */
    "i circumflex",                            /* 140 equal to codepage 850 */
    "i grave",                                 /* 141 equal to codepage 850 */
    "A diaeresis",                             /* 142 equal to codepage 850 */
    "C circumflex",                            /* 143 */
    "E acute",                                 /* 144 equal to codepage 850 */
    "c dot above",                             /* 145 */
    "C dot above",                             /* 146 */
    "o circumflex",                            /* 147 equal to codepage 850 */
    "o diaeresis",                             /* 148 equal to codepage 850 */
    "o grave",                                 /* 149 equal to codepage 850 */
    "u circumflex",                            /* 150 equal to codepage 850 */
    "u grave",                                 /* 151 equal to codepage 850 */
    "I dot above",                             /* 152 */
    "O diaeresis",                             /* 153 equal to codepage 850 */
    "U diaeresis",                             /* 154 equal to codepage 850 */
    "g circumflex",                            /* 155 */
    "Pound sterling sign",                     /* 156 equal to codepage 850 */
    "G circumflex",                            /* 157 */
    "S cedilla/ogonek???",                     /* 158 equal to codepage 857 */
    "s cedilla/ogonek???",                     /* 159 equal to codepage 857 */
    "a acute",                                 /* 160 equal to codepage 850 */
    "i acute",                                 /* 161 equal to codepage 850 */
    "o acute",                                 /* 162 equal to codepage 850 */
    "u acute",                                 /* 163 equal to codepage 850 */
    "n tilde",                                 /* 164 equal to codepage 850 */
    "N tilde",                                 /* 165 equal to codepage 850 */
    "G breve",                                 /* 166 equal to codepage 857 */
    "g breve",                                 /* 167 equal to codepage 857 */
    "H circumflex???",                         /* 168 */
    "h circumflex???",                         /* 169 */
    "UNDEFINED",                               /* 170 equal to codepage 852 */
    "One half",                                /* 171 equal to codepage 850 */
    "J circumflex",                            /* 172 */
    "s cedilla",                               /* 173 equal to codepage 852 */
    "Left angle quotes",                       /* 174 equal to codepage 850 */
    "Right angle quotes",                      /* 175 equal to codepage 850 */
    "Fill character light",                    /* 176 equal to codepage 850 */
    "Fill character medium",                   /* 177 equal to codepage 850 */
    "Fill character heavy",                    /* 178 equal to codepage 850 */
    "Center box bar vertical",                 /* 179 equal to codepage 850 */
    "Right middle box side",                   /* 180 equal to codepage 850 */
    "A acute",                                 /* 181 equal to codepage 850 */
    "A circumflex",                            /* 182 equal to codepage 850 */
    "A grave",                                 /* 183 equal to codepage 850 */
    "S cedilla",                               /* 184 equal to codepage 852 */
    "Right box side double",                   /* 185 equal to codepage 850 */
    "Center box vertical double",              /* 186 equal to codepage 850 */
    "Upper right box corner double",           /* 187 equal to codepage 850 */
    "Lower right box corner double",           /* 188 equal to codepage 850 */
    "Z dot above",                             /* 189 equal to codepage 852 */
    "z dot above",                             /* 190 equal to codepage 852 */
    "Upper right box corner",                  /* 191 equal to codepage 850 */
    "Lower right box corner",                  /* 192 equal to codepage 850 */
    "Middle box bottom",                       /* 193 equal to codepage 850 */
    "Middle box top",                          /* 194 equal to codepage 850 */
    "Left middle box side",                    /* 195 equal to codepage 850 */
    "Center box bar horizontal",               /* 196 equal to codepage 850 */
    "Box intersection",                        /* 197 equal to codepage 850 */
    "S soft circumflex???",                    /* 198 */
    "s soft circumflex???",                    /* 199 */
    "Lower left box corner double",            /* 200 equal to codepage 850 */
    "Upper left box corner double",            /* 201 equal to codepage 850 */
    "Middle box bottom double",                /* 202 equal to codepage 850 */
    "Middle box top double",                   /* 203 equal to codepage 850 */
    "Left box side double",                    /* 204 equal to codepage 850 */
    "Center box bar horizontal double",        /* 205 equal to codepage 850 */
    "Box intersection double",                 /* 206 equal to codepage 850 */
    "International currency symbol",           /* 207 equal to codepage 850 */
    "UNDEFINED",                               /* 208 */
    "UNDEFINED",                               /* 209 */
    "E circumflex",                            /* 210 equal to codepage 850 */
    "E diaeresis",                             /* 211 equal to codepage 850 */
    "E grave",                                 /* 212 equal to codepage 850 */
    "i dotless",                               /* 213 equal to codepage 850 */
    "I acute",                                 /* 214 equal to codepage 850 */
    "I circumflex",                            /* 215 equal to codepage 850 */
    "I diaeresis",                             /* 216 equal to codepage 850 */
    "Lower right box corner",                  /* 217 equal to codepage 850 */
    "Upper left box corner",                   /* 218 equal to codepage 850 */
    "Solid fill character",                    /* 219 equal to codepage 850 */
    "Solid fill character bottom half",        /* 220 equal to codepage 850 */
    "UNDEFINED",                               /* 221 */
    "Almost similar to I letter",              /* 222 */
    "Solid fill upper half with I lower half", /* 223 */
    "O acute",                                 /* 224 equal to codepage 850 */
    "German sharp s",                          /* 225 equal to codepage 850 */
    "O circumflex",                            /* 226 equal to codepage 850 */
    "O grave",                                 /* 227 equal to codepage 850 */
    "G with dot",                              /* 228 */
    "g with dot",                              /* 229 */
    "Greek mu",                                /* 230 equal to codepage 850 */
    "H with stroke",                           /* 231 */
    "h with stroke (similar Planck's quantum symbol)", /* 232 */
    "U acute",                                 /* 233 equal to codepage 850 */
    "U circumflex",                            /* 234 equal to codepage 850 */
    "U grave",                                 /* 235 equal to codepage 850 */
    "U breve",                                 /* 236 */
    "u breve",                                 /* 237 */
    "UNDEFINED",                               /* 238 */
    "Acute accent",                            /* 239 equal to codepage 850 */
    "Soft hyphen",                             /* 240 equal to codepage 850 */
    "UNDEFINED",                               /* 241 */
    "like a small l in western handwritings",  /* 242 */
    "apo ' followed by n",                     /* 243 */
    "Breve",                                   /* 244 equal to codepage 852 */
    "Paragraph sign",                          /* 245 equal to codepage 850 */
    "Divide sign",                             /* 246 equal to codepage 850 */
    "Cedilla",                                 /* 247 equal to codepage 850 */
    "Degree sign",                             /* 248 equal to codepage 850 */
    "Diaeresis",                               /* 249 equal to codepage 850 */
    "Center dot",                              /* 250 equal to codepage 850 */
    "UNDEFINED",                               /* 251 */
    "Superscript 3",                           /* 252 equal to codepage 850 */
    "Superscript 2",                           /* 253 equal to codepage 850 */
    "Solid square",                            /* 254 equal to codepage 850 */
    "Required Space"                           /* 255 equal to codepage 850 */
};  /* "UNDEFINED" actually means "SPACE" */

main() {
    int i;
    printf("IBM Code Page 853\n");
    printf("char dec col/row oct hex  description\n");
    for (i = 128; i < 256; i++) {
	printf("[%c]  %3d  %02d/%02d  %3o  %2X  %s\n",
	       i, i, i/16, i%16, i, i, name[i-128]);
    }
}
