@ ECHO off > \dev\nul
  ECHO off > \dev\nul
  IF NOT ""=="%batdbg%" ECHO %batdbg%
  IF "%@Eval[2+2]%"=="4" LOADBTM on > \dev\nul
  GOTO start

  :help
  REM ### Help for COMBINE.BAT: ###############################################
  REM  v1.00        Original file by Ralf Brown
  REM  v1.01 - 1.08 Enhanced by Matthias Paul (09/95, 01/96, 02/96, 05/96, 07/96)
  REM  v1.09-53     Enhanced and updated for Caldera OpenDOS by Matthias Paul (97-02-06)
  REM
  REM  Note:
  REM
  REM  With the introduction of Ralf's more flexible and faster .ASM version
  REM  (v1.10+, shipped with INTER51, 09/1996) this older .BAT version is
  REM  now obsolete. But: It's still a nice example how to handle advanced
  REM  features in batchjobs without backward compatibility problems. Also,
  REM  this .BAT version is able to extract & concat the list files directly
  REM  out of the original archives, which can be stored on floppy. This
  REM  sole feature might be needed in extremely low disk space situations...
  REM
  REM
  ECHO Combines the pieces of the interrupt list into the file INTERRUP.LST.
  REM
  REM  - All necessary files should be located in the current directory,
  REM    except with /Z, where PKUNZIP is needed to be in the %PATH% somehow,
  REM    and (optionally) the .ZIP archive residing on another drive. Also,
  REM    INTERRUP.LST will be created in the current directory. Please check,
  REM    that enough space (for file and swapping) is available, since this job
  REM    job cannot detect all error conditions with any command processor.
  REM  - If you're running out of free disk space for a complete copy of the
  REM    whole interrupt list, try running COMBINE.BAT with optional parameter
  REM    /L. This will combine the files into INTERRUP.LST while destroying the
  REM    original files, thus needing only a very small swapping area. The
  REM    space needed generally is of the same amount as the biggest separate
  REM    file to be combined, but depending on the implementation of the COPY
  REM    command and the memory & disk space available, the exact amount may
  REM    vary from zero up to the full interrupt list's size!
  REM  - If you don't need the separated files on your disk (or don't have
  REM    enough space for /L), you can use /Z to extract these files from the
  REM    .ZIP archives and concatenate them into INTERRUP.LST. For optimal
  REM    speed, if multiple archives reside on the same floppy, their directory
  REM    entries should be in ascending order. The mechanism also tries to
  REM    update COMBINE.BAT itself from the archives, but, since INTER51+ now
  REM    contains COMBINE.COM instead of COMBINE.BAT, this new feature cannot
  REM    succeed. So, currently you *must* combine parameter /Z with parameter
  REM    /O, especially on archives older than INTER51?.ZIP!
  REM  - If you're having trouble resulting in corrupted files, but have enough
  REM    swap space, try optional parameter /T, explicitly using a temporary
  REM    swap file. This will double the maximum amount of swap space needed by
  REM    each method.
  ECHO 
  ECHO Syntax: COMBINE [%switch%H, %switch%?] [%switch%L, %switch%C, [drive/dir] %switch%Z [%switch%O]] [%switch%T]
  ECHO 
  ECHO  not %switch%L, %switch%C, %switch%Z = Combine (non destructive).
  ECHO  %switch%L             = Low space combination (destructive).
  ECHO  [drive/dir] %switch%Z = As %switch%L, but extracts files from INTER???.ZIP archives.
  ECHO                   The first parameter optionally locates the archives,
  ECHO                   e.g.: "COMBINE a: %switch%Z" gets the archives from floppy.
  ECHO  %switch%O             = With %switch%Z only: Don't update COMBINE.BAT from archive
  ECHO                   (compatibility with all current releases of INTERxx,
  ECHO                   especially with releases before INTER51 & COMBINE v1.07).
  ECHO  %switch%C             = Continue after error when combining with %switch%L option.
  ECHO 
  ECHO  not %switch%T         = Standard COPY management (generally no problems).
  ECHO  %switch%T             = Explicit usage of a temporary swap file (saver).
  ECHO                   Doubles the swap space needed.
  ECHO 
  REM  - Needs DOS v2.0+. Takes advantage of NWDOS/DRDOS & 4DOS/NDOS, if found.
  REM  - Currently tested with Caldera OpenDOS 7.01, Novell DOS 7 (up to Update 15),
  REM    MS-DOS 6.2x, 4DOS 4.01a, 5.5a/b/c, 5.51, 5.52a, NDOS 7.0a. Reports welcome...
  REM  - Lines like "ECHO  " contain an invisible ASCII-255 character. Don't
  REM    edit the file with bare editors (e.g. NC EDIT) discarding these chars!
  REM  - Variable %Temp% generally may not end with "\". If necessary, use "\."
  REM    instead! A variable %SwitChar% can be used to indicate a changed
  REM    SwitChar.
  REM
  REM "!!!" indicates necessary adaptations with changes in count of INTERRUP.?
  REM       or INTER???.ZIP files, or maximum separate INTERRUP.? file size.
  REM #########################################################################
  GOTO exit
  :start
  BREAK off > \dev\nul
  REM Scanning for tokens:
  IF "_Std_"=="%1" GOTO combine
  IF "_Del_"=="%1" GOTO combine
  IF "_Zip_"=="%1" GOTO combine
  IF "_CB1_"=="%1" GOTO unzip
  IF "_CB2_"=="%1" GOTO unzip1

  ECHO 
  ECHO COMBINE.BAT v1.09-53 (c) 1995-1997 by Ralf Brown & Matthias Paul

  REM Checking system:
  IF NOT "DRDOS"=="%Os%" IF NOT "NWDOS"=="%Os%" IF NOT "OPENDOS"=="%Os%" GOTO s1
  GOTO s2
  :s1
  IF "%@Eval[2+2]%"=="4" IF 0%_DOSVer% LT 2 GOTO olddos > \dev\nul
  :s2
  IF "%@Eval[2+2]%"=="4" IF %_Env% LT 9 GOTO lowenv > \dev\nul
  SET Tmp_=123456789> \dev\nul
  IF NOT "%Tmp_%"=="123456789" GOTO lowenv
  SET Tmp_=> \dev\nul
  IF NOT ""=="%Temp%" GOTO tmp_ok
  SET Temp=%Tmp%> \dev\nul
  IF NOT "%Temp%"=="%Tmp%" SET Temp=> \dev\nul
  :tmp_ok
  IF EXIST %Temp%\combine.$$$ GOTO clear
  BREAK on > \dev\nul
  IF EXIST %Temp%\swc.btm ECHO Warning: "%Temp%\swc.btm" is locked by another task. Waiting for release...
  :wait
  IF EXIST %Temp%\swc.btm GOTO wait
  BREAK off > \dev\nul
  IF NOT "4"=="%@Eval[2+2]%" GOTO no4dos
  ECHOS `SET `> %Temp%\swc.btm
  SETDOS | @ FIND "SWITCH=">> %Temp%\swc.btm
@ CALL %Temp%\swc.btm > \dev\nul
  DEL %Temp%\swc.btm > \dev\nul
  GOTO anydos
  :no4dos
  REM Check for undocumented feature of Caldera OpenDOS 7.01, Novell DOS 7,
  REM and DR DOS 6.0 COMMAND.COM: If the current SwitChar is not "/", the
  REM 1st "\" in CD/CHDIR and PROMPT $p paths is replaced by "/"...
  REM If you have installed the DR DOS 6.0 COMMAND.COM update 1992 and later,
  REM you can remove the REM from the following special case:
  REM IF "DRDOS"=="%Os%" IF "6.0"=="%Ver%" GOTO drdos6
  IF NOT "NWDOS"=="%Os%" IF NOT "OPENDOS"=="%Os%" GOTO anydos
  :drdos6
  CD | CALL FIND "/" > %Temp%\swc.btm
  IF NOT EXIST %Temp%\swc.btm GOTO anydos
  BREAK on > \dev\nul
  IF EXIST %Temp%\combine.$$$ ECHO Warning: "%Temp%\combine.$$$" is locked by another task. Waiting for release...
  :wait2
  IF EXIST %Temp%\combine.$$$ GOTO wait2
  BREAK off > \dev\nul
  REM Eventually this will not run under the original DR DOS 6.0 COMMAND.COM,
  REM but should run with the 1992 updates ("don't copy zero files").
  IF EXIST %Temp%\swc.btm COPY %Temp%\swc.btm %Temp%\combine.$$$ > \dev\nul
  IF EXIST %Temp%\swc.btm DEL %Temp%\swc.btm > \dev\nul
  IF EXIST %Temp%\combine.$$$ IF ""=="%switchar%" SET switch=-> \dev\nul
  IF NOT EXIST %Temp%\combine.$$$ SET switch=> \dev\nul
  IF EXIST %Temp%\combine.$$$ DEL %Temp%\combine.$$$ > \dev\nul
  :anydos
  IF ""=="%switch%" SET switch=%switchar%> \dev\nul
  IF "4"=="%@Eval[2+2]%" IF %_Env% LT 9 GOTO lowenv
  SET Tmp_=123456789> \dev\nul
  IF NOT "%Tmp_%"=="123456789" GOTO lowenv
  SET Tmp_=> \dev\nul
  IF ""=="%switch%" SET switch=/> \dev\nul

  REM Check for help parameter:
  REM (4DOS 4.0x misinterprets /? parameter as filespec, so check first)
  IF NOT "?"=="%1" IF NOT "%switch%?"=="%1" IF NOT "/?"=="%1" IF NOT "-?"=="%1" GOTO start2
  GOTO help
  :start2
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="h" GOTO help
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="H" GOTO help
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="%switch%h" GOTO help
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="%switch%H" GOTO help

  REM Escape token for future enhancements (since v1.07+)...
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="_Nul_" GOTO exit

  REM Scanning for parameters and setting up variables:
  SET Met_=> \dev\nul
  SET Zip_=> \dev\nul
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="t" GOTO temp
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="T" GOTO temp
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="%switch%t" GOTO temp
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="%switch%T" GOTO temp
  GOTO nottemp
  :temp
  SET Met_=tmp> \dev\nul
  :nottemp

  IF ""=="%Met_%" SET Met_=mem> \dev\nul
  IF NOT "tmp"=="%Met_%" IF NOT "mem"=="%Met_%" GOTO lowenv
  SET Dir_=> \dev\nul
  IF NOT "tmp"=="%Met_%" IF NOT "%@Eval[2+2]%"=="4" GOTO no_tmp
  IF NOT "%@Eval[2+2]%"=="4" GOTO tmp
  IF 0%_4VER% GE 5 GOTO tmp_4d50
  REM IF 0%_NVER% GE 8? GOTO tmp_4d50
  IF "%@SubStr[%Temp%,%@Len[%Temp%]%,1]%"=="\" IF %_Env% LT 7 GOTO lowenv
  IF NOT "%@SubStr[%Temp%,%@Len[%Temp%]%,1]%"=="\" GOTO no_tmp
  GOTO tmp
  :tmp_4d50
  IF "%@InStr[%@Len[%Temp%]%,1,%Temp%]%"=="\" IF %_Env% LT 7 GOTO lowenv
  IF NOT "%@InStr[%@Len[%Temp%]%,1,%Temp%]%"=="\" GOTO no_tmp
  :tmp
  SET Dir_=.> \dev\nul
  IF NOT "."=="%Dir_%" GOTO lowenv > \dev\nul
  :no_tmp

  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="c" GOTO skip
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="C" GOTO skip
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="%switch%c" GOTO skip
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="%switch%C" GOTO skip

  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="z" GOTO zipped
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="Z" GOTO zipped
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="%switch%z" GOTO zipped
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="%switch%Z" GOTO zipped

  REM Checking interrupt list pieces:
  REM !!! [Changes necessary, if count of interrupt list files changes:]
  FOR %%a IN (a b c d e f g h i j k l m n o p) DO IF NOT EXIST interrup.%%a GOTO missing
  
  REM Scanning for parameters, again:
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="l" GOTO lowspace
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="L" GOTO lowspace
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="%switch%l" GOTO lowspace
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="%switch%L" GOTO lowspace

  ECHO Combining the pieces of the interrupt list...
  ECHO 
  IF NOT "%@Eval[2+2]%"=="4" GOTO ok_mem
  IF 0%_4VER% LT 4 IF 0%_NVER% LT 7 GOTO ok_mem
  REM Continuing with less space indicated may still work on compressed drives.
  IF %@FileSize[interrup.?,b]% LE %@DiskFree[%_Disk%:,b]% GOTO ok_%Met_% > \dev\nul
  ECHO Warning: Obviously less space on drive for INTERRUP.LST! [Ctrl-C aborts.]
  GOTO pause

  :ok_tmp
  IF NOT "%@Eval[2+2]%"=="4" GOTO ok_mem
  IF 0%_4VER% LT 4 IF 0%_NVER% LT 7 GOTO ok_mem
  IF 0%_DOSVer% LT 3 GOTO ok_mem
  ECHO _> %Temp%%Dir_%\interrup.tmp
  IF 0%_4VER% GE 5 GOTO okt_4d50
  REM IF 0%_NVER% GE 8? GOTO okt_4d50
  IF %@FileSize[interrup.?,b]% GT %@DiskFree[%@SubStr[%@TrueName[%Temp%%Dir_%\interrup.tmp]%,1,2]%,b]% GOTO notok_tmp > \dev\nul
  IF NOT "%@SubStr[%@TrueName[%Temp%%Dir_%\interrup.tmp]%,1,2]%"=="%_Disk%:" GOTO ok_mem > \dev\nul
  GOTO okt_4dos
  :okt_4d50
  IF %@FileSize[interrup.?,b]% GT %@DiskFree[%@InStr[1,2,%@TrueName[%Temp%%Dir_%\interrup.tmp]%]%,b]% GOTO notok_tmp > \dev\nul
  IF NOT "%@InStr[1,2,%@TrueName[%Temp%%Dir_%\interrup.tmp]%]%"=="%_Disk%:" GOTO ok_mem > \dev\nul
  :okt_4dos
  IF %@Eval[2*%@FileSize[interrup.?,b]%]% LE %@DiskFree[%_Disk%:,b]% GOTO ok_mem > \dev\nul
  :notok_tmp
  IF EXIST %Temp%%Dir_%\interrup.tmp DEL %Temp%%Dir_%\interrup.tmp > \dev\nul
  ECHO Warning: Possibly less swapping space! [Ctrl-C aborts.]
  :pause
  PAUSE

  :ok_mem
  IF EXIST %Temp%%Dir_%\interrup.tmp DEL %Temp%%Dir_%\interrup.tmp > \dev\nul

  REM Needs a minimum free disk space of the same size as the separated files.
  IF EXIST interrup.lst DEL interrup.lst > \dev\nul
  COPY interrup.a interrup.lst
  IF NOT EXIST interrup.lst GOTO fault
  REM !!! [Changes necessary, if count of interrupt list files changes:]
  FOR %%a IN (b c d e f g h i j k l m n o p) DO %ComSpec% %switch%c %0 _Std_ interrup.%%a %Met_%
  IF EXIST %Temp%%Dir_%\combine.$$$ GOTO break
  GOTO end

  :skip
  ECHO Resuming destructive interrupt list concatenation....
  ECHO 
  IF EXIST interrup.lst IF NOT EXIST interrup.a GOTO continue
  ECHO INTERRUP.LST file does not exist or INTERRUP.A does exist. Cannot continue.
  ECHO [If you already have tried option %switch%L, concatenate the files manually.]
  GOTO exit

  :zipped
  ECHO Combining the pieces of the interrupt list from INTER???.ZIP archives...
  ECHO 
  IF NOT EXIST interrup.? GOTO zip_strt
  ECHO Some INTERRUP.? files are already existing. Please delete them manually,
  ECHO if they shall not be used! [Ctrl-C aborts.]
  PAUSE
  :zip_strt
  SET Zip_=.\> \dev\nul
  IF EXIST %1\nul SET Zip_=%1.\> \dev\nul
  REM !!! [Changes necessary, if count of archive files changes:]
  REM      (only those archives, that do contain INTERRUP.? files)
  IF ".\"=="%Zip_%" FOR %%x IN (a b c d e) DO IF NOT EXIST %Zip_%inter??%%x.zip GOTO missing
  IF NOT "%@Eval[2+2]%"=="4" GOTO zip_ok
  IF 0%_4VER% LT 4 IF 0%_NVER% LT 7 GOTO zip_ok
  REM !!! [Changes necessary, if interrupt list count or size grows:]
  IF %@DiskFree[%_Disk%:,K]% GE %@Eval[16*360+360]% GOTO zip_ok > \dev\nul
  ECHO Warning: Obviously less space on drives for INTERRUP.LST! [Ctrl-C aborts.]
  PAUSE
  :zip_ok
  IF ".\"=="%Zip_%" GOTO zipped1
  ECHO You need to have the complete set of INTER???.ZIP archives at hands,
  ECHO located either in the same directory and/or floppy drive: %Zip_%
  ECHO [You will be prompted to insert the correct disks.]
  PAUSE

  :zipped1
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="o" GOTO unzip2
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="O" GOTO unzip2
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="%switch%o" GOTO unzip2
  FOR %%x IN (%1 %2 %3 %4 %5 %6 %7 %8 %9) DO IF "%%x"=="%switch%O" GOTO unzip2
  REM Perform self update... (%0 cannot be used here!)
  IF NOT EXIST combine.bat GOTO zipped2
  BREAK on > \dev\nul
  IF EXIST %Temp%%Dir_%\combine$.bat ECHO Warning: "%Temp%%Dir_%\combine$.bat" is locked. Waiting for release...
  :wait3
  IF EXIST %Temp%%Dir_%\combine$.bat GOTO wait3
  BREAK off > \dev\nul
  COPY combine.bat %Temp%%Dir_%\combine$.bat > \dev\nul
  :zipped2
  IF NOT EXIST %Temp%%Dir_%\combine$.bat ECHO Warning: Cannot update COMBINE.BAT, but continuing anyway...
  IF NOT EXIST %Temp%%Dir_%\combine$.bat GOTO unzip2
  %Temp%%Dir_%\combine$.bat _CB1_ combine.bat
  :unzip
  REM Coming from resync (Now, *this* batchjob is called COMBINE$.BAT)...
  IF EXIST %2 DEL %2 > \dev\nul
  %ComSpec% %switch%c %0 _Zip_ combine.bat %Met_%
  IF EXIST %Temp%%Dir_%\combine.$$$ ECHO Warning: COMBINE.BAT not updated!
  IF EXIST %Temp%%Dir_%\combine.$$$ DEL %Temp%%Dir_%\combine.$$$ > \dev\nul
  IF NOT EXIST combine.bat COPY %0 combine.bat > \dev\nul
  IF NOT EXIST combine.bat ECHO Error: Cannot recreate COMBINE.BAT... (Old COMBINE.BAT is called COMBINE$.BAT)
  IF NOT EXIST combine.bat GOTO unzip2
  REM Launch back to (updated) COMBINE.BAT...
  combine.bat _CB2_ %Temp%%Dir_%\combine$.bat
  :unzip1
  REM Back in (updated) COMBINE.BAT...
  IF EXIST %2 DEL %2 > \dev\nul

  :unzip2
  %ComSpec% %switch%c %0 _Del_ interrup.a %Met_%
  IF EXIST %Temp%%Dir_%\combine.$$$ GOTO breakdel
  GOTO continue

  :lowspace
  ECHO Combining the pieces of the interrupt list (destructive)...
  ECHO 
  IF EXIST interrup.lst DEL interrup.lst > \dev\nul

  :continue
  IF NOT "%@Eval[2+2]%"=="4" GOTO lsok
  ECHO _> %Temp%%Dir_%\interrup.tmp
  GOTO lsok_%Met_%
  :lsok_tmp
  IF NOT "%@Eval[2+2]%"=="4" GOTO lsok
  IF 0%_4VER% LT 4 IF 0%_NVER% LT 7 GOTO lsok
  IF 0%_DOSVer% LT 3 GOTO lsok
  IF 0%_4VER% LT 5 IF %@DiskFree[%@SubStr[%@TrueName[%Temp%%Dir_%\interrup.tmp]%,1,2]%,b]% GT %@FileSize[interrup.?;interrup.ls?[t],b]% GOTO lsok > \dev\nul
  IF 0%_4VER% LT 5 GOTO lsok_4d
  IF %@DiskFree[%@InStr[1,2,%@TrueName[%Temp%%Dir_%\interrup.tmp]%]%,b]% GT %@FileSize[interrup.?;interrup.ls?[t],b]% GOTO lsok > \dev\nul
  :lsok_4d
  ECHO Warning: Possibly less swapping space! [Ctrl-C aborts.]
  GOTO lspause
  :lsok_mem
  IF 0%_4VER% LT 4 IF 0%_NVER% LT 7 GOTO lsok
  REM !!! [Changes necessary in next 5 lines, if maximum separate file length exceeds 360KB:]
  IF %@DiskFree[%_Disk%:,K]% GE 360 GOTO lsok > \dev\nul
  IF 0%_DOSVer% LT 3 GOTO lsok
  IF 0%_4VER% LT 5 IF %@DiskFree[%@SubStr[%@TrueName[%Temp%%Dir_%\interrup.tmp]%,1,2]%,K]% GE 360 GOTO lsok > \dev\nul
  IF 0%_4VER% LT 5 GOTO lsnok
  IF %@DiskFree[%@InStr[1,2,%@TrueName[%Temp%%Dir_%\interrup.tmp]%]%,K]% GE 360 GOTO lsok > \dev\nul
  :lsnok
  ECHO Warning: Possibly less swapping space! [Ctrl-C aborts.]
  :lspause
  IF EXIST %Temp%%Dir_%\interrup.tmp DEL %Temp%%Dir_%\interrup.tmp > \dev\nul
  PAUSE
  :lsok
  IF EXIST %Temp%%Dir_%\interrup.tmp DEL %Temp%%Dir_%\interrup.tmp > \dev\nul

  IF EXIST interrup.a REN interrup.a interrup.lst > \dev\nul
  REM !!! [Changes necessary, if count of interrupt list files changes:]
  FOR %%a IN (b c d e f g h i j k l m n o p) DO %ComSpec% %switch%c %0 _Del_ interrup.%%a %Met_%
  IF EXIST %Temp%%Dir_%\combine.$$$ GOTO breakdel
  IF ""=="%Zip_%" ECHO Original separated files are now deleted.
  GOTO end


  REM ### Combine management (recursive level 1) ##############################

  :combine
  IF EXIST %Temp%%Dir_%\combine.$$$ GOTO exit
  IF ""=="%2" GOTO error
  IF EXIST %2 GOTO combstart
  IF ""=="%Zip_%" GOTO exit
  ECHO Looking for "%2" file in %Zip_%INTER???.ZIP now:
  IF ".\"=="%Zip_%" GOTO zip_skip
  PAUSE Archive file present on drive? Press any key to continue...
  :zip_skip
  FOR %%a IN (%Zip_%inter???.zip) DO IF NOT EXIST %2 %ComSpec% %switch%c PKUNZIP %switch%e %%a %2
  IF ERRORLEVEL 1 GOTO error
  IF EXIST %2 GOTO combstart
  ECHO Cannot find "%2" in %Zip_%INTER???.ZIP archives!
  GOTO error

  :combstart
  IF "_Zip_"=="%1" GOTO exit
  IF NOT "tmp"=="%3" IF NOT "mem"=="%3" GOTO overflow
  IF NOT ""=="%Zip_%" IF NOT EXIST interrup.lst IF EXIST interrup.a GOTO rename
  GOTO copy_%3
  :rename
  REN interrup.a interrup.lst > \dev\nul
  GOTO exit


  REM ### COPY subroutines ####################################################

  :copy_mem
  REM General COPY command:
  REM Some implementations have problems combining files to itself.
  REM In such cases use parameter /T to select alternative copy routine.
  COPY %switch%b %switch%v interrup.lst+%2 interrup.lst
  IF ERRORLEVEL 1 GOTO error
  IF NOT EXIST interrup.lst GOTO error
  GOTO copy_end

  :copy_tmp
  REM COPY command with explicit usage of a temporary file:
  REM Some COPY-implementations have problems combining files to itself.
  REM Explicit usage of a temporary file generally needs twice as much swap
  REM space as needed by the standard routine.
  IF EXIST %Temp%%Dir_%\interrup.tmp DEL %Temp%%Dir_%\interrup.tmp > \dev\nul
  COPY %switch%b %switch%v interrup.lst+%2 %Temp%%Dir_%\interrup.tmp
  IF ERRORLEVEL 1 GOTO error
  IF NOT EXIST %Temp%%Dir_%\interrup.tmp GOTO error
  IF EXIST %Temp%%Dir_%\interrup.tmp IF EXIST interrup.lst DEL interrup.lst > \dev\nul
  IF EXIST %Temp%%Dir_%\interrup.tmp IF NOT EXIST interrup.lst COPY %switch%b %Temp%%Dir_%\interrup.tmp interrup.lst
  IF EXIST %Temp%%Dir_%\interrup.tmp IF EXIST interrup.lst DEL %Temp%%Dir_%\interrup.tmp > \dev\nul
  IF NOT EXIST interrup.lst GOTO error
  :copy_end
  IF "_Del_"=="%1" DEL %2 > \dev\nul
  GOTO exit


  REM ### Error & Exit management #############################################

  :overflow
  ECHO Error: Environment full or path to file too long!
  IF NOT EXIST interrup.a IF EXIST interrup.b IF EXIST interrup.lst REN interrup.lst interrup.a > \dev\nul
  GOTO stop

  :error
  ECHO Error occured during file combination! (Less space available?) Please wait...
  :stop
  BREAK on > \dev\nul
  IF EXIST %Temp%%Dir_%\combine.$$$ ECHO Warning: "%Temp%%Dir_%\combine.$$$" is locked. Waiting for release...
  :wait4
  IF EXIST %Temp%%Dir_%\combine.$$$ GOTO wait4
  BREAK off > \dev\nul
  ECHO Semaphore: Breaking COMBINE.BAT... [Delete this if task hangs!]> %Temp%%Dir_%\combine.$$$
  GOTO exit
  
  :breakdel
  IF NOT ""=="%Zip_%" GOTO break
  ECHO [If INTERRUP.LST is valid so far, try parameter %switch%C to continue after
  ECHO solving error condition.]
  :break
  ECHO Processing aborted.
  GOTO clear

  :missing
  ECHO Error: Some sections of the interrupt list are missing! (Help with %switch%H)
  GOTO reset

  :olddos
  ECHO Error: This old DOS version cannot run this batchjob without modifications!
  ECHO Consider to update your system or concatenate files manually.
  GOTO exit

  :lowenv
  SET Tmp_=> \dev\nul
  ECHO Error: Not enough environment space available! (Running in a shell?)
  ECHO Check CONFIG.SYS SHELL=.. /E:bytes and/or 4DOS.INI ENVIRONMENT=, ENVFREE=.
  GOTO reset

  :fault
  ECHO Error occured trying to write first part of the interrupt list.
  GOTO reset

  :end
  ECHO The interrupt list has now been combined into INTERRUP.LST.

  :clear
  IF EXIST %Temp%%Dir_%\combine.$$$ DEL %Temp%%Dir_%\combine.$$$ > \dev\nul

  :reset
  SET Met_=> \dev\nul
  SET Dir_=> \dev\nul
  SET Zip_=> \dev\nul
  SET Switch=> \dev\nul

  :exit
  REM These dummies in the last two lines avoid a parser-bug occuring
  REM in an older MS-DOS COMMAND.COM release.
