{ CHRFRQ.PAS : Count Character frequencies in textfile

  Title   : CHRFRQ
  Language: Turbo Pascal v5.0 or up
  Version : 2.3
  Date    : Feb 13, 2000
  Author  : J R Ferguson
  Usage   : Refer procedure Help
  Download: http://hello.to/ferguson
  E-mail  : j.r.ferguson@iname.com

This program and its source may be used and copied freely without charge,
but only for non-commercial purposes. The author is not responsible for 
any damage or loss of data that may be caused by using it.

To compile this source file, you wil need some units from the JRFPAS
Pascal routine library by the same author, which can be downloaded from the
Internet address mentioned above.
}

{$V-}
{$R+}

program CHRFRQ;
uses ArgLib, StpLib, ChrLib, DefLib;

const
  { Option defaults: }
  DFLPRTY   = true;
  DFLSORT   = false;
  DFLTAB    = false;
  DFLZERO   = false;

  MAXFNAME  = 79;
  INPBUFSIZ = 4096;

  { Error codes and messages: }
  ERROK     = 0;
  ERRARG    = 1;
  ERRINP    = 2;
  ERROUT    = 3;

  ERRMSG    : array[ERRINP..ERROUT] of StpTyp =
 ('File not found : ',
  'Can''t open output : '
 );

type
  FrqElm    = record num: byte; cnt: longint end;

var
  InpFname,
  OutFname  : StpTyp;
  InpFvar,
  OutFvar   : Text;
  InpOpen,
  OutOpen   : boolean;
  InpBuf    : array[1..INPBUFSIZ] of char;

  ErrCod    : integer;

  OptPrty   : boolean;
  OptSort   : boolean;
  OptTab    : boolean;
  OptZero   : boolean;

  Frq       : Array[byte] of FrqElm;


{--- Command line parsing routines ---}

procedure Help;
begin
  writeln('CHRFRQ v2.3');
  writeln('usage  : CHRFRQ [<infile] [>outfile] [/[option[...]] [...] ]');
  writeln('options: P  do not ignore parity bit');
  writeln('         S  sort by highest frequency');
  writeln('         T  output in tabular format');
  writeln('         Z  include zero frequency entries');
  writeln('remarks: Option T implies options P and Z');
end;


procedure ReadOpt(arg: StpTyp);
begin
  StpDel(arg,1,1);
  while (ErrCod=ERROK) and not StpEmpty(arg) do case ToUpper(StpcGet(arg)) of
    'P': OptPrty := not DFLPRTY;
    'S': OptSort := not DFLSORT;
    'T': OptTab  := not DFLTAB ;
    'Z': OptZero := not DFLZERO;
    else ErrCod:= ERRARG;
  end;
end;


procedure ReadArgs;
var i   : ArgInd;
    arg : StpTyp;
begin
  StpCreate(InpFname); StpCreate(OutFname); { Standard input/output }
  GetArgs;
  i:= 0;
  while (i < ArgC) and (ErrCod = ERROK) do begin
    Inc(i); StpCpy(arg,ArgV[i]);
    case StpcRet(arg,1) of
      '/' : ReadOpt(arg);
      '<' : StpSub(InpFname,arg,2,MAXFNAME);
      '>' : StpSub(OutFname,arg,2,MAXFNAME);
      else  ErrCod:= ERRARG;
    end;
  end;
  if OptTab then OptPrty:= true;
end;


{--- I/O routines ---}


procedure OpenInp;
begin
  StpNCpy(InpFname,InpFname,MAXFNAME);
  {$I-} Assign(InpFvar,InpFname); SetTextbuf(InpFvar,InpBuf); reset(InpFvar);
  {$I+} if IOresult <> 0 then ErrCod:= ERRINP else InpOpen:= true;
end;


procedure OpenOut;
begin
  StpNCpy(OutFname,OutFname,MAXFNAME);
  {$I-} Assign(OutFvar,OutFname); rewrite(OutFvar) {$I+};
  if IOresult <> 0 then ErrCod:= ERROUT else OutOpen:= true;
end;


{--- Main line ---}


procedure CountChars;
var ch: record case boolean of
          false: (n: byte;);
          true : (c: char);
        end;
begin with ch do begin
  for n:= 0 to 255 do with Frq[n] do begin num:= n; cnt:= 0; end;
  while not eof(InpFvar) do begin
    read(InpFvar,c);
    if OptPrty then n:= n and $7F;
    Inc(Frq[n].cnt);
  end;
end; end;


procedure SortFrq;
var i,j,g: byte; t: FrqElm;
begin
  for i:= 0 to 254 do begin
    g:= i; for j:= i+1 to 255 do if Frq[g].cnt < Frq[j].cnt then g:= j;
    if g<>i then begin t:= Frq[i]; Frq[i]:= Frq[g]; Frq[g]:= t; end;
  end;
end;


procedure OutTab;
var i: 0..127;
    r: 0..15;
    k: 0..7;
begin
  for r:= 0 to 15 do begin
    for k:= 0 to 7 do begin
      i:= 16*k + r;
      with Frq[i] do begin
        if IsPrint(char(num)) then write(OutFvar,'"',char(num),'"')
                              else write(OutFvar,num:3);
        write(OutFvar,':');
        if cnt=0 then write(OutFvar,'   -')
                 else write(OutFvar,cnt:4);
        if k<7 then write(OutFvar,'  ');
      end;
    end;
    writeln(OutFvar);
  end;
end;


procedure OutKol;
var i,max: byte;
begin
  if OptPrty then max:=127 else max:= 255;
  for i:= 0 to max do with Frq[i] do if (cnt > 0) or OptZero then begin
    write(OutFvar,num:3,' ');
    if IsPrint(char(num and $7F))
    then write(OutFvar,char(num and $7F))
    else write(OutFvar,' ');
    writeln(OutFvar,cnt:6);
  end;
end;


procedure MainInit;
begin
  OptPrty:= DFLPRTY; OptSort:= DFLSORT; OptTab:= DFLTAB; OptZero:= DFLZERO;
  ErrCod:= ERROK; InpOpen:= false; OutOpen:= false;
  ReadArgs;
  if ErrCod = ERROK then begin
    OpenInp;
    if ErrCod = ERROK then OpenOut;
  end;
end;


procedure MainTerm;
begin
  if InpOpen then Close(InpFvar);
  if OutOpen then Close(OutFvar);
  if ErrCod <> ERROK then begin
    if ErrCod=ERRARG then Help
    else begin
      write(ERRMSG[ErrCod]);
      if      ErrCod = ERRINP then write(InpFname)
      else if ErrCod = ERROUT then write(OutFname);
      writeln;
    end;
  end;
end;


begin { Main program }
  MainInit;
  if ErrCod = ERROK then begin
    CountChars;
    if OptSort then SortFrq;
    if OptTab then OutTab else OutKol;
  end;
  MainTerm;
end.
