#include <stdio.h>

#include "dbf.h"

struct	DBF	*d1, *d2;

int	cmp_struct=0;
int	cmp_content=0;
int	use_order=0;
int	use_filter=0;

void	help(void);
void	error(char *s);
void	StructInfo(void);
void	CmpStruct(void);
void	CmpContent(void);
int	field_exist(struct DBF* t1, int i, struct DBF* t2, int *j);
char*	FieldInfo(struct DBF *d, int i);


char	*ts[]= {
	"dBase III",
	"FoxPro",
	"dBase IV",
	"Visual FoxPro",
	"Unknown"
	};

char	*cmp[]= {
	"--",
	"<>",
	"~=",
	"= ",
	"=="
	};

int
main(int argc, char *argv[])
{
 int	i;

 if (argc<3) help();

 d1=OpenBase(argv[1]);
 d2=OpenBase(argv[2]);
 if (!d1 || !d2) error("Open error...");

 for(i=3;i<argc;i++)
 {
  if (!stricmp (argv[i], "/s"   )) cmp_struct =1;
  if (!stricmp (argv[i], "/c"   )) cmp_content=1;
  if (!strnicmp(argv[i], "/o:",3)) { cmp_content=1; use_order=i;  }
  if (!strnicmp(argv[i], "/f:",3)) { cmp_content=1; use_filter=i; }
 } 

 StructInfo();
 if (cmp_struct)  CmpStruct();

 if (use_filter)
 {
  char	*t;
  int	j;
  t=&argv[use_filter][3];
  j=lstrlen(t);
  for (i=0;i<j;i++)
  {
   if (t[i]=='}') t[i]='>';
   if (t[i]=='{') t[i]='<';
   if (t[i]==';') t[i]='|';
  }

  set_filter(d1, &argv[use_filter][3], NULL);
  set_filter(d2, &argv[use_filter][3], NULL);
 }

 if (use_order)
 {
  SortBase(d1, &argv[use_order][3], NULL);
  SortBase(d2, &argv[use_order][3], NULL);
 }

 if (cmp_content) CmpContent();


 CloseBase(d1);
 CloseBase(d2);

 return 0;
}

void
StructInfo(void)
{
 char	*f1,*f2;

 f1=strrchr(d1->filename, '\\');
 f2=strrchr(d2->filename, '\\');
 if (f1) ++f1; else f1=d1->filename;
 if (f2) ++f2; else f2=d2->filename;

 printf("File: %-30s | File: %-30s\n"
	"Type: %-30s | Type: %-30s\n"
	"Last updated: %02d.%02d.%04d             | Last updated: %02d.%02d.%04d\n"
	"File size: %13ld             | File size: %13ld\n"
	"Header size: %11d             | Header size: %11d\n"
	"Record count: %10d             | Record count: %10d\n"
	"Field count: %11d             | Field count: %11d\n"
	"Record length: %9d             | Record length: %9d\n"
	"\n"
	,
	f1, f2,

	ts[GetMemoType(d1)], ts[GetMemoType(d2)],
	
	d1->hdr.last_month, d1->hdr.last_day, d1->hdr.last_year+1900,
	d2->hdr.last_month, d2->hdr.last_day, d2->hdr.last_year+1900,

	SetFilePointer(d1->h, 0, NULL, FILE_END),SetFilePointer(d2->h, 0, NULL, FILE_END),
	d1->hdr.offset_first, d2->hdr.offset_first,
	reccount(d1), reccount(d2),
	fieldcount(d1), fieldcount(d2),
	d1->hdr.rec_len, d2->hdr.rec_len
	);
}

/*
returns:
0 - not exists
1 - exists, same names, differs types
2 - exists, same names and types, but differs length
3 - exists, same names and types, length, but differs offsets
4 - exists, exact concurrence
*/
int
field_exist(struct DBF* t1, int i, struct DBF* t2, int *j)
{
 int	k;
 int	ret=0;
 
 for(k=0;k<fieldcount(t2);k++)
  if (!stricmp(t1->fld[i].name, t2->fld[k].name))
   {
     *j=k;
     ++ret;
     if (t1->fld[i].type == t2->fld[k].type)
      {
        ++ret;
        if (t1->fld[i].all_len == t2->fld[k].all_len)
         {
	  ++ret;
          if (t1->fld[i].offset == t2->fld[k].offset) ++ret;
         }
      }
     break; 
   }
      
 return ret;
}

char*
FieldInfo(struct DBF *d, int i)
{
 static char	ret[48];
 char c;

 c=d->fld[i].type;

 if ( (( c=='N' || c== 'F') && d->fld[i].high_len!=0) ||
      (  c=='D' && d->fld[i].low_len==8) )
    sprintf(ret,
 	"%-11s %-11s %5d %2d",
 	d->fld[i].name,
 	GetTypeName(d, i),
 	d->fld[i].high_len,
 	d->fld[i].low_len
 	);
 else
 {
    sprintf(ret,
 	"%-11s %-11s %5d   ",
 	d->fld[i].name,
 	GetTypeName(d, i),
 	d->fld[i].high_len
 	);
 }
 return ret;
}


void
CmpStruct(void)
{
 int	i, j;
 int	ret;
 int	bad=0;

 for(i=0;i<fieldcount(d1);i++)
 {
  switch (ret=field_exist(d1, i, d2, &j))
  {
	case 4:
	case 3:
	case 2:
	case 1:
		printf("%-32s", FieldInfo(d1,i));
		printf("  |%2s| ", cmp[ret]);
		printf("%-32s", FieldInfo(d2,j));
		break;
	default:
		printf("%-30s", FieldInfo(d1,i));
		printf("  |%2s| ", cmp[0]);
		printf("%-30s", "-");
		bad=1;
  }
  printf("\n");
 }
 
 if (fieldcount(d1)<fieldcount(d2) || bad)
 {
  for(i=0;i<fieldcount(d2);i++)
  {
   if (!field_exist(d2, i, d1, &j))
     {
	printf("%-32s", "-");
	printf("  |%2s| ", cmp[0]);
	printf("%-32s", FieldInfo(d2,i));
	printf("\n");
     }
  }
 }

}

void
CmpContent(void)
{
 int	i, j, k;
 int	memo_message=0;
 double	x,y;
 char	*f1,*f2;

 f1=strrchr(d1->filename, '\\');
 f2=strrchr(d2->filename, '\\');
 if (f1) ++f1; else f1=d1->filename;
 if (f2) ++f2; else f2=d2->filename;

 for(i=0;i<reccount(d1);i++)
 {
  if (i>=reccount(d2))
  {
	printf("EOF found: %s\n", d2->filename);
	break;
  } 

  ReadRecord(d1, i);
  ReadRecord(d2, i);
 
  for(j=0;j<fieldcount(d1);j++)
   if (field_exist(d1, j, d2, &k))
   {
	if (if_memo_type(d1, j) && if_memo_type(d2, k))
	{
		d1->memo_block=GetMemo(d1, j);
		d2->memo_block=GetMemo(d2, j);
		if (!d1->memo_block && !d2->memo_block) continue;
		if (!d1->memo_block || !d2->memo_block)
		{
		   if (d1->memo_block) d1->memo_block[__min(20, strlen(d1->memo_block))]='\0';
		   if (d2->memo_block) d2->memo_block[__min(20, strlen(d2->memo_block))]='\0';
		   printf("%-12s: %s - '%s' <> %-12s: %s - '%s'\n\n",
		   	f1, d1->fld[j].name, (d1->memo_block)?d1->memo_block:"<empty>",
		   	f2, d2->fld[k].name, (d2->memo_block)?d2->memo_block:"<empty>"
		   	);
		}
		else
		{
		   if (strcmp(d1->memo_block, d2->memo_block))
		      {
			d1->memo_block[__min(20, strlen(d1->memo_block))]='\0';
			d2->memo_block[__min(20, strlen(d2->memo_block))]='\0';
		   printf("  %-12s: %s - '%s'\n<> %-12s: %s - '%s'\n\n",
		   	f1, d1->fld[j].name, d1->memo_block,
		   	f2, d2->fld[k].name, d2->memo_block
		   	);
		      }
		}
		FreeMemo(d1);
		FreeMemo(d2);
	}
	else
	  if (if_memo_type(d1, j) || if_memo_type(d2, k))
	  {
		if (!memo_message)
		   printf("Can't compare %s: %s (%s) with %s: %s (%s)\n\n",
		   	f1, d1->fld[j].name, GetTypeName(d1, j),
		   	f2, d2->fld[k].name, GetTypeName(d2, k)
		   	);
		memo_message=1;
	  }
	  else
	  {

		if (if_digit_type(d1, j) && if_digit_type(d2, k))
		{
			if ((x=GetValue(d1, j)) != (y=GetValue(d2, k)))
			   printf("  %-12s %5d: %-10s (%c) %f\n<>%-12s %5d: %-10s (%c) %f\n\n",
			   	f1, GetOrder(d1, i), d1->fld[j].name, d1->fld[j].type, x,
			   	f2, GetOrder(d2, i), d2->fld[k].name, d2->fld[k].type, y);
		}
		else
		{
			GetStr(d1,j); GetStr(d2, k);
			DStrTrim(d1,1); DStrTrim(d2,1);
			if (strcmp(d1->str, d2->str))
			{
			   d1->str[__min(20, strlen(d1->str))]='\0';
			   d2->str[__min(20, strlen(d2->str))]='\0';
			   printf("  %-12s %5d: %-10s (%c) '%s'\n<>%-12s %5d: %-10s (%c) '%s'\n\n",
			   	f1, GetOrder(d1, i), d1->fld[j].name, d1->fld[j].type, d1->str,
			   	f2, GetOrder(d2, i), d2->fld[k].name, d2->fld[k].type, d2->str);
			}
		}
	  }
   }
 }

 if (i<reccount(d2)) printf("EOF found: %s\n", d1->filename);
}


void
help(void)
{
 puts("DBF File Compare. Version 1.00 Copyright (c) Sergey Chehuta, 2001\n"
      "Use:\n"
      "\tDFC <file1.dbf> <file2.dbf> [switches]\n"
      "Switches:\n"
      "\t/s - compare structure\n"
      "\t/c - compare content\n"
      "\t/f:condition...      - set filter\n"
      "\t/o:field1,field2,... - order of records for comparison\n"
     );
 exit(0);
}

void
error(char *s)
{
 puts(s);
 exit(1);
}
