#!/bin/bash

echo "Bash examples for Wenity"

## --------------------------------
## Ask user to select a button
## --------------------------------
java -jar Wenity.jar  dialog question "Please select|a button bellow:" "Yes,No,Perhaps"
RESULT=$?
case "$RESULT" in
    1)  echo "You selected YES."
        ;;

    2)  echo "You selected NO."
        ;;

    3)  echo "You selected PERHAPS."
        ;;

    254) echo "Dialog is cancelled by user."
        ;;

    255) echo "An error occurred."
        ;;
esac

## --------------------------------
## Ask user to select a file
## --------------------------------
# clean up previous response file if any
rm -f wenity_response.txt

java -jar Wenity.jar fileSelector "Please select an existing file" "File should exist!"
RESULT=$?
if [ $RESULT -eq 0 ]; then
    SELECTED_FILE=`cat wenity_response.txt`
    echo "You selected: $SELECTED_FILE"
    # clean up response file
    rm wenity_response.txt
else
    # this can also be an error, but that check is omitted
    echo "File selector is cancelled by user."
fi


## --------------------------------
## Ask user to input something
## --------------------------------
# clean up previous response file if any
rm -f wenity_response.txt

java -jar Wenity.jar  dialog input "Please input your details:"
RESULT=$?
if [ $RESULT -eq 0 ]; then
    USER_INPUT=`cat wenity_response.txt`
    echo "You typed: $USER_INPUT"
    # clean up response file
    rm wenity_response.txt
else
    # this can also be an error, but that check is omitted
    echo "Input dialog is cancelled by user."
fi
