/*
 * Decompiled with CFR 0.152.
 */
package wenity.modules.file;

import java.io.File;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import wenity.Logger;
import wenity.Utils;
import wenity.modules.common.AWenityModule;
import wenity.modules.common.ModuleRequest;
import wenity.modules.common.ModuleResponse;

public class FileSelector
extends AWenityModule {
    private static final String MODULE_NAME = "fileSelector";

    public FileSelector() {
        super(MODULE_NAME);
    }

    @Override
    public ModuleResponse process(ModuleRequest moduleRequest) throws Exception {
        try {
            Iterator<String> moduleParamsIter = moduleRequest.getModuleParams();
            String dialogCaption = Utils.getIteratorValueEx(moduleParamsIter, "dialog_caption");
            String noFileErrorMsg = Utils.getIteratorOptionalValue(moduleParamsIter);
            ModuleResponse moduleResponse = null;
            while (moduleResponse == null) {
                JFileChooser fileChooser = this.createFileChooser(dialogCaption);
                if (fileChooser.showOpenDialog(null) == 0) {
                    moduleResponse = this.checkModuleResponse(fileChooser, noFileErrorMsg);
                    continue;
                }
                moduleResponse = ModuleResponse.newCancelResponse();
            }
            return moduleResponse;
        }
        catch (Exception ex) {
            throw new Exception("An error occurred while executing fileSelector. Did you specify all the correct arguments? Error: " + ex, ex);
        }
    }

    private JFileChooser createFileChooser(String dialogCaption) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(dialogCaption);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        return fileChooser;
    }

    private ModuleResponse checkModuleResponse(JFileChooser fileChooser, String noFileErrorMsg) {
        boolean fileMustExist = !noFileErrorMsg.isEmpty();
        File selFile = fileChooser.getSelectedFile();
        Logger.debug("Selected file is %s. Exists: %s", selFile.getPath(), selFile.exists());
        if (fileMustExist && !selFile.exists()) {
            JOptionPane.showMessageDialog(null, noFileErrorMsg);
            return null;
        }
        return ModuleResponse.newFileResponse(selFile.getPath());
    }
}

