/*
 * Decompiled with CFR 0.152.
 */
package wenity.modules.dialog;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import wenity.Utils;
import wenity.modules.common.AWenityModule;
import wenity.modules.common.ModuleRequest;
import wenity.modules.common.ModuleResponse;

public class DialogModule
extends AWenityModule {
    private static final String MODULE_NAME = "dialog";
    private static final Map<DialogType, Integer> DIALOG_TYPES = DialogModule.initDialogTypesMap();

    public DialogModule() {
        super(MODULE_NAME);
    }

    @Override
    public ModuleResponse process(ModuleRequest moduleRequest) throws Exception {
        try {
            Iterator<String> moduleParamsIter = moduleRequest.getModuleParams();
            DialogType dialogType = this.getDialogType(moduleParamsIter);
            String dialogText = this.getDialogText(moduleParamsIter);
            boolean showNormalDialog = dialogType != DialogType.INPUT;
            return showNormalDialog ? this.showOptionDlg(dialogType, dialogText, this.getButtonCaptions(moduleParamsIter)) : this.showInputDlg(dialogType, dialogText);
        }
        catch (Exception ex) {
            throw new Exception("An error occurred while executing dialog. Did you specify all the correct arguments? Error: " + ex, ex);
        }
    }

    private String getDialogText(Iterator<String> moduleParamsIter) {
        return Utils.getIteratorValueEx(moduleParamsIter, "dialog_text").replace('|', '\n');
    }

    private DialogType getDialogType(Iterator<String> moduleParamsIter) {
        String dialogTypeString = Utils.getIteratorValueEx(moduleParamsIter, "dialog_type").toUpperCase();
        return DialogType.valueOf(dialogTypeString);
    }

    private String[] getButtonCaptions(Iterator<String> moduleParamsIter) {
        String buttonNames = Utils.getIteratorValueEx(moduleParamsIter, "button_caption");
        return buttonNames.split(",");
    }

    private ModuleResponse showInputDlg(DialogType dialogType, String dialogText) {
        int messageType = DIALOG_TYPES.get((Object)dialogType);
        String userInput = this.processInputLoop(dialogText, messageType);
        return userInput == null ? ModuleResponse.newCancelResponse() : ModuleResponse.newFileResponse(userInput);
    }

    private ModuleResponse showOptionDlg(DialogType dialogType, String dialogText, Object[] buttons) {
        assert (buttons.length > 0);
        int messageType = DIALOG_TYPES.get((Object)dialogType);
        int selectedButtonIdx = JOptionPane.showOptionDialog(null, dialogText, "Wenity", -1, messageType, null, buttons, buttons[0]);
        return selectedButtonIdx == -1 ? ModuleResponse.newCancelResponse() : ModuleResponse.newResponse(selectedButtonIdx + 1);
    }

    private String processInputLoop(String dialogText, int messageType) {
        String userInput;
        while ((userInput = JOptionPane.showInputDialog(null, dialogText, "Wenity", messageType)) != null && userInput.isEmpty()) {
        }
        return userInput;
    }

    private static EnumMap<DialogType, Integer> initDialogTypesMap() {
        EnumMap<DialogType, Integer> enumMap = new EnumMap<DialogType, Integer>(DialogType.class);
        enumMap.put(DialogType.QUESTION, 3);
        enumMap.put(DialogType.WARNING, 2);
        enumMap.put(DialogType.ERROR, 0);
        enumMap.put(DialogType.INFO, 1);
        enumMap.put(DialogType.INPUT, 1);
        return enumMap;
    }

    private static enum DialogType {
        QUESTION,
        WARNING,
        ERROR,
        INPUT,
        INFO;

    }
}

