/*
 * Decompiled with CFR 0.152.
 */
package wenity.modules.common;

public final class ModuleResponse {
    private final String result;
    private final ModuleResponseStatus status;
    private final boolean createResponseFile;

    private ModuleResponse(String result, ModuleResponseStatus status, boolean createResponseFile) {
        this.result = result;
        this.status = status;
        this.createResponseFile = createResponseFile;
    }

    public boolean isValid() {
        return this.status == ModuleResponseStatus.OK;
    }

    public boolean isCanceled() {
        return this.status == ModuleResponseStatus.CANCELLED;
    }

    public boolean isError() {
        return this.status == ModuleResponseStatus.ERROR;
    }

    public boolean createsResponseFile() {
        return this.createResponseFile;
    }

    public String getResultAsString() {
        return this.result;
    }

    public int getResultAsInt() {
        return Integer.parseInt(this.result);
    }

    public String toString() {
        return "ModuleResponse{result='" + this.result + '\'' + ", status=" + (Object)((Object)this.status) + ", createResponseFile=" + this.createResponseFile + '}';
    }

    @Deprecated
    public static ModuleResponse newErrorResponse() {
        return new ModuleResponse("255", ModuleResponseStatus.ERROR, false);
    }

    public static ModuleResponse newCancelResponse() {
        return new ModuleResponse("254", ModuleResponseStatus.CANCELLED, false);
    }

    public static ModuleResponse newResponse(String result) {
        return new ModuleResponse(result, ModuleResponseStatus.OK, false);
    }

    public static ModuleResponse newResponse(int result) {
        return new ModuleResponse(Integer.toString(result), ModuleResponseStatus.OK, false);
    }

    public static ModuleResponse newFileResponse(String result) {
        assert (result != null);
        return new ModuleResponse(result, ModuleResponseStatus.OK, true);
    }

    public static ModuleResponse newFileResponse(int result) {
        return new ModuleResponse(Integer.toString(result), ModuleResponseStatus.OK, true);
    }

    private static enum ModuleResponseStatus {
        CANCELLED,
        ERROR,
        OK;

    }
}

