/*
 * Decompiled with CFR 0.152.
 */
package wenity;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import wenity.Logger;
import wenity.ModuleConfig;
import wenity.modules.common.IWenityModule;
import wenity.modules.common.ModuleRequest;
import wenity.modules.common.ModuleResponse;

public class Wenity {
    public int doIt(String[] args) {
        try {
            ModuleRequest moduleRequest = this.parseArgs(args);
            IWenityModule module = this.findModule(moduleRequest.getModuleName());
            if (module == null) {
                Logger.error("Can't find module to execute! // " + moduleRequest.getModuleName(), new Object[0]);
                return 255;
            }
            ModuleResponse moduleResponse = this.executeModule(module, moduleRequest);
            if (moduleResponse.isValid() && moduleResponse.createsResponseFile()) {
                this.writeResponseFile(moduleResponse.getResultAsString());
                return 0;
            }
            return moduleResponse.getResultAsInt();
        }
        catch (Exception ex) {
            Logger.exception("Wenity - An error occurred! ", ex);
            return 255;
        }
    }

    private ModuleRequest parseArgs(String[] args) {
        try {
            int argsLength = args.length;
            int lastArgIdx = argsLength - 1;
            boolean hasOptionalParam = "-d".equals(args[0]) || "-i".equals(args[0]);
            int moduleNameIdx = hasOptionalParam ? 1 : 0;
            String moduleName = args[moduleNameIdx];
            int firstModuleParamIdx = moduleNameIdx + 1;
            Object[] moduleParams = new String[]{};
            if (firstModuleParamIdx <= lastArgIdx) {
                moduleParams = Arrays.copyOfRange(args, firstModuleParamIdx, argsLength);
            }
            Logger.debug("Processed arguments - module: '%s' parameters: '%s'", moduleName, Arrays.toString(moduleParams));
            return new ModuleRequest(moduleName, (String[])moduleParams);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't parse program arguments! Reason: " + ex, ex);
        }
    }

    private IWenityModule findModule(String moduleName) {
        for (IWenityModule module : ModuleConfig.getInstalledModules()) {
            if (!module.canProcess(moduleName)) continue;
            return module;
        }
        return null;
    }

    private ModuleResponse executeModule(IWenityModule module, ModuleRequest moduleRequest) throws Exception {
        try {
            Logger.debug("Executing '%s' with request '%s'", module.getModuleName(), moduleRequest);
            ModuleResponse moduleResponse = module.process(moduleRequest);
            Logger.debug("Executed '%s' with response '%s'", module.getModuleName(), moduleResponse);
            return moduleResponse;
        }
        catch (Exception ex) {
            Logger.error("Failed to execute '%s' with params '%s'", module.getModuleName(), moduleRequest);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponseFile(String data) throws IOException {
        PrintWriter printWriter = null;
        BufferedWriter bufferedWriter = null;
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter("wenity_response.txt");
            bufferedWriter = new BufferedWriter(fileWriter);
            printWriter = new PrintWriter(bufferedWriter);
            printWriter.println(data);
            this.closeNoThrow(printWriter);
            this.closeNoThrow(bufferedWriter);
            this.closeNoThrow(fileWriter);
        }
        catch (Throwable throwable) {
            this.closeNoThrow(printWriter);
            this.closeNoThrow(bufferedWriter);
            this.closeNoThrow(fileWriter);
            throw throwable;
        }
    }

    private void closeNoThrow(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
            }
        }
    }
}

