// send.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <winable.h>
#include "globals.h"
#include "regexp.h"
#include <math.h>

#ifndef VK_NULL
#define VK_NULL 0
#endif

void MakeLower(const char *sz, char *szlc, int iMax)
{
    int i = 0;
	while (*sz != '\0')
	{
		*szlc = tolower(*sz);
		sz++;
		szlc++;
        i++;
        if (i >= iMax)
        {
            *szlc = '\0';
            return;
        }
	}
	*szlc = '\0';
}

BOOL CharInString(LPCSTR sz, char c)
{
    c = tolower(c);

    while (*sz != '\0')
    {
        if (tolower(*sz) == c)
            return TRUE;
        sz++;
    }

    return FALSE;
}

void Usage()
{
	printf("\
Send, version 1.22\n\
\n\
Usage:    send [Options] [-n NewName] [-s \"ClassName\"] \"app\" \"keys\" [time]\n\
\n\
Example:  send \"virtualdub\" \"\\{F6}\" 7:55pm\n\
\n\
Options:  -r     Use regular expression matching on \"application\"\n\
          -c     Use a case-sensitive search\n\
          -f     Repeatedly send the string (forever)\n\
          -g     Use the foreground window (ignores the specified app)\n\
          -b     Leave the selected window in the background (WM/pos only)\n\
          -l     List captions of all windows not matching \"application\"\n\
          -w     Wait for the window to exist\n\
          -d     Do not restore the forground window afterwards\n\
          -h     Include hidden windows in the search\n\
          -n     Give the found window a new caption\n\
          -s     Also match the window class specified\n\
          -a     Send the command to every matching window\n\
          time   Wait until specified time to send the keys\n\
\n\
          --fullhelp  Print the full documentation\n");
}

class CSendInfo
{
public:
	std::string m_strKeys;
	std::string m_strApp;
};

DWORD GetNormalKey(char c)
{
    short iKey = VkKeyScan(c);
    if (iKey == -1)
        return 0;

    DWORD dwResult = (BYTE) (iKey & 0xff);

    if (iKey & 0x0100)
        dwResult |= SVK_SHIFT;

    if (iKey & 0x0200)
        dwResult |= SVK_CONTROL;

    if (iKey & 0x0400)
        dwResult |= SVK_MENU;

    return dwResult;
}

DWORD GetQuotedKey(char c)
{
	switch(c)
	{
		case 'a':
			return VK_MENU;
		case 'A':
			return VK_MENU | SVK_RELEASE;
		case 'b':
		case 'B':
			return VK_BACK;
		case 'c':
			return VK_CONTROL;
		case 'C':
			return VK_CONTROL | SVK_RELEASE;
		case 'd':
		case 'D':
			return VK_DOWN;
		case 'e':
		case 'E':
			return VK_ESCAPE;
        case 'k':
        case 'K':
            return VK_LBUTTON;
		case 'l':
		case 'L':
			return VK_LEFT;
		case 's':
			return VK_SHIFT;					// and zero for the VK
		case 'S':
			return VK_SHIFT | SVK_RELEASE;	    // and zero for the VK
		case 't':
		case 'T':
			return VK_TAB;
		case 'n':
		case 'N':
			return VK_RETURN;
        case 'p':
            return VK_APPS;
        case 'P':
            return VK_APPS | SVK_RELEASE;
		case 'r':
		case 'R':
			return VK_RIGHT;
		case 'u':
		case 'U':
			return VK_UP;
        case 'w':
            return VK_LWIN;
        case 'W':
            return VK_LWIN + SVK_RELEASE;
		default:
			return GetNormalKey(c);
	}
}

DWORD GetMouseCommand(LPCSTR sz, MouseEventStruct *pEvent)
{
	char szKey[MAX_PATH];
	int i = 0;
    int iStr = 0;
    enum { Mouse, Button, Action, PointX, PointY, Options };
    int iEventPart = Mouse;

    pEvent->iAction = MOUSE_ACTION_NONE;
    pEvent->iButton = MOUSE_BUTTON_NONE;
    pEvent->iOptions = MOUSE_GLOBAL;
    pEvent->iX = 0;
    pEvent->iY = 0;
    pEvent->dwFlags = 0;

    int iLen;

    while (*sz != '}')
	{
        if (*sz == '\0')
            break;
        iStr = 0;
        while (*sz != ',')
        {
		    if (*sz == '\0')
			    break;
            if (*sz == ']')
                break;
		    szKey[iStr] = *sz;
		    i++;
            iStr++;
		    sz++;
    	}
	    szKey[iStr] = '\0';
        if (*sz != '\0')
            sz++;
        i++;

        switch(iEventPart)
        {
            case Mouse:
                break;
            case Button:
                switch(szKey[0])
                {
                    case 'l':
                    case 'L':
                        pEvent->iButton = MOUSE_BUTTON_LEFT;
                        break;
                    case 'r':
                    case 'R':
                        pEvent->iButton = MOUSE_BUTTON_RIGHT;
                        break;
                    case 'm':
                    case 'M':
                        pEvent->iButton = MOUSE_BUTTON_MIDDLE;
                        break;
                    case '1':
                        pEvent->iButton = MOUSE_BUTTON_X1;
                        break;
                    case '2':
                        pEvent->iButton = MOUSE_BUTTON_X2;
                        break;
                    case 'n':
                    case 'N':
                        pEvent->iButton = MOUSE_BUTTON_NONE;
                        break;
                    case 'w':
                    case 'W':
                        pEvent->iButton = MOUSE_WHEEL;
                        break;
                    default:
                        break;
                }
                break;
            case Action:
                switch(szKey[0])
                {
                    case 'd':
                    case 'D':
                        pEvent->iAction = MOUSE_ACTION_DOWN;
                        break;
                    case 'u':
                    case 'U':
                        pEvent->iAction = MOUSE_ACTION_UP;
                        break;
                    case 'c':
                    case 'C':
                        pEvent->iAction = MOUSE_ACTION_CLICK;
                        break;
                    case 'n':
                    case 'N':
                        pEvent->iAction = MOUSE_ACTION_NONE;
                        break;
                    default:
                        break;
                }
                break;
            case PointX:
                pEvent->iX = StringToInteger(szKey);
                iLen = strlen(szKey);
                if (iLen > 0)
                {
                    if (tolower(szKey[iLen-1]) == 'r')
                    {
                        pEvent->dwFlags |= MES_RELATIVE_X;
                    }
                }
                break;
            case PointY:
                pEvent->iY = StringToInteger(szKey);
                iLen = strlen(szKey);
                if (iLen > 0)
                {
                    if (tolower(szKey[iLen-1]) == 'r')
                    {
                        pEvent->dwFlags |= MES_RELATIVE_Y;
                    }
                }
                break;
            case Options:
                switch(szKey[0])
                {
                    case 'l':
                    case 'L':
                    case 'c':
                    case 'C':
                        pEvent->iOptions = MOUSE_LOCAL;
                        break;
                    case 's':
                    case 'S':
                    case 'g':
                    case 'G':
                        pEvent->iOptions = MOUSE_GLOBAL;
                        break;
                    default:
                        break;
                }
                break;
            default: ;
        }
        iEventPart++;
    }

    return SVK_MOUSE;
}

DWORD GetWindowCommand(LPCSTR sz, WindowEventStruct *pEvent)
{
	char szKey[MAX_PATH];
	int i = 0;
    int iStr = 0;
    enum { Window, H1, V1, H2, V2 };
    int iEventPart = Window;

    pEvent->dwFlags = 0;
    pEvent->iHeight = 0;
    pEvent->iWidth = 0;
    pEvent->iX = 0;
    pEvent->iY = 0;

    bool bPosition = true;
    int iTemp;

    int iLen;

    while (*sz != '}')
	{
        if (*sz == '\0')
            break;
        iStr = 0;
        while (*sz != ',')
        {
		    if (*sz == '\0')
			    break;
            if (*sz == ']')
                break;
		    szKey[iStr] = *sz;
		    i++;
            iStr++;
		    sz++;
    	}
	    szKey[iStr] = '\0';
        if (*sz != '\0')
            sz++;
        i++;

        switch(iEventPart)
        {
            case H1:
            case V1:
            case H2:
            case V2:
                iTemp = ExpressionToInteger(szKey);
                iLen = strlen(szKey);
                break;
            default:
                break;
        }

        switch(iEventPart)
        {
            case Window:
                switch(szKey[1])
                {
                    case 'p':
                    case 'P':
                        bPosition = true;
                        break;
                    case 's':
                    case 'S':
                        bPosition = false;
                        break;
                }
                break;
            case H1:
                if (iLen > 0)
                {
                    if (tolower(szKey[iLen-1]) == 'r')
                    {
                        pEvent->dwFlags |= (bPosition ? WES_RELATIVE_X : WES_RELATIVE_WIDTH);
                    }
                }
                if (bPosition)
                    pEvent->iX = iTemp;
                else
                    pEvent->iWidth = iTemp;
                break;
            case V1:
                if (iLen > 0)
                {
                    if (tolower(szKey[iLen-1]) == 'r')
                    {
                        pEvent->dwFlags |= (bPosition ? WES_RELATIVE_Y : WES_RELATIVE_HEIGHT);
                    }
                }
                if (bPosition)
                    pEvent->iY = iTemp;
                else
                    pEvent->iHeight = iTemp;
                break;
            case H2:
                if (iLen > 0)
                {
                    if (tolower(szKey[iLen-1]) == 'r')
                    {
                        pEvent->dwFlags |= (bPosition ? WES_RELATIVE_WIDTH : WES_RELATIVE_X);
                    }
                }
                if (!bPosition)
                    pEvent->iX = iTemp;
                else
                    pEvent->iWidth = iTemp;
                break;
            case V2:
                if (iLen > 0)
                {
                    if (tolower(szKey[iLen-1]) == 'r')
                    {
                        pEvent->dwFlags |= (bPosition ? WES_RELATIVE_HEIGHT : WES_RELATIVE_Y);
                    }
                }
                if (!bPosition)
                    pEvent->iY = iTemp;
                else
                    pEvent->iHeight = iTemp;
                break;
            default: ;
        }
        iEventPart++;
    }

    if (!bPosition && iEventPart == H2)
    {
        pEvent->dwFlags |= (WES_RELATIVE_X | WES_RELATIVE_Y);
    }

    return SVK_WINDOW;
}

DWORD GetSpecialKey(LPCSTR sz, int *piNew, LPMSG pMsg, MouseEventStruct *pMouseEventStruct, WindowEventStruct *pWindowEvent)
{
	char szKey[MAX_PATH];
	int i = 0;
	
	while (*sz != '}')
	{
		if (*sz == '\0')
			break;
		szKey[i] = *sz;
		i++;
		sz++;
	}
	szKey[i] = '\0';
	if (piNew)
		*piNew = i+2;

    switch(szKey[0])
    {
        // "Delete" key is anything that starts with "d"
        case 'd':
        case 'D':
            return VK_DELETE;

        // "End" key is anything that starts with "e"
        case 'e':
        case 'E':
            return VK_END;

        // Function keys F1-F24 (undefined for above F24)
        case 'F':
        case 'f':
            i = atol(&szKey[1]);
            if (i < 1)
                return 0;
            return VK_F1 + (i-1);

        // "Home" key is anything that starts with "h"
        case 'h':
        case 'H':
            return VK_HOME;

        // "Insert" key is anything that starts with "i"
        case 'i':
        case 'I':
            return VK_INSERT;

        // Mouse movements are handled separately
        case 'm':
        case 'M':
            return GetMouseCommand(szKey, pMouseEventStruct);

        // Window movements are also a separate event
        case 'w':
        case 'W':
            return GetWindowCommand(szKey, pWindowEvent);

        // Numeric keypad keys begin with "n" (i.e. \{n*} is the numeric "multiply" key)
        case 'n':
        case 'N':
            switch(szKey[1])
            {
                case '0':   return VK_NUMPAD0;
                case '1':   return VK_NUMPAD1;
                case '2':   return VK_NUMPAD2;
                case '3':   return VK_NUMPAD3;
                case '4':   return VK_NUMPAD4;
                case '5':   return VK_NUMPAD5;
                case '6':   return VK_NUMPAD6;
                case '7':   return VK_NUMPAD7;
                case '8':   return VK_NUMPAD8;
                case '9':   return VK_NUMPAD9;
                case '*':   return VK_MULTIPLY;
                case '+':   return VK_ADD;
                case '-':   return VK_SUBTRACT;
                case '/':   return VK_DIVIDE;
                case '.':   return VK_DECIMAL;
                default:    return VK_NUMLOCK;
            }

        // PageUp, PageDown, PrintScreen, and Pause all begin with "p" - so
        // check what follows to determine which key to send
        case 'p':
        case 'P':
            if (CharInString(&szKey[1], 'u'))
                return VK_PRIOR;    // PageUp
            else if (CharInString(&szKey[1], 'd'))
                return VK_NEXT;     // PageDown
            else if (CharInString(&szKey[1], 'c'))
                return VK_SNAPSHOT; // PrintScreen
            else
                return VK_PAUSE;    // Pause

        // "Scroll Lock" is "s" followed by anything other than a number.
        // "s" followed by a number means "sleep for N milliseconds"
        case 's':
        case 'S':
            i = atol(&szKey[1]);
            if (i < 1)
                return VK_SCROLL;   // Scroll Lock
            if (pMsg)
                pMsg->lParam = (DWORD) i;
            return SVK_SLEEP;

        // Unicode characters can be input by \{uXXXX} where XXXX is a
        // hexadecimal number.
        case 'u':
        case 'U':
            if (sscanf(&szKey[1], "%x", &i) < 1)
                return VK_NULL; // Invalid hex code
            
            return VK_NULL; // Not currently supported

        default:
            return 0;   // No idea what this key is
    }

	return 0;
}

DWORD GetWindowMessage(LPCSTR sz, int *piNew, LPMSG pMsg)
{
	char szKey[MAX_PATH];
	int i = 0;
    int iStr = 0;
    enum { Message, WParam, LParam };
    int iMsgPart = Message;
    DWORD dwValue;

    pMsg->hwnd = NULL;
    pMsg->message = WM_NULL;
    pMsg->lParam = 0;
    pMsg->wParam = 0;
    GetCursorPos(&pMsg->pt);
    pMsg->time = 0;
	
    bool bContinue = true;

	while (bContinue)
	{
        if (*sz == '\0')
            break;
        iStr = 0;
        while (*sz != ',')
        {
		    if ((*sz == '\0') || (*sz == ']'))
            {
                bContinue = false;
                break;
            }
		    szKey[iStr] = *sz;
		    i++;
            iStr++;
		    sz++;
    	}
	    szKey[iStr] = '\0';
        if (*sz != '\0')
            sz++;
        i++;

        dwValue = GetWM(szKey);
        switch(iMsgPart)
        {
            case Message:
                printf("Message: %d\n", dwValue);
                pMsg->message = dwValue;
                break;
            case LParam:
                printf("LParam: %d\n", dwValue);
                pMsg->lParam = dwValue;
                break;
            case WParam:
                printf("WParam: %d\n", dwValue);
                pMsg->wParam = dwValue;
                break;
            default: ;
        }
        iMsgPart++;
    }

	if (piNew)
		*piNew = i+1;

	return SVK_MESSAGE;
}

int ReleaseMods(INPUT *pInputs, DWORD dwModifiers, int iIndex)
{
    int iMod = 0;

    while (g_dwSVKModOrder[iMod] != 0)
    {
        if (dwModifiers & g_dwSVKModOrder[iMod])
        {
            pInputs[iIndex].ki.wVk = (WORD) g_dwVKModOrder[iMod];
            pInputs[iIndex].ki.dwFlags = KEYEVENTF_KEYUP;
            iIndex++;
        }
        iMod++;
    }

    return iIndex;
}

int GetMods(INPUT *pInputs, DWORD dwModifiers, int iIndex)
{
    // Add keyboard modifiers (Control, Alt, Shift, Windows key, Apps key)
    // to the input array.

    DWORD dwFlags = (dwModifiers & SVK_RELEASE) ? KEYEVENTF_KEYUP : 0;

    int iMod = 0;

    while (g_dwSVKModOrder[iMod] != 0)
    {
        if (dwModifiers & g_dwSVKModOrder[iMod])
        {
            pInputs[iIndex].ki.wVk = (WORD) g_dwVKModOrder[iMod];
            pInputs[iIndex].ki.dwFlags = dwFlags;
            iIndex++;
        }
        iMod++;
    }

    return iIndex;
}

DWORD GetNextKey(LPCSTR *psz, LPMSG pMsg, MouseEventStruct *pMouseEventStruct, WindowEventStruct *pWindowEvent)
{
    LPCSTR sz = *psz;
    DWORD dwVKey;
    int i;

	switch(*sz)
	{
		case '\\':
            switch(sz[1])
            {
                case '{':
				    dwVKey = GetSpecialKey(&sz[2], &i, pMsg, pMouseEventStruct, pWindowEvent);
				    sz += i;
                    break;
                case '[':
                    dwVKey = GetWindowMessage(&sz[2], &i, pMsg);
                    sz += i;
                    break;
                default:
				    dwVKey = GetQuotedKey(sz[1]);
				    sz++;
            }
			break;
		default:
			dwVKey = GetNormalKey(*sz);
	}
	sz++;

    *psz = sz;
    return dwVKey;
}

void WindowPos(HWND hwnd, WindowEventStruct *pEvent)
{
    int iX = pEvent->iX;
    int iY = pEvent->iY;
    int iHeight = pEvent->iHeight;
    int iWidth = pEvent->iWidth;

    RECT rc;
    GetWindowRect(hwnd, &rc);

    if (pEvent->dwFlags & WES_RELATIVE_X)
        iX += rc.left;

    if (pEvent->dwFlags & WES_RELATIVE_WIDTH)
        iWidth += (rc.right - rc.left);

    if (pEvent->dwFlags & WES_RELATIVE_Y)
        iY += rc.top;

    if (pEvent->dwFlags & WES_RELATIVE_HEIGHT)
        iHeight += (rc.bottom - rc.top);

    if (iWidth == 0)
        iWidth = (rc.right - rc.left);

    if (iHeight == 0)
        iHeight = (rc.bottom - rc.top);

    MoveWindow(hwnd, iX, iY, iWidth, iHeight, TRUE);
}

void SendKeys(HWND hwnd, std::string strKeys, LPCSTR szText)
{
	HWND hwndPrev = GetForegroundWindow();

    if (!g_bLeaveInBackground)
	    SetForegroundWindow(hwnd);

    if ((!g_bRepeatForever) && (!g_bQuiet))
    {
	    printf("Sending \"%s\" to \"%s\"\n", strKeys.c_str(), szText);
    }

	int i = 0;
	int iLen = strKeys.length();
	const char *sz = strKeys.c_str();
	int vkey;
    BYTE bVK;
    DWORD dwShift;
    MSG msg;
    MouseEventStruct mouseEventStruct;
    WindowEventStruct windowEvent;
    INPUT inputs[MAX_INPUTS];

//    RECT rcWorkArea;
//    SystemParametersInfo(SPI_GETWORKAREA, 0, &rcWorkArea, 0);
//    int iScreenX = rcWorkArea.right - rcWorkArea.left;
//    int iScreenY = rcWorkArea.bottom - rcWorkArea.top;

    int iScreenX = GetSystemMetrics(SM_CXSCREEN);
    int iScreenY = GetSystemMetrics(SM_CYSCREEN);

    for (i = 0; i < MAX_INPUTS; i++)
    {
		inputs[i].type = INPUT_KEYBOARD;
		inputs[i].ki.wVk = 0;
		inputs[i].ki.wScan = 0;
		inputs[i].ki.dwFlags = 0;
		inputs[i].ki.time = 0;
    }

	while (*sz != '\0')
	{
		vkey = GetNextKey(&sz, &msg, &mouseEventStruct, &windowEvent);

        bVK = vkey & 0xff;
        dwShift = vkey & 0xffffff00;

        // Sleep if desired
        if (dwShift & SVK_SLEEP)
            Sleep(msg.lParam);

        // Send a windows message if requested
        if (dwShift & SVK_MESSAGE)
        {
            // Some hacks
            if (msg.message == WM_SHOWWINDOW)
            {
                ShowWindow(hwnd, msg.wParam ? SW_SHOW : SW_HIDE);
            }
            else
            {
                SendMessage(hwnd, msg.message, msg.wParam, msg.lParam);
            }
        }

        if (vkey == SVK_MOUSE)
        {
            BOOL bRelative = FALSE;

            INPUT iMouse;
            iMouse.type = INPUT_MOUSE;
            iMouse.mi.time = 0;
            iMouse.mi.dwFlags = 0;
            iMouse.mi.mouseData = 0;

            POINT pt;
            POINT ptCurrent;
            GetCursorPos(&ptCurrent);

            pt.x = mouseEventStruct.iX;
            pt.y = mouseEventStruct.iY;

            if (mouseEventStruct.iOptions == MOUSE_LOCAL)
            {
                ClientToScreen(hwnd, &pt);
            }

            bRelative = (((mouseEventStruct.dwFlags & MES_RELATIVE_X) > 0) ||
                         ((mouseEventStruct.dwFlags & MES_RELATIVE_Y) > 0));
/*
            if ((mouseEventStruct.dwFlags & MES_RELATIVE_X) > 0)
            {
                pt.x += ptCurrent.x;
            }

            if ((mouseEventStruct.dwFlags & MES_RELATIVE_Y) > 0)
            {
                pt.y += ptCurrent.y;
            }
*/

            if (bRelative)
            {
                iMouse.mi.dwFlags &= ~MOUSEEVENTF_ABSOLUTE;
            }
            else
            {
                iMouse.mi.dwFlags |= MOUSEEVENTF_ABSOLUTE;
                pt.x = (pt.x + 1) * 65536 / iScreenX;
                pt.y = (pt.y + 1) * 65536 / iScreenY;
            }

            iMouse.mi.dx = pt.x;
            iMouse.mi.dy = pt.y;

            BOOL bDown = (mouseEventStruct.iAction == MOUSE_ACTION_DOWN);
            BOOL bClick = (mouseEventStruct.iAction == MOUSE_ACTION_CLICK);
            BOOL bUp = (mouseEventStruct.iAction == MOUSE_ACTION_UP);

            switch(mouseEventStruct.iButton)
            {
                case MOUSE_BUTTON_LEFT:
                    if (bUp)
                        iMouse.mi.dwFlags |= MOUSEEVENTF_LEFTUP;
                    else if (bDown || bClick)
                        iMouse.mi.dwFlags |= MOUSEEVENTF_LEFTDOWN;
                    break;
                case MOUSE_BUTTON_MIDDLE:
                    if (bUp)
                        iMouse.mi.dwFlags |= MOUSEEVENTF_MIDDLEUP;
                    else if (bDown || bClick)
                        iMouse.mi.dwFlags |= MOUSEEVENTF_MIDDLEDOWN;
                    break;
                case MOUSE_BUTTON_RIGHT:
                    if (bUp)
                        iMouse.mi.dwFlags |= MOUSEEVENTF_RIGHTUP;
                    else if (bDown || bClick)
                        iMouse.mi.dwFlags |= MOUSEEVENTF_RIGHTDOWN;
                    break;
                case MOUSE_WHEEL:
                    iMouse.mi.dwFlags |= MOUSEEVENTF_WHEEL;
                    if (bUp)
                        iMouse.mi.mouseData = WHEEL_DELTA;
                    else if (bDown)
                        iMouse.mi.mouseData = -WHEEL_DELTA;
                    break;
                case MOUSE_BUTTON_X1:
                case MOUSE_BUTTON_X2:
                    if (bDown || bClick)
                    {
                        iMouse.mi.dwFlags |= MOUSEEVENTF_XDOWN;
                    }
                    else if (bUp)
                    {
                        iMouse.mi.dwFlags |= MOUSEEVENTF_XUP;
                    }
                    iMouse.mi.mouseData = (mouseEventStruct.iButton == MOUSE_BUTTON_X2 ? XBUTTON2 : XBUTTON1);
                    break;
                default:
                    break;
            }

            // If the co-ordinates aren't (-1,-1), move the mouse to the given
            // location before clicking
            if ((mouseEventStruct.iX != -1) || (mouseEventStruct.iY != -1))
            {
                iMouse.mi.dwFlags |= MOUSEEVENTF_MOVE;
            }
            else
            {
                POINT ptSet;
                ptSet.x = (ptCurrent.x + 1) * 65536 / iScreenX;
                ptSet.y = (ptCurrent.y + 1) * 65536 / iScreenY;
                iMouse.mi.dx = ptSet.x;
                iMouse.mi.dy = ptSet.y;
            }
            SendInput(1, &iMouse, sizeof(INPUT));

            if (bClick)
            {
                iMouse.mi.dwFlags = MOUSEEVENTF_ABSOLUTE;
                switch(mouseEventStruct.iButton)
                {
                    case MOUSE_BUTTON_LEFT:
                        iMouse.mi.dwFlags |= MOUSEEVENTF_LEFTUP;
                        break;
                    case MOUSE_BUTTON_MIDDLE:
                        iMouse.mi.dwFlags |= MOUSEEVENTF_MIDDLEUP;
                        break;
                    case MOUSE_BUTTON_RIGHT:
                        iMouse.mi.dwFlags |= MOUSEEVENTF_RIGHTUP;
                        break;
                    case MOUSE_BUTTON_X1:
                        iMouse.mi.dwFlags |= MOUSEEVENTF_XUP;
                        iMouse.mi.mouseData = XBUTTON1;
                        break;
                    case MOUSE_BUTTON_X2:
                        iMouse.mi.dwFlags |= MOUSEEVENTF_XUP;
                        iMouse.mi.mouseData = XBUTTON2;
                        break;
                    default:
                        break;
                }
                SendInput(1, &iMouse, sizeof(INPUT));
            }
        }
        else if (vkey == SVK_WINDOW)
        {
            WindowPos(hwnd, &windowEvent);
        }
        else
        {
            if (bVK == VK_LBUTTON)
            {
                // Click the mouse button
                POINT pt;
                GetCursorPos(&pt);
                INPUT iMouse;
                iMouse.type = INPUT_MOUSE;
                iMouse.mi.dx = pt.x;
                iMouse.mi.dy = pt.y;
                iMouse.mi.time = 0;
                iMouse.mi.mouseData = 0;
                iMouse.mi.dwFlags = MOUSEEVENTF_LEFTDOWN;
                iMouse.mi.dwExtraInfo = 0;
        
                SendInput(1, &iMouse, sizeof(INPUT));
                iMouse.mi.dwFlags = MOUSEEVENTF_LEFTUP;
                SendInput(1, &iMouse, sizeof(INPUT));

                continue;
            }

            // Apply any modifier keys necessary
            i = 0;
            if (dwShift & SVK_ANYMOD)
                i = GetMods(inputs, dwShift, i);

            // Apply the actual virtual-key code desired
            if (bVK)
            {
                inputs[i].ki.wVk = bVK;
                inputs[i].ki.dwFlags = (dwShift & SVK_RELEASE) ? KEYEVENTF_KEYUP : 0;
                i++;
            }
            if (bVK && !(dwShift & SVK_RELEASE))
            {
                switch(bVK)
                {
                    case VK_LSHIFT:
                    case VK_RSHIFT:
                    case VK_SHIFT:
                    case VK_LCONTROL:
                    case VK_RCONTROL:
                    case VK_CONTROL:
                    case VK_LMENU:
                    case VK_RMENU:
                    case VK_MENU:
                        // We don't want to release this key
                        break;
                    default:
                        inputs[i].ki.wVk = bVK;
                        inputs[i].ki.dwFlags = KEYEVENTF_KEYUP;
                        i++;
                }
            }

            // Release any modifier keys that were "pressed down" prior to
            // sending the virtual-key.
            if ((dwShift & SVK_ANYMOD) && !(dwShift & SVK_RELEASE))
                i = ReleaseMods(inputs, dwShift, i);

            // Re-acquire the foreground window in case something (like an Instant Message)
            // decided to rudely pop up while we were sending keys.
        	SetForegroundWindow(hwnd);

            // Send the stream of modifiers and keystroke to the foreground application
 		    SendInput(i, inputs, sizeof(INPUT));
        }
	}

    if ((g_bRestoreForeground) && (!g_bLeaveInBackground))
    {
        // Wait a few milliseconds before yanking focus away (prevents
        // keystrokes from being "eaten" in a lot of cases).

        Sleep(50);

	    if (IsWindow(hwndPrev))
		    SetForegroundWindow(hwndPrev);
    }
}

std::string ParseString(LPCSTR szParse)
{
	std::string strResult = szParse;
	return strResult;
}

BOOL CALLBACK EnumWindowsProc(
  HWND hwnd,      // handle to parent window
  LPARAM lParam   // application-defined value
)
{
    if (!g_bIncludeHidden)
    {
        if (!IsWindowVisible(hwnd))
            return TRUE;
    }

	char szText[MAX_PATH];
    char szClass[MAX_PATH];
	char szTextLC[MAX_PATH];
    char szWindowLC[MAX_PATH];
    BOOL bMatch = FALSE;

	CSendInfo *pInfo = (CSendInfo *) lParam;
	GetWindowText(hwnd, szText, MAX_PATH);
    GetClassName(hwnd, szClass, MAX_PATH);

    if (pInfo->m_strApp.length() > 0)
    {
        if (g_bCaseSensitive)
        {
            strcpy(szTextLC, szText);
            strcpy(szWindowLC, pInfo->m_strApp.c_str());
        } else
        {
            MakeLower(szText, szTextLC, MAX_PATH);
            MakeLower(pInfo->m_strApp.c_str(), szWindowLC, MAX_PATH);
        }

        if (g_bRegEx)
        {
            Regexp re(szWindowLC);
            bMatch = re.Match(szTextLC);
        } else
        {
            bMatch = (strstr(szTextLC, szWindowLC) != NULL);
        }

        if (g_bMatchClass)
        {
            if (g_bCaseSensitive)
            {
                bMatch = bMatch && (strcmp(szClass, g_szMatchClass) == 0);
            }
            else
            {
                bMatch = bMatch && (stricmp(szClass, g_szMatchClass) == 0);
            }
        }
    }

    if (g_bMatchForegroundWindow)
    {
        hwnd = GetForegroundWindow();
        bMatch = TRUE;
    }

	if (bMatch)
	{
		if (strstr(szTextLC, g_szEXEString))
			goto Ignore;
        g_bSent = TRUE;
        if (g_bRenameWindow)
        {
            SetWindowText(hwnd, g_szRename);
        }
		SendKeys(hwnd, pInfo->m_strKeys, szText);

        if (g_bSendToEveryWindow)
            return TRUE;

		return FALSE;
	}

Ignore:
    if (g_bListFailedWindows)
    {
        printf("0x%.8x \"%s\" (%s)\n", (long) hwnd, szText, szClass);
    }

	return TRUE;
}

void ParseFullCommand(LPCSTR szCommand)
{
    if (stricmp(szCommand, "fullhelp") == 0)
    {
        FullHelp();
        g_bFullHelp = TRUE;
    }
}

int ParseArgs(int argc, char *argv[])
{
    int iArg = 1;
    int iChar;

    if (argc < 2)
        return iArg;

    while (argv[iArg][0] == '-')
    {
        iChar = 1;
        while (argv[iArg][iChar] != '\0')
        {
            switch(argv[iArg][iChar])
            {
                case 'd':
                case 'D':
                    g_bRestoreForeground = FALSE;
                    break;
                case 'h':
                case 'H':
                    g_bIncludeHidden = TRUE;
                    break;
                case 'R':
                case 'r':
                    g_bRegEx = TRUE;
                    break;
                case 'C':
                case 'c':
                    g_bCaseSensitive = TRUE;
                    break;
                case 'F':
                case 'f':
                    g_bRepeatForever = TRUE;
                    break;
                case 'G':
                case 'g':
                    g_bMatchForegroundWindow = TRUE;
                    break;
                case 'B':
                case 'b':
                    g_bLeaveInBackground = TRUE;
                    break;
                case 'l':
                case 'L':
                    g_bListFailedWindows = TRUE;
                    break;
				case 'w':
				case 'W':
					g_bWaitForSuccess = TRUE;
                    break;
				case 'q':
				case 'Q':
					g_bQuiet = TRUE;
                    break;
                case 'a':
                case 'A':
                    g_bSendToEveryWindow = TRUE;
                    break;
				case 's':
				case 'S':
                    if (iArg < argc - 1)
                    {
                        g_bMatchClass = TRUE;
                        strcpy(g_szMatchClass, argv[iArg+1]);
                        iArg++;
                        iChar = strlen(argv[iArg]) - 1;
                    }
					break;
				case 'n':
				case 'N':
                    if (iArg < argc - 1)
                    {
					    g_bRenameWindow = TRUE;
                        strcpy(g_szRename, argv[iArg+1]);
                        iArg++;
                        iChar = strlen(argv[iArg]) - 1;
                    }
					break;
                case '-':
                    ParseFullCommand(&argv[iArg][iChar+1]);
                    iChar = strlen(argv[iArg]) - 1;
                    break;
                default:
                    fprintf(stderr, "Warning:  Ignoring invalid option \"-%c\"\n", argv[iArg][iChar]);
            }
            iChar++;
        }
        iArg++;
        if (iArg >= argc)
            break;
    }

    return iArg;
}

int main(int argc, char* argv[])
{
    g_bRegEx = FALSE;
    g_bCaseSensitive = FALSE;
    g_bMatchForegroundWindow = FALSE;
    g_bSent = FALSE;
    g_bWaitDate = FALSE;
    g_bListFailedWindows = FALSE;
    g_bWaitForSuccess = FALSE;
    g_bRepeatForever = FALSE;
    g_bRestoreForeground = TRUE;
    g_bIncludeHidden = FALSE;
    g_bRenameWindow = FALSE;
    g_bFullHelp = FALSE;
    g_bQuiet = FALSE;
    g_bMatchClass = FALSE;
    g_bSendToEveryWindow = FALSE;

    BOOL bContinue = TRUE;
    int iArg = ParseArgs(argc, argv);
    
    if (g_bFullHelp)
    {
        return 0;
    }

    if ((argc - iArg < 2) && (!g_bListFailedWindows) && (!g_bMatchForegroundWindow))
    {
        fprintf(stderr, "Error:  Provide at least an application name and keystroke string\n\n");
		Usage();
		return -1;
    }

    InitWM();

	CSendInfo sendInfo;
    sendInfo.m_strApp = "";
    sendInfo.m_strKeys = "";

    if (argc > iArg)
        sendInfo.m_strApp = ParseString(argv[iArg]);

    if (argc > iArg+1)
	    sendInfo.m_strKeys = ParseString(argv[iArg+1]);

    if (argc > iArg + 2)
    {
        // User provided a time for processing
        g_bWaitDate = TRUE;
        int iLen = strlen(argv[iArg+2]);
        OLECHAR *wszTemp = new OLECHAR[iLen+1];
        mbstowcs(wszTemp, argv[iArg+2], iLen+1);
        if (FAILED(VarDateFromStr(wszTemp, LANG_USER_DEFAULT, 0, &g_dtWait)))
        {
            fprintf(stderr,"Error:  Could not parse date/time: \"%s\"\n", argv[iArg+2]);
            bContinue = FALSE;
        }
        delete[] wszTemp;

        SYSTEMTIME stNow;
        double dtNow;
        double dtDiff;

        GetLocalTime(&stNow);
        SystemTimeToVariantTime(&stNow, &dtNow);

        if (g_dtWait < 1.0)
        {
            // No day provided; use today
            g_dtWait += floor(dtNow);
        }

        if (g_dtWait < dtNow)
        {
            // Too early for today; use tomorrow
            g_dtWait += 1.0;
        }

        // Wait until it's time to send the keys
        while (dtNow < g_dtWait)
        {
            GetLocalTime(&stNow);
            SystemTimeToVariantTime(&stNow, &dtNow);
            dtDiff = (g_dtWait - dtNow) * (24*60);

            printf("Waiting for %.0f min, %.0f sec       \r", floor(dtDiff), (dtDiff - floor(dtDiff)) * 60);

            Sleep(1000);
        }
        printf("\n");
    }

    if (!bContinue)
        return -1;

    sprintf(g_szEXEString, " - %s", argv[0]);

    if (g_bRepeatForever)
    {
        printf("Sending keystrokes repeatedly...press Ctrl+Alt+Shift to terminate.\n");
    }

	EnumWindows(EnumWindowsProc, (LPARAM) &sendInfo);
	Sleep(SLEEPTIME);
	while ((!g_bSent && g_bWaitForSuccess) || g_bRepeatForever)
	{
		g_bSent = FALSE;
		EnumWindows(EnumWindowsProc, (LPARAM) &sendInfo);
		Sleep(SLEEPTIME);

        if (GetAsyncKeyState(VK_CONTROL) & 0x8000)
            if (GetAsyncKeyState(VK_MENU) & 0x8000)
                if (GetAsyncKeyState(VK_SHIFT) & 0x8000)
                    break;

	}

    if (!g_bSent && (argv[iArg] != NULL))
    {
        printf("Could not find window matching \"%s\"\n", argv[iArg]);
    }

	return 0;
}

