// Globals.cpp

#include "stdafx.h"
#include "globals.h"

DWORD g_dwSVKModOrder[] =
{
    SVK_APPS,
    SVK_WIN,
    SVK_RWIN,
    SVK_CONTROL,
    SVK_RCONTROL,
    SVK_SHIFT,
    SVK_RSHIFT,
    SVK_MENU,
    SVK_RMENU,
    0
};

DWORD g_dwVKModOrder[] =
{
    VK_APPS,
    VK_LWIN,
    VK_RWIN,
    VK_CONTROL,
    VK_RCONTROL,
    VK_SHIFT,
    VK_RSHIFT,
    VK_MENU,
    VK_RMENU,
    0
};

// Global variables
BOOL g_bRegEx;
BOOL g_bWaitDate;
DATE g_dtWait;
BOOL g_bCaseSensitive;
char g_szEXEString[256];
BOOL g_bSent;
BOOL g_bListFailedWindows;
BOOL g_bWaitForSuccess;
BOOL g_bRepeatForever;
BOOL g_bRestoreForeground;
BOOL g_bIncludeHidden;
BOOL g_bRenameWindow;
BOOL g_bMatchForegroundWindow;
BOOL g_bLeaveInBackground;
BOOL g_bFullHelp;
BOOL g_bQuiet;
BOOL g_bMatchClass;
BOOL g_bSendToEveryWindow;
char g_szRename[256];
char g_szMatchClass[256];

DWORD StringToInteger(std::string str)
{
    char * szEnd;
    if (str.substr(0, 2).compare("0x") == 0)
    {
        return strtol(str.substr(2).c_str(), &szEnd, 16); 
    }
    return strtol(str.c_str(), &szEnd, 10);
}

DWORD ExpressionToInteger(std::string str)
{
    // This expression evaluator is only designed to understand
    // the expressions "w-number" and "h-number"

    char cToken = '\0';
    int iNum = 0;
    int iScreenMetric = 0;
    bool bSubtract = false;

    size_t i = 0;

    RECT rc;
    SystemParametersInfo(SPI_GETWORKAREA, 0, &rc, 0);

    while(i < str.length())
    {
        if (isdigit(str.at(i)))
        {
            std::string strNum = str.substr(i);
            iNum = StringToInteger(strNum);
            while (isdigit(str.at(i)))
            {
                i++;
                if (i >= str.length())
                    break;
            }

            continue;
        }

        switch(str.at(i))
        {
            case ' ':
            case '\t':
            case '\r':
            case '\n':
                break;

            case 'w':
                iScreenMetric = GetSystemMetrics(SM_CXSCREEN);
                break;
            case 'W':
                iScreenMetric = rc.right;
                break;

            case 'h':
                iScreenMetric = GetSystemMetrics(SM_CYSCREEN);
                break;
            case 'H':
                iScreenMetric = rc.bottom;
                break;

            case '-':
                bSubtract = true;
                break;

            case '+':
                bSubtract = false;
                break;
        }

        i++;
    }

    return bSubtract ? iScreenMetric - iNum : iScreenMetric + iNum;
}
