// JTHZ Windows 32 enumerator and task-(de)activator
// Programmed using Borland C++ 5.02

#include <windows.h>
#include <commctrl.h>
#include "enumwin.h"

LRESULT CALLBACK WindowFunc(HWND,UINT,WPARAM,LPARAM);
BOOL CALLBACK EnumChildProc(HWND,LPARAM);
VOID RecurseExpanding(HWND,HTREEITEM);
VOID SetWindow(HWND,int);
BOOL CALLBACK SettingsFunc(HWND,UINT,WPARAM,LPARAM);
VOID PutProfileInt(LPCTSTR,UINT);

const UINT NUMPARTS=4; // n statuswnd-parts
UINT AlwaysOnTop,ShowWarnings;
HINSTANCE hInst;
HWND hTreeWndCtrl,hStatusWnd;
WINDOWPLACEMENT wp;

#pragma argsused
int WINAPI WinMain(HINSTANCE hThisInst,HINSTANCE hPrev,LPSTR lpszArgs,int nWinMode){
	const char mutexName[]="JTHZ enum",className[]="Julius";
  	UINT parts[NUMPARTS];
	HANDLE hAccel;
	HWND hWnd;
	MSG msg;
	RECT WinDim;
	WNDCLASSEX wcl;
	// just one instance of this babe:
	if(OpenMutex(0,FALSE,mutexName)) // app is already running!
		return 0;
	HANDLE mutex=CreateMutex(NULL,TRUE,mutexName);
	hInst=hThisInst;
	wcl.cbSize=sizeof(WNDCLASSEX);
	wcl.hInstance=hThisInst;
	wcl.lpszClassName=className;
	wcl.lpfnWndProc=WindowFunc;
	wcl.style=0;
	wcl.hIcon=LoadIcon(hThisInst,"ICON1");
	wcl.hIconSm=LoadIcon(hThisInst,"ICON2");
	wcl.hCursor=LoadCursor(NULL,IDC_ARROW);
	wcl.lpszMenuName="BORG";
	wcl.cbClsExtra=0;
	wcl.cbWndExtra=0;
	wcl.hbrBackground=GetStockObject(LTGRAY_BRUSH);
	if(!RegisterClassEx(&wcl))
		return 0;
	hWnd=CreateWindow(
		className,
		"JTHZ Window-enumerator",
		WS_OVERLAPPEDWINDOW,
		GetPrivateProfileInt(INI_SECTION,"X",CW_USEDEFAULT,INI_FILE),
		GetPrivateProfileInt(INI_SECTION,"Y",CW_USEDEFAULT,INI_FILE),
		GetPrivateProfileInt(INI_SECTION,"W",CW_USEDEFAULT,INI_FILE),
		GetPrivateProfileInt(INI_SECTION,"H",CW_USEDEFAULT,INI_FILE),
		HWND_DESKTOP,
		NULL,
		hThisInst,
		NULL
	);
	InitCommonControls();
	// statusbar
	hStatusWnd=CreateStatusWindow(WS_CHILD|WS_VISIBLE,"",hWnd,IDC_STATUS);
	GetClientRect(hWnd,&WinDim);
	for(UINT i=1;i<=NUMPARTS;i++)
		parts[i-1]=WinDim.right/NUMPARTS*i;
	SendMessage(hStatusWnd,SB_SETPARTS,4,(LPARAM)parts);
	// treeview
	hTreeWndCtrl=CreateWindow(
		WC_TREEVIEW,
		"Jolanda",
		WS_VISIBLE|WS_TABSTOP|WS_CHILD|TVS_HASLINES|TVS_HASBUTTONS|TVS_LINESATROOT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		hWnd,
		NULL,
		hThisInst,
		NULL
	);
	// create and use imageList
	HIMAGELIST imgList=ImageList_Create(15,15,ILC_COLOR4|ILC_MASK,4,0);
	char resID[2][5]={"LED1","LED2"};
	for(UINT i=0;i<2;i++){
		HBITMAP hBit=LoadBitmap(hThisInst,resID[i]);
		// RGB(255,255,255) is used as transparent masking color
		ImageList_AddMasked(imgList,hBit,RGB(255,255,255));
		DeleteObject(hBit);
	}
	TreeView_SetImageList(hTreeWndCtrl,imgList,TVSIL_NORMAL);
	hAccel=LoadAccelerators(hThisInst,"BORG");
	ShowWindow(hWnd,nWinMode);
	UpdateWindow(hWnd);
	AlwaysOnTop=GetPrivateProfileInt(INI_SECTION,"Topmost",0,INI_FILE);
	ShowWarnings=GetPrivateProfileInt(INI_SECTION,"Warnings",1,INI_FILE);
	if(AlwaysOnTop)
		SetWindowPos(hWnd,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
	SendMessage(hWnd,WM_COMMAND,IDM_UPDATE,0);
	while(GetMessage(&msg,NULL,0,0))
		if(!TranslateAccelerator(hWnd,hAccel,&msg)){
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	ReleaseMutex(mutex);
	return msg.wParam;
}

#pragma warn -pia
LRESULT CALLBACK WindowFunc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam){
	char*winText;
  	UINT i,textLength,parts[NUMPARTS];
	HCURSOR hCursor;
	HTREEITEM hti;
	HWND win;
	NMHDR*nmptr;
	RECT clientRect,statusRect;
	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDM_QUIT:
					DestroyWindow(hWnd);
					break;
				case IDM_UPDATE:
					hCursor=SetCursor(LoadCursor(NULL,IDC_WAIT));
					LockWindowUpdate(hWnd);
					TreeView_DeleteAllItems(hTreeWndCtrl);
					EnumWindows((WNDENUMPROC)EnumChildProc,(LPARAM)TVI_ROOT);
					TreeView_EnsureVisible(hTreeWndCtrl,TreeView_GetRoot(hTreeWndCtrl));
					LockWindowUpdate(0);
					SetCursor(hCursor);
					break;
				case IDM_HIDE:
					SetWindow(hWnd,SW_HIDE);
					break;
				case IDM_SHOW:
					SetWindow(hWnd,SW_SHOW);
					break;
				case IDM_MIN:
					SetWindow(hWnd,SW_SHOWMINIMIZED);
					break;
				case IDM_MAX:
					SetWindow(hWnd,SW_SHOWMAXIMIZED);
					break;
				case IDM_TOTOP:
					SetWindow(hWnd,SW_SHOW);
					BringWindowToTop(hWnd);
					break;
				case IDM_RESTORE:
					SetWindow(hWnd,SW_RESTORE);
					break;
				case IDM_SETTINGS:
					DialogBox(hInst,"SETTINGS",hWnd,(DLGPROC)SettingsFunc);
					SetWindowPos(hWnd,AlwaysOnTop?HWND_TOPMOST:HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
					break;
				case IDM_COLLAPSE:
					// only collapsing root-items collapses whole treeview
					hCursor=SetCursor(LoadCursor(NULL,IDC_WAIT));
					LockWindowUpdate(hWnd);
					hti=TreeView_GetRoot(hTreeWndCtrl);
					TreeView_Expand(hTreeWndCtrl,hti,TVE_COLLAPSE);
					while(hti=TreeView_GetNextSibling(hTreeWndCtrl,hti))
						TreeView_Expand(hTreeWndCtrl,hti,TVE_COLLAPSE);
					TreeView_EnsureVisible(hTreeWndCtrl,TreeView_GetRoot(hTreeWndCtrl));
					LockWindowUpdate(0);
					SetCursor(hCursor);
					break;
				case IDM_EXPAND:
					hCursor=SetCursor(LoadCursor(NULL,IDC_WAIT));
					LockWindowUpdate(hWnd);
					RecurseExpanding(hTreeWndCtrl,TreeView_GetRoot(hTreeWndCtrl));
					TreeView_EnsureVisible(hTreeWndCtrl,TreeView_GetRoot(hTreeWndCtrl));
					LockWindowUpdate(0);
					SetCursor(hCursor);
					break;
			}
			break;
		case WM_DESTROY:
			wp.length=sizeof(WINDOWPLACEMENT);
			GetWindowPlacement(hWnd,&wp);
			PutProfileInt("X",wp.rcNormalPosition.left);
			PutProfileInt("Y",wp.rcNormalPosition.top);
			PutProfileInt("W",wp.rcNormalPosition.right-wp.rcNormalPosition.left);
			PutProfileInt("H",wp.rcNormalPosition.bottom-wp.rcNormalPosition.top);
			PutProfileInt("Topmost",AlwaysOnTop);
			PutProfileInt("Warnings",ShowWarnings);
			PostQuitMessage(0);
			break;
		case WM_SIZE:
			// pass msg to statuswindow
			SendMessage(hStatusWnd,WM_SIZE,wParam,lParam);
			GetClientRect(hWnd,&clientRect);
			GetWindowRect(hStatusWnd,&statusRect);
			MoveWindow(hTreeWndCtrl,0,0,clientRect.right-clientRect.left,
					clientRect.bottom-clientRect.top-(statusRect.bottom-statusRect.top),TRUE);
			for(i=1;i<=NUMPARTS;i++)
				parts[i-1]=clientRect.right/NUMPARTS*i;
			SendMessage(hStatusWnd,SB_SETPARTS,4,(LPARAM)parts);
			break;
		case WM_NOTIFY:
			nmptr=(LPNMHDR)lParam;
			if(nmptr->code==TVN_SELCHANGED){
				win=(HWND)((LPNM_TREEVIEW)nmptr)->itemNew.lParam;
				textLength=GetWindowTextLength(win);
				if(textLength){
					winText=new char[textLength+2];
					GetWindowText(win,winText,textLength+1);
				}
				else{
					winText=new char[8];
					wsprintf(winText,"%s","zerolength");
				}
				SendMessage(hStatusWnd,SB_SETTEXT,0,(LPARAM)winText);
				delete[]winText;
				winText=new char[64];
				wsprintf(winText,"ID: 0x%X",GetWindowLong(win,GWL_ID));
				SendMessage(hStatusWnd,SB_SETTEXT,1,(LPARAM)winText);
				wsprintf(winText,"PROC: 0x%X",GetWindowLong(win,GWL_WNDPROC));
				SendMessage(hStatusWnd,SB_SETTEXT,2,(LPARAM)winText);
				GetClassName(win,winText,64);
				SendMessage(hStatusWnd,SB_SETTEXT,3,(LPARAM)winText);
				delete[]winText;
			}
			break;
		default:
			return DefWindowProc(hWnd,message,wParam,lParam);
	}
	return 0;
}

#pragma argsused
BOOL CALLBACK EnumChildProc(HWND hWnd,LPARAM lParam){
	char*winText;
	HTREEITEM tvParent;
	TV_INSERTSTRUCT tvs;
	TV_ITEM tvi;
  	UINT textLength=GetWindowTextLength(hWnd);
	if(textLength){
		winText=new char[textLength+2];
		GetWindowText(hWnd,winText,textLength+1);
	}
	else{
		winText=new char[16];
		wsprintf(winText,"zerolength");
	}
	tvi.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE|TVIF_PARAM;
	tvi.iImage=0;
	tvi.iSelectedImage=1;
	tvi.pszText=winText;
	tvi.lParam=(LPARAM)hWnd; // remember associated window
	tvs.hInsertAfter=TVI_SORT;
	tvs.hParent=(HTREEITEM)lParam;
	tvs.item=tvi;
	tvParent=TreeView_InsertItem(hTreeWndCtrl,&tvs);
	delete[]winText;
	EnumChildWindows(hWnd,(WNDENUMPROC)EnumChildProc,(LPARAM)tvParent);
	return TRUE;
}

VOID RecurseExpanding(HWND hTreeWndCtrl,HTREEITEM hti){
	// self-calling baby to expand all treeview-nodes
	HTREEITEM htiChild,htiSibling=hti;
	TreeView_Expand(hTreeWndCtrl,htiSibling,TVE_EXPAND);
	if(htiChild=TreeView_GetChild(hTreeWndCtrl,htiSibling))
		RecurseExpanding(hTreeWndCtrl,htiChild);
	while(htiSibling=TreeView_GetNextSibling(hTreeWndCtrl,htiSibling)){
		TreeView_Expand(hTreeWndCtrl,htiSibling,TVE_EXPAND);
		if(htiChild=TreeView_GetChild(hTreeWndCtrl,htiSibling))
			RecurseExpanding(hTreeWndCtrl,htiChild);
	}
}

VOID SetWindow(HWND owner,int state){
	// force a window to a certain state
	TV_ITEM tvi;
	HTREEITEM hti=TreeView_GetSelection(hTreeWndCtrl);
	if(hti){
		if(ShowWarnings&&MessageBox(owner,"This can corrupt current Windows-session\nContinue anyway?","Warning!",MB_YESNO|MB_ICONWARNING)!=IDYES)
			return;
		tvi.mask=TVIF_PARAM; // lParam contains window-handle
		tvi.hItem=hti;
		TreeView_GetItem(hTreeWndCtrl,&tvi);
		ShowWindow((HWND)tvi.lParam,state);
	}
	else if(ShowWarnings)
		MessageBox(owner,"Nothing selected",NULL,MB_ICONHAND);
}

#pragma argsused
BOOL CALLBACK SettingsFunc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam){
	switch(message){
		case WM_COMMAND:
			if(LOWORD(wParam)==IDOK){
				AlwaysOnTop=IsDlgButtonChecked(hWnd,IDC_TOP);
				ShowWarnings=IsDlgButtonChecked(hWnd,IDC_WARNING);
				EndDialog(hWnd,0);
				return TRUE;
			}
			break;
		case WM_INITDIALOG:
			CheckDlgButton(hWnd,IDC_TOP,AlwaysOnTop);
			CheckDlgButton(hWnd,IDC_WARNING,ShowWarnings);
			break;
	}
	return FALSE;
}

VOID PutProfileInt(LPCTSTR lpKeyName,UINT value){
	char buf[16];
	wsprintf(buf,"%u",value);
	WritePrivateProfileString(INI_SECTION,lpKeyName,buf,INI_FILE);
}
