@echo off
:: Point to the directory where utilities are installed.
set u$p=v:\batutil

:: Initialize the limiting quantity of backups at 1.
set mx$f=1

:: Determine how many hours ago we last made a rotating system image backup.
%u$p%\fileage c:\syssave\syssave.rec /h >nul

:: If less than 1 hour ago, skip it; if more than 4 hours, normalize.
if not errorlevel 1 goto end
if errorlevel 4 goto normalize

:: If less than 4 hours ago, check the file at level zero.
:: If level zero is over an hour old, refresh.
%u$p%\fileage c:\syssave\syssave$.0
if not errorlevel 1 goto end
goto bkup

:normalize
:: Set the normal maximum quantity of rotating image backups to 6.
:: Use 1 - 9, or use capital A - Z to represent 10 through 35, respectively.
set mx$f=6

:: Determine how many days ago a short-term extra backup was made.
%u$p%\fileage c:\syssave\syssave$.%mx$f% /d >nul

:: If less than 10 days ago, use the normal quantity; if more, adjust.
if not errorlevel 10 goto useit
set mx$f=7

:: Determine how many days ago a long-term extra backup was made.
%u$p%\fileage c:\syssave\syssave$.%mx$f% /d >nul

:: If 20 days or more, adjust limit accordingly.
if errorlevel 20 set mx$f=8

:useit
echo.>c:\syssave\syssave.rec

:bkup
%u$p%\syssave %mx$f%

:end
set u$p=
set mx$f=
