        PAGE    60,132
NAME    BOX
        TITLE   BOX version 1.3 1996 October 25
COMMENT |


This program may be freely copied and used for any purpose
except military.

Usage:

BOX    Please insert the yellow diskette.

BOX is much like ECHO except that in encloses the text in a box.
Leading and trailing blanks are removed from the string and one
blank is added to each end.  The result on the screen is:

Ŀ
 Please insert the yellow diskette. 



Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com

version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove addres

Version 1.1 1993 June 7
- embed new phone/address


| ;


; M A C R O S

CR      MACRO   ; Carriage return line feed
        DB 0dh,0ah
        ENDM

;======

EOS     MACRO   ; marks end of display string
        DB 0dh,0ah,'$'
        ENDM

;======


CODE    SEGMENT PARA

        ASSUME  CS:CODE,DS:CODE
        ORG     100H

;==============================================================

BOX      PROC    FAR

START:
;==============================================================
; LINE DRAWING CONSTANTS
UpLeftChar      EQU     ""
UpRightChar     EQU     ""
LowLeftChar     EQU     ""
LowRightChar    EQU     ""
HorChar         EQU     ""
VertChar        EQU     ""
SpaceChar       EQU     " "

;==============================================================
; MAINLINE PROGRAM
        Call    ParseString
        Call    TopLine
        Call    MidLine
        Call    BottomLine
QUIT:   MOV     AX,4C00H        ; EXIT back to DOS
        INT     21H

;==============================================================
; PARSE STRING TO REMOVE LEAD/TRAIL BLANKS
ParseString     PROC
                                ; counted string at HEX 80
                                ; contains command line.
                                ; It has no trailing null.
                                ; String we want may be
                                ; preceded and followed by
                                ; unwanted spaces.
        MOV     BX,81h          ; start of string
        XOR     CH,CH
        MOV     CL,DS:80h       ; length of string
        CALL    MLEADING        ; get rid of leading blanks
        CALL    MTRAILING       ; get rid of trailing blanks
        MOV     StringAd,BX
        MOV     StringLen,CX
        RET
ParseString     ENDP
;==============================================================
; DRAW THE TOP LINE OF THE BOX WITH CORNERS
TopLine PROC
        MOV     DL,UpLeftChar   ; handle upper left corner
        Call    SayChar

        MOV     CX,StringLen    ; handle top line
        INC     CX              ; account for blank at left
        INC     CX              ; account for blank at right
        Call    HorLine

        MOV     DL,UpRightChar  ; handle upper right corner
        Call    SayChar

        LEA     DX,CrLf         ; CrLf
        MOV     CX,2
        Call    SayString
        RET
TopLine ENDP
;==============================================================
; DRAW THE MIDDLE LINE OF THE BOX WITH THE TEXT
MidLine PROC
        MOV     DL,VertChar     ; handle left end bar
        Call    SayChar

        MOV     DL,SpaceChar    ; handle space before text
        Call    SayChar

        MOV     DX,StringAd     ; handle text
        MOV     CX,StringLen
        Call    SayString

        MOV     DL,SpaceChar    ; handle space after text
        Call    SayChar

        MOV     DL,VertChar     ; handle right end bar
        Call    SayChar

        LEA     DX,CrLf         ; CrLf
        MOV     CX,2
        Call    SayString

        RET
MidLine ENDP
;==============================================================
; DRAW THE BOTTOM LINE OF THE BOX WITH CORNERS
BottomLine      PROC
        MOV     DL,LowLeftChar  ; handle lower left corner
        Call    SayChar

        MOV     CX,StringLen    ; handle bottom line
        INC     CX              ; account for blank at left
        INC     CX              ; account for blank at right
        Call    HorLine

        MOV     DL,LowRightChar ; handle lower right corner
        Call    SayChar

        LEA     DX,CrLf         ; CrLf
        MOV     CX,2
        Call    SayString
        RET
BottomLine      ENDP
;==============================================================
; DRAW A HORIZONTAL LINE CX CHARS LONG
HorLine PROC
        MOV     DL,HorChar
        JCXZ    HorDone
HorLoop:
        Call    SayChar
        LOOP    HorLoop
HorDone:
        RET
HorLine ENDP
;==============================================================
; REMOVE LEADING BLANKS FROM A STRING
MLeading        PROC    Near
;       on entry BX is addr of string, CX its length.
;       Trims off any leading blanks, leaving result in BX CX
;       Length may also be 0 or 1, but not -ve
;       If the entire string is blank the result is the null string
        MOV     DI,BX
        MOV     AL,20h          ; AL = blank  -- the search char
        JCXZ    MLEADING2       ; jump if null string
        REPE    SCASB           ; scan ES:DI forwards till hit non blank
                                ; DI points just after it (wrap ok)
                                ; CX is one too small, or 0 if none found
        JE      MLEADING1       ; jump if entire string was blank
        INC     CX              ; CX is length of remainder of string
MLEADING1:
        DEC     DI              ; DI points to non-blank
MLEADING2:
        MOV     BX,DI           ; put address back
        RET
MLeading        ENDP
;========================================
; REMOVE TRAILING BLANKS FROM A STRING
MTrailing       PROC    Near
;       on entry BX is addr of string, CX its length.
;       Trims off any trailing blanks, leaving result in BX CX
;       Length may also be 0 or 1, but not -ve
;       If the entire string is blank the result is the null string
        MOV     DI,BX
        ADD     DI,CX           ; calc addr last char in string
        DEC     DI
        MOV     AL,20h          ; AL = blank  -- the search char
        JCXZ    MTRAILING1      ; jump if null string
        STD
        REPE    SCASB           ; scan ES:DI backwards till hit non blank
                                ; DI points just ahead of it (wrap ok)
                                ; CX is one too small, or 0 if none found
        CLD
        JE      MTRAILING1      ; jump if whole string was blank
        INC     CX
MTRAILING1:
        RET
MTrailing       ENDP
;========================================;====
; DISPLAY STRING AT DS:DX CX BYTES LONG
SayString       PROC
        MOV     BX,1            ; handle 1 - standard output
        MOV     AX,4000H        ; AH=40 signifies write by handle
        INT     21H             ; DOS WRITE STRING
        RET
SayString       ENDP
;==============================================================
; DISPLAY SINGLE CHAR IN DL
SayChar         PROC
        MOV     AH,02H          ; AH=02 signifies standard output
        INT     21H             ; DOS WRITE CHAR
        RET
SayChar         ENDP
;==============================================================
; VARIABLES
StringAd        DW      0       ; addr first char of string
StringLen       DW      0       ; len of string after strip
CrLf            DB      13,10
;==============================================================
BOX     ENDP

CopyrightMsg    label byte      ; does not display
        CR
        DB      ' BOX 1.3 ۲'
        CR
        DB      'Freeware to change display a string with a box around it.'
        CR
        DB      'usage:  BOX  Please insert the yellow disk.'
        CR
        DB      'Copyright (c) 1988-1999 Roedy Green Canadian Mind Products'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.'
        EOS

CODE    ENDS
        END     START
