
#define u8      unsigned char
#define s8      char
#define u16     unsigned short int
#define s16     short int
#define u32     unsigned int
#define s32     int
#define f32     float
#define f64     double

#define TRUE    (1)
#define FALSE   (0)

#define PI      (3.1415926535798F)

extern u8   rm_Int;
extern u16  rm_DS;
extern u16  rm_ES;

extern u16  Code32Seg;
extern u16  PSPSeg;

extern u32  Code32Addr;
extern u32  PSPAddr;

extern u8   HexTAB;


void *malloc(u32 Size);
void  free(void *Pointer);

u32   fopen(void  *fName);
u32   fcreate(void  *fName);
u32   ftell(u32 fHandle);
void  fread(u32 fHandle, void  *p, u32  Count);
void  fwrite(u32 fHandle, void  *p, u32  Count);
void  fclose(u32 fHandle);

void  outp(u16 Port, u8 Value);
#pragma aux outp = \
  "out dx,al" \
  parm [dx] [al];

void  outpw(u16 Port, u16 Value);
#pragma aux outpw = \
  "out dx,ax" \
  parm [dx] [ax];

u8    inp(u16 Port);
#pragma aux inp = \
  "in al,dx" \
  parm [dx] \
  value [al];

u16   inpw(u16 Port);
#pragma aux inpw = \
  "in ax,dx" \
  parm [dx] \
  value [ax];

u8    kbhit(void);
#pragma aux kbhit = \
  "mov ah,0Bh" \
  "int 21h" \
  value [al];

u8    getch(void);
#pragma aux getch = \
  "mov ah,08h" \
  "int 21h" \
  value [al];

f32   sin(f32 rad);
f32   cos(f32 rad);

s16   rand(void);

