
;ͻ;
; Xi Development Systems - Watcom C shell                                   ;
;                                                                           ;
; Copyright 1995-1997 (c) Maxwell Sayles.  All Rights Reserved.             ;
;ͼ;

  LOCALS
  .386p

INCLUDE ..\xids\xids.inc
INCLUDE wshell.inc

Code32 SEGMENT
  ASSUME CS:DATA_GROUP, DS:DATA_GROUP, SS:DATA_GROUP

;Ŀ;
; FMPI Entry                                                                ;
;;
Start32:
  ; jump to Watcom C/C++ entry point
  call C_Entry

  ; return to operating system
  jmp Exit32


;*****************************************************************************;

;Ŀ;
; void  *malloc(u32 Size);                                                  ;
;;
malloc:
  push edx
  mov edx,[esp+8]
  call m Alloc
  pop edx
  ret


;Ŀ;
; void  free(void *p);                                                      ;
;;
free:
  push eax
  mov eax,[esp+8]
  call m Release
  pop eax
  ret


;*****************************************************************************;

;Ŀ;
; u32  fopen(u8 *fName);                                                    ;
;;
fopen:
  push edx
  mov edx,[esp+8]
  call FileOpen
  pop edx
  ret


;Ŀ;
; u32  fcreate(u8 *fName);                                                  ;
;;
fcreate:
  push edx
  mov edx,[esp+8]
  call FileCreate
  pop edx
  ret


;Ŀ;
; u32  ftell(u32 fHandle);                                                  ;
;;
ftell:
  push ebx
  mov ebx,[esp+8]
  call FileSize
  pop ebx
  ret


;Ŀ;
; void  fread(u32 fHandle, u8  *p, u32  Count);                             ;
;;
fread:
  pushad
  mov ebx,[esp+36]
  mov edx,[esp+40]
  mov ecx,[esp+44]
  call FileRead
  popad
  ret


;Ŀ;
; void  fwrite(u32 fHandle, u8  *p, u32 Count);                             ;
;;
fwrite:
  pushad
  mov ebx,[esp+36]
  mov edx,[esp+40]
  mov ecx,[esp+44]
  call FileWrite
  popad
  ret


;Ŀ;
; void  fclose(u32 fHandle);                                                ;
;;
fclose:
  push ebx
  mov ebx,[esp+8]
  call FileClose
  pop ebx
  ret


;*****************************************************************************;

;Ŀ;
; For compatibility with watcom floating point.                             ;
;;
__CHP:
  ret


;Ŀ;
; f32  sin(f32 rad);                                                        ;
;;
sin:
  fld d [esp+4]
  fsin
  fstp d [esp+4]
  mov eax,[esp+4]
  ret


;Ŀ;
; f32  cos(f32 rad)                                                         ;
;;
cos:
  fld d [esp+4]
  fcos
  fstp d [esp+4]
  mov eax,[esp+4]
  ret


;Ŀ;
;                                                                           ;
;;
rand:
  pushad
  mov RandMod,0FFFFh
  call Random
  mov ax,RandMod
  mov [esp+28],eax
  popad
  ret



;*****************************************************************************;

Code32 ENDS


  END
